/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers.properties;

import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.BasePropertyHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.profileSettings.SessionProfileSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserProfileSettingsPropertyHandler
extends BasePropertyHandler {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, String encodedStoreId, String passport) throws CMException, IOException, HTTPException {
        SessionProfileSettings sps = this.ctx.getCurrentUserProfileSettings();
        if (!"~~".equals(encodedStoreId) || sps == null) {
            throw new HTTPException(400);
        }
        int etag = this.getRequestEtag(request);
        if (etag == sps.hashCode()) {
            response.setStatus(304);
        } else {
            response.setContentType("application/json; charset=utf-8");
            response.setStatus(200);
            response.setHeader("ETag", Integer.toHexString(sps.hashCode()));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8");
            sps.writeTo(osw);
        }
    }

    private int getRequestEtag(HttpServletRequest request) throws HTTPException {
        String eTag = request.getHeader("If-None-Match");
        if (eTag != null) {
            if (eTag.length() > 2 && eTag.charAt(0) == '\"') {
                eTag = eTag.substring(1, eTag.length() - 1);
            }
            try {
                return Integer.parseInt(eTag, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

