/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing;

import com.cognos.cm.search.indexing.CMIndexPayload;
import com.cognos.cm.search.indexing.TraceLogger;
import com.ibm.json.java.JSONArray;

public class CMIndexBatchController {
    private static final TraceLogger logger = new TraceLogger();
    private JSONArray batch = new JSONArray();
    private long batchSizeByte;
    private final long maxBatchSizeByte;

    public CMIndexBatchController(long maxBatchSizeBytes) {
        this.maxBatchSizeByte = maxBatchSizeBytes;
        this.logDebug("CMIndexBatchController created with Max Batch Size: ", this.maxBatchSizeByte, "(Bytes)");
    }

    public JSONArray getNextBatch() {
        return this.batch;
    }

    public boolean addToBatchAndIsBatchFull(CMIndexPayload payload) {
        boolean isBatchFull = false;
        this.batch.add((Object)payload.getPayload());
        this.batchSizeByte += payload.getSize();
        if (this.batchSizeByte >= this.maxBatchSizeByte) {
            this.logDebug("CM Indexing Batch Size: ", this.batchSizeByte, "(bytes) exceeded the limit of the Max Size: ", this.maxBatchSizeByte, "(bytes).");
            isBatchFull = true;
        }
        return isBatchFull;
    }

    public void clear() {
        this.batch.clear();
        this.batchSizeByte = 0L;
    }

    public int size() {
        return this.batch.size();
    }

    private void logDebug(Object ... params) {
        if (logger.isDebugEnabled()) {
            StringBuilder b = new StringBuilder();
            for (Object param : params) {
                b.append(param);
            }
            logger.debug(b.toString());
        }
    }
}

