/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.search.indexing.AncestorsJSONWithVirtualParent;
import com.cognos.cm.search.indexing.CMIndexPayload;
import com.cognos.cm.search.indexing.CMObjectNotIndexableException;
import com.cognos.cm.search.indexing.IndexingSubscriptionChecker;
import com.cognos.cm.search.indexing.SerializerFactory;
import com.cognos.cm.search.indexing.SubscriptionChecker;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.fieldBuilders.DescendantsFieldBuilder;
import com.cognos.cm.search.indexing.initialSync.IndexTree;
import com.cognos.cm.search.indexing.jsonSerializers.JSONSerializer;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStoreXPath;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CMIndexBuilder {
    private static final long DELAY_BETWEEN_EXCEPTION_LOGS_IN_MILLIS = 300000L;
    private static long lastTimeExceptionWasLogged;
    private final SubscriptionChecker subscriptionChecker;
    private final TraceLogger logger;
    private SerializerFactory factory;
    private DescendantsFieldBuilder descendantsFieldBuilder;

    public CMIndexBuilder() {
        this(new IndexingSubscriptionChecker(), new TraceLogger());
    }

    public CMIndexBuilder(SubscriptionChecker subscriptionChecker, TraceLogger logger) {
        this(subscriptionChecker, logger, new SerializerFactory(CMIndexBuilder.getStore()));
    }

    protected CMIndexBuilder(SubscriptionChecker subscriptionChecker, TraceLogger logger, SerializerFactory factory) {
        this.subscriptionChecker = subscriptionChecker;
        this.logger = logger;
        this.factory = factory;
        this.descendantsFieldBuilder = new DescendantsFieldBuilder();
    }

    private static CMStore getStore() {
        try {
            return CMExecutionContext.get().getStore();
        }
        catch (CMException e) {
            throw new RuntimeException(e);
        }
    }

    public CMProperty[] getIndexableProperties(CMObjectClass objClass) {
        CMProperty[] classProps = objClass.getProperties();
        ArrayList<CMProperty> props = new ArrayList<CMProperty>();
        for (CMProperty prop : classProps) {
            if (!this.subscriptionChecker.isSubscribed(prop)) continue;
            props.add(prop);
        }
        CMProperty[] indexableClassProps = new CMProperty[props.size()];
        props.toArray(indexableClassProps);
        return indexableClassProps;
    }

    public JSONObject getIndexableObject(CMStore store, String storeID, String objClassName) throws Exception {
        CMProperty[] props = this.getIndexableProperties(store, objClassName);
        return this.queryCMObject(store, storeID, props);
    }

    public CMProperty[] getIndexableProperties(CMStore store, String objClassName) {
        CMObjectClass objectClass = this.getClassByName(store, objClassName);
        return this.getIndexableProperties(objectClass);
    }

    private CMObjectClass getClassByName(CMStore store, String objClassName) {
        return store.getObjectClasses().getClassByName(objClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject queryCMObject(CMStore store, String storeID, CMProperty[] cmProperties) throws CMException {
        ICMLockManager lockManager = store.getLockManager();
        CMStoreQueryResults queryResults = null;
        JSONObject object = new JSONObject();
        try {
            CMStoreXPath objectPath = CMStoreXPath.fromStoreID(storeID);
            lockManager.requestLocks(objectPath);
            queryResults = store.executeQuery(objectPath, cmProperties, null, 0, this.getPermissions(), null);
            if (queryResults.next()) {
                object = this.buildJSONFromResults(queryResults, cmProperties);
            }
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
            lockManager.releaseLocks();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<InternalStoreId, CMIndexPayload> queryCMObjects(CMStore store, List<InternalStoreId> storeIds, Map<String, CMProperty[]> propertiesByObjectClass) throws CMException {
        HashMap<InternalStoreId, CMIndexPayload> payloadsByStoreId = new HashMap<InternalStoreId, CMIndexPayload>();
        CMStoreQueryResults results = null;
        ICMLockManager lockMgr = store.getLockManager();
        try {
            CMProperty[] allProperties = this.aggregateProperties(propertiesByObjectClass.values());
            lockMgr.requestLocks(storeIds, 10);
            results = store.executeQuery(storeIds, allProperties, null, 0, this.getPermissions(), null);
            while (results.next()) {
                int cmid = results.getObjectID();
                CMIndexPayload payload = this.buildJSONPayloadFromResults(results, allProperties);
                payloadsByStoreId.put(store.getInternalStoreId(cmid), payload);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            lockMgr.releaseLocks();
        }
        return payloadsByStoreId;
    }

    private CMProperty[] aggregateProperties(Collection<CMProperty[]> properties) {
        HashSet<CMProperty> allProperties = new HashSet<CMProperty>();
        for (CMProperty[] group : properties) {
            for (CMProperty property : group) {
                allProperties.add(property);
            }
        }
        return allProperties.toArray(new CMProperty[allProperties.size()]);
    }

    protected int getPermissions() {
        return 33280;
    }

    public JSONObject buildJSONFromResults(CMStoreQueryResults queryResults, CMProperty[] props) throws CMException {
        return this.buildJSONPayloadFromResults(queryResults, props).getPayload();
    }

    public CMIndexPayload buildJSONPayloadFromResults(CMStoreQueryResults queryResults, CMProperty[] props) throws CMException {
        JSONObject json = new JSONObject();
        long size = 0L;
        JSONArray refArray = null;
        for (int i = 0; i < props.length; ++i) {
            CMProperty prop = props[i];
            Object item = queryResults.getValue(i);
            if (item == null) continue;
            String name = this.factory.getIndexFieldName(prop);
            JSONSerializer serializer = this.factory.getSerializer(prop, item.getClass());
            if (serializer == null) {
                CMIndications.logException(new CMException("cmNoSearchIndexSerializer", new CMException.Parm("Property", prop.getName())));
                continue;
            }
            try {
                Object value = serializer.getJSON(queryResults.getObjectClass(), prop, item);
                if (value instanceof String) {
                    size += (long)((String)value).length();
                }
                if (value == null) continue;
                if (value instanceof AncestorsJSONWithVirtualParent) {
                    AncestorsJSONWithVirtualParent ancestorObj = (AncestorsJSONWithVirtualParent)value;
                    json.put((Object)name, (Object)ancestorObj.getJSON());
                    json.put((Object)"virtualParent", (Object)ancestorObj.getVirtualParentID());
                } else {
                    json.put((Object)name, value);
                }
                if (!prop.isIndexReference()) continue;
                if (refArray == null) {
                    refArray = new JSONArray();
                }
                refArray.addAll((Collection)((JSONArray)value));
                json.put((Object)"references", (Object)refArray);
                continue;
            }
            catch (CMObjectNotIndexableException ex) {
                this.logger.logDebug("Object \"" + queryResults.getSearchPath() + "\" is not indexed because its ancestor class \"" + ex.getAncestorClassName() + "\" is not indexable.");
                json.clear();
                break;
            }
        }
        return new CMIndexPayload(json, size);
    }

    public Object buildDescendantsField(CMStore store, String storeID) throws Exception {
        return this.descendantsFieldBuilder.build(store, storeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexTree buildIndexTree(String root) throws CMException {
        int rootId;
        CMStore store = CMExecutionContext.get().getStore();
        IndexTree tree = new IndexTree(store.getObjectClasses());
        CMStoreQueryResults results = null;
        CMStoreXPath rootPath = new CMStoreXPath(root);
        CMStoreXPath descendantsPath = new CMStoreXPath(rootPath, "descendant-or-self::*", false);
        try {
            store.getLockManager().requestLocks(descendantsPath);
            rootId = this.getObjectId(store, rootPath);
            results = store.executeQuery(descendantsPath, null, null, 0, 512, null);
            while (results.next()) {
                CMObjectClass cls = results.getObjectClass();
                if (!this.subscriptionChecker.isSubscribed(cls)) continue;
                int cmid = results.getObjectID();
                int pcmid = results.getParentObjectID();
                if (cmid == 0 && cls == CMObjectClass.ROOT) {
                    pcmid = -1;
                }
                InternalStoreId storeid = store.getInternalStoreId(cmid);
                tree.add(cmid, pcmid, storeid, cls, -1);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            store.getLockManager().releaseLocks();
        }
        tree.build(rootId);
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getObjectId(CMStore store, CMStoreXPath rootPath) throws CMException {
        CMStoreQueryResults results = null;
        int id = -1;
        try {
            results = store.executeQuery(rootPath, null, null, 0, 512, null);
            if (results.next()) {
                id = results.getObjectID();
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
        }
        return id;
    }

    public IndexTree buildIndexTree(String root, int maxRetries) throws CMException, InterruptedException {
        for (int attempt = 1; attempt <= maxRetries; ++attempt) {
            try {
                return this.buildIndexTree(root);
            }
            catch (Exception e) {
                this.handleIndexTreeException(attempt, e);
                continue;
            }
        }
        throw this.buildCmException(maxRetries, null);
    }

    private void handleIndexTreeException(int attempt, Exception e) throws InterruptedException {
        if (CMIndexBuilder.shouldLogException()) {
            this.logger.logException(this.buildCmException(attempt, e));
        }
        Thread.sleep(AdvancedSettings.INDEX_DELAYBETWEENRETRIES);
    }

    private static boolean shouldLogException() {
        long now = System.currentTimeMillis();
        if (now - lastTimeExceptionWasLogged > 300000L) {
            lastTimeExceptionWasLogged = now;
            return true;
        }
        return false;
    }

    private CMException buildCmException(int numberOfAttempts, Exception cause) {
        return new CMException(cause, "cmFailedToBuildIndexTree", new CMException.Parm("numberOfAttempts", String.valueOf(numberOfAttempts)));
    }
}

