/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing;

import java.util.ArrayList;
import java.util.List;

public class FieldSchema {
    public static final String SCHEMA_VERSION = "1.20";
    public static final String SEPARATOR = "|";
    private final String name;
    private final Type type;
    private List<Handling> handling = new ArrayList<Handling>();
    private List<Analysis> analysis = null;
    private final boolean mandatorySchema;
    private final int boost;

    public FieldSchema(String fieldName, Type fieldType, Handling handlingType, boolean mandatoryRequired) {
        this.name = fieldName;
        this.type = fieldType;
        this.handling.add(handlingType);
        this.mandatorySchema = mandatoryRequired;
        this.boost = 1;
    }

    public FieldSchema(String fieldName, Type fieldType, Handling[] handlingValues, boolean mandatoryRequired, int boostValue, Analysis ... analysisValues) {
        this.name = fieldName;
        this.type = fieldType;
        for (Handling handling : handlingValues) {
            this.handling.add(handling);
        }
        this.mandatorySchema = mandatoryRequired;
        this.analysis = new ArrayList<Analysis>();
        for (Enum enum_ : analysisValues) {
            this.analysis.add((Analysis)enum_);
        }
        this.boost = boostValue;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type.toString();
    }

    public String getHandling() {
        StringBuffer handlingValues = new StringBuffer();
        boolean firstValue = true;
        for (Handling value : this.handling) {
            if (firstValue) {
                firstValue = false;
            } else {
                handlingValues.append(SEPARATOR);
            }
            handlingValues.append(value.toString());
        }
        return handlingValues.toString();
    }

    public String getAnalysis() {
        if (this.analysis == null) {
            return null;
        }
        StringBuffer analysisValues = new StringBuffer();
        boolean firstValue = true;
        for (Analysis value : this.analysis) {
            if (firstValue) {
                firstValue = false;
            } else {
                analysisValues.append(SEPARATOR);
            }
            analysisValues.append(value.toString());
        }
        return analysisValues.toString();
    }

    public boolean mandatorySchemaRequired() {
        return this.mandatorySchema;
    }

    public String getBoost() {
        return new Integer(this.boost).toString();
    }

    public static enum Analysis {
        STEMMING,
        SPECIALCHARACTERS;

    }

    public static enum Handling {
        NONE,
        SEARCH,
        SUGGEST,
        FACET;

    }

    public static enum Type {
        STRING,
        MULTILINGUAL,
        ANCESTORS,
        DATE,
        TENANT,
        SECURITY_POLICY,
        STRING_ARRAY,
        CONTENT,
        SELF_URL;

    }
}

