/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing;

import com.cognos.cm.backgroundTask.RunOptionsReader;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskAction;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.connectors.rest.search.IndexConnector;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.queues.CMIndexQueueData;
import com.cognos.cm.search.indexing.Operation;
import com.cognos.cm.search.indexing.indexers.BatchIndexer;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.InternalStoreId;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class IndexingTaskAction
implements IBackgroundTaskAction {
    public static final String RUN_OPTION_MAX_CLASSES_PER_BATCH = "maxClassesToHandlePerBatch";
    private static final int DEFAULT_MAX_CLASSES_PER_BATCH = 10;
    private BatchIndexer batchIndexer;
    private int maxClassesPerBatch;
    private static final Summary SUMMARY_TIME_PROCESSING = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name("p2pd_cm_index_task_action_time")).help("time spent processing items to be indexed, includes data preparation and i/o")).register();
    private static final Summary SUMMARY_BATCH_SIZE = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name("p2pd_cm_index_task_batch_size")).help("summary of sizes of batches sent to search")).register();
    private static final Counter COUNT_INDEXED_ITEMS = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("p2pd_cm_index_task_action_count")).help("count of index items processed")).register();

    @Override
    public void initialize(IBackgroundTaskExectutionContext context, Element runOptionsElement) throws Exception {
        this.batchIndexer = new BatchIndexer(IndexConnector.getConnector());
        this.maxClassesPerBatch = new RunOptionsReader(runOptionsElement).getIntValue(RUN_OPTION_MAX_CLASSES_PER_BATCH, 10);
    }

    @Override
    public void setupExecute(IBackgroundTaskExectutionContext context) throws Exception {
    }

    @Override
    public void execute(IBackgroundTaskExectutionContext context, List<?> items) throws Exception {
        this.sendItemsToSearch(context, items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendItemsToSearch(IBackgroundTaskExectutionContext context, List<?> items) throws Exception {
        Summary.Timer timer = null;
        try {
            timer = SUMMARY_TIME_PROCESSING.startTimer();
            this.trySendItemsToSearch(context, items);
        }
        finally {
            timer.close();
            COUNT_INDEXED_ITEMS.inc((double)items.size());
        }
    }

    private void trySendItemsToSearch(IBackgroundTaskExectutionContext context, List<?> items) throws Exception {
        CMStore store = context.getStore();
        ArrayList<ICMQueueItem> batchItems = new ArrayList<ICMQueueItem>();
        HashSet<String> objectClasses = new HashSet<String>();
        for (Object o : items) {
            ICMQueueItem item = (ICMQueueItem)o;
            if (this.isBatchable(item, objectClasses)) {
                batchItems.add(item);
                objectClasses.add(this.getObjectClass(item));
                continue;
            }
            this.sendBatchToSearch(batchItems, store);
            this.sendSingleItemToSearch(item, store);
            batchItems = new ArrayList();
            objectClasses.clear();
        }
        this.sendBatchToSearch(batchItems, store);
    }

    private boolean isBatchable(ICMQueueItem item, Set<String> objectClasses) {
        Operation operation = this.getOperation(item);
        return operation.isBatchable() && this.hasBatchableStoreId(item) && objectClasses.size() <= this.maxClassesPerBatch;
    }

    private boolean hasBatchableStoreId(ICMQueueItem item) {
        return InternalStoreId.validate(item.getObjectID());
    }

    private String getObjectClass(ICMQueueItem item) {
        CMIndexQueueData data = (CMIndexQueueData)item.getData();
        return data.getObjectClass();
    }

    private void sendBatchToSearch(List<ICMQueueItem> batchItems, CMStore store) throws Exception {
        SUMMARY_BATCH_SIZE.observe((double)batchItems.size());
        this.batchIndexer.sendBatchItems(batchItems, store);
    }

    private void sendSingleItemToSearch(ICMQueueItem item, CMStore store) throws Exception {
        SUMMARY_BATCH_SIZE.observe(1.0);
        this.getOperation(item).index(item, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String storeID, IBackgroundTaskExectutionContext context, Object item) throws Exception {
        Summary.Timer timer = null;
        try {
            timer = SUMMARY_TIME_PROCESSING.startTimer();
            this.sendSingleItemToSearch((ICMQueueItem)item, context.getStore());
        }
        finally {
            timer.close();
            COUNT_INDEXED_ITEMS.inc();
        }
    }

    Operation getOperation(ICMQueueItem item) {
        CMIndexQueueData data = (CMIndexQueueData)item.getData();
        Operation operation = this.getOperation(data);
        if (operation == Operation.UPDATE && this.isPoliciesUpdated(data)) {
            return Operation.UPDATEPOLICIES;
        }
        return operation;
    }

    private boolean isPoliciesUpdated(CMIndexQueueData data) {
        String updatedProps = data.getProperties();
        String policies = CMProperty.POLICIES.getName();
        return updatedProps != null && updatedProps.indexOf(policies) != -1;
    }

    private Operation getOperation(CMIndexQueueData data) {
        try {
            return Operation.valueOf(data.getOperation().toUpperCase());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void tearDown() {
    }
}

