/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing;

import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.search.indexing.indexers.AddIndexer;
import com.cognos.cm.search.indexing.indexers.DeleteIndexer;
import com.cognos.cm.search.indexing.indexers.Indexer;
import com.cognos.cm.search.indexing.indexers.MoveIndexer;
import com.cognos.cm.search.indexing.indexers.UpdateIndexer;
import com.cognos.cm.search.indexing.indexers.UpdatePermissionsIndexer;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;

public enum Operation {
    ADD(true),
    UPDATE(true),
    DELETE(true),
    COPY(true),
    UPDATEPOLICIES(false),
    MOVE(false);

    private final boolean isBatchable;
    private Indexer indexer;

    private Operation(boolean isBatchable) {
        this.isBatchable = isBatchable;
    }

    public static synchronized void initialize() throws CMException {
        if (!Operation.isInitialized()) {
            ADD.setIndexer(new AddIndexer());
            UPDATE.setIndexer(new UpdateIndexer());
            DELETE.setIndexer(new DeleteIndexer());
            UPDATEPOLICIES.setIndexer(new UpdatePermissionsIndexer());
            COPY.setIndexer(new AddIndexer());
            MOVE.setIndexer(new MoveIndexer());
        }
    }

    private static boolean isInitialized() {
        return ADD.getIndexer() != null;
    }

    public boolean isBatchable() {
        return this.isBatchable;
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    private void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public void index(ICMQueueItem item, CMStore store) throws Exception {
        this.getIndexer().index(item, store);
    }

    public String toLowercase() {
        return this.toString().toLowerCase();
    }

    public static long getMaxBatchSizeInBytes() throws CMException {
        Operation.initialize();
        return ADD.getIndexer().getMaxBatchSizeInBytes();
    }
}

