/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing;

import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreDeploymentReferenceArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreNavigationPathArray;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.search.indexing.jsonSerializers.AncestorsSerializer;
import com.cognos.cm.search.indexing.jsonSerializers.BaseClassArraySerializer;
import com.cognos.cm.search.indexing.jsonSerializers.ComplexTypeArraySerializer;
import com.cognos.cm.search.indexing.jsonSerializers.ContentSerializer;
import com.cognos.cm.search.indexing.jsonSerializers.JSONSerializer;
import com.cognos.cm.search.indexing.jsonSerializers.LocalizedStringArraySerializer;
import com.cognos.cm.search.indexing.jsonSerializers.ObjectClassSerializer;
import com.cognos.cm.search.indexing.jsonSerializers.PoliciesSerializer;
import com.cognos.cm.search.indexing.jsonSerializers.StringArraySerializer;
import com.cognos.cm.search.indexing.jsonSerializers.StringSerializer;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SerializerFactory {
    private static final String[] CONTENT_PROPS = new String[]{"smartsModule.smartsData", "baseModule.baseAnalytics", "module.analytics"};
    private Map<CMProperty, String> propertyToIndexMap = new HashMap<CMProperty, String>();
    private Map<CMProperty, JSONSerializer> propSerializers = new HashMap<CMProperty, JSONSerializer>();
    private Map<Class<?>, JSONSerializer> typeSerializers = new ConcurrentHashMap();

    public SerializerFactory(CMStore store) {
        this.typeSerializers.put(CMDbStoreString.class, new StringSerializer());
        this.typeSerializers.put(CMDbStoreStringArray.class, new StringArraySerializer());
        this.typeSerializers.put(CMDbObjectClass.class, new ObjectClassSerializer());
        this.typeSerializers.put(CMDbStoreLocalizedStringArray.class, new LocalizedStringArraySerializer());
        this.typeSerializers.put(CMDbStoreBaseClassArray.class, new BaseClassArraySerializer());
        this.typeSerializers.put(CMDbStoreDeploymentReferenceArray.class, new ComplexTypeArraySerializer());
        this.typeSerializers.put(CMDbStoreNavigationPathArray.class, new ComplexTypeArraySerializer());
        ContentSerializer cs = new ContentSerializer();
        this.typeSerializers.put(Reader.class, cs);
        this.propSerializers.put(CMProperty.POLICIES, new PoliciesSerializer());
        this.propSerializers.put(CMProperty.ANCESTORS, new AncestorsSerializer());
        this.propSerializers.put(CMProperty.SPECIFICATION, cs);
        this.propertyToIndexMap.put(CMProperty.STOREID, "id");
        this.propertyToIndexMap.put(CMProperty.OBJECTCLASS, "type");
        this.propertyToIndexMap.put(CMProperty.POLICIES, "permissions");
        this.propertyToIndexMap.put(CMProperty.SPECIFICATION, "content");
        this.propertyToIndexMap.put(CMProperty._CMID, "cmid");
        for (String qname : CONTENT_PROPS) {
            CMProperty prop = this.getPropertyByQualifiedName(store, qname);
            if (prop == null) {
                CMIndications.logException(new CMException("cmNoSearchIndexSerializer", new CMException.Parm("Property", qname)));
                continue;
            }
            this.propSerializers.put(prop, cs);
            this.propertyToIndexMap.put(prop, "content");
        }
    }

    private CMProperty getPropertyByQualifiedName(CMStore store, String qname) {
        int idx = qname.indexOf(46);
        CMObjectClass cls = store.getObjectClasses().getClassByName(qname.substring(0, idx));
        if (cls != null) {
            return cls.getProperty(qname.substring(idx + 1));
        }
        return null;
    }

    public JSONSerializer getSerializer(CMProperty prop, Class<?> type) {
        if (this.propSerializers.containsKey(prop)) {
            return this.propSerializers.get(prop);
        }
        if (this.typeSerializers.containsKey(type)) {
            return this.typeSerializers.get(type);
        }
        return this.findAndSaveSuperclassSerializer(type);
    }

    private JSONSerializer findAndSaveSuperclassSerializer(Class<?> type) {
        for (Class<?> superclass = type.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            JSONSerializer serializer = this.typeSerializers.get(superclass);
            if (serializer == null) continue;
            this.typeSerializers.put(type, serializer);
            return serializer;
        }
        return null;
    }

    public String getIndexFieldName(CMProperty property) {
        String propName = property.getName();
        String fieldName = this.propertyToIndexMap.get(property);
        return fieldName == null ? propName : fieldName;
    }

    boolean hasSerializer(Class<?> type) {
        return this.typeSerializers.containsKey(type);
    }
}

