/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.ibm.json.java.JSONArtifact;

public class TraceLogger {
    private static final String DEFAULT_CATEGORY = "Trace.CM.INDEX";
    private String category;

    public TraceLogger() {
        this(DEFAULT_CATEGORY);
    }

    public TraceLogger(String category) {
        this.category = category;
    }

    public void logStartupAudit(String msgCode) {
        this.logStartupAudit(msgCode, null);
    }

    public void logStartupAudit(String msgCode, CMException.Parm[] listOfParms) {
        CMIndications.Audit_Message_FreeFormText(msgCode, listOfParms, 50000, "StartService", "ContentManagerService", "", "Info", null);
    }

    public boolean isInfoEnabled() {
        return CMIndications.logEnabled(this.category, 20000);
    }

    public boolean isDebugEnabled() {
        return CMIndications.logEnabled(this.category, 10000);
    }

    public void fatal(String text) {
        CMIndications.CMTraceText(this.category, 50000, text);
    }

    public void error(String text) {
        CMIndications.CMTraceText(this.category, 40000, text);
    }

    public void warn(String text) {
        CMIndications.CMTraceText(this.category, 30000, text);
    }

    public void info(String text) {
        CMIndications.CMTraceText(this.category, 20000, text);
    }

    public void debug(String text) {
        CMIndications.CMTraceText(this.category, 10000, text);
    }

    public void debug(JSONArtifact payload) {
        if (payload != null) {
            this.debug(payload.toString());
        }
    }

    public void logInfo(String text) {
        if (this.isInfoEnabled()) {
            this.info(text);
        }
    }

    public void logDebug(String text) {
        if (this.isDebugEnabled()) {
            this.debug(text);
        }
    }

    public void logDebug(JSONArtifact payload) {
        if (this.isDebugEnabled()) {
            this.debug(payload);
        }
    }

    public void logException(Exception exception) {
        CMIndications.logException(exception);
    }

    public void logException(CMException cmException) {
        CMIndications.logException(cmException);
    }
}

