/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.store.InternalStoreId;

public class CmObject {
    static final String NO_OBJECT_CLASS_NAME = "";
    static final int NO_CLASS_ID = -1;
    static final int ROOT_CLASS_ID = 0;
    private String storeId;
    private InternalStoreId internalStoreId;
    private int version;
    private int classId = -1;
    private String objId;
    private int cmId;
    private CmObject parent;

    public InternalStoreId getInternalStoreId() {
        if (this.internalStoreId == null) {
            this.internalStoreId = new InternalStoreId(this.getStoreId());
        }
        return this.internalStoreId;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
        this.invalidateInternalStoreId();
    }

    private void invalidateInternalStoreId() {
        this.internalStoreId = null;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getClassId() {
        return this.classId;
    }

    public void setClassId(int classId) {
        this.classId = classId;
    }

    public String getObjId() {
        return this.objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public int getCmId() {
        return this.cmId;
    }

    public void setCmId(int cmId) {
        this.cmId = cmId;
    }

    public boolean isCrawlable() {
        CMObjectClass objectClass = this.getObjectClass();
        return objectClass != null && objectClass.isIndexable();
    }

    private CMObjectClass getObjectClass() {
        return this.isRootObject() ? CMObjectClass.ROOT : this.getObjectClassByID();
    }

    private boolean isRootObject() {
        return this.getClassId() == 0;
    }

    private CMObjectClass getObjectClassByID() {
        return this.classId != -1 ? CMObjectClass.getObjectClassByID(this.classId) : null;
    }

    public String getObjectClassName() {
        CMObjectClass objectClass = this.getObjectClass();
        return objectClass != null ? objectClass.getName() : NO_OBJECT_CLASS_NAME;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public CmObject getParent() {
        return this.parent;
    }

    public void setParent(CmObject parent) {
        this.parent = parent;
    }

    public String getParentStoreId() {
        return this.parent != null ? this.parent.getStoreId() : null;
    }

    public String toString() {
        return "CmObject(storeId:" + this.getStoreId() + ", version:" + this.getVersion() + ", classId:" + this.getObjectClassName() + ", cmId:" + this.getCmId() + ", objId:" + this.getObjId() + ", parent:" + this.getParent() + ")";
    }
}

