/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.search.indexing.crawler.CmObject;
import com.cognos.cm.search.indexing.crawler.IdBlock;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CmObjectsQuery
implements AutoCloseable {
    static final String SELECT_STATEMENT = "SELECT s.STOREID, o.VERSION, o.CLASSID, p.OBJID, o.CMID, o.PCMID, ps.STOREID, pp.OBJID FROM CMOBJECTS o INNER JOIN CMSTOREIDS s ON o.CMID=s.CMID INNER JOIN CMSTOREIDS ps ON o.PCMID=ps.CMID LEFT OUTER JOIN CMOBJPROPS1 p ON o.CMID=p.CMID LEFT OUTER JOIN CMOBJPROPS1 pp ON o.PCMID=pp.CMID WHERE o.CMID >= ? AND o.CMID < ? ORDER BY o.CMID";
    private static final int STOREID_INDEX = 1;
    private static final int VERSION_INDEX = 2;
    private static final int CLASSID_INDEX = 3;
    private static final int OBJID_INDEX = 4;
    private static final int CMID_INDEX = 5;
    private static final int PARENT_CMID_INDEX = 6;
    private static final int PARENT_STOREID_INDEX = 7;
    private static final int PARENT_OBJID_INDEX = 8;
    private static final int ROOT_CMID = 0;
    private final ICMDbConnection connection;
    private PreparedStatement stmt;

    public CmObjectsQuery(ICMDbConnection connection) {
        this.connection = connection;
    }

    public Results getObjects(IdBlock idBlock) throws SQLException {
        this.stmt = this.connection.prepareStatement(SELECT_STATEMENT);
        this.stmt.setInt(1, idBlock.getStartId());
        this.stmt.setInt(2, idBlock.getEndId());
        ResultSet rs = this.stmt.executeQuery();
        return new Results(rs);
    }

    @Override
    public void close() throws SQLException {
        CMDbStoreUtil.safeCloseStatement(this.stmt);
    }

    public static class Results {
        private final Map<Integer, CmObject> parents = new HashMap<Integer, CmObject>();
        private final ResultSet rs;

        public Results(ResultSet rs) {
            this.rs = rs;
        }

        public boolean next() throws SQLException {
            return this.rs.next();
        }

        public CmObject getCmObject() throws SQLException {
            CmObject cmObject = new CmObject();
            Results.setStoreId(cmObject, this.rs, 1);
            cmObject.setVersion(this.rs.getInt(2));
            cmObject.setClassId(this.rs.getInt(3));
            cmObject.setObjId(this.rs.getString(4));
            cmObject.setCmId(this.rs.getInt(5));
            this.setParent(this.rs, cmObject);
            return cmObject;
        }

        private static void setStoreId(CmObject cmObject, ResultSet rs, int index) throws SQLException {
            String storeId = Results.fixStoreIdCase(rs.getString(index));
            cmObject.setStoreId(storeId);
        }

        private void setParent(ResultSet rs, CmObject cmObject) throws SQLException {
            int parentCmId = rs.getInt(6);
            if (parentCmId != 0) {
                CmObject parent = this.getOrCreateParent(parentCmId, rs);
                cmObject.setParent(parent);
            }
        }

        private CmObject getOrCreateParent(int parentCmId, ResultSet rs) throws SQLException {
            CmObject parent = this.parents.get(parentCmId);
            if (parent == null) {
                parent = this.createParent(parentCmId, rs);
            }
            return parent;
        }

        private CmObject createParent(int parentCmId, ResultSet rs) throws SQLException {
            CmObject parent = new CmObject();
            parent.setCmId(parentCmId);
            parent.setStoreId(Results.fixStoreIdCase(rs.getString(7)));
            parent.setObjId(rs.getString(8));
            this.parents.put(parentCmId, parent);
            return parent;
        }

        private static String fixStoreIdCase(String storeId) {
            if (StringUtils.startsWith((String)storeId, (String)"i")) {
                return "i" + storeId.substring(1).toUpperCase();
            }
            return storeId;
        }
    }
}

