/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.crawler.CmObject;
import com.cognos.cm.search.indexing.crawler.CmObjects;
import com.cognos.cm.search.indexing.crawler.CmObjectsQuery;
import com.cognos.cm.search.indexing.crawler.IdBlock;
import com.cognos.cm.search.indexing.crawler.QueryFactory;
import com.cognos.cm.search.indexing.crawler.StoreIdQuery;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.CMCAMIDHelper;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CmObjectsReader {
    private static final CmObjects NO_CM_OBJECTS = new CmObjects();
    private final QueryFactory factory;
    private final TraceLogger logger;
    private final CMWhileDeadlockExecutor deadlockExecutor;
    private CMStore store;
    private int numOfCmObjectsPerCheck;

    public CmObjectsReader() {
        this(new QueryFactory(), new TraceLogger("Trace.CM.CRAWLER"));
    }

    protected CmObjectsReader(QueryFactory factory, TraceLogger logger) {
        this(factory, logger, new CMWhileDeadlockExecutor());
    }

    protected CmObjectsReader(QueryFactory factory, TraceLogger logger, CMWhileDeadlockExecutor deadlockExecutor) {
        this.factory = factory;
        this.logger = logger;
        this.deadlockExecutor = deadlockExecutor;
    }

    public void initialize(IBackgroundTaskExectutionContext context, int numOfCmObjectsPerCheck) throws CMStoreNotAvailable, CMStoreUnexpected {
        this.numOfCmObjectsPerCheck = numOfCmObjectsPerCheck;
        this.store = context.getCMExecutionContext().getStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmObjects getNextBlock(IdBlock idBlock) throws CMException, SQLException {
        ICMDbConnection connection = this.getConnection();
        try {
            CmObjects cmObjects = this.tryGetNextBlock(connection, idBlock);
            return cmObjects;
        }
        catch (SQLException e) {
            throw this.wrapSQLException(e, connection);
        }
        catch (Exception e) {
            this.logger.logException(e);
            CmObjects cmObjects = NO_CM_OBJECTS;
            return cmObjects;
        }
        finally {
            this.releaseConnection();
        }
    }

    private ICMDbConnection getConnection() throws CMException {
        return ((ICMDbStore)this.store).getICMDbConnection();
    }

    private CmObjects tryGetNextBlock(ICMDbConnection connection, IdBlock idBlock) throws CMException, SQLException {
        CmObjects cmObjects = this.getNextBlockInDeadlockLoop(connection, idBlock);
        this.updateStoreIds(cmObjects);
        return cmObjects;
    }

    private CmObjects getNextBlockInDeadlockLoop(ICMDbConnection connection, IdBlock idBlock) throws CMException {
        return this.deadlockExecutor.exec(() -> this.getNextBlockOfCmObjects(connection, idBlock), connection, "cmDatabaseDeadlock");
    }

    private CmObjects getNextBlockOfCmObjects(ICMDbConnection connection, IdBlock idBlock) throws SQLException {
        CmObjects cmObjects = new CmObjects();
        try (CmObjectsQuery query2 = this.factory.createCmObjectsQuery(connection);){
            CmObjectsQuery.Results results = query2.getObjects(idBlock);
            while (results.next()) {
                CmObject cmObject = results.getCmObject();
                if (cmObject.isCrawlable()) {
                    cmObjects.add(cmObject);
                }
                if (!this.hasTooManyObjects(cmObjects)) continue;
                this.logMessageAboutTooManyObjects(idBlock);
                CmObjects cmObjects2 = NO_CM_OBJECTS;
                return cmObjects2;
            }
        }
        return cmObjects;
    }

    private boolean hasTooManyObjects(CmObjects cmObjects) {
        return (double)cmObjects.size() > 1.5 * (double)this.numOfCmObjectsPerCheck;
    }

    private void logMessageAboutTooManyObjects(IdBlock idBlock) {
        this.logger.info("Too many objects found inside " + idBlock + ". The Crawler will skip this block and try again during the next scan.");
    }

    private void updateStoreIds(CmObjects cmObjects) throws CMException {
        Map<InternalStoreId, CmObject> specialIdObjects = this.getObjectsWithSpecialIds(cmObjects);
        if (!specialIdObjects.isEmpty()) {
            this.queryEncodedStoreIds(specialIdObjects);
        }
    }

    private Map<InternalStoreId, CmObject> getObjectsWithSpecialIds(CmObjects cmObjects) {
        HashMap<InternalStoreId, CmObject> specialIdObjects = new HashMap<InternalStoreId, CmObject>();
        for (CmObject cmObject : cmObjects) {
            CmObjectsReader.saveOrUpdateObject(specialIdObjects, cmObject);
            if (!cmObject.hasParent()) continue;
            CmObjectsReader.saveOrUpdateObject(specialIdObjects, cmObject.getParent());
        }
        return specialIdObjects;
    }

    private static void saveOrUpdateObject(Map<InternalStoreId, CmObject> specialIdObjects, CmObject cmObject) {
        String objId = cmObject.getObjId();
        if (CmObjectsReader.isSpecialObjId(objId, cmObject.getCmId())) {
            specialIdObjects.put(cmObject.getInternalStoreId(), cmObject);
        } else if (CmObjectsReader.isCamId(objId)) {
            cmObject.setStoreId(CmObjectsReader.encodeCamId(objId));
        }
    }

    private static boolean isSpecialObjId(String objId, int cmId) {
        return StringUtils.startsWith((String)objId, (String)("::" + cmId + ":"));
    }

    private static boolean isCamId(String objId) {
        return StringUtils.isNotEmpty((String)objId);
    }

    private static String encodeCamId(String objId) {
        return CMCAMIDHelper.CAMID2storeID(objId);
    }

    private void queryEncodedStoreIds(Map<InternalStoreId, CmObject> specialIdObjects) throws CMException {
        try (StoreIdQuery query2 = this.factory.createStoreIdQuery(this.store);){
            StoreIdQuery.Results results = query2.getEncodedStoreIds(specialIdObjects);
            while (results.next()) {
                String encodedStoreId = results.getStoreId();
                CmObject cmObject = this.getCmObject(specialIdObjects, results.getObjectID());
                cmObject.setStoreId(encodedStoreId);
            }
        }
        catch (Exception e) {
            throw new CMException(e);
        }
    }

    private CmObject getCmObject(Map<InternalStoreId, CmObject> specialIdObjects, int cmid) {
        InternalStoreId internalStoreId = this.store.getInternalStoreId(cmid);
        return specialIdObjects.get(internalStoreId);
    }

    private CMException wrapSQLException(SQLException e, ICMDbConnection connection) {
        this.logger.logException(e);
        if (CMDbConnection.isConnectionProblem(e)) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                this.logger.logException(ex);
            }
            return new CMStoreNotAvailable(e);
        }
        return new CMException(e, "cmErrorQueueOperationFailure");
    }

    private void releaseConnection() throws CMException {
        ((ICMDbStore)this.store).releaseICMDbConnection();
    }
}

