/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.search.indexing.Operation;
import com.cognos.cm.search.indexing.crawler.CmObject;
import com.cognos.cm.search.indexing.crawler.CmObjects;
import com.cognos.cm.search.indexing.crawler.CrawlerNotification;
import com.cognos.cm.search.indexing.crawler.SearchResult;
import com.cognos.cm.search.indexing.crawler.SearchResults;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ConsistencyChecker {
    public List<CrawlerNotification> reconcile(CmObjects cmObjects, SearchResults searchResults) {
        List<CrawlerNotification> notifications = ConsistencyChecker.findMissingOrOutdatedObjects(cmObjects, searchResults);
        return ConsistencyChecker.appendDeletedObjects(searchResults, notifications);
    }

    private static List<CrawlerNotification> findMissingOrOutdatedObjects(CmObjects cmObjects, SearchResults searchResults) {
        ArrayList<CrawlerNotification> notifications = new ArrayList<CrawlerNotification>();
        for (CmObject cmObject : cmObjects) {
            SearchResult searchResult;
            if (ConsistencyChecker.needsToBeMoved(cmObject, searchResult = searchResults.remove(cmObject.getStoreId()))) {
                notifications.add(new CrawlerNotification(Operation.MOVE, cmObject));
                continue;
            }
            if (!ConsistencyChecker.needsToBeUpdated(cmObject, searchResult)) continue;
            notifications.add(new CrawlerNotification(Operation.UPDATE, cmObject));
        }
        return notifications;
    }

    private static boolean needsToBeUpdated(CmObject cmObject, SearchResult searchResult) {
        return searchResult == null || searchResult.getVersion() != cmObject.getVersion();
    }

    private static boolean needsToBeMoved(CmObject cmObject, SearchResult searchResult) {
        return searchResult != null && searchResult.isParentStoreIdSupported() && !StringUtils.equals((String)searchResult.getParentStoreId(), (String)cmObject.getParentStoreId());
    }

    private static List<CrawlerNotification> appendDeletedObjects(SearchResults searchResults, List<CrawlerNotification> notifications) {
        for (String storeId : searchResults) {
            notifications.add(new CrawlerNotification(Operation.DELETE, storeId));
        }
        return notifications;
    }
}

