/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.backgroundTask.RunOptionsReader;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskAction;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.crawler.CmObjects;
import com.cognos.cm.search.indexing.crawler.CmObjectsReader;
import com.cognos.cm.search.indexing.crawler.ConsistencyChecker;
import com.cognos.cm.search.indexing.crawler.CrawlerNotification;
import com.cognos.cm.search.indexing.crawler.IdBlock;
import com.cognos.cm.search.indexing.crawler.IdBlockReader;
import com.cognos.cm.search.indexing.crawler.IdBlocks;
import com.cognos.cm.search.indexing.crawler.NotificationSender;
import com.cognos.cm.search.indexing.crawler.SearchReader;
import com.cognos.cm.search.indexing.crawler.SearchResults;
import com.cognos.cm.server.CMException;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.sql.SQLException;
import java.util.List;
import org.dom4j.Element;

public class CrawlerTaskAction
implements IBackgroundTaskAction {
    private static final String RUN_OPTION_NUM_OF_CM_OBJECTS_PER_CHECK = "numOfCmObjectsPerCheck";
    private static final int DEFAULT_NUM_OF_CM_OBJECTS_PER_CHECK = 500;
    private static final String RUN_OPTION_THROTTLING_DELAY_IN_MILLIS = "throttlingDelayInMillis";
    private static final int DEFAULT_THROTTLING_DELAY_IN_MILLIS = 10000;
    private static final String RUN_OPTION_MAX_ATTEMPTS_TO_RECONCILE = "maxAttemptsToReconcile";
    private static final int DEFAULT_MAX_ATTEMPTS_TO_RECONCILE = 100;
    private static final String RUN_OPTION_PAUSE_BETWEEN_ATTEMPTS_IN_MILLIS = "pauseBetweenAttemptsInMillis";
    private static final int DEFAULT_PAUSE_BETWEEN_ATTEMPTS_IN_MILLIS = 15000;
    private static final Summary PROCESSING_TIME = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name("p2pd_cm_crawler_task_action_time")).help("time spent running the crawler, includes querying content store and updating search")).register();
    private static final Counter TOTAL_MISMATCHES_DETECTED = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("p2pd_cm_crawler_task_total_mismatches_detected")).help("cummulative count of mismatches detected")).register();
    private static final Gauge CURRENT_MISMATCHES_DETECTED = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("p2pd_cm_crawler_task_last_mismatches_detected")).help("last count of mismatches detected")).register();
    private final IdBlockReader idBlockReader;
    private final CmObjectsReader cmObjectsReader;
    private final SearchReader searchReader;
    private final ConsistencyChecker consistencyChecker;
    private final NotificationSender notificationSender;
    private final TraceLogger logger;
    private int numOfCmObjectsPerCheck;
    private int throttlingDelayInMillis;
    private int maxAttemptsToReconcile;
    private long pauseBetweenAttemptsInMillis;

    public CrawlerTaskAction() {
        this(new IdBlockReader(), new CmObjectsReader(), new SearchReader(), new ConsistencyChecker(), new NotificationSender(), new TraceLogger("Trace.CM.CRAWLER"));
    }

    protected CrawlerTaskAction(IdBlockReader idBlockReader, CmObjectsReader cmObjectsReader, SearchReader searchReader, ConsistencyChecker consistencyChecker, NotificationSender notificationSender, TraceLogger logger) {
        this.idBlockReader = idBlockReader;
        this.cmObjectsReader = cmObjectsReader;
        this.searchReader = searchReader;
        this.consistencyChecker = consistencyChecker;
        this.notificationSender = notificationSender;
        this.logger = logger;
    }

    @Override
    public void initialize(IBackgroundTaskExectutionContext context, Element runOptionsElement) throws Exception {
        RunOptionsReader reader = new RunOptionsReader(runOptionsElement);
        this.numOfCmObjectsPerCheck = reader.getIntValue(RUN_OPTION_NUM_OF_CM_OBJECTS_PER_CHECK, 500);
        this.throttlingDelayInMillis = reader.getIntValue(RUN_OPTION_THROTTLING_DELAY_IN_MILLIS, 10000);
        this.maxAttemptsToReconcile = reader.getIntValue(RUN_OPTION_MAX_ATTEMPTS_TO_RECONCILE, 100);
        this.pauseBetweenAttemptsInMillis = reader.getIntValue(RUN_OPTION_PAUSE_BETWEEN_ATTEMPTS_IN_MILLIS, 15000);
    }

    public int getNumOfCmObjectsPerCheck() {
        return this.numOfCmObjectsPerCheck;
    }

    public int getThrottlingDelayInMillis() {
        return this.throttlingDelayInMillis;
    }

    @Override
    public void setupExecute(IBackgroundTaskExectutionContext context) throws Exception {
        this.idBlockReader.initialize(context, this.numOfCmObjectsPerCheck);
        this.cmObjectsReader.initialize(context, this.numOfCmObjectsPerCheck);
        this.notificationSender.initialize(context, this.numOfCmObjectsPerCheck, this.throttlingDelayInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IBackgroundTaskExectutionContext context, List<?> items) throws Exception {
        Summary.Timer timer = this.logCrawlerStarted();
        try {
            this.runCrawler();
        }
        finally {
            this.logCrawlerFinished(timer);
        }
    }

    private Summary.Timer logCrawlerStarted() {
        this.logger.logInfo("Started crawling");
        CURRENT_MISMATCHES_DETECTED.clear();
        return PROCESSING_TIME.startTimer();
    }

    private void logCrawlerFinished(Summary.Timer timer) {
        if (this.logger.isInfoEnabled()) {
            double mismatchesDetected = CURRENT_MISMATCHES_DETECTED.get();
            this.logger.logInfo("Finished crawling in " + Math.round(timer.observeDuration()) + " seconds, " + Math.round(mismatchesDetected) + " potential mismatches detected.");
        }
        timer.close();
    }

    private void runCrawler() throws CMException, SQLException, InterruptedException {
        IdBlocks idBlocks = this.idBlockReader.findBlocks();
        for (IdBlock idBlock : idBlocks) {
            this.logObjectsRetrieved(idBlock);
            CmObjects cmObjects = this.getCmObjects(idBlock);
            this.checkConsistency(idBlock, cmObjects);
        }
    }

    private CmObjects getCmObjects(IdBlock idBlock) throws CMException, SQLException {
        CmObjects cmObjects = this.cmObjectsReader.getNextBlock(idBlock);
        this.logObjectsRetrieved(cmObjects);
        return cmObjects;
    }

    private void logObjectsRetrieved(Object objects) {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug("Retrieved " + objects);
        }
    }

    private void checkConsistency(IdBlock idBlock, CmObjects cmObjects) throws CMException, InterruptedException {
        SearchResults results = this.queryObjects(idBlock);
        boolean hasMoreResultsAhead = results.hasMaxResults();
        int attempt = 0;
        while (attempt++ < this.maxAttemptsToReconcile && results.hasValidResults()) {
            this.logObjectsRetrieved(results);
            this.reconcile(cmObjects, results);
            if (!hasMoreResultsAhead) break;
            results = this.queryForMoreResults(idBlock);
            hasMoreResultsAhead = results.hasMaxResults();
        }
    }

    private SearchResults queryForMoreResults(IdBlock idBlock) throws CMException, InterruptedException {
        this.logger.logDebug("Search returned max results. Querying for more documents.");
        Thread.sleep(this.pauseBetweenAttemptsInMillis);
        return this.queryObjects(idBlock);
    }

    private SearchResults queryObjects(IdBlock idBlock) throws CMException {
        return this.searchReader.queryByCmid(idBlock.getStartId(), idBlock.getEndId());
    }

    private void reconcile(CmObjects cmObjects, SearchResults searchResults) throws CMException, InterruptedException {
        List<CrawlerNotification> notifications = this.consistencyChecker.reconcile(cmObjects, searchResults);
        if (!notifications.isEmpty()) {
            this.notificationSender.send(notifications);
            this.logNotificationsSent(notifications);
        }
    }

    private void logNotificationsSent(List<CrawlerNotification> notifications) {
        int count = notifications.size();
        TOTAL_MISMATCHES_DETECTED.inc((double)count);
        CURRENT_MISMATCHES_DETECTED.inc((double)count);
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug("Sent " + count + " notifications: " + notifications);
        }
    }

    @Override
    public void execute(String storeID, IBackgroundTaskExectutionContext context, Object item) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void tearDown() {
    }
}

