/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.search.indexing.crawler.CmObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IdBlockQuery
implements AutoCloseable {
    private static final String SELECT_STATEMENT = "SELECT o.CLASSID, o.CMID FROM CMOBJECTS o WHERE o.CMID >= ? ORDER BY o.CMID";
    private static final int CLASSID_INDEX = 1;
    private static final int CMID_INDEX = 2;
    private final ICMDbConnection connection;
    private PreparedStatement stmt;

    public IdBlockQuery(ICMDbConnection connection) {
        this.connection = connection;
    }

    public Results getObjectsStartingAt(int id) throws SQLException {
        this.stmt = this.connection.prepareStatement(SELECT_STATEMENT);
        this.stmt.setInt(1, id);
        ResultSet rs = this.stmt.executeQuery();
        return new Results(rs);
    }

    @Override
    public void close() throws SQLException {
        CMDbStoreUtil.safeCloseStatement(this.stmt);
    }

    public static class Results {
        private final ResultSet rs;

        public Results(ResultSet rs) {
            this.rs = rs;
        }

        public boolean next() throws SQLException {
            return this.rs.next();
        }

        public CmObject getCmObject() throws SQLException {
            CmObject cmObject = new CmObject();
            cmObject.setClassId(this.rs.getInt(1));
            cmObject.setCmId(this.rs.getInt(2));
            return cmObject;
        }
    }
}

