/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.crawler.CmObject;
import com.cognos.cm.search.indexing.crawler.IdBlock;
import com.cognos.cm.search.indexing.crawler.IdBlockQuery;
import com.cognos.cm.search.indexing.crawler.IdBlocks;
import com.cognos.cm.search.indexing.crawler.QueryFactory;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import io.prometheus.client.Summary;
import java.sql.SQLException;

public class IdBlockReader {
    private static final IdBlocks NO_ID_BLOCKS = new IdBlocks();
    private static final Summary PROCESSING_TIME = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name("p2pd_cm_crawler_id_block_reader_time")).help("time spent by the crawler looking for ID blocks")).register();
    private final QueryFactory factory;
    private final TraceLogger logger;
    private final CMWhileDeadlockExecutor deadlockExecutor;
    private CMStore store;
    private int numOfCmObjectsPerCheck;

    public IdBlockReader() {
        this(new QueryFactory(), new TraceLogger("Trace.CM.CRAWLER"));
    }

    protected IdBlockReader(QueryFactory factory, TraceLogger logger) {
        this(factory, logger, new CMWhileDeadlockExecutor());
    }

    protected IdBlockReader(QueryFactory factory, TraceLogger logger, CMWhileDeadlockExecutor deadlockExecutor) {
        this.factory = factory;
        this.logger = logger;
        this.deadlockExecutor = deadlockExecutor;
    }

    public void initialize(IBackgroundTaskExectutionContext context, int numOfCmObjectsPerCheck) throws CMStoreNotAvailable, CMStoreUnexpected {
        this.numOfCmObjectsPerCheck = numOfCmObjectsPerCheck;
        this.store = context.getCMExecutionContext().getStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdBlocks findBlocks() throws CMException {
        Summary.Timer timer = PROCESSING_TIME.startTimer();
        ICMDbConnection connection = this.getConnection();
        try {
            IdBlocks idBlocks = this.findIdBlocksInDeadlockLoop(connection);
            return idBlocks;
        }
        catch (SQLException e) {
            throw this.wrapSQLException(e, connection);
        }
        catch (Exception e) {
            this.logger.logException(e);
            IdBlocks idBlocks = NO_ID_BLOCKS;
            return idBlocks;
        }
        finally {
            this.releaseConnection();
            this.logProcessingTime(timer);
        }
    }

    private void logProcessingTime(Summary.Timer timer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug("Finished looking for ID blocks in " + Math.round(timer.observeDuration()) + " seconds.");
        }
        timer.close();
    }

    private ICMDbConnection getConnection() throws CMException {
        return ((ICMDbStore)this.store).getICMDbConnection();
    }

    private IdBlocks findIdBlocksInDeadlockLoop(ICMDbConnection connection) throws CMException, SQLException {
        return this.deadlockExecutor.exec(() -> this.findIdBlocks(connection), connection, "cmDatabaseDeadlock");
    }

    private IdBlocks findIdBlocks(ICMDbConnection connection) throws SQLException {
        IdBlocks idBlocks = new IdBlocks();
        try (IdBlockQuery query2 = this.factory.createIdBlockQuery(connection);){
            IdBlockQuery.Results results = query2.getObjectsStartingAt(0);
            IdBlock idBlock = new IdBlock();
            idBlock.makeFirstBlock(true);
            while (results.next()) {
                CmObject currentObject = results.getCmObject();
                if (!currentObject.isCrawlable()) continue;
                if (this.hasEnoughObjects(idBlock)) {
                    idBlock.setEndId(currentObject.getCmId());
                    idBlocks.add(idBlock);
                    idBlock = new IdBlock();
                    idBlock.setStartId(currentObject.getCmId());
                }
                idBlock.add(currentObject);
            }
            idBlock.makeLastBlock(true);
            idBlocks.add(idBlock);
        }
        return idBlocks;
    }

    private boolean hasEnoughObjects(IdBlock idBlock) {
        return idBlock.size() >= this.numOfCmObjectsPerCheck;
    }

    private CMException wrapSQLException(SQLException e, ICMDbConnection connection) {
        this.logger.logException(e);
        if (CMDbConnection.isConnectionProblem(e)) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                this.logger.logException(ex);
            }
            return new CMStoreNotAvailable(e);
        }
        return new CMException(e, "cmErrorQueueOperationFailure");
    }

    private void releaseConnection() throws CMException {
        ((ICMDbStore)this.store).releaseICMDbConnection();
    }
}

