/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.backgroundTask.BackgroundTasksManager;
import com.cognos.cm.backgroundTask.IBackgroundTasksManager;
import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.queues.CMIndexQueueData;
import com.cognos.cm.queues.CMQueueManager;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.crawler.CrawlerNotification;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import java.util.List;

public class NotificationSender {
    private static final String BACKGROUND_TASK_NAME = "indexTask";
    private final TraceLogger logger;
    private final IBackgroundTasksManager taskMgr;
    private final ICMQueueManager queueManager;
    private CMStore store;
    private int throttlingThreshold;
    private String queueName;
    private long throttlingDelayInMillis;

    public NotificationSender() {
        this(BackgroundTasksManager.getManager(), CMQueueManager.getManager(), new TraceLogger("Trace.CM.CRAWLER"));
    }

    protected NotificationSender(IBackgroundTasksManager taskMgr, ICMQueueManager queueManager, TraceLogger logger) {
        this.logger = logger;
        this.taskMgr = taskMgr;
        this.queueManager = queueManager;
    }

    public void initialize(IBackgroundTaskExectutionContext context, int throttlingThreshold, long throttlingDelayInMillis) throws CMStoreNotAvailable, CMStoreUnexpected {
        this.store = context.getStore();
        this.throttlingThreshold = throttlingThreshold;
        this.throttlingDelayInMillis = throttlingDelayInMillis;
        this.queueName = this.queueManager.getFirstQueueName("searchIndex");
    }

    public void send(List<CrawlerNotification> notifications) throws CMException, InterruptedException {
        this.throttleIfNeeded();
        for (CrawlerNotification notification : notifications) {
            this.send(notification);
        }
    }

    private void throttleIfNeeded() throws CMException, InterruptedException {
        while (this.isBackgroundTaskTooBusy()) {
            this.logBackingOffMessage();
            this.taskMgr.ensureTaskIsRunning(BACKGROUND_TASK_NAME);
            Thread.sleep(this.throttlingDelayInMillis);
        }
    }

    private void logBackingOffMessage() throws CMException {
        if (this.logger.isInfoEnabled()) {
            this.logger.logInfo("Crawler is backing off because the background task is too busy. There are currently " + this.getQueueSize() + " items in the notification queue.");
        }
    }

    private boolean isBackgroundTaskTooBusy() throws CMException {
        return this.getQueueSize() > this.throttlingThreshold;
    }

    private int getQueueSize() throws CMException {
        return this.queueManager.getQueueSize(this.store, this.queueName, CMQueueItemState.AVAILABLE);
    }

    private void send(CrawlerNotification notification) throws CMException {
        CMIndexQueueData data = new CMIndexQueueData(notification.getOperation().toString());
        data.setObjectClass(notification.getObjectClassName());
        this.queueManager.put(this.store, notification.getStoreId(), "searchIndex", data);
    }

    String getQueueName() {
        return this.queueName;
    }

    CMStore getStore() {
        return this.store;
    }
}

