/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.connectors.BusMethod;
import com.cognos.cm.connectors.rest.AsyncRESTResponseProcessor;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.server.AsyncRequestState;
import com.cognos.cm.server.CMException;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;

public class SearchResponseProcessor
extends AsyncRESTResponseProcessor {
    private static final TraceLogger logger = new TraceLogger("Trace.CM.CRAWLER");
    private boolean isSuccess = false;
    private JSONObject jsonResponse;

    public SearchResponseProcessor() {
        this.response = new AsyncRequestState(4);
    }

    @Override
    public void processStatusCodes(BusMethod method) {
        int statusCode = method.getStatusCode();
        if (statusCode == 200) {
            this.isSuccess = true;
        } else {
            logger.logInfo("CM.SearchResponseProcessor: Request failed. Status code: " + statusCode);
            this.response.setRequestState(3);
        }
    }

    @Override
    public AsyncRequestState processResponse(InputStream responseStream) throws CMException {
        if (this.isSuccess) {
            try {
                this.jsonResponse = JSONObject.parse((InputStream)responseStream);
                this.response.setRequestState(1);
            }
            catch (IOException e) {
                this.isSuccess = false;
                logger.logInfo("CM.SearchResponseProcessor: Invalid response: " + e.toString());
                this.response.setRequestState(3);
            }
        }
        return this.response;
    }

    public boolean hasSuccessfulResponse() {
        return this.isSuccess;
    }

    public JSONObject getJsonResponse() {
        return this.jsonResponse;
    }
}

