/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.search.indexing.crawler.SearchResult;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SearchResults
implements Iterable<String> {
    public static final int MAX_SEARCH_RESULTS = 1000;
    private Map<String, SearchResult> resultsByStoreId;

    public void saveSearchResponse(JSONObject jsonResponse) {
        this.resultsByStoreId = new HashMap<String, SearchResult>();
        JSONArray results = (JSONArray)jsonResponse.get((Object)"results");
        for (Object result : results) {
            this.saveResult((JSONObject)result);
        }
    }

    private void saveResult(JSONObject result) {
        String storeId = (String)result.get((Object)"id");
        String version = (String)result.get((Object)"version");
        String parentId = (String)result.get((Object)"parentId");
        SearchResult searchResult = new SearchResult(storeId, version, parentId);
        this.resultsByStoreId.put(storeId, searchResult);
    }

    public boolean hasValidResults() {
        return this.resultsByStoreId != null;
    }

    public String toString() {
        int size = this.hasValidResults() ? this.resultsByStoreId.size() : 0;
        return "SearchDocuments(" + size + " results)";
    }

    public SearchResult remove(String storeId) {
        return this.resultsByStoreId.remove(storeId);
    }

    @Override
    public Iterator<String> iterator() {
        return this.resultsByStoreId.keySet().iterator();
    }

    public boolean hasMaxResults() {
        return this.getSize() >= 1000;
    }

    public int getSize() {
        return this.hasValidResults() ? this.resultsByStoreId.size() : 0;
    }
}

