/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.crawler;

import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.search.indexing.crawler.CmObject;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.CMQueryUtils;
import java.util.Map;

public class StoreIdQuery
implements AutoCloseable {
    private static final CMProperty[] PROPERTIES = new CMProperty[]{CMProperty.STOREID};
    private final CMStore store;
    private final ICMLockManager lockMgr;
    private Results results;

    public StoreIdQuery(CMStore store) {
        this.store = store;
        this.lockMgr = store.getLockManager();
    }

    public Results getEncodedStoreIds(Map<InternalStoreId, CmObject> cmObjects) throws CMException {
        this.lockMgr.requestLocks(cmObjects.keySet(), 10);
        this.results = new Results(this.store.executeQuery(cmObjects.keySet(), PROPERTIES, null, 0, 512, null));
        return this.results;
    }

    @Override
    public void close() throws Exception {
        try {
            this.results.close();
        }
        finally {
            this.lockMgr.releaseLocks();
        }
    }

    public class Results {
        private CMStoreQueryResults cmResults;

        public Results(CMStoreQueryResults cmResults) {
            this.cmResults = cmResults;
        }

        public boolean next() throws CMException {
            return this.cmResults.next();
        }

        public String getStoreId() throws CMException {
            return this.cmResults.getValue(0).toString();
        }

        public int getObjectID() {
            return this.cmResults.getObjectID();
        }

        public void close() {
            CMQueryUtils.safeQueryResultsRelease(this.cmResults);
        }
    }
}

