/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.fieldBuilders;

import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.ibm.json.java.JSONArray;
import java.util.HashMap;

public class DescendantsFieldBuilder {
    public JSONArray build(CMStore store, String storeID) throws Exception {
        HashMap<Integer, String> allDescendants = this.getAllDescendants(store, storeID);
        return this.getImpactedDescendants(store, allDescendants);
    }

    private HashMap<Integer, String> getAllDescendants(CMStore store, String rootStoreID) throws Exception {
        ICMLockManager lockManager = this.getLockManager(store);
        CMStoreQueryResults queryResults = null;
        HashMap<Integer, String> descendants = new HashMap<Integer, String>();
        try {
            CMStoreXPath path = new CMStoreXPath(CMStoreXPath.encodeStoreIdToPathString(rootStoreID) + "/descendant::*");
            lockManager.requestLocks(path);
            queryResults = store.executeQuery(path, new CMProperty[]{CMProperty.STOREID}, null, 0, this.getPermissions(), null);
            while (queryResults.next()) {
                int objectId = queryResults.getObjectID();
                String storeId = queryResults.getValue(0).toString();
                descendants.put(new Integer(objectId), storeId);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
            lockManager.releaseLocks();
        }
        return descendants;
    }

    private JSONArray getImpactedDescendants(CMStore store, HashMap<Integer, String> descendants) {
        CMCache cache = store.getCache();
        JSONArray impacted = new JSONArray();
        for (Integer id : descendants.keySet()) {
            int policyContainingObjectId = cache.getPolicyObject(id);
            if (descendants.containsKey(policyContainingObjectId)) continue;
            impacted.add((Object)descendants.get(id));
        }
        return impacted;
    }

    private int getPermissions() {
        return 33280;
    }

    private ICMLockManager getLockManager(CMStore store) {
        return store.getLockManager();
    }
}

