/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.indexers;

import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.connectors.rest.search.Connector;
import com.cognos.cm.search.indexing.CMIndexBuilder;
import com.cognos.cm.search.indexing.IndexingSubscriptionChecker;
import com.cognos.cm.search.indexing.Operation;
import com.cognos.cm.search.indexing.SubscriptionChecker;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.indexers.BatchRequest;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import java.util.List;

public class BatchIndexer {
    private final Connector connector;
    private final CMIndexBuilder indexBuilder;
    private final TraceLogger logger;
    private final long maxBatchSizeInBytes;

    public BatchIndexer(Connector connector) throws CMException {
        this(connector, new IndexingSubscriptionChecker(), new TraceLogger());
    }

    public BatchIndexer(Connector connector, SubscriptionChecker subscriptionChecker, TraceLogger logger) throws CMException {
        this(connector, new CMIndexBuilder(subscriptionChecker, logger), logger, Operation.getMaxBatchSizeInBytes());
    }

    protected BatchIndexer(Connector connector, CMIndexBuilder indexBuilder, TraceLogger logger, long maxBatchSizeInBytes) {
        this.connector = connector;
        this.indexBuilder = indexBuilder;
        this.logger = logger;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
    }

    public void sendBatchItems(List<ICMQueueItem> batchItems, CMStore store) throws CMException {
        this.logBatch(batchItems);
        BatchRequest batch = new BatchRequest(this.connector, this.indexBuilder, store, this.maxBatchSizeInBytes);
        batch.sendRequest(batchItems);
    }

    private void logBatch(List<ICMQueueItem> batchItems) {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug("CM.BatchIndexer: //* Sending " + this.toString(batchItems));
        } else if (this.logger.isInfoEnabled()) {
            this.logger.logInfo("CM.BatchIndexer: //* Batch size: " + batchItems.size());
        }
    }

    private String toString(List<ICMQueueItem> batchItems) {
        StringBuilder sb = new StringBuilder().append(batchItems.size()).append(" batch items:");
        for (ICMQueueItem item : batchItems) {
            sb.append(" ").append(item.getObjectID());
        }
        return sb.toString();
    }
}

