/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.indexers;

import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.connectors.rest.search.Connector;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.queues.CMIndexQueueData;
import com.cognos.cm.search.indexing.CMIndexBuilder;
import com.cognos.cm.search.indexing.CMIndexPayload;
import com.cognos.cm.search.indexing.Operation;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.InternalStoreId;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchRequest {
    private static final String ADD_OPERATION = Operation.ADD.toLowercase();
    private static final String UPDATE_OPERATION = Operation.UPDATE.toLowercase();
    private static final String DELETE_OPERATION = Operation.DELETE.toLowercase();
    private static final String COPY_OPERATION = Operation.COPY.toLowercase();
    private static final String MOVE_OPERATION = Operation.MOVE.toLowercase();
    private final Connector connector;
    private final CMIndexBuilder indexBuilder;
    private final CMStore store;
    private long maxBatchSizeInBytes;
    private Map<InternalStoreId, CMIndexPayload> indexablePayloads = new HashMap<InternalStoreId, CMIndexPayload>();
    private Map<String, CMProperty[]> propertiesByObjectClass = new HashMap<String, CMProperty[]>();
    private List<InternalStoreId> internalStoreIds = new ArrayList<InternalStoreId>();
    private JSONArray batchCommands = new JSONArray();
    private JSONArray currentItems = new JSONArray();
    private String currentOperation = "";
    private long estimatedBatchSizeInBytes;

    public BatchRequest(Connector connector, CMIndexBuilder indexBuilder, CMStore store, long maxBatchSizeInBytes) {
        this.connector = connector;
        this.indexBuilder = indexBuilder;
        this.store = store;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
    }

    public void sendRequest(List<ICMQueueItem> batchItems) throws CMException {
        this.queryIndexableItems(batchItems);
        this.addItemsToBatchRequest(batchItems);
        this.sendToSearch();
    }

    private void queryIndexableItems(List<ICMQueueItem> batchItems) throws CMException {
        for (ICMQueueItem item : batchItems) {
            this.collectQueryParameters(item);
        }
        this.queryCmObjects();
    }

    private void collectQueryParameters(ICMQueueItem item) {
        String operation = this.getOperation(item);
        if (this.isAdd(operation) || this.isUpdate(operation)) {
            this.saveIndexableProperties(this.getObjectClass(item));
            this.internalStoreIds.add(item.getInternalStoreId());
        }
    }

    private String getObjectClass(ICMQueueItem item) {
        CMIndexQueueData data = (CMIndexQueueData)item.getData();
        return data.getObjectClass();
    }

    private void saveIndexableProperties(String objectClass) {
        CMProperty[] properties;
        if (!this.propertiesByObjectClass.containsKey(objectClass) && (properties = this.indexBuilder.getIndexableProperties(this.store, objectClass)) != null) {
            this.propertiesByObjectClass.put(objectClass, properties);
        }
    }

    private void queryCmObjects() throws CMException {
        if (!this.internalStoreIds.isEmpty()) {
            this.indexablePayloads = this.indexBuilder.queryCMObjects(this.store, this.internalStoreIds, this.propertiesByObjectClass);
        }
    }

    private void addItemsToBatchRequest(List<ICMQueueItem> batchItems) {
        for (ICMQueueItem item : batchItems) {
            this.addItem(item);
        }
    }

    private void addItem(ICMQueueItem item) {
        String operation = this.getOperation(item);
        if (this.hasOperationChanged(operation)) {
            this.saveCurrentItems();
            this.currentOperation = operation;
        }
        this.addItemToBatch(item, operation);
    }

    private String getOperation(ICMQueueItem item) {
        CMIndexQueueData data = (CMIndexQueueData)item.getData();
        String operation = data.getOperation().toLowerCase();
        if (this.isCopy(operation)) {
            return ADD_OPERATION;
        }
        if (this.isMove(operation)) {
            return UPDATE_OPERATION;
        }
        return operation;
    }

    private boolean hasOperationChanged(String operation) {
        return !operation.equals(this.currentOperation);
    }

    private void saveCurrentItems() {
        if (!this.currentItems.isEmpty()) {
            JSONObject batchCommand = new JSONObject();
            batchCommand.put((Object)this.currentOperation, (Object)this.currentItems);
            this.batchCommands.add((Object)batchCommand);
            this.currentItems = new JSONArray();
        }
    }

    private void addItemToBatch(ICMQueueItem item, String operation) {
        if (this.isAdd(operation) || this.isUpdate(operation)) {
            this.addIndexableItem(item);
        } else if (this.isDelete(operation)) {
            this.currentItems.add((Object)item.getObjectID());
        } else {
            throw new UnsupportedOperationException(operation);
        }
    }

    private boolean isAdd(String operation) {
        return operation.equals(ADD_OPERATION);
    }

    private boolean isCopy(String operation) {
        return operation.equals(COPY_OPERATION);
    }

    private boolean isMove(String operation) {
        return operation.equals(MOVE_OPERATION);
    }

    private boolean isUpdate(String operation) {
        return operation.equals(UPDATE_OPERATION);
    }

    private boolean isDelete(String operation) {
        return operation.equals(DELETE_OPERATION);
    }

    private void addIndexableItem(ICMQueueItem item) {
        JSONObject indexableItem;
        CMIndexPayload indexablePayload = this.getIndexablePayload(item);
        JSONObject jSONObject = indexableItem = indexablePayload != null ? indexablePayload.getPayload() : null;
        if (indexableItem != null && !indexableItem.isEmpty()) {
            this.currentItems.add((Object)indexableItem);
            this.updateBatchSize(indexablePayload.getSize());
        }
    }

    private void updateBatchSize(long payloadSize) {
        this.estimatedBatchSizeInBytes += payloadSize;
        if (this.estimatedBatchSizeInBytes >= this.maxBatchSizeInBytes) {
            this.sendToSearch();
        }
    }

    private CMIndexPayload getIndexablePayload(ICMQueueItem item) {
        InternalStoreId id = item.getInternalStoreId();
        return id != null ? this.indexablePayloads.get(id) : null;
    }

    private void sendToSearch() {
        this.saveCurrentItems();
        if (!this.batchCommands.isEmpty()) {
            this.sendBatchPayload();
            this.resetBatch();
        }
    }

    private void sendBatchPayload() {
        JSONObject jsonPayload = new JSONObject();
        jsonPayload.put((Object)"batch", (Object)this.batchCommands);
        this.connector.sendBatchRequest(jsonPayload);
    }

    private void resetBatch() {
        this.batchCommands = new JSONArray();
        this.estimatedBatchSizeInBytes = 0L;
    }
}

