/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.indexers;

import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.deployment.exportTree.BatchSizeSelector;
import com.cognos.cm.deployment.exportTree.ExportEntry;
import com.cognos.cm.deployment.exportTree.ExportSet;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.search.indexing.CMIndexBatchController;
import com.cognos.cm.search.indexing.CMIndexBuilder;
import com.cognos.cm.search.indexing.CMIndexPayload;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.initialSync.IndexTree;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;

public abstract class Indexer {
    protected static final String OBJECTS = "objects";
    protected static final int DEFAULT_MAX_BATCH_SIZE_NUMBER_OBJECTS = 2000;
    protected static final long DEFAULT_MAX_BATCH_SIZE_BYTES = 0xA00000L;
    protected final CMIndexBuilder indexBuilder;
    private final TraceLogger logger;
    private BatchSizeSelector batchSizeSelector;
    private int maxIndexingBatchSizeNumObjs;
    private long maxIndexingBatchSizeBytes;

    public Indexer() throws CMException {
        this(new CMIndexBuilder(), ConfigurationFactory.getConfig(), new TraceLogger());
    }

    protected Indexer(CMIndexBuilder indexBuilder, IConfiguration config, TraceLogger logger) throws CMException {
        this.indexBuilder = indexBuilder;
        this.logger = logger;
        this.maxIndexingBatchSizeBytes = Indexer.getMaxBatchSizeBytes(config);
        this.maxIndexingBatchSizeNumObjs = Indexer.getMaxBatchSizeNumOfObjs(config);
        this.batchSizeSelector = new BatchSizeSelector(Math.min(this.maxIndexingBatchSizeNumObjs, CMDbConnection.getMaxObjectsInline()));
    }

    public long getMaxBatchSizeInBytes() {
        return this.maxIndexingBatchSizeBytes;
    }

    public IndexTree buildIndexTree(String root) throws CMException {
        return this.indexBuilder.buildIndexTree(root);
    }

    public IndexTree buildIndexTree(String root, int maxRetries) throws CMException, InterruptedException {
        return this.indexBuilder.buildIndexTree(root, maxRetries);
    }

    public int index(IndexTree tree) throws CMException {
        CMIndexBatchController batchController = new CMIndexBatchController(this.maxIndexingBatchSizeBytes);
        int nextId = 1;
        for (ExportSet set : tree.exportSets()) {
            CMObjectClass cls = set.getObjectClass();
            int batchSize = this.batchSizeSelector.getBatchSize(cls);
            set.setBatchSize(batchSize);
            nextId = this.indexSet(set, nextId, batchController);
        }
        if (batchController.size() > 0) {
            this.indexOneBulkPackage(batchController);
        }
        return nextId - 1;
    }

    public abstract void index(ICMQueueItem var1, CMStore var2) throws Exception;

    private void indexOneBulkPackage(CMIndexBatchController batchController) throws CMException {
        this.indexOneBatch(batchController.getNextBatch());
        batchController.clear();
    }

    protected abstract void indexOneBatch(JSONArray var1) throws CMException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexSet(ExportSet set, int nextId, CMIndexBatchController batchController) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        ICMLockManager lockMgr = store.getLockManager();
        CMProperty[] props = this.indexBuilder.getIndexableProperties(set.getObjectClass());
        for (HashMap<InternalStoreId, ExportEntry> batch : set) {
            CMStoreQueryResults results = null;
            if (batch.isEmpty()) continue;
            try {
                lockMgr.requestLocks(batch.keySet(), 10);
                results = store.executeQuery(batch.keySet(), props, null, 0, this.getPermissions(), null);
                while (results.next()) {
                    int cmid = results.getObjectID();
                    ExportEntry entry = batch.get(store.getInternalStoreId(cmid));
                    if (entry == null) continue;
                    CMIndexPayload payload = this.indexBuilder.buildJSONPayloadFromResults(results, props);
                    if (batchController.addToBatchAndIsBatchFull(payload)) {
                        this.indexOneBulkPackage(batchController);
                    }
                    entry.setID(nextId);
                    ++nextId;
                }
            }
            finally {
                if (results != null) {
                    results.release();
                }
                lockMgr.releaseLocks();
            }
            if (batchController.size() < this.maxIndexingBatchSizeNumObjs) continue;
            this.logDebug("Max number of objects per batch " + this.maxIndexingBatchSizeNumObjs + " is reached.");
            this.indexOneBulkPackage(batchController);
        }
        return nextId;
    }

    private static int getMaxBatchSizeNumOfObjs(IConfiguration config) {
        String maxBatchSizeNumObjsStr = config.getConfigAdvancedProp("INDEXING_MAX_BATCH_SIZE_NUMBER_OBJECTS");
        int maxBatchSizeNumObjs = 2000;
        if (maxBatchSizeNumObjsStr != null) {
            maxBatchSizeNumObjs = Integer.parseInt(maxBatchSizeNumObjsStr);
        }
        return maxBatchSizeNumObjs;
    }

    private static long getMaxBatchSizeBytes(IConfiguration config) {
        String maxBatchSizeMBStr = config.getConfigAdvancedProp("INDEXING_MAX_BATCH_SIZE_MB");
        long maxBatchSizeBytes = 0xA00000L;
        if (maxBatchSizeMBStr != null) {
            maxBatchSizeBytes = 0x100000L * Long.parseLong(maxBatchSizeMBStr);
        }
        return maxBatchSizeBytes;
    }

    protected int getPermissions() {
        return 33280;
    }

    protected ICMLockManager getLockManager(CMStore store) {
        return store.getLockManager();
    }

    protected CMObjectClass getClassByName(CMStore store, String objClassName) {
        return store.getObjectClasses().getClassByName(objClassName);
    }

    protected void log(String text) {
        this.logger.logInfo(text);
    }

    protected void logDebug(String text) {
        this.logger.logDebug(text);
    }

    protected void log(JSONObject json) {
        this.logger.logDebug((JSONArtifact)json);
    }
}

