/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.indexers;

import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.connectors.rest.search.IndexConnector;
import com.cognos.cm.search.indexing.indexers.Indexer;
import com.cognos.cm.search.indexing.initialSync.IndexTree;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.path.CMStoreXPath;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;

public class MoveIndexer
extends Indexer {
    @Override
    public void index(ICMQueueItem queueItem, CMStore store) throws Exception {
        this.log("CM.MoveIndexer: //* Move " + queueItem.getObjectID());
        long tStart = System.currentTimeMillis();
        String storeID = CMStoreXPath.encodeStoreIdToPathString(queueItem.getObjectID());
        IndexTree tree = this.buildIndexTree(storeID);
        int count = this.index(tree);
        long duration = (System.currentTimeMillis() - tStart) / 1000L;
        String msg = "Indexed " + count + " moved objects. " + "Duration: " + duration + " (seconds)";
        this.log(msg);
    }

    @Override
    protected void indexOneBatch(JSONArray batch) throws CMException {
        IndexConnector connector = IndexConnector.getConnector();
        JSONObject jsonPayload = new JSONObject();
        jsonPayload.put((Object)"objects", (Object)batch);
        connector.cmObjectsUpdated(jsonPayload);
        this.log("CM.MoveIndexer: //* Payload sent, size=" + batch.size());
    }
}

