/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.indexing.jsonSerializers;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.search.indexing.jsonSerializers.JSONSerializer;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMServlet;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class PoliciesSerializer
implements JSONSerializer {
    private static final String READ = "read";
    private static final String EXECUTE = "execute";
    private static final String TRAVERSE = "traverse";
    private static final String WRITE = "write";
    private static final String SETPOLICY = "setPolicy";
    private static final String GRANT = "grant";
    private static final String DENY = "deny";
    private static final String NAME = "name";
    private static final String ACCESS = "access";

    @Override
    public Object getJSON(CMObjectClass objClass, CMProperty prop, Object value) throws CMException {
        return this.convertPolicyBlob((byte[])value);
    }

    private JSONObject convertPolicyBlob(byte[] arrPolicy) throws CMException {
        if (arrPolicy.length > 0) {
            try {
                String policiesXML = CMServlet.AAA.DescribePolicy(null, arrPolicy, "<properties xmlns=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">searchPath</item></properties>", null);
                HashMap<String, JSONArray> allGrants = new HashMap<String, JSONArray>();
                HashMap<String, JSONArray> allDenies = new HashMap<String, JSONArray>();
                this.initializeMapWithPermissionSets(allGrants);
                this.initializeMapWithPermissionSets(allDenies);
                this.getGrantDenyPolicies(policiesXML, allGrants, allDenies);
                return this.createJSONObject(allGrants, allDenies);
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmNoReadPolicy");
            }
        }
        return new JSONObject();
    }

    private void initializeMapWithPermissionSets(Map<String, JSONArray> map) {
        map.put(READ, new JSONArray());
        map.put(WRITE, new JSONArray());
        map.put(EXECUTE, new JSONArray());
        map.put(SETPOLICY, new JSONArray());
        map.put(TRAVERSE, new JSONArray());
    }

    private void getGrantDenyPolicies(String policiesXML, Map<String, JSONArray> allGrants, Map<String, JSONArray> allDenies) throws Exception {
        try {
            SAXReader reader = new SAXReader();
            Document policies = reader.read((InputStream)new ByteArrayInputStream(policiesXML.getBytes(Charset.forName("UTF-8"))));
            List policyNodes = policies.selectNodes("/bus:policies/value/item");
            Iterator policyIter = policyNodes.iterator();
            while (policyIter.hasNext()) {
                this.extractPolicyInformation((Node)policyIter.next(), allGrants, allDenies);
            }
        }
        catch (DocumentException ex) {
            throw new CMException((Exception)((Object)ex), "cmBadXML");
        }
    }

    private void extractPolicyInformation(Node policy, Map<String, JSONArray> allGrants, Map<String, JSONArray> allDenies) {
        String camId = this.getTextFromInnerNode(policy, "securityObject/searchPath/value");
        List permissionNodes = policy.selectNodes("permissions/item");
        Iterator nodeIter = permissionNodes.iterator();
        while (nodeIter.hasNext()) {
            this.extractGrantDenyInformation((Node)nodeIter.next(), camId, allGrants, allDenies);
        }
    }

    private void extractGrantDenyInformation(Node permission, String camId, Map<String, JSONArray> allGrants, Map<String, JSONArray> allDenies) {
        String name = this.getTextFromInnerNode(permission, NAME);
        String access = this.getTextFromInnerNode(permission, ACCESS);
        if (GRANT.equals(access)) {
            this.addCamId(allGrants.get(name), camId);
        } else if (DENY.equals(access)) {
            this.addCamId(allDenies.get(name), camId);
        }
    }

    private void addCamId(JSONArray grantOrDeny, String camId) {
        if (grantOrDeny != null) {
            grantOrDeny.add((Object)camId);
        }
    }

    private String getTextFromInnerNode(Node parentNode, String path) {
        return parentNode.selectSingleNode(path).getText();
    }

    private JSONObject createJSONObject(Map<String, JSONArray> grant, Map<String, JSONArray> deny) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)GRANT, (Object)this.buildPolicyObject(grant));
        jsonObj.put((Object)DENY, (Object)this.buildPolicyObject(deny));
        return jsonObj;
    }

    private JSONObject buildPolicyObject(Map<String, JSONArray> policy) {
        JSONObject obj = new JSONObject();
        obj.put((Object)READ, (Object)policy.get(READ));
        obj.put((Object)WRITE, (Object)policy.get(WRITE));
        obj.put((Object)EXECUTE, (Object)policy.get(EXECUTE));
        obj.put((Object)SETPOLICY, (Object)policy.get(SETPOLICY));
        obj.put((Object)TRAVERSE, (Object)policy.get(TRAVERSE));
        return obj;
    }
}

