/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.search.notification;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.notification.NotificationObserver;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.queues.CMIndexQueueData;
import com.cognos.cm.queues.CMQueueManager;
import com.cognos.cm.search.indexing.IndexingSubscriptionChecker;
import com.cognos.cm.search.indexing.SubscriptionChecker;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import io.prometheus.client.Summary;
import java.util.ArrayList;
import java.util.Map;

public class IndexingObserver
implements NotificationObserver {
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    public boolean notificationsEnabled = true;
    private static long lastTimeErrorWasLogged;
    private String indexQueueName;
    private static final Summary NOTIFICATION_ADD_SUMMARY;
    private final String workflow;
    private final int queueCapacity;
    private final String queueFullErrorCode;
    private final SubscriptionChecker subscriptionChecker;
    private final TraceLogger logger;

    public IndexingObserver() {
        this("searchIndex", AdvancedSettings.INDEX_MAXNOTIFICATIONQUEUECAPACITY, "cmSearchNotificationQueueIsFull", new IndexingSubscriptionChecker(), new TraceLogger());
    }

    protected IndexingObserver(String workflow, int queueCapacity, String queueFullErrorCode, SubscriptionChecker subscriptionChecker, TraceLogger logger) {
        this.workflow = workflow;
        this.queueCapacity = queueCapacity;
        this.queueFullErrorCode = queueFullErrorCode;
        this.subscriptionChecker = subscriptionChecker;
        this.logger = logger;
    }

    @Override
    public void initialize(Subscription subscription) {
        ICMQueueManager queueManager = this.getQueueManager();
        try {
            if (!queueManager.isStarted()) {
                queueManager.start();
            }
            this.indexQueueName = queueManager.getFirstQueueName(this.workflow);
        }
        catch (Throwable t) {
            CMIndications.logThrowable(t);
        }
    }

    @Override
    public void enable(boolean enable) {
        this.notificationsEnabled = enable;
        if (!enable) {
            this.cleanIndexQueue();
        }
    }

    @Override
    public void addNotification(Notification notification) {
        if (!this.notificationsEnabled) {
            return;
        }
        if (!this.subscriptionChecker.isSubscribed(notification)) {
            return;
        }
        try (Summary.Timer addTimer = null;){
            addTimer = NOTIFICATION_ADD_SUMMARY.startTimer();
            this.reallyAddNotification(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyAddNotification(Notification notification) {
        CMExecutionContext origContext = null;
        if (CMExecutionContext.hasContext()) {
            origContext = CMExecutionContext.get();
        }
        CMExecutionContext.set(new CMExecutionContext());
        CMIndexQueueData data = new CMIndexQueueData(notification.getOperation());
        data.setObjectClass(notification.getObjectClass().toString());
        try {
            if (notification.getOperation() == "update") {
                this.setForUpdate(notification, data);
            } else {
                if (notification.getOperation() == "copy" && !this.isCopied(notification)) {
                    return;
                }
                if (notification.getOperation() == "move" && !this.isMoved(notification)) {
                    return;
                }
            }
            this.queueNotification(notification, data);
        }
        catch (Throwable t) {
            CMIndications.logThrowable(t);
        }
        finally {
            if (CMExecutionContext.hasContext()) {
                CMExecutionContext.tearDown();
            }
            CMExecutionContext.set(origContext);
        }
    }

    private void queueNotification(Notification notification, CMIndexQueueData data) throws CMException, CMStoreNotAvailable, CMStoreUnexpected {
        CMStore store;
        ICMQueueManager queueManager = this.getQueueManager();
        if (this.isNofiticationQueueFull(queueManager, store = this.getStore())) {
            this.logNotificationQueueError();
        } else {
            this.addToNotificationQueue(queueManager, store, notification, data);
        }
    }

    private void logNotificationQueueError() {
        if (this.shouldLogQueueError()) {
            CMIndications.CMTrace(this.queueFullErrorCode);
        }
    }

    private boolean shouldLogQueueError() {
        long now = System.currentTimeMillis();
        if (now - lastTimeErrorWasLogged > 60000L) {
            lastTimeErrorWasLogged = now;
            return true;
        }
        return false;
    }

    private boolean isNofiticationQueueFull(ICMQueueManager queueManager, CMStore store) throws CMException {
        return this.getNotificationQueueSize(queueManager, store) > this.queueCapacity;
    }

    private int getNotificationQueueSize(ICMQueueManager queueManager, CMStore store) throws CMException {
        return queueManager.getQueueSize(store, this.indexQueueName, CMQueueItemState.AVAILABLE);
    }

    private void addToNotificationQueue(ICMQueueManager queueManager, CMStore store, Notification notification, CMIndexQueueData data) throws CMException {
        String storeID = notification.getStoreID();
        queueManager.put(store, storeID, this.workflow, data);
        this.log(storeID, data);
    }

    private void setForUpdate(Notification notification, CMIndexQueueData data) {
        Map<String, Object> additional = notification.getAdditionalParameters();
        String updateProperties = (String)additional.get("updateProperties");
        data.setProperties(updateProperties);
    }

    private boolean isCopied(Notification notification) {
        return this.isAffectedObject(notification, "copiedObjects");
    }

    private boolean isMoved(Notification notification) {
        return this.isAffectedObject(notification, "movedObjects");
    }

    private boolean isAffectedObject(Notification notification, String paramName) {
        Map<String, Object> additional = notification.getAdditionalParameters();
        int[] ids = (int[])additional.get(paramName);
        String storeID = notification.getStoreID();
        for (int i = 0; i < ids.length; ++i) {
            try {
                String objStoreId = this.getStore().getObjectStoreID(ids[i]);
                if (!objStoreId.equals(storeID)) continue;
                return true;
            }
            catch (Throwable t) {
                CMIndications.logThrowable(t);
            }
        }
        return false;
    }

    private void log(String storeId, CMIndexQueueData data) {
        if (this.logger.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("CM.IndexingObserver: ");
            sb.append(data.getOperation()).append(" ");
            sb.append(data.getObjectClass()).append(" ");
            sb.append(storeId).append(" ");
            String props = data.getProperties();
            if (props != null) {
                sb.append(data.getProperties());
            }
            this.logger.info(sb.toString());
        }
    }

    private void cleanIndexQueue() {
        ICMQueueManager queueManager = this.getQueueManager();
        try {
            queueManager.cleanQueue(this.getStore(), this.indexQueueName);
            this.logger.logInfo("CM.IndexingObserver: Notification queue cleaned!");
        }
        catch (Throwable t) {
            CMIndications.logThrowable(t);
        }
    }

    protected CMStore getStore() throws CMStoreNotAvailable, CMStoreUnexpected {
        return CMExecutionContext.get().getStore();
    }

    protected ICMQueueManager getQueueManager() {
        return CMQueueManager.getManager();
    }

    @Override
    public void addNotifications(ArrayList<Notification> notifications) {
        for (Notification notification : notifications) {
            this.addNotification(notification);
        }
    }

    static {
        NOTIFICATION_ADD_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name("p2pd_cm_index_notification_enqueue_time")).help("summary of time taken adding to the indexing notification queue")).register();
    }
}

