/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.CAM.AAAException;
import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.AccManAuthResponse;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.CamAction;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.RequestManager;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDOMUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cm.util.DOMWriter;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AccMan {
    private static boolean bInitialized = false;
    public static boolean bEnableAuthenticateMethod = true;
    public static boolean bFirstAuthenticate = true;
    private static String camLogoff1_ = null;
    private static String camLogoff2_;
    private static String camLogoff3_;

    private static synchronized void Initialize() {
        if (!bInitialized) {
            bInitialized = true;
            IConfiguration config = null;
            config = ConfigurationFactory.getConfig();
            String s = config.getInternalProp("CMEnableAuthenticateMethod");
            if (s != null) {
                if (0 == s.compareTo("1")) {
                    bEnableAuthenticateMethod = true;
                } else if (0 == s.compareTo("0")) {
                    bEnableAuthenticateMethod = false;
                }
            }
        }
    }

    private static String constructCAMPassportHeader(String sPassportID) {
        StringBuffer doc = new StringBuffer();
        doc.append("<bus:biBusHeader xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        doc.append("<CAM xsi:type=\"bus:CAM\">");
        doc.append("<CAMPassport xsi:type=\"bus:CAMPassport\">");
        doc.append("<id xsi:type=\"xsd:string\" xml:space=\"preserve\">");
        doc.append(sPassportID);
        doc.append("</id>");
        doc.append("</CAMPassport>");
        doc.append("</CAM>");
        doc.append("</bus:biBusHeader>");
        return doc.toString();
    }

    public static String Authenticate(XMLElement headerEl, CamAction camAction, boolean bCreateUserAccount, boolean bIsValidate, boolean bHasCredential) throws CMException {
        String sPassportDoc;
        if (headerEl == null) {
            throw new CMException("cmAuthenticateFailed");
        }
        AccMan.Initialize();
        if (!bEnableAuthenticateMethod) {
            throw new CMException(null, "cmNoAuthenticate");
        }
        if (bHasCredential) {
            AccMan.processAuthCredential(headerEl, bCreateUserAccount);
        }
        if ((sPassportDoc = AccMan.invokeCAMAuthenticate(headerEl, camAction, bCreateUserAccount, bIsValidate, bHasCredential)) != null && CMIndicationGlobals.bSYS_Info_isEnabled) {
            CMExecutionContext ctx = CMExecutionContext.get();
            CMIndications.CMTrace("cmPassportIs", new CMException.Parm[]{new CMException.Parm("User", ctx.getCurrentUserDisplayName()), new CMException.Parm("UserID", ctx.getCurrentUser()), new CMException.Parm("Passport", ctx.getAccManPassportID())});
        }
        return sPassportDoc;
    }

    private static void processAuthCredential(XMLElement headerEl, boolean bCreateUserAccount) throws CMException {
        block15: {
            CMStoreQueryResults credentialresults = null;
            try {
                XMLElement xmlCAMCredential;
                XMLElement xmlCAM = headerEl.getOptionalChildWithName("CAM");
                if (xmlCAM == null || (xmlCAMCredential = xmlCAM.getOptionalChildWithName("CAMCredentialPath")) == null) break block15;
                if (!bCreateUserAccount) {
                    xmlCAM.deleteChildWithName("CAMCredentialPath");
                    break block15;
                }
                String sServiceID = CMExecutionContext.get().getServiceId();
                if (sServiceID == null) {
                    throw new CMException("cmAuthenticateTCNotTrusted");
                }
                String tcReferenceValue = xmlCAMCredential.value_;
                if (tcReferenceValue == null) {
                    throw new CMException("cmAuthenticateTCNullReference");
                }
                CMStoreXPath credentialContext = new CMStoreXPath(tcReferenceValue);
                CMProperty[] props = new CMProperty[]{CMProperty.CREDENTIALS};
                CMStore store = CMExecutionContext.get().getStore();
                credentialresults = store.executeQuery(credentialContext, props, null, 0, 512, null);
                if (credentialresults != null && credentialresults.next()) {
                    Object credentialValueObject = credentialresults.getValue(0);
                    if (credentialresults.getObjectClass() != CMObjectClass.CREDENTIAL) {
                        throw new CMException("cmAuthenticateTCInvalidReference", new CMException.Parm("reference", tcReferenceValue));
                    }
                    if (credentialValueObject == null) {
                        throw new CMException("cmAuthenticateTCInvalidSelection", new CMException.Parm("reference", tcReferenceValue));
                    }
                    xmlCAMCredential.name_ = "CAMTrustedCredential";
                    xmlCAMCredential.xsiTypeNs_ = CMSOAPConstants.NS_XMLSCHEMA;
                    xmlCAMCredential.xsiType_ = "anyType";
                    xmlCAMCredential.value_ = RequestHandler.readAnyTypePropertyValueIntoString(credentialValueObject);
                    if (credentialresults.next()) {
                        throw new CMException("cmAuthenticateTCInvalidReference", new CMException.Parm("reference", tcReferenceValue));
                    }
                    break block15;
                }
                throw new CMException("cmAuthenticateTCInvalidReference", new CMException.Parm("reference", tcReferenceValue));
            }
            catch (CMException cme) {
                String strErrType = CMError.getSection(cme.getCode());
                if (strErrType != null && strErrType.equalsIgnoreCase("HDR")) {
                    throw cme;
                }
                throw new CMException(cme, "cmAuthenticateTCUnexpectedFault");
            }
            catch (Exception e) {
                throw new CMException(e, "cmAuthenticateTCUnexpectedFault");
            }
            finally {
                if (credentialresults != null) {
                    credentialresults.release();
                }
            }
        }
    }

    private static String invokeCAMAuthenticate(XMLElement headerElement, CamAction camAction, boolean createUserAccount, boolean isValidate, boolean hasCamCredentialPath) throws CMException {
        CMExecutionContext currContext = CMExecutionContext.get();
        String sPassportDoc = null;
        try {
            boolean isLogoff = camAction == CamAction.logoff;
            CMExecutionContext.checkCancelOrTimeOut();
            AAAProvider.Action action = AccMan.getCAMAction(createUserAccount, isValidate, isLogoff, hasCamCredentialPath);
            boolean requiresValidate = action == AAAProvider.Action.VALIDATE;
            boolean validated = false;
            if (requiresValidate) {
                validated = CMServlet.AAA.validate(currContext.getAccManPassportID());
            }
            if (AccMan.requiresCAMAction(requiresValidate, validated)) {
                boolean removeCamAction = false;
                if (currContext.getCurrentUser() == null && AccMan.getCAMAction(headerElement) == null) {
                    AccMan.insertCAMAction(headerElement, "validateWithResponse");
                    removeCamAction = true;
                }
                String camResponse = CMServlet.AAA.invoke(headerElement, action);
                if (removeCamAction) {
                    AccMan.removeCAMAction(headerElement);
                }
                sPassportDoc = AccMan.processAuthRsp(camResponse, camAction, createUserAccount, isValidate);
            }
            currContext.Authenticated();
            return sPassportDoc;
        }
        catch (AAAException ae) {
            throw new CMException((Exception)((Object)ae), "cmAuthenticateFailed");
        }
        catch (CMException e) {
            throw new CMException(e, "cmAuthenticateFailed");
        }
        catch (Exception e) {
            throw new CMException(e, "cmAuthenticateFailed");
        }
    }

    private static void insertCAMAction(XMLElement header, String action) {
        XMLElement cam = header.getOptionalChildWithName("CAM");
        XMLElement actionEl = cam.getOptionalChildWithNameEvenIfNil("action");
        if (actionEl == null) {
            cam.addChild(null, "action", CMSOAPConstants.NS_XMLSCHEMA, "string", action);
        } else {
            actionEl.value_ = action;
        }
    }

    private static void removeCAMAction(XMLElement header) {
        XMLElement cam = header.getOptionalChildWithName("CAM");
        cam.deleteChildWithName("action");
    }

    private static boolean requiresCAMAction(boolean validating, boolean validated) {
        return !validating || !validated;
    }

    private static String getCAMAction(XMLElement header) {
        XMLElement elAction = header.getChild("CAM", "action");
        if (elAction != null) {
            return elAction.value_;
        }
        return null;
    }

    private static AAAProvider.Action getCAMAction(boolean bCreateUserAccount, boolean bIsValidate, boolean bIsLogoff, boolean hasCamCredentialPath) {
        AAAProvider.Action action = bIsLogoff ? AAAProvider.Action.LOGOFF : (bCreateUserAccount ? AAAProvider.Action.CREATEUSERACCOUNT : (bIsValidate && !hasCamCredentialPath ? AAAProvider.Action.VALIDATE : AAAProvider.Action.LOGON));
        return action;
    }

    private static String processAuthRsp(String sPassportDoc, CamAction action, boolean bCreateUserAccount, boolean bIsValidate) throws CMException, Exception {
        if (sPassportDoc == null) {
            throw new CMException("cmLoginFailed");
        }
        AccManAuthResponse rsp = new AccManAuthResponse(sPassportDoc);
        CMExecutionContext currContext = CMExecutionContext.get();
        String sOldPassport = currContext.getAccManPassportID();
        String sNewPassport = rsp.getPassportID();
        if (sNewPassport != null && !sNewPassport.equalsIgnoreCase(sOldPassport)) {
            bIsValidate = false;
            currContext.setAccManPassportID(sNewPassport);
            currContext.setSessionContext(rsp.getSessionContext());
        }
        if (action != CamAction.logoff && (!bIsValidate || bCreateUserAccount)) {
            boolean createProxy = action != CamAction.clonePassport && action != CamAction.generateTC;
            currContext.initializeASession(rsp, createProxy);
            if (currContext.getTrustedCredential() != null) {
                CMStore store = currContext.getStore();
                store.getUserAccountObjectID(currContext.getCurrentUser(), null, currContext.getTrustedCredential(), -1);
                rsp.rewriteTrustedCredential(currContext.getCurrentUser());
                sPassportDoc = rsp.toString();
            }
        }
        return sPassportDoc;
    }

    public static String AuthenticateCredentials(XMLElement headerEl, String credentialValue) throws CMException {
        if (headerEl == null) {
            throw new CMException("cmAuthenticateFailed");
        }
        AccMan.Initialize();
        if (!bEnableAuthenticateMethod) {
            throw new CMException(null, "cmNoAuthenticate");
        }
        String sHeader = null;
        CMExecutionContext currContext = CMExecutionContext.get();
        ArrayList<XMLElement> oldCAMChildren = null;
        ArrayList<XMLElement> oldHDRSession = null;
        XMLElement xmlHdrSession = headerEl.getOptionalChildWithName("hdrSession");
        if (xmlHdrSession != null) {
            oldHDRSession = xmlHdrSession.children_;
            headerEl.deleteChildWithName("hdrSession");
        }
        try {
            XMLElement xmlCAM = headerEl.getOptionalChildWithName("CAM");
            if (xmlCAM != null) {
                oldCAMChildren = xmlCAM.children_;
                xmlCAM.deleteChildren();
            } else {
                xmlCAM = new XMLElement();
                xmlCAM = headerEl.addChild(CMSOAPConstants.NS_BIBUS, "CAM", null, null);
            }
            xmlCAM.addChild(CMSOAPConstants.NS_BIBUS, "action", CMSOAPConstants.NS_BIBUS, "actionEnum", "logonAs");
            xmlCAM.addChild(CMSOAPConstants.NS_BIBUS, "CAMTrustedCredential", CMSOAPConstants.NS_XMLSCHEMA, "base64Binary", credentialValue);
            sHeader = headerEl.makeXML("\t", true, true, true, true, currContext.getCAMAdditionalInfo(), headerEl.getOptionalChildWithName("tracking"));
            xmlCAM.children_ = oldCAMChildren;
            if (xmlHdrSession != null) {
                xmlHdrSession = headerEl.addChild((CMSOAPConstants.XMLNamespace)null, "hdrSession", CMSOAPConstants.NS_BIBUS, "hdrSession");
                xmlHdrSession.children_ = oldHDRSession;
            }
        }
        catch (Exception e) {
            throw new CMException(e, "cmAuthenticateTCUnexpectedFault");
        }
        String cookieValue = "";
        try {
            String sPassportDoc = CMServlet.AAA.invoke(sHeader, AAAProvider.Action.LOGONAS);
            cookieValue = AccMan.getCAMPassportCookie(sPassportDoc);
        }
        catch (AAAException ae) {
            throw new CMException((Exception)((Object)ae), "cmAuthenticateFailed");
        }
        catch (CMException e) {
            throw new CMException(e, "cmAuthenticateFailed");
        }
        catch (Exception e) {
            throw new CMException(e, "cmAuthenticateFailed");
        }
        return cookieValue;
    }

    private static String getCAMPassportCookie(String sPassportDoc) throws CMException, Exception {
        String passportCookieValue = "";
        if (sPassportDoc == null) {
            throw new CMException("cmLoginFailed");
        }
        AccManAuthResponse authRsp = new AccManAuthResponse(sPassportDoc);
        passportCookieValue = authRsp.getCAMPassportCookie();
        return passportCookieValue;
    }

    private static void writeArrayElement(StringBuffer out, String elementName, String arrayTypePrefix, String arrayType) {
        out.append("<");
        out.append(elementName);
        out.append(" ");
        out.append("xsi");
        out.append(":");
        out.append("type");
        out.append("=\"");
        out.append("SOAP-ENC");
        out.append(":");
        out.append("Array");
        out.append("\" ");
        out.append("SOAP-ENC");
        out.append(":");
        out.append("arrayType");
        out.append("=\"");
        out.append(arrayTypePrefix);
        out.append(":");
        out.append(arrayType);
        out.append("[");
    }

    private static void writeArrayElement(StringBuffer out, String elementName, String arrayTypePrefix, String arrayType, int size) {
        AccMan.writeArrayElement(out, elementName, arrayTypePrefix, arrayType);
        out.append(Integer.toString(size));
        out.append("]\">\r\n");
    }

    private static void writeElement(StringBuffer out, String elementName, String typePrefix, String type) {
        out.append("<");
        out.append(elementName);
        out.append(" ");
        out.append("xsi");
        out.append(":");
        out.append("type");
        out.append("=\"");
        out.append(typePrefix);
        out.append(":");
        out.append(type);
        out.append("\">");
    }

    private static void writeElement(StringBuffer out, String elementName, String typePrefix, String type, String value) {
        AccMan.writeElement(out, elementName, typePrefix, type);
        out.append(value);
        out.append("</");
        out.append(elementName);
        out.append(">\r\n");
    }

    private static void writeEndElement(StringBuffer out, String elementName) {
        out.append("</");
        out.append(elementName);
        out.append(">\r\n");
    }

    private static void writePermissionElement(StringBuffer policyXML, String strName, String strAccess) {
        AccMan.writeElement(policyXML, "item", "cm", "permission");
        AccMan.writeElement(policyXML, "name", "xsd", CMPropertyTypes.XML_STRING.getName(), strName);
        AccMan.writeElement(policyXML, "access", "cm", "accessEnum", strAccess);
        AccMan.writeEndElement(policyXML, "item");
    }

    public static byte[] createAPolicy(Object[][] policyDefinition) throws AAAException {
        StringBuffer policyXML = new StringBuffer(2048);
        policyXML.append("<");
        policyXML.append("policies");
        policyXML.append(" ");
        policyXML.append(" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"");
        policyXML.append(" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"");
        policyXML.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        policyXML.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        AccMan.writeArrayElement(policyXML, "value", "cm", "policy", policyDefinition.length);
        for (int i = 0; i < policyDefinition.length; ++i) {
            AccMan.writeElement(policyXML, "item", "cm", "policy");
            AccMan.writeElement(policyXML, "securityObject", "cm", "baseClass");
            AccMan.writeElement(policyXML, CMProperty.SEARCHPATH.getName(), "cm", CMPropertyTypes.XML_STRING.getPropertyTypeName());
            AccMan.writeElement(policyXML, "value", "xsd", CMPropertyTypes.XML_STRING.getName(), XMLUtils.escape((String)((String)policyDefinition[i][0])));
            AccMan.writeEndElement(policyXML, CMProperty.SEARCHPATH.getName());
            AccMan.writeEndElement(policyXML, "securityObject");
            int numPerms = 0;
            for (int iPerm = 1; iPerm < 6; ++iPerm) {
                if (!((Boolean)policyDefinition[i][iPerm]).booleanValue()) continue;
                ++numPerms;
            }
            AccMan.writeArrayElement(policyXML, "permissions", "cm", "permission", numPerms);
            if (((Boolean)policyDefinition[i][1]).booleanValue()) {
                AccMan.writePermissionElement(policyXML, "read", "grant");
            }
            if (((Boolean)policyDefinition[i][2]).booleanValue()) {
                AccMan.writePermissionElement(policyXML, "write", "grant");
            }
            if (((Boolean)policyDefinition[i][3]).booleanValue()) {
                AccMan.writePermissionElement(policyXML, "execute", "grant");
            }
            if (((Boolean)policyDefinition[i][4]).booleanValue()) {
                AccMan.writePermissionElement(policyXML, "setPolicy", "grant");
            }
            if (((Boolean)policyDefinition[i][5]).booleanValue()) {
                AccMan.writePermissionElement(policyXML, "traverse", "grant");
            }
            AccMan.writeEndElement(policyXML, "permissions");
            AccMan.writeEndElement(policyXML, "item");
        }
        AccMan.writeEndElement(policyXML, "value");
        AccMan.writeEndElement(policyXML, "policies");
        String strpolicyXML = policyXML.toString();
        byte[] arrPolicy = CMServlet.AAA.CreatePolicy(strpolicyXML, CMExecutionContext.get().getCAMAdditionalInfo());
        return arrPolicy;
    }

    public static byte[] createUserSessionPolicyFromTemplate(String sUserCAMID, byte[] templatePolicy) throws AAAException, Exception {
        return AccMan.createUserAccountPolicyFromTemplate(sUserCAMID, templatePolicy, sUserCAMID.equals("::Anonymous"), true);
    }

    public static byte[] createUserAccountPolicyFromTemplate(String sUserCAMID, byte[] templatePolicy, boolean isAnonymous) throws AAAException, Exception {
        return AccMan.createUserAccountPolicyFromTemplate(sUserCAMID, templatePolicy, isAnonymous, false);
    }

    private static byte[] createUserAccountPolicyFromTemplate(String sUserCAMID, byte[] templatePolicy, boolean isAnonymous, boolean bSession) throws AAAException, Exception {
        String xmlPolicy = CMServlet.AAA.DescribePolicy(null, templatePolicy, null, null);
        try {
            XMLElement xmlPolicies;
            XMLDoc xmlDoc = null;
            XMLDocParser parser = new XMLDocParser();
            xmlDoc = parser.readXML(xmlPolicy);
            if (xmlDoc != null && xmlDoc.getRootXMLElement() != null && (xmlPolicies = xmlDoc.getRootXMLElement().getOptionalChildWithName("value")) != null) {
                ArrayList<XMLElement> children = xmlPolicies.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    XMLElement item = (XMLElement)children.get(i);
                    XMLElement sp = item.getChild("securityObject", "searchPath", "value");
                    if (sp == null || sp.value_ == null || sp.value_.indexOf("::Everyone") < 0) continue;
                    children.remove(i);
                    --i;
                }
                if (sUserCAMID != null) {
                    XMLElement newPolicy = xmlPolicies.addChild(null, "item", CMSOAPConstants.NS_XMLSCHEMAINSTANCE, "policy", null);
                    XMLElement elem = newPolicy.addChild(null, "securityObject", CMSOAPConstants.NS_BIBUS, "baseClass", null);
                    elem = elem.addChild(null, "searchPath", CMSOAPConstants.NS_BIBUS, "stringProp", null);
                    elem = elem.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "string", "CAMID(\"" + sUserCAMID + "\")");
                    XMLElement elemPerms = newPolicy.addChild(null, "permissions", CMSOAPConstants.NS_BIBUS, "permission", null);
                    elemPerms.isArray_ = true;
                    XMLElement permItem = elemPerms.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "permission", null);
                    elem = permItem.addChild(null, "name", CMSOAPConstants.NS_XMLSCHEMA, "string", "read");
                    elem = permItem.addChild(null, "access", CMSOAPConstants.NS_BIBUS, "accessEnum", "grant");
                    permItem = elemPerms.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "permission", null);
                    elem = permItem.addChild(null, "name", CMSOAPConstants.NS_XMLSCHEMA, "string", "traverse");
                    elem = permItem.addChild(null, "access", CMSOAPConstants.NS_BIBUS, "accessEnum", "grant");
                    if (!isAnonymous || bSession) {
                        permItem = elemPerms.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "permission", null);
                        elem = permItem.addChild(null, "name", CMSOAPConstants.NS_XMLSCHEMA, "string", "write");
                        elem = permItem.addChild(null, "access", CMSOAPConstants.NS_BIBUS, "accessEnum", "grant");
                        if (!bSession) {
                            permItem = elemPerms.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "permission", null);
                            elem = permItem.addChild(null, "name", CMSOAPConstants.NS_XMLSCHEMA, "string", "setPolicy");
                            elem = permItem.addChild(null, "access", CMSOAPConstants.NS_BIBUS, "accessEnum", "grant");
                        }
                    }
                    permItem = elemPerms.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "permission", null);
                    elem = permItem.addChild(null, "name", CMSOAPConstants.NS_XMLSCHEMA, "string", "execute");
                    elem = permItem.addChild(null, "access", CMSOAPConstants.NS_BIBUS, "accessEnum", "grant");
                }
            }
            xmlPolicy = xmlDoc.getRootXMLElement().makeXML(null, true, true);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return CMServlet.AAA.CreatePolicy(xmlPolicy, CMExecutionContext.get().getCAMAdditionalInfo());
    }

    public static ArrayList<String> parseAncestorsValue(org.w3c.dom.Node propNode, String camObject) throws CMException {
        ArrayList<String> retArray = new ArrayList<String>();
        NodeList values = ((Element)propNode).getElementsByTagName("value");
        org.w3c.dom.Node propValue = values.item(0);
        NodeList ancestorSPNodes = ((Element)propValue).getElementsByTagName("searchPath");
        int numNodes = ancestorSPNodes.getLength();
        if (numNodes < 2) {
            throw new CMException("cmBadCAMPropValue", new CMException.Parm("Property", CMProperty.ANCESTORS.getName()), new CMException.Parm("Object", camObject));
        }
        for (int iSP = 0; iSP < numNodes; ++iSP) {
            org.w3c.dom.Node searchPathNode = ancestorSPNodes.item(iSP);
            if (searchPathNode != null) {
                String sNodePath = searchPathNode.getFirstChild().getNodeValue();
                if (sNodePath.startsWith("/")) {
                    retArray.add(sNodePath);
                    continue;
                }
                if (sNodePath.startsWith("CAMID('")) {
                    sNodePath = sNodePath.substring(sNodePath.indexOf(39) + 1, sNodePath.lastIndexOf(39));
                } else if (sNodePath.startsWith("CAMID(\"")) {
                    sNodePath = sNodePath.substring(sNodePath.indexOf(34) + 1, sNodePath.lastIndexOf(34));
                }
                retArray.add("/directory//*[@id=" + CMStoreXPath.attributeQuoteString(sNodePath) + "]");
                continue;
            }
            throw new CMException("cmBadCAMPropValue", new CMException.Parm("Property", CMProperty.ANCESTORS.getName()), new CMException.Parm("Object", camObject));
        }
        return retArray;
    }

    public static String parseParametersValue(org.w3c.dom.Node propNode) throws CMException {
        String propValue = null;
        if (propNode != null) {
            try {
                ByteArrayOutputStream baout = new ByteArrayOutputStream();
                DOMWriter domWriter = new DOMWriter(true, baout);
                domWriter.print(propNode);
                propValue = baout.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CMException((Exception)e, "cmBadPropertyData", new CMException.Parm("Property", CMProperty.PARAMETERS.getName()));
            }
        }
        return propValue;
    }

    public static ArrayList<String> parseCapabilitesValue(org.w3c.dom.Node propNode) {
        ArrayList<String> caps = new ArrayList<String>();
        NodeList capsNodes = ((Element)propNode).getElementsByTagName("item");
        for (int iCap = 0; iCap < capsNodes.getLength(); ++iCap) {
            org.w3c.dom.Node capItemNode = capsNodes.item(iCap);
            org.w3c.dom.Node capTextNode = capItemNode.getFirstChild();
            String sCap = capTextNode.getNodeValue();
            caps.add(sCap);
        }
        return caps;
    }

    public static AncestorOrSelfResult getAncestorsAndSelf(String sUserID, boolean bReturnClass) throws AAAException, CMException {
        AncestorOrSelfResult results = new AncestorOrSelfResult();
        if (sUserID.equals("::Anonymous")) {
            results.ancestorCamIDList.add("/directory");
            results.ancestorCamIDList.add("/directory//*[@id=':']");
            results.ancestorCamIDList.add("/directory//*[@id='" + CMStoreXPath.attributeEncodeString(sUserID, '\'') + "']");
            return results;
        }
        String sCAMIDPath = "CAMID(\"" + XMLUtils.escape((String)sUserID) + "\")";
        StringBuffer query2 = new StringBuffer();
        query2.append(CMSOAPConstants.SOAPEnvHeaderStart);
        query2.append(CMExecutionContext.get().getCAMAdditionalInfo());
        query2.append(CMSOAPConstants.SOAPHeaderToBody);
        query2.append("<bus:query><search>");
        query2.append(sCAMIDPath);
        query2.append("</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\">");
        query2.append("<item xsi:type='bus:propEnum'>ancestors</item>");
        query2.append("</properties></bus:query>");
        query2.append(CMSOAPConstants.SOAPBodyEnvEnd);
        String response = null;
        try {
            response = CMServlet.AAA.Search(CMExecutionContext.get().getAccManPassportID(), query2.toString());
        }
        catch (AAAException exaa) {
            CMIndications.CMTrace("cmBadSecurityID", new CMException.Parm("ID", sUserID), new CMException.Parm("Details", exaa.toString()));
            throw exaa;
        }
        if (response != null) {
            try {
                org.w3c.dom.Document doc = CMXMLUtils.parse(new InputSource(new StringReader(response)));
                NodeList ancestorNodes = doc.getElementsByTagName(CMProperty.ANCESTORS.getName());
                if (ancestorNodes == null || ancestorNodes.getLength() != 1) {
                    throw new CMException("cmBadCAMPropValue", new CMException.Parm("Property", CMProperty.ANCESTORS.getName()), new CMException.Parm("Object", sCAMIDPath));
                }
                results.ancestorCamIDList = AccMan.parseAncestorsValue(ancestorNodes.item(0), sCAMIDPath);
                results.ancestorCamIDList.add("/directory//*[@id=" + CMStoreXPath.attributeQuoteString(sUserID) + "]");
                if (bReturnClass) {
                    NodeList objectNodes = doc.getElementsByTagName("item");
                    org.w3c.dom.Node itemNode = objectNodes.item(0);
                    String sClass = CMDOMUtils.getTypeValue((Element)itemNode);
                    results.objectClass = AccMan.getObjectClassFromTypeAttr(sClass);
                }
                return results;
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static CMObjectClass getObjectClassFromTypeAttr(String attrValue) {
        try {
            int colonPos = attrValue.indexOf(":");
            if (colonPos > 0) {
                attrValue = attrValue.substring(colonPos + 1);
            }
            return CMExecutionContext.get().getStore().getObjectClasses().getClassByName(attrValue);
        }
        catch (CMException cMException) {
            return null;
        }
    }

    public static String normalizeExternalSearch(String externalReference) throws AAAException, CMException {
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append(CMSOAPConstants.SOAPEnvHeaderStart);
        queryBuf.append(CMExecutionContext.get().getCAMAdditionalInfo());
        queryBuf.append(CMSOAPConstants.SOAPHeaderToBody);
        queryBuf.append("<bus:query><search>");
        queryBuf.append(XMLUtils.escape((String)externalReference));
        queryBuf.append("</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\">");
        queryBuf.append("<item xsi:type='cm:propEnum'>searchPath</item>");
        queryBuf.append("</properties></bus:query>");
        queryBuf.append(CMSOAPConstants.SOAPBodyEnvEnd);
        String query2 = queryBuf.toString();
        String results = null;
        results = CMServlet.AAA.Search(CMExecutionContext.get().getAccManPassportID(), query2.toString());
        if (results != null) {
            try {
                org.w3c.dom.Document doc = CMXMLUtils.parse(new InputSource(new StringReader(results)));
                NodeList spNodes = doc.getElementsByTagName("value");
                if (spNodes.getLength() > 1) {
                    throw new CMException("cmBadSecurityReferenceMultipleSelect", new CMException.Parm("Reference", externalReference));
                }
                org.w3c.dom.Node searchPathNode = spNodes.item(0);
                if (searchPathNode != null) {
                    return searchPathNode.getFirstChild().getNodeValue();
                }
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String normalizeExternalSearch(CMStoreXPath externalReference) throws AAAException, CMException {
        if (externalReference == null) {
            return null;
        }
        String searchPath = externalReference.getCAMQuery();
        if (externalReference.size() > 2 && externalReference.getCAMIDFromFirstStep() != null) {
            return externalReference.getOriginalPath();
        }
        return AccMan.normalizeExternalSearch(searchPath);
    }

    private static String makeAAAGenerateCredentialBiBusHeader(XMLElement origBiBusHeader, String namespace) {
        XMLElement formFieldVars;
        XMLElement CAMElem = origBiBusHeader.getOptionalChildWithName("CAM");
        if (CAMElem == null) {
            throw new IllegalStateException("Cam block missing from header while generateing Credential Request Doc");
        }
        AccMan.replaceCAMElement(CAMElem);
        XMLElement hdrSession = origBiBusHeader.getOptionalChildWithName("hdrSession");
        if (hdrSession == null) {
            hdrSession = new XMLElement("hdrSession", CMSOAPConstants.NS_BIBUS, "hdrSession");
            origBiBusHeader.children_.add(hdrSession);
        }
        if ((formFieldVars = hdrSession.getOptionalChildWithName("formFieldVars")) == null) {
            formFieldVars = new XMLElement("formFieldVars", CMSOAPConstants.NS_SOAP_ENC, "Array");
            hdrSession.addChild(formFieldVars);
        } else {
            AccMan.removeCAMNS(formFieldVars);
        }
        AccMan.addCAMNS(formFieldVars, namespace);
        String sBusHeader = origBiBusHeader.makeXML("", true, true);
        String camAdditionalInfo = CMExecutionContext.get().getCAMAdditionalInfo();
        StringBuffer sRet = new StringBuffer(sBusHeader);
        sRet.insert(sBusHeader.indexOf(62) + 1, camAdditionalInfo);
        return sRet.toString();
    }

    private static void replaceCAMElement(XMLElement elem) {
        AccMan.replaceCAMPassport(elem);
        elem.deleteChildWithName("action");
        elem.addChild(null, "action", CMSOAPConstants.NS_BIBUS, "string", "generateCredential");
    }

    private static void addCAMNS(XMLElement formFieldVars, String namespace) {
        XMLElement CAMNSElem = new XMLElement("item", false);
        CAMNSElem.addChild(null, "name", CMSOAPConstants.NS_XMLSCHEMA, "string", "CAMNamespace");
        CAMNSElem.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "string", namespace);
        formFieldVars.addChild(CAMNSElem);
    }

    private static void removeCAMNS(XMLElement formFieldVars) {
        ArrayList<XMLElement> children = formFieldVars.children_;
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            XMLElement itemElem = (XMLElement)children.get(i);
            try {
                String nameValue = itemElem.getChildValueWithName("name");
                if (!"CAMNamespace".equals(nameValue)) continue;
                children.remove(i);
                --i;
                continue;
            }
            catch (CMException ex) {
                CMIndications.logException(ex);
            }
        }
    }

    private static void replaceCAMPassport(XMLElement elem) {
        elem.deleteChildWithName("CAMPassport");
        XMLElement CAMPassportElem = new XMLElement("CAMPassport", false);
        String currUserPassportId = CMExecutionContext.get().getAccManPassportID();
        CAMPassportElem.addChild(null, "id", CMSOAPConstants.NS_XMLSCHEMA, "string", currUserPassportId);
        elem.addChild(CAMPassportElem);
    }

    public static String getCurrentUserCredentials(String namespace) throws AAAException, CMException {
        RequestManager rm = CMExecutionContext.get().getContext().getRequestManager();
        if (rm == null) {
            throw new IllegalStateException("The RequestManager is null while trying to generate a user credential.");
        }
        XMLElement origBiBusHeader = rm.getOriginalBiBusHeader();
        if (origBiBusHeader == null) {
            throw new IllegalStateException("The header is null while trying to generate a user credential.");
        }
        String authDoc = AccMan.makeAAAGenerateCredentialBiBusHeader(origBiBusHeader = XMLElement.copyFrom(origBiBusHeader), namespace);
        String sPassportDoc = CMServlet.AAA.invoke(authDoc, AAAProvider.Action.GENERATECREDENTIAL);
        if (sPassportDoc != null) {
            if (sPassportDoc.lastIndexOf("Misunderstood") > -1 || sPassportDoc.lastIndexOf("ErrorDetailDocument") > -1) {
                throw new CMException("cmNoCredentialAccessDataSource");
            }
            try {
                AccManAuthResponse rsp = new AccManAuthResponse(sPassportDoc);
                List<XMLElement> rspList = rsp.getQueryResult();
                if (rspList != null && rspList.size() > 0) {
                    CMExecutionContext currContext = CMExecutionContext.get();
                    currContext.initializeASession(rsp, false);
                }
                return rsp.getCurrentUserCredential();
            }
            catch (SAXException ex) {
                CMIndications.logException(ex, "cmNoCredentialAccessDataSource");
            }
            catch (Exception ex) {
                CMIndications.logException(ex, "cmNoCredentialAccessDataSource");
            }
        } else {
            throw new CMException("cmNoCredentialAccessDataSource");
        }
        return null;
    }

    public static void logoffPassport(String passportID) throws AAAException {
        StringBuffer sb = new StringBuffer();
        sb.append(camLogoff1_);
        sb.append(CMExecutionContext.get().getCAMAdditionalInfo());
        sb.append(camLogoff2_);
        sb.append(passportID);
        sb.append(camLogoff3_);
        CMServlet.AAA.invoke(sb.toString(), AAAProvider.Action.LOGOFF);
    }

    public static void validatePassport(String sPassportID) throws AAAException {
        if (!CMServlet.AAA.validate(sPassportID)) {
            CMServlet.AAA.invoke(AccMan.constructCAMPassportHeader(sPassportID), AAAProvider.Action.VALIDATE);
        }
    }

    public static String generateTC() throws CMException {
        StringBuffer sb = new StringBuffer(256);
        sb.append("<bus:").append("biBusHeader").append(" xsi:type=\"bus:").append("biBusHeader").append("\" xmlns:xsi=\"").append("http://www.w3.org/2001/XMLSchema-instance").append("\" xmlns:xsd=\"").append("http://www.w3.org/2001/XMLSchema").append("\" xmlns:bus=\"").append("http://developer.cognos.com/schemas/bibus/3/").append("\"><").append("CAM").append(" xsi:type=\"bus:").append("CAM").append("\"><").append("CAMPassport").append(" xsi:type=\"bus:").append("CAMPassport").append("\"><").append("id").append(" xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(CMExecutionContext.get().getAccManPassportID()).append("</").append("id").append("></").append("CAMPassport").append("><action xsi:type=\"xsd:string\">generateTC</action></").append("CAM").append("></bus:").append("biBusHeader").append(">");
        String credPath = null;
        try {
            String authResult = null;
            authResult = CMServlet.AAA.invoke(sb.toString(), AAAProvider.Action.GENERATETRUSTEDCREDENTIAL);
            authResult = AccMan.processAuthRsp(authResult, CamAction.generateTC, true, true);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(authResult));
            Node n = doc.selectSingleNode("//CAMCredentialPath");
            if (n != null) {
                credPath = n.getText();
            }
        }
        catch (Exception e) {
            throw new CMException(e, "cmCantGenerateTC");
        }
        if (credPath == null) {
            throw new CMException("cmCantGenerateTC");
        }
        return credPath;
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(CMSOAPConstants.NS_BIBUS.getPrefix()).append(":").append("biBusHeader").append(" ");
        CMSOAPConstants.addXMLNSAttr(sb, CMSOAPConstants.NS_XMLSCHEMA);
        sb.append(" ");
        CMSOAPConstants.addXMLNSAttr(sb, CMSOAPConstants.NS_XMLSCHEMAINSTANCE);
        sb.append(" ");
        CMSOAPConstants.addXMLNSAttr(sb, CMSOAPConstants.NS_BIBUS);
        sb.append(" ");
        CMSOAPConstants.addXSITypeAttr(sb, CMSOAPConstants.NS_BIBUS, "biBusHeader");
        sb.append(">");
        camLogoff1_ = sb.toString();
        camLogoff2_ = null;
        sb = new StringBuffer();
        sb.append("<").append("CAM").append(" ");
        CMSOAPConstants.addXSITypeAttr(sb, CMSOAPConstants.NS_BIBUS, "CAM");
        sb.append(">");
        sb.append("<").append("CAMPassport").append(" ");
        CMSOAPConstants.addXSITypeAttr(sb, CMSOAPConstants.NS_BIBUS, "CAMPassport");
        sb.append(" xml:space=\"preserve\"");
        sb.append(">");
        sb.append("<").append("id").append(" ");
        CMSOAPConstants.addXSITypeAttr(sb, CMSOAPConstants.NS_XMLSCHEMA, "string");
        sb.append(">");
        camLogoff2_ = sb.toString();
        camLogoff3_ = null;
        sb = new StringBuffer();
        sb.append("</").append("id").append(">");
        sb.append("</").append("CAMPassport").append(">");
        sb.append("<").append("action").append(" ");
        CMSOAPConstants.addXSITypeAttr(sb, CMSOAPConstants.NS_XMLSCHEMA, "string");
        sb.append(">");
        sb.append("logoff");
        sb.append("</").append("action").append(">");
        sb.append("</").append("CAM").append(">");
        sb.append(CMSOAPConstants.sBUSHeaderEndElement);
        camLogoff3_ = sb.toString();
    }

    public static class AncestorOrSelfResult {
        private CMObjectClass objectClass;
        private List<String> ancestorCamIDList = new ArrayList<String>();

        public CMObjectClass getObjectClass() {
            return this.objectClass;
        }

        public List<String> getAncestorCamIDs() {
            return this.ancestorCamIDList;
        }
    }
}

