/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import java.util.ArrayList;
import java.util.List;

public class AccManAuthResponse {
    private XMLDoc doc_;
    private String passportID_;
    private String sessionContext_;
    private String trustedCredential_;
    private XMLElement camTrCredentialEL_;
    private XMLElement camEl_;
    private XMLElement camExcpEl_;
    private List<XMLElement> queryResult_;
    private String currentUserCredential_;
    private String cam_passportCookie_;
    private static final String CAM_AUTHUNRECOVERABLE = "camAuthUnrecoverable";
    private static final String CAM_PASSPORTCOOKIE_NAME = "cam_passport";

    public AccManAuthResponse(String rsp) throws CMException, Exception {
        if (rsp.lastIndexOf("Misunderstood") > -1 || rsp.lastIndexOf("ErrorDetailDocument") > -1) {
            throw new CMException("cmAuthenticateFailed");
        }
        XMLDocParser parser = new XMLDocParser();
        this.doc_ = parser.readXML(rsp);
        if (this.doc_ == null || this.doc_.getRootXMLElement() == null) {
            throw new CMException("cmAuthenticateFailed");
        }
        this.parse();
    }

    public String getSessionContext() {
        return this.sessionContext_;
    }

    public String getPassportID() {
        return this.passportID_;
    }

    public String getTrustedCredential() {
        return this.trustedCredential_;
    }

    public List<XMLElement> getQueryResult() {
        return this.queryResult_;
    }

    public String getCurrentUserCredential() {
        return this.currentUserCredential_;
    }

    public void rewriteTrustedCredential(String userID) {
        if (this.camTrCredentialEL_ != null) {
            this.camTrCredentialEL_.name_ = "CAMCredentialPath";
            this.camTrCredentialEL_.xsiTypeNs_ = CMSOAPConstants.NS_XMLSCHEMA;
            this.camTrCredentialEL_.xsiType_ = "string";
            this.camTrCredentialEL_.value_ = "CAMID(\"" + userID + "\")/credential";
        }
    }

    public boolean hasCAMException() {
        boolean rc = false;
        try {
            if (this.camEl_ != null) {
                this.camExcpEl_ = this.camEl_.getChildWithName("exception");
                if (this.camExcpEl_ != null) {
                    rc = true;
                }
            }
        }
        catch (CMException e) {
            rc = false;
        }
        return rc;
    }

    public boolean isCAMExceptionRecoverable() {
        boolean rc = true;
        try {
            if (this.camExcpEl_ != null) {
                XMLElement errorCodeEl = this.camExcpEl_.getChildWithName("errorCodeString");
                if (errorCodeEl.value_.equals(CAM_AUTHUNRECOVERABLE)) {
                    rc = false;
                }
            }
        }
        catch (CMException e) {
            rc = false;
        }
        return rc;
    }

    public String getCAMPassportCookie() {
        return this.cam_passportCookie_;
    }

    public String toString() {
        String docStr = this.doc_.getRootXMLElement().makeXML("\t", true, true);
        return docStr;
    }

    private void parse() throws CMException {
        if (this.doc_ == null) {
            throw new CMException("cmAuthenticateFailed");
        }
        XMLElement xmlHeader = this.doc_.getRootXMLElement().getOptionalChildWithName("Header");
        if (xmlHeader == null) {
            throw new CMException("cmAuthenticateFailed");
        }
        if ((xmlHeader = xmlHeader.getOptionalChildWithName("biBusHeader")) == null) {
            throw new CMException("cmAuthenticateFailed");
        }
        this.camEl_ = xmlHeader.getOptionalChildWithName("CAM");
        if (this.camEl_ != null) {
            XMLElement camCredentialEL;
            XMLElement xmlPassportID = this.camEl_.getOptionalChildWithName("CAMPassport");
            if (xmlPassportID != null) {
                this.passportID_ = xmlPassportID.getOptionalChildValueWithName("id");
            }
            this.camTrCredentialEL_ = this.camEl_.getOptionalChildWithName("CAMTrustedCredential");
            if (this.camTrCredentialEL_ != null && this.camTrCredentialEL_.value_ != null) {
                this.trustedCredential_ = this.camTrCredentialEL_.value_;
            }
            if ((camCredentialEL = this.camEl_.getOptionalChildWithName("CAMCredential")) != null) {
                this.currentUserCredential_ = camCredentialEL.value_;
            }
        }
        this.processHdrSessionElement(xmlHeader);
        this.processTrackingElement(xmlHeader);
        XMLElement el = this.doc_.getRootXMLElement().getChildWithName("Body");
        el = el.getChildWithName("queryResponse");
        el = el.getChildWithName("queryResult");
        this.queryResult_ = el.getChildren();
    }

    private void processHdrSessionElement(XMLElement xmlHeader) {
        ArrayList<XMLElement> children;
        XMLElement setCookieVarsEle;
        XMLElement hdrSessionEle = xmlHeader.getOptionalChildWithName("hdrSession");
        if (hdrSessionEle != null && (setCookieVarsEle = hdrSessionEle.getOptionalChildWithName("setCookieVars")) != null && (children = setCookieVarsEle.getChildren()) != null) {
            for (int i = 0; i < children.size(); ++i) {
                XMLElement itemEle = (XMLElement)children.get(i);
                if (itemEle.getOptionalChildValueWithName("name") == null || !itemEle.getOptionalChildValueWithName("name").equals(CAM_PASSPORTCOOKIE_NAME)) continue;
                this.cam_passportCookie_ = itemEle.getOptionalChildValueWithName("value");
            }
        }
    }

    private void processTrackingElement(XMLElement xmlHeader) {
        XMLElement sessionContextEle;
        XMLElement trackingEle = xmlHeader.getOptionalChildWithName("tracking");
        if (trackingEle != null && (sessionContextEle = trackingEle.getOptionalChildWithName("sessionContext")) != null && sessionContextEle.value_ != null) {
            this.sessionContext_ = sessionContextEle.value_;
        }
    }
}

