/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMDescendantModifiedProperty;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMQueryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountTemplates {
    private ArrayList<CMStoreXPath> accountSearchPaths = new ArrayList();
    private static Map<CMObjectClass, CMLocalizedStringArray> templateNames = new HashMap<CMObjectClass, CMLocalizedStringArray>();
    private static Date templateNamesLastUpdated = null;

    public void addAccountSearchPath(CMStoreXPath searchPath) {
        this.accountSearchPaths.add(searchPath);
    }

    public void update(CMStringLocale locale) {
        try {
            this.updateTemplateNames();
            for (CMStoreXPath searchPath : this.accountSearchPaths) {
                Map<String, CMLocalizedStringArray> objects = this.getObjectsToUpdate(searchPath, locale, templateNames);
                if (objects.isEmpty()) continue;
                for (Map.Entry<String, CMLocalizedStringArray> obj : objects.entrySet()) {
                    this.update(obj.getKey(), obj.getValue());
                }
            }
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
    }

    private void updateTemplateNames() throws CMException {
        Date confLastModified = CMDescendantModifiedProperty.get().getValue();
        if (templateNamesLastUpdated == null || templateNamesLastUpdated.before(confLastModified)) {
            templateNames = this.queryTemplateNames();
            templateNamesLastUpdated = confLastModified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CMObjectClass, CMLocalizedStringArray> queryTemplateNames() throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        HashMap<CMObjectClass, CMLocalizedStringArray> names = new HashMap<CMObjectClass, CMLocalizedStringArray>();
        CMStoreQueryResults results = null;
        try {
            CMStoreXPath path = this.getTemplateSearchPath();
            store.getLockManager().requestLocks(path);
            CMProperty[] props = new CMProperty[]{CMProperty.NAME};
            results = store.executeQuery(path, props, null, 0, 512, null);
            while (results.next()) {
                CMObjectClass templateObjClass = results.getObjectClass();
                CMLocalizedStringArray templateName = (CMLocalizedStringArray)results.getValue(0);
                names.put(templateObjClass, templateName);
            }
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(results);
            store.getLockManager().releaseLocks();
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        store.getLockManager().releaseLocks();
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, CMLocalizedStringArray> getObjectsToUpdate(CMStoreXPath searchPath, CMStringLocale locale, Map<CMObjectClass, CMLocalizedStringArray> templateNames) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        HashMap<String, CMLocalizedStringArray> objects = new HashMap<String, CMLocalizedStringArray>();
        CMStoreQueryResults results = null;
        try {
            CMStoreXPath path = new CMStoreXPath(searchPath + "/child::*");
            store.getLockManager().requestLocks(path);
            CMProperty[] props = new CMProperty[]{CMProperty.NAME};
            results = store.executeQuery(path, props, null, 0, 512, null);
            while (results.next()) {
                CMLocalizedStringArray templateName;
                CMLocalizedStringArray name = (CMLocalizedStringArray)results.getValue(0);
                if (!this.updateNameFromATemplate(locale, name, templateName = templateNames.get(results.getObjectClass()))) continue;
                objects.put(results.getSearchPath(), name);
            }
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(results);
            store.getLockManager().releaseLocks();
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        store.getLockManager().releaseLocks();
        return objects;
    }

    private boolean updateNameFromATemplate(CMStringLocale locale, CMLocalizedStringArray name, CMLocalizedStringArray templateName) {
        CMStringLocale serverLocale;
        if (templateName == null || name.get(locale) != null) {
            return false;
        }
        CMLocalizedString localizedName = templateName.get(locale);
        if (localizedName == null) {
            if (name.get(locale.getMappedLocale()) == null) {
                localizedName = templateName.get(locale.getMappedLocale());
            } else {
                return false;
            }
        }
        if (localizedName == null && name.get(serverLocale = CMDbStoreStringLocales.findLocale(ConfigurationFactory.getConfig().getServerLocale().toString())) == null) {
            localizedName = templateName.get(serverLocale);
        }
        if (localizedName != null) {
            name.add(localizedName);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(String searchPath, CMLocalizedStringArray name) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        CMStoreQueryResults results = null;
        try {
            CMStoreXPath path = new CMStoreXPath(searchPath, 13);
            store.getLockManager().requestLocks(path);
            store.beginTransaction();
            results = store.executeQuery(path, null, null, 7, 512, null);
            if (results.next()) {
                List<CMProperty> properties = Collections.singletonList(CMProperty.NAME);
                List<Object> values = Collections.singletonList(name);
                store.update(results, properties, values);
            }
            store.commitTransaction();
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(results);
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            store.getLockManager().releaseLocks();
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        if (store.inTransaction()) {
            try {
                store.rollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        store.getLockManager().releaseLocks();
    }

    private CMStoreXPath getTemplateSearchPath() throws CMStoreParseException {
        return new CMStoreXPath("/configuration/account/*");
    }
}

