/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.CAMParsingDelegate;
import com.cognos.cm.server.CAMVariableExtractorPlugin;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ParsingPlugin;
import com.cognos.cm.server.PostProcessingPathLocator;
import com.cognos.cm.server.RequestManager;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.stax.PathParser;
import javax.xml.stream.XMLStreamReader;

public class CAMParsingPlugin
extends ParsingPlugin {
    private CAMParsingDelegate camDelegate;

    public CAMParsingPlugin(RequestManager requestManager, XMLStreamReader reader) {
        super(requestManager, reader);
        this.camDelegate = new CAMParsingDelegate(this.reader);
    }

    @Override
    public XMLStreamReader getParsingDelegate() {
        return this.camDelegate;
    }

    @Override
    public void parseComplete() throws CMException {
        if (!this.allDataExtracted()) {
            this.extractVariablesPostParse();
        }
        CAMVariableExtractorPlugin extractorPlugin = this.camDelegate.getPlugin();
        this.setCAMElementPresent(extractorPlugin);
        this.setPassportID(extractorPlugin);
        this.setCAMAction(extractorPlugin);
        this.setCAMTrustedElementPresent(extractorPlugin);
        this.setSecurityBlob(extractorPlugin);
    }

    private void extractVariablesPostParse() {
        PathParser pathParser = new PathParser("/biBusHeader/CAM");
        XMLElement soapHeader = this.requestManager.getSOAPHeader();
        CAMVariableExtractorPlugin plugin = this.camDelegate.getPlugin();
        PostProcessingPathLocator postDelegate = new PostProcessingPathLocator(pathParser, soapHeader, plugin);
        postDelegate.parse();
    }

    private boolean allDataExtracted() {
        return this.camDelegate.parseSuccessful();
    }

    private void setSecurityBlob(CAMVariableExtractorPlugin extractorPlugin) {
        String securityBlob = extractorPlugin.getSecurityBlob();
        if (securityBlob != null) {
            CMExecutionContext.get().setAccManSecurityBlob(securityBlob);
        }
    }

    private void setCAMTrustedElementPresent(CAMVariableExtractorPlugin extractorPlugin) {
        this.requestManager.setCAMTrustedElementPresent(extractorPlugin.camTrustedPresent());
    }

    private void setCAMAction(CAMVariableExtractorPlugin extractorPlugin) {
        String camAction = extractorPlugin.getCAMAction();
        if (camAction != null) {
            this.requestManager.processCAMAction(camAction);
        }
    }

    private void setCAMElementPresent(CAMVariableExtractorPlugin extractorPlugin) {
        this.requestManager.setCAMElementPresent(extractorPlugin.camElementPresent());
    }

    private void setPassportID(CAMVariableExtractorPlugin extractorPlugin) throws CMException {
        String passportID = extractorPlugin.getPassportID();
        if (passportID != null) {
            this.requestManager.setPassport(passportID);
        }
    }
}

