/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.dbstore.properties.CMDbStoreArrayXMLValue;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMLocalePreference;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.DatabaseConfigInfo;
import com.cognos.cm.server.ExternalObjectStore;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDbStoreEncryptHelper;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.UrlUtils;
import com.cognos.cmutils.config.CognosConfigParser;
import com.cognos.cmutils.url.FileURIUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class CMConfiguration
extends ConfigurationFactory
implements IConfiguration {
    private static final String[] PARM_NAMES = new String[]{"productLocaleMap", "contentLocaleMap", "normalizationLocaleMap", "supportedContentLocales", "supportedProductLocales", "supportedCurrencies", "supportedFonts", "aliasRoots"};
    private static final String[] PARM_NAMES_FORSINGLEVALUE = new String[]{"serverTimeZoneID", "cookieDomain", "cookiePath", "cookieSecure", "archiveLocationFileSchemeRoot"};
    private boolean namesHaveTenantScope;
    private boolean bRunningWindows_;
    private boolean bEnableReportOutput_;
    private Properties properties_;
    private File configurationDir_;
    private File schemaDir_;
    private String deploymentFolder_;
    private String archiveRoot_;
    private List<IConfiguration.AliasRoot> aliasRoots_;
    private ICCLConfiguration oConfig_;
    private static final String ELEM_CONFIG_DATABASETYPE = "databaseType";
    private ExternalObjectStore externalObjectStore;
    private boolean isEncryptionEnabled_ = false;
    private final Map<String, String> connectionAdvancedParameters = new HashMap<String, String>();
    private CMDbStoreEncryptHelper helper_ = null;

    protected CMConfiguration(ICCLConfiguration icclconfig) throws CMConfigurationException {
        this(System.getProperties());
        this.importCCLConfiguration(icclconfig);
    }

    protected CMConfiguration(Properties systemProps) {
        this.properties_ = new Properties();
        String sOS = systemProps.getProperty("os.name");
        if (sOS != null && sOS.startsWith("Windows")) {
            this.bRunningWindows_ = true;
        }
    }

    @Override
    public String getString(String name) {
        return this.properties_.getProperty(name);
    }

    @Override
    public String getInternalProp(String key) {
        return this.getString(key);
    }

    @Override
    public String getDatabaseProp(String key) {
        return System.getProperty("com.cognos.cm.server.configuration." + key, this.getString(key));
    }

    @Override
    public String getDatabaseType() {
        return this.getDatabaseProp(ELEM_CONFIG_DATABASETYPE);
    }

    @Override
    public String getCognosProp(String key) {
        return this.getString(key);
    }

    @Override
    public String getConfigAdvancedProp(String key) {
        return this.getString(key);
    }

    @Override
    public Object getObject(String objectName) {
        return this.properties_.get(objectName);
    }

    @Override
    public List<?> getList(String parameterName) {
        Object o = this.properties_.get(parameterName);
        if (null == o) {
            return null;
        }
        if (o instanceof ArrayList) {
            return (List)o;
        }
        throw new RuntimeException(new CMException("cmUnexpectedError"));
    }

    @Override
    public void setObject(String objectName, Object value) {
        if (objectName == null || objectName.length() < 1 || value == null) {
            return;
        }
        this.properties_.put(objectName, value);
    }

    private void removeString(String name) {
        this.properties_.remove(name);
    }

    private void setString(String name, String value) {
        if (name == null || name.length() < 1) {
            // empty if block
        }
        if (value == null) {
            value = new String("");
        }
        this.properties_.remove(name);
        this.properties_.setProperty(name, value);
    }

    @Override
    public void setInternalProp(String key, String value) {
        this.setString(key, value);
    }

    @Override
    public void setDatabaseProp(String key, String value) {
        this.setString(key, value);
    }

    public void setCognosProp(String key, String value) {
        this.setString(key, value);
    }

    public void setConfigAdvancedProp(String key, String value) {
        this.setString(key, value);
    }

    @Override
    public Properties getProperties() {
        return this.properties_;
    }

    @Override
    public boolean isRunningWindows() {
        return this.bRunningWindows_;
    }

    protected void importCCLConfiguration(ICCLConfiguration icclconfig) throws CMConfigurationException {
        this.oConfig_ = icclconfig;
        String dbPathName = "schemas/content";
        String configurationFolder = this.oConfig_.resolveEffectivePath("../configuration");
        this.setConfigurationDirectory(configurationFolder);
        this.setSchemasDirectory("schemas/content");
        this.archiveRoot_ = this.getValue("archiveLocationFileSchemeRoot", false);
        Properties props = this.getProperties();
        ResourceBundle resBund = ResourceBundle.getBundle("com.cognos.cm.server.CMInternal", new Locale("ov", "CA"));
        Enumeration<String> parmNames = resBund.getKeys();
        while (parmNames.hasMoreElements()) {
            String parmName = parmNames.nextElement();
            String parmValue = resBund.getString(parmName);
            this.setInternalProp(parmName, parmValue);
        }
        try {
            this.getConfigParam(props, "serverLocale");
            this.initializeServerLocale();
            this.initializeConfigAdvancedProps();
            this.parseCCLConfiguration(icclconfig);
            String sXmlConfig = this.oConfig_.getValue("CM", true);
            XMLDocParser parser = new XMLDocParser();
            XMLDoc xmlDoc = null;
            xmlDoc = parser.readXML(sXmlConfig);
            if (xmlDoc != null && xmlDoc.baseElement_ != null) {
                XMLElement rootEL = xmlDoc.getRootXMLElement();
                this.bEnableReportOutput_ = this.readOptionalBooleanParameter(rootEL, "outputCMReportToFile", false);
                this.readDatabaseInstance(rootEL);
                this.parseContentManagerNodeAdvancedProperties(rootEL);
            }
            ArrayList<String> cmURLs = null;
            try {
                cmURLs = this.getCMURLs(props);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getConfigParam(props, "internalDispatcher");
            this.getConfigParam(props, "externalDispatcher");
            this.getConfigParam(props, "temp");
            this.getConfigParam(props, "encryptTemporaryFiles");
            this.getConfigParam(props, "formatSpecificationLocation");
            this.getConfigParam(props, "defaultFont");
            this.getConfigParam(props, "emailEncoding");
            this.deploymentFolder_ = this.getConfigParam(null, "deploymentPath");
            try {
                this.getLocalCMURL(props, cmURLs);
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmConfigInfoError");
        }
    }

    private void parseContentManagerNodeAdvancedProperties(XMLElement rootEL) {
        XMLElement valueEl;
        XMLElement xmlElAdvancedProperties = rootEL.getOptionalChildWithNameAndAttribute("parameter", "name", "advancedProperties");
        if (xmlElAdvancedProperties != null && (valueEl = xmlElAdvancedProperties.getOptionalChildWithName("value")) != null && valueEl.hasChildren()) {
            ArrayList<XMLElement> parameters = valueEl.getChildren();
            for (XMLElement parameter : parameters) {
                if (!parameter.nameIs("parameter")) continue;
                String name = parameter.getAttribute("name");
                String value = parameter.getOptionalChildValueWithName("value");
                if (name == null || value == null) continue;
                this.setConfigAdvancedProp(name, value);
            }
        }
    }

    private void initializeConfigAdvancedProps() throws CCLConfigurationException {
        Element e = this.oConfig_.getValueElement("advancedProperties", true);
        if (e == null) {
            return;
        }
        List parametersList = e.elements("parameter");
        for (Element parameterElement : parametersList) {
            String propertyName = parameterElement.attributeValue("name");
            if (!propertyName.startsWith("CMSCRIPT_") && !propertyName.startsWith("CM_")) continue;
            Element valueElement = parameterElement.element("value");
            String propertyValue = valueElement.getText();
            this.setConfigAdvancedProp(propertyName, propertyValue);
        }
    }

    @Override
    public void reconfigure() throws CMException {
    }

    private ArrayList<String> getCMURLs(Properties props) throws CCLConfigurationException, Exception {
        String cmURLListStr = this.oConfig_.getValue("contentManagers", true);
        ArrayList cmURLList = new CognosConfigParser().parseContentManagers(cmURLListStr);
        if (cmURLList.isEmpty()) {
            throw new CMException("cmMissingCMURLs");
        }
        props.put("contentManagers", cmURLList);
        return cmURLList;
    }

    private void getLocalCMURL(Properties props, ArrayList<String> cmURLList) throws CMException {
        if (cmURLList == null || cmURLList.isEmpty()) {
            throw new CMException("cmMissingCMURLs");
        }
        boolean success = false;
        String localExternalHostname = null;
        String localExternalIPAddress = null;
        int localExternalPort = -1;
        String localInternalHostname = null;
        String localInternalIPAddress = null;
        int localInternalPort = -1;
        String externalDispatcherURL = this.getString("externalDispatcher");
        String internalDispatcherURL = this.getString("internalDispatcher");
        if (externalDispatcherURL == null || internalDispatcherURL == null) {
            throw new CMException("cmInvalidCMURLs");
        }
        externalDispatcherURL = UrlUtils.convertURItoDispatcherPath(externalDispatcherURL, true);
        internalDispatcherURL = UrlUtils.convertURItoDispatcherPath(internalDispatcherURL, true);
        String externalDispatcherIPAddressURL = UrlUtils.convertURItoDispatcherPath(externalDispatcherURL, true, true);
        String internalDispatcherIPAddressURL = UrlUtils.convertURItoDispatcherPath(internalDispatcherURL, true, true);
        URL externalDispatcherURLObject = null;
        URL internalDispatcherURLObject = null;
        try {
            externalDispatcherURLObject = new URL(externalDispatcherURL);
            localExternalHostname = externalDispatcherURLObject.getHost();
            localExternalPort = externalDispatcherURLObject.getPort();
            internalDispatcherURLObject = new URL(internalDispatcherURL);
            localInternalHostname = internalDispatcherURLObject.getHost();
            localInternalPort = internalDispatcherURLObject.getPort();
            externalDispatcherURLObject = new URL(externalDispatcherIPAddressURL);
            localExternalIPAddress = externalDispatcherURLObject.getHost();
            internalDispatcherURLObject = new URL(internalDispatcherIPAddressURL);
            localInternalIPAddress = internalDispatcherURLObject.getHost();
        }
        catch (MalformedURLException ex) {
            throw new CMException("cmInvalidCMURLs");
        }
        if (localExternalHostname == null || localInternalHostname == null || localExternalIPAddress == null || localInternalIPAddress == null) {
            throw new CMException("cmInvalidCMURLs");
        }
        String cmHostname = null;
        String cmIPAddress = null;
        int cmPort = -1;
        URL cmURL = null;
        String cmURLStr = null;
        String cmIPAddressURLStr = null;
        ListIterator<String> iter = cmURLList.listIterator();
        while (iter.hasNext()) {
            try {
                cmURLStr = iter.next();
                if (cmURLStr == null) continue;
                cmURLStr = UrlUtils.convertURItoDispatcherPath(cmURLStr, true);
                cmIPAddressURLStr = UrlUtils.convertURItoDispatcherPath(cmURLStr, true, true);
                cmURL = new URL(cmURLStr);
                cmHostname = cmURL.getHost();
                cmPort = cmURL.getPort();
                cmURL = new URL(cmIPAddressURLStr);
                cmIPAddress = cmURL.getHost();
            }
            catch (MalformedURLException ex) {
                throw new CMException(ex, "cmInvalidCMURLs");
            }
            if (cmHostname.equalsIgnoreCase("localhost") && (cmPort == localExternalPort || cmPort == localInternalPort)) {
                success = true;
                break;
            }
            if (localExternalHostname.equalsIgnoreCase(cmHostname) && cmPort == localExternalPort || localInternalHostname.equalsIgnoreCase(cmHostname) && cmPort == localInternalPort) {
                success = true;
                break;
            }
            if ((!localExternalIPAddress.equalsIgnoreCase(cmIPAddress) || cmPort != localExternalPort) && (!localInternalIPAddress.equalsIgnoreCase(cmIPAddress) || cmPort != localInternalPort)) continue;
            success = true;
            break;
        }
        if (success) {
            if (props != null) {
                cmURLStr = externalDispatcherURLObject.getProtocol() + "://" + cmHostname + ":" + externalDispatcherURLObject.getPort() + cmURL.getPath();
                props.put("localCMURL", cmURLStr);
            }
        } else {
            throw new CMException("cmMissingLocalCMURL");
        }
    }

    private String getConfigParam(Properties props, String configName) throws CCLConfigurationException {
        String param = this.oConfig_.getValue(configName, false);
        if (props != null) {
            props.put(configName, param);
        }
        return param;
    }

    @Override
    public boolean databaseIsConfigured() {
        if (System.getProperty("com.cognos.cm.server.ContentManager.configMode") != null) {
            return true;
        }
        if (this.getDatabaseConnect() == null) {
            return false;
        }
        String strUser = this.getString("user");
        if (strUser == null || strUser.length() < 1) {
            String dbType = this.getDatabaseType();
            List<String> optionalUserDBs = this.getUserOptionalDatabaseList();
            if (optionalUserDBs.contains(dbType)) {
                return true;
            }
            CMIndications.logException(new CMException("cmUserIDEmpty"));
            return false;
        }
        String strPassword = this.getString("password");
        return strPassword != null;
    }

    @Override
    public List<DatabaseConfigInfo> getDatabaseConfigInfo() {
        ArrayList<DatabaseConfigInfo> configInfoList = new ArrayList<DatabaseConfigInfo>();
        String strProvider = this.getString(ELEM_CONFIG_DATABASETYPE);
        this.removeString(ELEM_CONFIG_DATABASETYPE);
        if (strProvider == null || strProvider.length() < 1) {
            configInfoList.add(new DatabaseConfigInfo(ELEM_CONFIG_DATABASETYPE));
            return configInfoList;
        }
        String strConnectName = "CMDatabase" + strProvider;
        String strConnect = this.getString(strConnectName);
        if (strConnect == null || strConnect.length() < 1) {
            configInfoList.add(new DatabaseConfigInfo(ELEM_CONFIG_DATABASETYPE));
            return configInfoList;
        }
        configInfoList.add(new DatabaseConfigInfo(ELEM_CONFIG_DATABASETYPE, strProvider));
        List<String> subs = CMStringUtils.getBraceStringSubs(strConnect);
        for (int i = 0; i < subs.size(); ++i) {
            String sSub = subs.get(i);
            String sValue = this.getString(sSub);
            this.removeString(sSub);
            configInfoList.add(new DatabaseConfigInfo(sSub, sValue));
        }
        try {
            String sValue = this.getDatabaseDecryptedProp("user");
            configInfoList.add(new DatabaseConfigInfo("user", sValue));
            sValue = this.getDatabaseDecryptedProp("password");
            configInfoList.add(new DatabaseConfigInfo("password", sValue));
        }
        catch (CAMCryptoException e) {
            CMIndications.logException(e);
        }
        this.removeString("user");
        this.removeString("password");
        Enumeration<?> leftOverEnum = this.getProperties().propertyNames();
        while (leftOverEnum.hasMoreElements()) {
            String key = (String)leftOverEnum.nextElement();
            CMException ex = new CMException("cmBadConfigParm", new CMException.Parm("Name", key));
            CMIndications.logException(ex);
        }
        return configInfoList;
    }

    @Override
    public String getDatabaseConnect() {
        String strProvider = this.getDatabaseType();
        if (strProvider == null || strProvider.length() < 1) {
            return null;
        }
        String strConnect = this.getDatabaseConnectString(strProvider);
        List<String> subs = CMStringUtils.getBraceStringSubs(strConnect);
        for (int i = 0; i < subs.size(); ++i) {
            String sSub = subs.get(i);
            String sValue = this.getString(sSub);
            if (sValue == null || sValue.length() < 1) {
                return null;
            }
            if (sSub.equalsIgnoreCase("server") && sValue.equals("(local)")) {
                sValue = "localhost";
            }
            strConnect = CMStringUtils.subBraceString(strConnect, sSub, sValue);
        }
        return strConnect;
    }

    private String getDatabaseConnectString(String strProvider) {
        String strConnectName = "CMDatabase" + strProvider;
        String strConnect = System.getProperty("com.cognos.cm.server.configuration." + strConnectName);
        if (strConnect != null) {
            return strConnect;
        }
        return this.getString(strConnectName);
    }

    @Override
    public List<String> getDatabaseTypeList() {
        ArrayList<String> dbList = new ArrayList<String>();
        String strDBs = this.getString("CMDatabaseProviders");
        StringTokenizer tokens = new StringTokenizer(strDBs, ",");
        while (tokens.hasMoreTokens()) {
            String db = tokens.nextToken();
            dbList.add(db);
        }
        return dbList;
    }

    public List<String> getUserOptionalDatabaseList() {
        ArrayList<String> dbOptionalList = new ArrayList<String>();
        String strDBs = this.getString("CMDatabaseUserOptional");
        StringTokenizer tokens = new StringTokenizer(strDBs, ",");
        while (tokens.hasMoreTokens()) {
            String db = tokens.nextToken();
            dbOptionalList.add(db);
        }
        return dbOptionalList;
    }

    @Override
    public String getDeploymentFolder() {
        if (this.deploymentFolder_ == null) {
            this.deploymentFolder_ = "../deployment";
        }
        this.deploymentFolder_ = this.oConfig_.resolveEffectivePath(this.deploymentFolder_);
        return this.deploymentFolder_;
    }

    @Override
    public String getArchiveRoot() {
        return this.archiveRoot_;
    }

    @Override
    public List<IConfiguration.AliasRoot> getAliasRoots() {
        return this.aliasRoots_;
    }

    private void parseAliasRoots(CMDbStoreArrayXMLValue xmlValue) {
        for (int i = 0; i < xmlValue.getSize(); ++i) {
            XMLElement unixElem;
            String name = null;
            String windowsURI = null;
            String unixURI = null;
            XMLElement elem = (XMLElement)xmlValue.getItem(i);
            try {
                XMLElement nameElem = elem.getChildWithName("name");
                name = nameElem.value_;
            }
            catch (CMException e) {
                CMException ex = new CMException(e, "cmMissingAliasRootName");
                CMIndications.logException(ex);
                continue;
            }
            if (!this.isAliasRootNameValid(name)) {
                this.logFailure("cmMissingAliasRootName");
                continue;
            }
            XMLElement windowsElem = elem.getOptionalChildWithName("windowsURI");
            if (windowsElem != null) {
                windowsURI = windowsElem.value_;
            }
            if ((unixElem = elem.getOptionalChildWithName("unixURI")) != null) {
                unixURI = unixElem.value_;
            }
            if (!this.areAliasRootValuesValid(windowsURI, unixURI)) {
                this.logFailure("cmInvalidAliasRoot", new CMException.Parm[]{new CMException.Parm("aliasRootName", name)});
                this.logFailure("cmMissingAliasRootURIs");
                continue;
            }
            if (!this.validateAliasRootPaths(windowsURI, unixURI)) {
                this.logWarning("cmInvalidAliasRoot", new CMException.Parm[]{new CMException.Parm("aliasRootName", name)});
            }
            if (this.aliasRoots_ == null) {
                this.aliasRoots_ = new ArrayList<IConfiguration.AliasRoot>();
            }
            this.aliasRoots_.add(new IConfiguration.AliasRoot(name, windowsURI, unixURI));
        }
    }

    private void logFailure(String messageCode) {
        this.logFailure(messageCode, null);
    }

    private void logFailure(String messageCode, CMException.Parm[] messageParameters) {
        this.logMessage(messageCode, messageParameters, "Failure");
    }

    private void logFailure(String messageCode, CMException.Parm[] messageParameters, CMException e1) {
        Locale locale = this.getServerLocale().toLocale();
        CMException e2 = new CMException((Exception)e1, messageCode, messageParameters);
        String[] errors = new String[]{"<messageString>" + e2.getFullMessage() + "</messageString>"};
        CMIndications.Audit_Message_Config(messageCode, messageParameters, locale, "Failure", errors);
    }

    private void logWarning(String messageCode) {
        this.logWarning(messageCode, null);
    }

    private void logWarning(String messageCode, CMException.Parm[] messageParameters) {
        this.logMessage(messageCode, messageParameters, "Warning");
    }

    private void logMessage(String messageCode, CMException.Parm[] messageParameters, String logStatus) {
        CMIndications.Audit_Message_Config(messageCode, messageParameters, this.getServerLocale().toLocale(), logStatus, null);
    }

    private boolean isAliasRootNameValid(String name) {
        return name != null && name.length() != 0;
    }

    private boolean areAliasRootValuesValid(String windowsURI, String unixURI) {
        return windowsURI != null && windowsURI.length() != 0 || unixURI != null && unixURI.length() != 0;
    }

    private boolean validateAliasRootPaths(String windowsURI, String unixURI) {
        if (this.bRunningWindows_) {
            if (!this.isValidPath(windowsURI)) {
                this.logWarning("cmInvalidAliasRootWindowsURI");
                this.logWarning("cmInvalidFilePath", new CMException.Parm[]{new CMException.Parm("Path", windowsURI)});
                return false;
            }
        } else if (!this.isValidPath(unixURI)) {
            this.logWarning("cmInvalidAliasRootUnixURI");
            this.logWarning("cmInvalidFilePath", new CMException.Parm[]{new CMException.Parm("Path", unixURI)});
            return false;
        }
        return true;
    }

    private boolean isValidPath(String pathURI) {
        String path;
        String fixedUpUriString = pathURI.replace("\\", "/");
        try {
            fixedUpUriString = URIUtil.encodePath((String)fixedUpUriString);
            path = FileURIUtils.getPathFromURI((String)fixedUpUriString);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (URIException e) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    @Override
    public boolean isValidRoot() throws CMException {
        return this.isValidRoot(this.archiveRoot_);
    }

    @Override
    public boolean isValidRoot(String root) throws CMException {
        boolean bValid = false;
        if (root == null || root.length() == 0) {
            return true;
        }
        if (!CMConfiguration.isSupportedScheme(root)) {
            throw new CMException("cmInvalidFileScheme");
        }
        String validateArchiveRoot = this.getConfigAdvancedProp("CM_VALIDATE_ARCHIVE_ROOT");
        if (validateArchiveRoot != null && validateArchiveRoot.equalsIgnoreCase("false")) {
            bValid = true;
        } else {
            if (root.startsWith("file://")) {
                root = root.substring(new String("file://").length());
            }
            root = this.resolveEffectivePath(root);
            File path = new File(root);
            bValid = path.exists();
        }
        if (!bValid) {
            throw new CMException("cmInvalidFilePath", new CMException.Parm("Path", root));
        }
        return bValid;
    }

    private static boolean isSupportedScheme(String location) {
        boolean isSupported = false;
        if (location.startsWith("file://")) {
            isSupported = true;
        }
        return isSupported;
    }

    private void parseCCLConfiguration(ICCLConfiguration cclConfig) throws CMException {
        XMLElement localeMap;
        int parmIdx;
        String localeInfo = null;
        try {
            localeInfo = cclConfig.export();
        }
        catch (Exception e) {
            throw new CMException(e, "cmFailedToLoadLocaleInfo");
        }
        if (localeInfo == null || localeInfo.length() < 1) {
            // empty if block
        }
        XMLDoc info = null;
        try {
            info = new XMLDocParser().readXML(localeInfo);
        }
        catch (Exception e) {
            throw new CMException(e, "cmFailedToParseLocaleInfo");
        }
        XMLElement root = info.getRootXMLElement();
        int parmCnt = PARM_NAMES.length;
        for (parmIdx = 0; parmIdx != parmCnt; ++parmIdx) {
            XMLElement localeMapValue;
            localeMap = root.getOptionalChildWithName(PARM_NAMES[parmIdx]);
            if (localeMap == null || (localeMapValue = localeMap.getSingleChildWithName("value")) == null) continue;
            if (PARM_NAMES[parmIdx].equalsIgnoreCase("aliasRoots")) {
                this.parseAliasRoots(new CMDbStoreArrayXMLValue(localeMapValue));
                continue;
            }
            this.setObject(PARM_NAMES[parmIdx], new CMDbStoreArrayXMLValue(localeMapValue));
        }
        parmCnt = PARM_NAMES_FORSINGLEVALUE.length;
        for (parmIdx = 0; parmIdx != parmCnt; ++parmIdx) {
            localeMap = root.getOptionalChildWithName(PARM_NAMES_FORSINGLEVALUE[parmIdx]);
            if (localeMap == null) continue;
            String parmValue = localeMap.getOptionalChildValueWithName("value");
            boolean bSet = false;
            if (parmValue != null) {
                if (PARM_NAMES_FORSINGLEVALUE[parmIdx].equalsIgnoreCase("archiveLocationFileSchemeRoot")) {
                    this.archiveRoot_ = parmValue;
                    try {
                        bSet = this.isValidRoot();
                        parmValue = this.archiveRoot_;
                    }
                    catch (CMException ex) {
                        this.archiveRoot_ = null;
                        this.logFailure("cmArchiveRootNotSet", null, ex);
                    }
                } else {
                    bSet = true;
                }
            }
            if (!bSet) continue;
            this.setObject(PARM_NAMES_FORSINGLEVALUE[parmIdx], parmValue);
        }
    }

    @Override
    public String getValue(String parm, boolean b) {
        try {
            return this.oConfig_.getValue(parm, b);
        }
        catch (CCLConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Element getValueElement(String prop, boolean b) throws CMConfigurationException {
        try {
            return this.oConfig_.getValueElement(prop, b);
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public boolean isInternalSSL() throws CMConfigurationException {
        try {
            return this.oConfig_.isInternalSSL();
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public boolean isReportOutputEnabled() {
        return this.bEnableReportOutput_;
    }

    @Override
    public String mapContentLocale(String localeHint, boolean b) throws CMConfigurationException {
        try {
            return this.oConfig_.mapContentLocale(localeHint, b);
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public String mapContentLocaleStrict(String localeHint, boolean b) throws CMConfigurationException {
        try {
            return this.oConfig_.mapContentLocaleStrict(localeHint, b);
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public String mapProductLocale(String value, boolean b) throws CMConfigurationException {
        try {
            return this.oConfig_.mapProductLocale(value, b);
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public String normalizeLocale(String localeHint) throws CMConfigurationException {
        try {
            return this.oConfig_.normalizeLocale(localeHint);
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public String resolveEffectivePath(String string) throws CMConfigurationException {
        return this.oConfig_.resolveEffectivePath(string);
    }

    @Override
    public void setCMRootDir(String root) {
    }

    @Override
    public boolean validateContentLocale(String localeHint) throws CMConfigurationException {
        try {
            return this.oConfig_.validateContentLocale(localeHint);
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public boolean validateContentLocaleStrict(String localeHint) throws CMConfigurationException {
        try {
            return this.oConfig_.validateContentLocaleStrict(localeHint);
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public boolean validateProductLocale(String localeHint) throws CMConfigurationException {
        try {
            return this.oConfig_.validateProductLocale(localeHint);
        }
        catch (CCLConfigurationException e) {
            throw new CMConfigurationException(e);
        }
    }

    @Override
    public CMLocalePreference getServerLocale() {
        return CMServlet.serverLocale_;
    }

    void initializeServerLocale() {
        try {
            String localeStr = this.getCognosProp("serverLocale");
            String localeID = null;
            boolean isLocaleFound = false;
            if (localeStr != null) {
                localeID = this.normalizeLocale(localeStr);
                isLocaleFound = this.validateContentLocale(localeID);
            }
            if (!(isLocaleFound || this.validateContentLocale(localeID = this.normalizeLocale(localeStr = CMLocaleUtils.toString(new Locale("en", "")))) || this.validateContentLocale(localeID = this.normalizeLocale(localeStr = CMLocaleUtils.toString(Locale.getDefault()))))) {
                StringBuffer exMessage = new StringBuffer("No valid system locale could be found. Locale ('");
                exMessage.append(localeStr);
                exMessage.append("') is invalid.");
                IllegalStateException illegalStateExcp = new IllegalStateException(exMessage.toString());
                throw new CMRuntimeException(illegalStateExcp);
            }
            CMServlet.serverLocale_ = new CMLocalePreference(localeID);
        }
        catch (CMConfigurationException ex) {
            CMIndications.logException(new CMException(ex, "cmErrConfig"));
        }
    }

    @Override
    public void setConfigurationDirectory(String configurationFolderName) {
        this.configurationDir_ = new File(configurationFolderName);
        if (!this.configurationDir_.exists()) {
            CMConfigurationException cmex = new CMConfigurationException("cmMissingConfigurationFolder", new CMException.Parm("Path", this.configurationDir_.getAbsolutePath()));
            CMIndications.logException(cmex);
            throw new RuntimeException(cmex);
        }
    }

    @Override
    public File getConfigurationDirectory() {
        return this.configurationDir_;
    }

    @Override
    public void setSchemasDirectory(String dbPathName) {
        this.schemaDir_ = new File(this.configurationDir_, dbPathName);
    }

    @Override
    public File getSchemasDirectory() {
        return this.schemaDir_;
    }

    @Override
    public String getCMRootDir() {
        return null;
    }

    public static String getDatabaseTypeConstant() {
        return ELEM_CONFIG_DATABASETYPE;
    }

    @Override
    public void encryptDatabaseProperty(String elemConfig) throws CMConfigurationException {
        if (this.helper_ == null) {
            this.helper_ = new CMDbStoreEncryptHelper();
        }
        if (this.helper_ != null) {
            String tmp = this.getDatabaseProp(elemConfig);
            String encryptedValue = null;
            if (tmp != null && tmp.length() != 0) {
                try {
                    encryptedValue = this.helper_.encrypt(tmp);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CMConfigurationException((Throwable)e);
                }
                catch (CAMCryptoException e) {
                    throw new CMConfigurationException(e);
                }
                if (encryptedValue != null) {
                    this.removeString(elemConfig);
                    this.setString(elemConfig, encryptedValue);
                    this.setString(elemConfig, encryptedValue);
                }
            }
        }
    }

    @Override
    public String getDatabaseDecryptedProp(String elemConfig) throws CAMCryptoException {
        String tmp = this.getDatabaseProp(elemConfig);
        if (this.helper_ != null && tmp != null && tmp.length() != 0) {
            return this.helper_.decrypt(tmp);
        }
        return tmp;
    }

    @Override
    public boolean isEncryptionEnabled() {
        return this.isEncryptionEnabled_;
    }

    @Override
    public ExternalObjectStore getExternalObjectStore() {
        return this.externalObjectStore;
    }

    private boolean readOptionalBooleanParameter(XMLElement el, String parameterName, boolean defaultValue) throws CMException {
        String s;
        boolean value = defaultValue;
        if ((el = el.getOptionalChildWithNameAndAttribute("parameter", "name", parameterName)) != null && (s = el.getChildValueWithName("value")) != null) {
            value = s.equalsIgnoreCase("true");
        }
        return value;
    }

    private boolean readBooleanValue(XMLElement el, boolean defaultValue) throws CMException {
        String s;
        boolean value = defaultValue;
        if (el != null && (s = el.getChildValueWithName("value")) != null) {
            value = s.equalsIgnoreCase("true");
        }
        return value;
    }

    private void readDatabaseInstance(XMLElement eRoot) throws CMException, CMConfigurationException {
        XMLElement eInstance;
        XMLElement eInstances = eRoot.getChildWithNameAndAttribute("instances", "name", "database");
        if (eInstances != null && (eInstance = eInstances.getChildWithName("instance")) != null) {
            this.setString(ELEM_CONFIG_DATABASETYPE, eInstance.getAttribute("class"));
            ListIterator<XMLElement> iter = this.getParameterIterator(eInstance);
            if (iter != null) {
                while (iter.hasNext()) {
                    XMLElement xmlEl = iter.next();
                    String paramName = xmlEl.getAttribute("name");
                    if (paramName == null) continue;
                    if (paramName.equals("user")) {
                        xmlEl = this.getParameterElement(xmlEl, "value");
                        xmlEl = this.getParameterElement(xmlEl, "credential");
                        this.setString("user", this.getStringParameter(xmlEl, "username"));
                        this.setString("password", this.getStringParameter(xmlEl, "password"));
                        continue;
                    }
                    if (paramName.equals("eos")) {
                        this.readFileStoreInstance(xmlEl);
                        continue;
                    }
                    if (paramName.equals("SSLencryptionEnabled")) {
                        this.isEncryptionEnabled_ = this.readBooleanValue(xmlEl, false);
                        continue;
                    }
                    if (paramName.equals("advancedProperties")) {
                        this.parseAdvancedParameters(xmlEl);
                        continue;
                    }
                    String paramValue = this.getStringParameter(xmlEl, "value");
                    if (paramName.equals("name")) {
                        paramName = "databaseName";
                    }
                    this.setString(paramName, paramValue);
                }
            }
        }
    }

    private void parseAdvancedParameters(XMLElement xmlEl) throws CMConfigurationException, CMException {
        ArrayList<XMLElement> params = (xmlEl = this.getParameterElement(xmlEl, "value")).getChildren();
        if (params != null && !params.isEmpty()) {
            for (XMLElement param : params) {
                String name = param.getAttribute("name");
                String value = param.getChildValueWithName("value");
                if (!StringUtils.isNotBlank((String)name) || !StringUtils.isNotBlank((String)value)) continue;
                this.connectionAdvancedParameters.put(name, value);
            }
        }
    }

    private void readFileStoreInstance(XMLElement eInstances) throws CMException, CMConfigurationException {
        ListIterator<XMLElement> iter;
        XMLElement eInstance = eInstances.getChildWithName("instance");
        if (eInstance != null && (iter = this.getParameterIterator(eInstance)) != null) {
            String windowsRepositoryURI = null;
            String unixRepositoryURI = null;
            boolean migrateContentToRepository = false;
            while (iter.hasNext()) {
                XMLElement xmlEl = iter.next();
                String paramName = xmlEl.getAttribute("name");
                if ("fileStoreURI".equals(paramName)) {
                    xmlEl = this.getParameterElement(xmlEl, "value");
                    windowsRepositoryURI = this.getItemValue(xmlEl, "winURI");
                    unixRepositoryURI = this.getItemValue(xmlEl, "unixURI");
                    continue;
                }
                if (!"migrateContentToRepository".equals(paramName)) continue;
                migrateContentToRepository = "true".equalsIgnoreCase(this.getStringParameter(xmlEl, "value"));
            }
            this.externalObjectStore = new ExternalObjectStore(migrateContentToRepository, windowsRepositoryURI, unixRepositoryURI);
            this.setString("windowsRepositoryURI", windowsRepositoryURI);
            this.setString("unixRepositoryURI", unixRepositoryURI);
        }
    }

    private ListIterator<XMLElement> getParameterIterator(XMLElement eInstance) {
        ListIterator iter = null;
        ArrayList<XMLElement> lParameters = eInstance.getChildren();
        if (lParameters != null) {
            iter = lParameters.listIterator();
        }
        return iter;
    }

    private XMLElement getParameterElement(XMLElement el, String parameterName) throws CMConfigurationException {
        try {
            return el.getChildWithName(parameterName);
        }
        catch (Exception ex) {
            throw new CMConfigurationException("cmConfigDatabaseError", new CMException.Parm("Name", parameterName));
        }
    }

    private String getStringParameter(XMLElement el, String parameterName) throws CMConfigurationException {
        try {
            return el.getChildValueWithName(parameterName);
        }
        catch (Exception ex) {
            throw new CMConfigurationException("cmConfigDatabaseError", new CMException.Parm("Name", parameterName));
        }
    }

    private String getItemValue(XMLElement el, String parameterName) throws CMConfigurationException {
        try {
            XMLElement pathElement = el.getOptionalChildWithNameAndAttribute("item", "name", parameterName);
            if (pathElement == null) {
                return "";
            }
            return pathElement.value_;
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmConfigDatabaseError", new CMException.Parm("Name", parameterName));
        }
    }

    @Override
    public boolean isExternalObjectStoreEnabled() {
        ExternalObjectStore eos = this.getExternalObjectStore();
        return eos != null && eos.isEnabled();
    }

    @Override
    public Map<String, String> getConnectionAdvancedParameters() {
        return this.connectionAdvancedParameters;
    }

    @Override
    public void enablePerTenantNameUniqueness() {
        this.namesHaveTenantScope = true;
    }

    @Override
    public boolean namesHaveTenantScope() {
        return this.namesHaveTenantScope;
    }
}

