/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.dbstore.properties.CMDbStoreArrayXMLValue;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMLocalePreference;
import com.cognos.cm.server.DatabaseConfigInfo;
import com.cognos.cm.server.ExternalObjectStore;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class CMConfigurationRegression
implements IConfiguration {
    private String sCMRootDir_;
    private boolean bEnableReportOutput_ = false;
    private Properties properties_ = this.getBundle();
    private File configurationDir_;
    private File schemaDir_;
    private String archiveRoot_ = this.getValue("archiveLocationFileSchemeRoot", false);

    protected CMConfigurationRegression() {
        this.configurationDir_ = new File(this.getString("CMConfigurationDirectory"));
    }

    private Properties getBundle() {
        ResourceBundle props = null;
        props = ResourceBundle.getBundle("com.cognos.cm.server.ConfigurationRegression");
        Properties prop = new Properties();
        Enumeration<String> keys = props.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = props.getString(key);
            prop.setProperty(key, value);
        }
        return prop;
    }

    @Override
    public boolean databaseIsConfigured() {
        return true;
    }

    @Override
    public String getArchiveRoot() {
        return this.archiveRoot_;
    }

    @Override
    public List<IConfiguration.AliasRoot> getAliasRoots() {
        return null;
    }

    @Override
    public String getCognosProp(String key) {
        return this.getString(key);
    }

    @Override
    public String getConfigAdvancedProp(String key) {
        return this.getString(key);
    }

    @Override
    public File getConfigurationDirectory() {
        return this.configurationDir_;
    }

    @Override
    public List<DatabaseConfigInfo> getDatabaseConfigInfo() {
        ArrayList<DatabaseConfigInfo> configInfoList = new ArrayList<DatabaseConfigInfo>();
        configInfoList.add(new DatabaseConfigInfo("databaseType", this.getDatabaseType()));
        configInfoList.add(new DatabaseConfigInfo("server", this.getString("server")));
        configInfoList.add(new DatabaseConfigInfo("databaseName", this.getString("databaseName")));
        configInfoList.add(new DatabaseConfigInfo("user", this.getString("user")));
        configInfoList.add(new DatabaseConfigInfo("password", this.getString("password")));
        return configInfoList;
    }

    @Override
    public String getDatabaseConnect() {
        String strConnect = this.getString("CMDatabase" + this.getDatabaseType());
        List<String> subs = CMStringUtils.getBraceStringSubs(strConnect);
        for (int i = 0; i < subs.size(); ++i) {
            String sSub = subs.get(i);
            String sValue = this.getString(sSub);
            strConnect = CMStringUtils.subBraceString(strConnect, sSub, sValue);
        }
        return strConnect;
    }

    @Override
    public String getDatabaseProp(String key) {
        return this.getString(key);
    }

    @Override
    public List<String> getDatabaseTypeList() {
        ArrayList<String> dbList = new ArrayList<String>();
        String strDBs = this.getString("CMDatabaseProviders");
        StringTokenizer tokens = new StringTokenizer(strDBs, ",");
        while (tokens.hasMoreTokens()) {
            String db = tokens.nextToken();
            dbList.add(db);
        }
        return dbList;
    }

    @Override
    public String getDeploymentFolder() {
        return "../deployment";
    }

    @Override
    public String getInternalProp(String key) {
        return this.getString(key);
    }

    @Override
    public Object getObject(String key) {
        return this.properties_.get(key);
    }

    @Override
    public List<?> getList(String parameterName) {
        Object o = this.properties_.get(parameterName);
        if (null == o) {
            return null;
        }
        if (o instanceof ArrayList) {
            return (List)o;
        }
        return null;
    }

    @Override
    public Properties getProperties() {
        return this.properties_;
    }

    @Override
    public File getSchemasDirectory() {
        return this.schemaDir_;
    }

    @Override
    public CMLocalePreference getServerLocale() {
        return new CMLocalePreference(this.properties_.getProperty("serverLocale"));
    }

    @Override
    public String getString(String key) {
        return this.properties_.getProperty(key);
    }

    @Override
    public String getValue(String key, boolean b) {
        return this.getString(key);
    }

    @Override
    public Element getValueElement(String configurationAdvancedProperties, boolean b) throws CMConfigurationException {
        return null;
    }

    @Override
    public boolean isInternalSSL() throws CMConfigurationException {
        return false;
    }

    @Override
    public boolean isReportOutputEnabled() {
        return this.bEnableReportOutput_;
    }

    @Override
    public boolean isRunningWindows() {
        return false;
    }

    @Override
    public boolean isValidRoot(String archiveRoot) throws CMException {
        return false;
    }

    @Override
    public boolean isValidRoot() throws CMException {
        return false;
    }

    @Override
    public String mapContentLocale(String locale, boolean b) throws CMConfigurationException {
        String propObj = (String)this.getObject("contentLocaleMap");
        return this.findLocaleMatch(locale, propObj);
    }

    @Override
    public String mapContentLocaleStrict(String locale, boolean b) throws CMConfigurationException {
        String propObj = (String)this.getObject("contentLocaleMap");
        return this.findLocaleMatch(locale, propObj);
    }

    @Override
    public String mapProductLocale(String value, boolean b) throws CMConfigurationException {
        String propObj = (String)this.getObject("productLocaleMap");
        return this.findLocaleMatch(value, propObj);
    }

    private String findLocaleMatch(String value, String propObj) throws CMConfigurationException {
        CMDbStoreArrayXMLValue xmlValue = null;
        try {
            xmlValue = new CMDbStoreArrayXMLValue(CMXMLUtils.convertXMLString2XMLElement(propObj));
        }
        catch (CMException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < xmlValue.getSize(); ++i) {
            XMLElement d = (XMLElement)xmlValue.getItem(i);
            ArrayList<XMLElement> elements = d.getChildren();
            for (int k = 0; k < elements.size(); ++k) {
                XMLElement elem = (XMLElement)elements.get(k);
                ArrayList<XMLElement> elemChildren = elem.getChildren();
                for (int j = 0; j < elemChildren.size(); ++j) {
                    XMLElement elemChild = (XMLElement)elemChildren.get(j);
                    try {
                        XMLElement keyElem = elemChild.getChildWithName("key");
                        XMLElement valueElem = elemChild.getChildWithName("value");
                        String exactMatch = keyElem.value_;
                        if (Pattern.matches(exactMatch, value)) {
                            return valueElem.value_;
                        }
                        if (!value.startsWith(keyElem.value_.substring(0, keyElem.value_.indexOf("-")))) continue;
                        return valueElem.value_;
                    }
                    catch (CMException e) {
                        throw new CMConfigurationException("Unable to find locale");
                    }
                }
            }
        }
        throw new CMConfigurationException("Unable to find locale");
    }

    @Override
    public String normalizeLocale(String localeHint) throws CMConfigurationException {
        int endIndex;
        String localeNormalized = localeHint.toLowerCase();
        if (!localeNormalized.startsWith("zh") && (endIndex = localeNormalized.indexOf(45)) != -1) {
            localeNormalized = localeNormalized.substring(0, endIndex);
        }
        return localeNormalized;
    }

    @Override
    public void reconfigure() throws CMException {
    }

    @Override
    public String resolveEffectivePath(String string) throws CMConfigurationException {
        String resolvedPath = null;
        try {
            String cwd = System.getProperty("user.dir");
            File resolvedFilePath = new File(cwd + File.separatorChar + string);
            resolvedPath = resolvedFilePath.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resolvedPath;
    }

    @Override
    public void setCMRootDir(String root) {
        this.sCMRootDir_ = root;
    }

    @Override
    public String getCMRootDir() {
        return this.sCMRootDir_;
    }

    @Override
    public void setConfigurationDirectory(String configurationDirectoryName) throws CMConfigurationException {
        this.configurationDir_ = new File(configurationDirectoryName);
    }

    @Override
    public void setDatabaseProp(String string, String name) {
        this.setString(string, name);
    }

    @Override
    public void setInternalProp(String string, String name) {
        this.setString(string, name);
    }

    @Override
    public void setObject(String objectName, Object objectValue) {
        if (objectName == null || objectName.length() < 1 || objectValue == null) {
            return;
        }
        this.properties_.remove(objectName);
        this.properties_.put(objectName, objectValue);
    }

    @Override
    public void setSchemasDirectory(String schemaDirName) throws CMConfigurationException {
        this.schemaDir_ = new File(schemaDirName);
    }

    private void setString(String name, String value) {
        if (name == null || name.length() < 1) {
            return;
        }
        if (value == null) {
            value = new String("");
        }
        this.properties_.remove(name);
        this.properties_.setProperty(name, value);
    }

    @Override
    public boolean validateContentLocale(String localeHint) throws CMConfigurationException {
        return this.verifyLocaleMap("supportedContentLocales", localeHint);
    }

    @Override
    public boolean validateContentLocaleStrict(String localeHint) throws CMConfigurationException {
        return this.verifyLocaleMap("supportedContentLocales", localeHint);
    }

    @Override
    public boolean validateProductLocale(String localeHint) throws CMConfigurationException {
        return this.verifyLocaleMap("supportedProductLocales", localeHint);
    }

    private boolean verifyLocaleMap(String localeMap, String value) {
        String propObj = (String)this.getObject(localeMap);
        CMDbStoreArrayXMLValue xmlValue = null;
        try {
            xmlValue = new CMDbStoreArrayXMLValue(CMXMLUtils.convertXMLString2XMLElement(propObj));
        }
        catch (CMException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < xmlValue.getSize(); ++i) {
            XMLElement d = (XMLElement)xmlValue.getItem(i);
            ArrayList<XMLElement> elements = d.getChildren();
            for (int k = 0; k < elements.size(); ++k) {
                XMLElement elem = (XMLElement)elements.get(k);
                String match = elem.getAttribute("id");
                if (!Pattern.matches(match, value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDatabaseType() {
        return this.getString("databaseType");
    }

    @Override
    public void encryptDatabaseProperty(String elemConfig) {
    }

    @Override
    public String getDatabaseDecryptedProp(String elemConfig) {
        return null;
    }

    @Override
    public ExternalObjectStore getExternalObjectStore() {
        return null;
    }

    @Override
    public boolean isExternalObjectStoreEnabled() {
        return false;
    }

    @Override
    public boolean isEncryptionEnabled() {
        return false;
    }

    @Override
    public Map<String, String> getConnectionAdvancedParameters() {
        return null;
    }

    @Override
    public void enablePerTenantNameUniqueness() {
    }

    @Override
    public boolean namesHaveTenantScope() {
        return false;
    }
}

