/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.dbstore.CMDbDataUpgradeStore;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.plugin.Interface.CMPlugin;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPluginManager;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMDataUpgrade;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMUpgradeLogXMLGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class CMDataUpgradeManager {
    private CMPluginManager pluginMgr_;
    private CMDataUpgrade dataUpgradeStore_ = new CMDbDataUpgradeStore();
    private static String reportPluginVersionInDB_ = "";
    private static String queryPluginVersionInDB_ = "";
    private int countUpgraded_;
    private int countUpToDate_;
    private int countTotal_;
    private int countStep_;
    private int countCurrentObject_;
    private static final String CONFIG_PARM_REPORTUPGRADE = "doReportSpecUpgrade";

    public void upgradeData(boolean bEmptyCM, boolean requireMajorUpgrade) {
        this.pluginMgr_ = CMPluginManager.getInstance();
        if (!this.pluginMgr_.hasPlugins()) {
            return;
        }
        boolean bReportUpgradeOptionSet = false;
        String upgradeReport = ConfigurationFactory.getConfig().getValue(CONFIG_PARM_REPORTUPGRADE, false);
        if (upgradeReport != null && upgradeReport.equalsIgnoreCase("true")) {
            bReportUpgradeOptionSet = true;
        }
        List<CMPluginDescriptor> descs = this.pluginMgr_.getPluginDescriptors();
        for (CMPluginDescriptor desc : descs) {
            List clss;
            boolean bNeedUpgrade = false;
            if (!desc.getPluginType().equalsIgnoreCase("Upgrade") || desc.getEditions() != null) continue;
            if (bEmptyCM) {
                this.populatePluginVersionInDB(desc);
                continue;
            }
            boolean bReportPlugin = false;
            boolean bQueryPlugin = false;
            boolean bSetReportUpgradeFlag = false;
            boolean bSetPluginVersion = false;
            if (!desc.isMandatory() && (clss = desc.getClassNamesForDeployment()) != null && !clss.isEmpty()) {
                if (clss.contains(CMObjectClass.REPORT.getName())) {
                    bReportPlugin = true;
                } else if (clss.contains(CMObjectClass.QUERY.getName())) {
                    bQueryPlugin = true;
                }
            }
            boolean isBeringRTM = false;
            if (CMDbStoreFactory.versionBeforeUpgrade_ > 2.0 && CMDbStoreFactory.versionBeforeUpgrade_ < 2.0049) {
                isBeringRTM = true;
            }
            String pluginName = desc.getPluginName();
            String pluginVersion = desc.getVersion();
            boolean bUpdateVersionTable = false;
            try {
                boolean bVerionExisted;
                String pluginVersionInDB = "";
                try {
                    pluginVersionInDB = this.dataUpgradeStore_.get(pluginName);
                }
                catch (CMException sqlEx) {
                    this.logStoreError(sqlEx, pluginName, "get");
                }
                boolean bl = bVerionExisted = pluginVersionInDB.length() != 0;
                if (bVerionExisted) {
                    if (bReportPlugin) {
                        reportPluginVersionInDB_ = pluginVersionInDB;
                    } else if (bQueryPlugin) {
                        queryPluginVersionInDB_ = pluginVersionInDB;
                    }
                    float versionInDesc = Float.parseFloat(pluginVersion);
                    float versionInDB = Float.parseFloat(pluginVersionInDB);
                    boolean bl2 = bNeedUpgrade = versionInDesc > versionInDB || requireMajorUpgrade && bReportUpgradeOptionSet && (bReportPlugin || bQueryPlugin);
                    if (bNeedUpgrade && (bReportPlugin || bQueryPlugin)) {
                        if (bReportUpgradeOptionSet) {
                            bSetReportUpgradeFlag = true;
                        }
                        if (versionInDesc > versionInDB) {
                            bSetPluginVersion = true;
                        }
                    }
                } else if (desc.isMandatory()) {
                    bNeedUpgrade = true;
                } else if (requireMajorUpgrade) {
                    if (bReportPlugin || bQueryPlugin) {
                        if (isBeringRTM) {
                            bNeedUpgrade = true;
                            if (bReportUpgradeOptionSet) {
                                bSetReportUpgradeFlag = true;
                            }
                            bSetPluginVersion = true;
                            if (bReportPlugin) {
                                reportPluginVersionInDB_ = new Float(2.001).toString();
                            } else {
                                queryPluginVersionInDB_ = new Float(2.0).toString();
                            }
                        } else if (bReportUpgradeOptionSet) {
                            bNeedUpgrade = true;
                            bSetReportUpgradeFlag = true;
                        }
                    }
                    if (!bNeedUpgrade) {
                        bUpdateVersionTable = true;
                    }
                } else if (bReportPlugin || bQueryPlugin) {
                    bNeedUpgrade = true;
                    if (bReportUpgradeOptionSet) {
                        bSetReportUpgradeFlag = true;
                    }
                }
                if (bNeedUpgrade) {
                    String className = this.concatenateClassNames(desc);
                    if (isBeringRTM && (bReportPlugin || bQueryPlugin) && !bReportUpgradeOptionSet) {
                        CMIndications.Audit_Message_FreeFormText("cmDataUpgradeSpecial", new CMException.Parm[]{new CMException.Parm("CMVersion", "Bering RTM"), new CMException.Parm("Class", className)}, 50000, "UpgradeDetails", "ContentManagerService", "", "Info", null);
                    }
                    CMIndications.Audit_Message_FreeFormText("cmDataUpgradeStart", new CMException.Parm[]{new CMException.Parm("Class", className), new CMException.Parm("Plugin", desc.getPluginID())}, 50000, "UpgradeDetails", "ContentManagerService", "", "Info", null);
                    boolean continueUpgrade = this.doUpgradeForOnePlugin(desc, requireMajorUpgrade, bReportPlugin, bQueryPlugin, bSetReportUpgradeFlag, bSetPluginVersion);
                    if (!continueUpgrade) continue;
                    if (bVerionExisted) {
                        this.updateStore(desc);
                        continue;
                    }
                    this.addToStore(desc);
                    continue;
                }
                if (!bUpdateVersionTable) continue;
                this.addToStore(desc);
            }
            catch (Throwable e) {
                CMIndications.logException(new CMException(e, "cmDataUpgradeError"));
            }
        }
    }

    private CMProperty[] buildPropArray(CMPropertySet propSet, CMObjectClass objClass, List<String> properties) {
        ArrayList<CMProperty> propList = new ArrayList<CMProperty>();
        for (String propName : properties) {
            CMProperty prop = propSet.getProperty(propName, objClass);
            if (prop == null) continue;
            propList.add(prop);
        }
        if (propList.size() == 0) {
            return null;
        }
        return propList.toArray(new CMProperty[propList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean doUpgradeForOnePlugin(CMPluginDescriptor desc, boolean requireMajorUpgrade, boolean bReportPlugin, boolean bQueryPlugin, boolean bSetReportUpgradeFlag, boolean bSetPluginVersion) throws CMException {
        this.countUpgraded_ = 0;
        this.countUpToDate_ = 0;
        this.countCurrentObject_ = 0;
        this.countTotal_ = 0;
        boolean bRet = true;
        if (desc == null) {
            return bRet;
        }
        List properties = desc.getProperties();
        if (properties.isEmpty()) {
            return bRet;
        }
        String startTime = CMDateUtils.getIsoDate();
        CMStore store = CMExecutionContext.get().getStore();
        List<String> searchPaths = desc.getSearchPaths();
        if (desc.searchPathsUseNameIds()) {
            searchPaths = CMLocaleUtils.localizeNameAttributesInSearchPaths(searchPaths);
        }
        ArrayList<String> storeIdList = new ArrayList<String>();
        ArrayList<CMObjectClass> classList = new ArrayList<CMObjectClass>();
        CMStoreQueryResults results = null;
        for (String searchPath : searchPaths) {
            if (searchPath == null) continue;
            try {
                results = store.executeQuery(new CMStoreXPath(searchPath), null, null, 0, 512, null);
                if (results == null) continue;
                while (results.next()) {
                    String storeId = store.getObjectStoreID(results.getObjectID());
                    storeIdList.add(storeId);
                    CMObjectClass objClass = results.getObjectClass();
                    classList.add(objClass);
                }
            }
            catch (Throwable ex) {
                CMIndications.logException(new CMException(ex, "cmFailedQueryForUpgrade", new CMException.Parm("PATH", searchPath)));
            }
            finally {
                if (results == null) continue;
                results.release();
                results = null;
            }
        }
        if (storeIdList.isEmpty()) {
            return true;
        }
        this.countTotal_ = storeIdList.size();
        CMStoreQueryResults oneObjRes = null;
        CMPropertySet propSet = store.getPropertySets().getPropertySet();
        String ipfOp = "UpgradeDetails";
        if (requireMajorUpgrade) {
            ipfOp = "Upgrade";
        }
        Timer progressLogTimer = this.startDataUpgradeProgressLogTimer(ipfOp);
        this.logDataUpgradeStep(++this.countStep_, this.countTotal_, ipfOp);
        for (int i = 0; i < storeIdList.size(); ++i) {
            String ipfObjPath;
            String ipfObjType;
            block59: {
                this.countCurrentObject_ = i + 1;
                String storeId = (String)storeIdList.get(i);
                if (storeId == null) continue;
                CMObjectClass objClass = (CMObjectClass)classList.get(i);
                ipfObjType = objClass.getName();
                CMProperty[] props = this.buildPropArray(propSet, objClass, properties);
                if (props == null) continue;
                CMStoreXPath upgradePath = CMStoreXPath.fromStoreID(storeId);
                ipfObjPath = upgradePath.getOriginalPath();
                oneObjRes = store.executeQuery(upgradePath, props, null, 0, 512, null);
                if (!oneObjRes.next()) break block59;
                ipfObjPath = oneObjRes.getSearchPath();
                CMUpgradeData data = CMDataUpgradeManager.getDataFromCMResult(oneObjRes, props, bReportPlugin, bQueryPlugin, bSetReportUpgradeFlag, bSetPluginVersion);
                oneObjRes.release();
                oneObjRes = null;
                CMUpgradeResult upgradeResult = null;
                try {
                    this.logDataUpgradeOneObject(ipfObjPath);
                    upgradeResult = this.getUpgradedData(data, desc);
                }
                catch (Throwable ex) {
                    CMException cmEx = new CMException(ex, "cmPluginFailUpgrade", new CMException.Parm("Name", desc.getPluginName()), new CMException.Parm("Path", ipfObjPath));
                    CMIndications.logException(cmEx);
                    this.addDataUpgradeError(ipfObjType, ipfObjPath, cmEx, null, desc.getPluginID());
                    if (oneObjRes != null) {
                        oneObjRes.release();
                        oneObjRes = null;
                    }
                    if (!store.inTransaction()) continue;
                    try {
                        store.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (upgradeResult == null) {
                    ++this.countUpToDate_;
                    continue;
                }
                int upgradeStatus = upgradeResult.getUpgradeStatus();
                if (upgradeStatus == 1) {
                    store.beginTransaction();
                    oneObjRes = store.executeQuery(upgradePath, props, null, 0, 512, null);
                    if (oneObjRes.next()) {
                        CMDataUpgradeManager.upgradeDataInCM(oneObjRes, props, upgradeResult, store);
                    }
                    oneObjRes.release();
                    oneObjRes = null;
                    store.commitTransaction();
                    ++this.countUpgraded_;
                } else if (upgradeStatus == 3) {
                    store.beginTransaction();
                    CMStoreXPath descendantQuery = new CMStoreXPath(upgradePath, "descendant-or-self::*", false);
                    oneObjRes = store.executeQuery(descendantQuery, null, null, 8, 512, null);
                    store.delete(oneObjRes, true);
                    oneObjRes.release();
                    oneObjRes = null;
                    store.commitTransaction();
                    ++this.countUpgraded_;
                } else if (upgradeStatus == 0) {
                    ++this.countUpToDate_;
                }
                String[] sErrors = null;
                List msgs = upgradeResult.getMessages();
                if (msgs != null) {
                    sErrors = new String[msgs.size()];
                    for (int j = 0; j < msgs.size(); ++j) {
                        CMUpgradeMessage msgObj = (CMUpgradeMessage)msgs.get(j);
                        sErrors[j] = msgObj.getMessage();
                    }
                }
                if (upgradeStatus == 1) {
                    if (sErrors != null) {
                        this.logObjectDataUpgraded(ipfObjType, ipfObjPath, sErrors);
                    }
                } else if (upgradeStatus == 2) {
                    this.logObjectDataNotUpgraded(desc.getComponentID(), ipfObjType, ipfObjPath, sErrors);
                }
                if (sErrors != null) {
                    List upgradeMessages = upgradeResult.getMessages();
                    this.addDataUpgradeErrors(ipfObjType, ipfObjPath, null, upgradeMessages, desc.getPluginID());
                }
                if (upgradeResult.getNextAction() != 2) continue;
                bRet = false;
                break;
            }
            if (oneObjRes != null) {
                oneObjRes.release();
                oneObjRes = null;
            }
            if (!store.inTransaction()) continue;
            try {
                store.rollbackTransaction();
            }
            catch (Exception data) {}
            continue;
            catch (Throwable e) {
                CMIndications.logException(e, new CMException("cmFailedToUpgradeObject", new CMException.Parm("PATH", ipfObjPath)).getMessage(), "Upgrade", ipfObjType, ipfObjPath);
                continue;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (oneObjRes != null) {
                    oneObjRes.release();
                    oneObjRes = null;
                }
                if (store.inTransaction()) {
                    try {
                        store.rollbackTransaction();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        progressLogTimer.cancel();
        String className = this.concatenateClassNames(desc);
        String endTime = CMDateUtils.getIsoDate();
        int failed = this.countTotal_ - this.countUpgraded_ - this.countUpToDate_;
        String sTotal = Integer.toString(this.countTotal_);
        String sUpgraded = Integer.toString(this.countUpgraded_);
        String sUpToDate = Integer.toString(this.countUpToDate_);
        String sFailed = Integer.toString(failed);
        CMIndications.Audit_Message_FreeFormText("cmDataUpgradeSummary", new CMException.Parm[]{new CMException.Parm("NUM", sTotal), new CMException.Parm("TYPE", className), new CMException.Parm("NUM1", sUpgraded), new CMException.Parm("NUM2", sFailed), new CMException.Parm("NUM3", sUpToDate)}, 50000, ipfOp, className, searchPaths.get(0), "Info", null);
        this.addDataUpgradeSummary(desc, className, startTime, endTime);
        if (CMUpgradeLogXMLGenerator.hasLogs()) {
            File upgradeLogFile = new File(CMServlet.logsDir_, "upgradeLog.xml");
            try {
                CMUpgradeLogXMLGenerator.dumpLogAsXML(upgradeLogFile, true);
            }
            catch (Throwable ex) {
                CMException cmEx = new CMException(ex, "cmErrUpgradeLogFile", new CMException.Parm("PATH", upgradeLogFile.getAbsolutePath()));
                CMIndications.logException(cmEx);
            }
        }
        return bRet;
    }

    private void logObjectDataNotUpgraded(String compID, String ipfObjType, String ipfObjPath, String[] sErrors) {
        CMIndications.Audit_Message_FreeFormText("objectDataNotUpgraded", new CMException.Parm[]{new CMException.Parm("COMPID", compID), new CMException.Parm("OBJTYPE", ipfObjType), new CMException.Parm("PATH", ipfObjPath)}, 50000, "Upgrade", ipfObjType, ipfObjPath, "Warning", sErrors);
    }

    private void logDataUpgradeOneObject(String ipfObjPath) {
        CMIndications.Audit_Message_FreeFormText("cmDataUpgradeOneObject", new CMException.Parm[]{new CMException.Parm("Path", ipfObjPath)}, 20000, "UpgradeDetails", "ContentManagerService", ipfObjPath, "Info", null);
    }

    private void logObjectDataUpgraded(String ipfObjType, String ipfObjPath, String[] sErrors) {
        CMIndications.Audit_Message_FreeFormText("objectDataUpgraded", new CMException.Parm[]{new CMException.Parm("OBJTYPE", ipfObjType), new CMException.Parm("PATH", ipfObjPath)}, 50000, "Upgrade", ipfObjType, ipfObjPath, "Info", sErrors);
    }

    private String concatenateClassNames(CMPluginDescriptor desc) {
        List classes = desc.getClassNamesForDeployment();
        String classNames = null;
        if (classes != null) {
            classNames = (String)classes.get(0);
            if (classes.size() > 1) {
                for (int m = 1; m < classes.size(); ++m) {
                    classNames = classNames + "', '" + (String)classes.get(m);
                }
            }
        } else {
            classNames = desc.getPluginName();
        }
        return classNames;
    }

    public static CMUpgradeData getDataFromCMResult(CMStoreQueryResults results, CMProperty[] props, boolean bReportPlugin, boolean bQueryPlugin, boolean bSetReportUpgradeFlag, boolean bSetPluginVersion) throws CMException {
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (int i = 0; i < props.length; ++i) {
            Object propValue = results.getValue(i);
            String propValueXML = null;
            if (propValue == null) continue;
            propValueXML = CMDataUpgradeUtils.getValueFromProp(props[i], propValue);
            String propName = props[i].getName();
            propMap.put(propName, propValueXML);
            if (!propName.equals("policies")) continue;
            boolean bAcquired = results.wasAcquired();
            propMap.put("POLICIES_ACQUIRED", Boolean.toString(bAcquired));
        }
        if (!propMap.isEmpty()) {
            if (bReportPlugin || bQueryPlugin) {
                if (bSetReportUpgradeFlag) {
                    propMap.put("UPGRADE_REPORT", new String(""));
                }
                if (bSetPluginVersion) {
                    if (bReportPlugin) {
                        propMap.put("PLUGIN_VERSION", reportPluginVersionInDB_);
                    } else if (bQueryPlugin) {
                        propMap.put("PLUGIN_VERSION", queryPluginVersionInDB_);
                    }
                }
            }
            propMap.put("UPGRADE_FROM", "DB");
        }
        String editionVersion = CMServlet.getEdition().getName();
        propMap.put("$VERSION_SOURCE", editionVersion);
        propMap.put("$VERSION_TARGET", editionVersion);
        CMUpgradeData data = new CMUpgradeData();
        data.setData(propMap);
        return data;
    }

    private CMUpgradeResult getUpgradedData(CMUpgradeData data, CMPluginDescriptor desc) throws Exception {
        String pluginID = desc.getPluginID();
        CMPlugin plugin = this.pluginMgr_.getPlugin(pluginID);
        CMUpgradeResult result = null;
        if (plugin instanceof CMUpgradePlugin) {
            result = ((CMUpgradePlugin)plugin).upgrade(data);
        } else {
            CMIndications.logException(new CMException("cmMissingPluginInfo"));
        }
        return result;
    }

    public static boolean upgradeDataInCM(CMStoreQueryResults cmStoreResult, CMProperty[] props, CMUpgradeResult result, CMStore store) throws CMException {
        if (result.getUpgradeStatus() != 1) {
            throw new IllegalStateException();
        }
        Map data = result.getData();
        if (data == null) {
            return true;
        }
        CMObjectClass objClass = cmStoreResult.getObjectClass();
        AddDef addDef = new AddDef();
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            if (!data.containsKey(propName)) continue;
            Object propValueObj = data.get(propName);
            if (propValueObj == null) {
                addDef.addUnique(props[i], null);
                continue;
            }
            String propValue = (String)propValueObj;
            CMDataUpgradeUtils.addPropertyIntoAddDef(addDef, props[i], propValue, objClass);
        }
        if (addDef.size() > 0) {
            store.update(cmStoreResult, addDef.names(), addDef.values());
        }
        return true;
    }

    private void populatePluginVersionInDB(CMPluginDescriptor desc) {
        try {
            this.dataUpgradeStore_.set(desc.getPluginName(), desc.getVersion());
        }
        catch (CMException sqlEx) {
            this.logStoreError(sqlEx, desc.getPluginName(), "set");
        }
    }

    private void addToStore(CMPluginDescriptor desc) {
        try {
            this.dataUpgradeStore_.add(desc.getPluginName(), desc.getVersion());
        }
        catch (CMException sqlEx) {
            this.logStoreError(sqlEx, desc.getPluginName(), "add");
        }
    }

    private void updateStore(CMPluginDescriptor desc) {
        try {
            this.dataUpgradeStore_.update(desc.getPluginName(), desc.getVersion());
        }
        catch (CMException sqlEx) {
            this.logStoreError(sqlEx, desc.getPluginName(), "update");
        }
    }

    private void logStoreError(CMException sqlEx, String pluginName, String operation) {
        CMException cmEx = new CMException((Exception)sqlEx, "cmDataUpgradeStoreError", new CMException.Parm("Name", pluginName), new CMException.Parm("Operation", operation));
        CMIndications.logException(cmEx);
    }

    private void addDataUpgradeError(String objClass, String searchPath, CMException emEx, CMUpgradeMessage sPluginError, String pluginID) {
        String message = null;
        int severity = -1;
        if (sPluginError != null) {
            message = sPluginError.getMessage();
            severity = sPluginError.getSeverity();
        } else if (emEx != null) {
            message = emEx.getFullMessage();
        }
        if (message != null) {
            CMUpgradeLogXMLGenerator.addElementWithSeverity("plugin", objClass, null, searchPath, message, pluginID, severity);
        }
    }

    private void addDataUpgradeErrors(String objClass, String searchPath, CMException emEx, List<CMUpgradeMessage> messages, String pluginID) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        for (int i = 0; i < messages.size(); ++i) {
            CMUpgradeMessage msg = messages.get(i);
            this.addDataUpgradeError(objClass, searchPath, emEx, msg, pluginID);
        }
    }

    private void addDataUpgradeSummary(CMPluginDescriptor desc, String className, String startTime, String endTime) {
        int failed = this.countTotal_ - this.countUpgraded_ - this.countUpToDate_;
        CMException cmEx = new CMException("cmDataUpgradeSummary", new CMException.Parm("NUM", Integer.toString(this.countTotal_)), new CMException.Parm("TYPE", className), new CMException.Parm("NUM1", Integer.toString(this.countUpgraded_)), new CMException.Parm("NUM2", Integer.toString(failed)), new CMException.Parm("NUM3", Integer.toString(this.countUpToDate_)));
        CMUpgradeLogXMLGenerator.addPluginElement(desc, this.countTotal_, this.countUpToDate_, this.countUpgraded_, failed, cmEx.getFullMessage(), startTime, endTime);
    }

    private Timer startDataUpgradeProgressLogTimer(String ipfOp) {
        final String sIpfOperation = ipfOp;
        final CMExecutionContext ctx = CMExecutionContext.get();
        TimerTask task = new TimerTask(){
            boolean bFirstRun = true;

            @Override
            public void run() {
                if (this.bFirstRun) {
                    CMExecutionContext.set(ctx);
                    this.bFirstRun = false;
                }
                CMDataUpgradeManager.this.logDataUpgradeProgress(CMDataUpgradeManager.this.countStep_, CMDataUpgradeManager.this.countCurrentObject_, CMDataUpgradeManager.this.countTotal_, sIpfOperation);
            }
        };
        Timer timer = new Timer();
        timer.schedule(task, AdvancedSettings.PROGRESS_LOG_FREQUENCY, (long)AdvancedSettings.PROGRESS_LOG_FREQUENCY);
        return timer;
    }

    private void logDataUpgradeStep(int stepCount, int totalObjectCount, String ipfOp) {
        CMIndications.Audit_Message_FreeFormText("cmDataUpgradeLogStep", new CMException.Parm[]{new CMException.Parm("NUM1", Integer.toString(stepCount)), new CMException.Parm("NUM2", Integer.toString(totalObjectCount))}, 50000, ipfOp, "ContentManagerService", "", "Info", null);
    }

    private void logDataUpgradeProgress(int stepCount, int currentObjectCount, int totalObjectCount, String ipfOp) {
        CMIndications.Audit_Message_FreeFormText("cmDataUpgradeLogProgress", new CMException.Parm[]{new CMException.Parm("NUM1", Integer.toString(stepCount)), new CMException.Parm("NUM2", Integer.toString(currentObjectCount)), new CMException.Parm("NUM3", Integer.toString(totalObjectCount))}, 50000, ipfOp, "ContentManagerService", "", "Info", null);
    }
}

