/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.CAM.AAAException;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.server.CMExceptionMessage;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cmutils.xml.XMLUtils;
import com.cognos.pogo.util.NameValuePair;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;

public class CMException
extends Exception
implements CMExceptionMessage {
    private static final long serialVersionUID = -1092787211459349798L;
    protected String sCode_;
    public Exception ex_ = null;
    private Exception ex2_ = null;
    public Throwable cause_ = null;
    protected String name_;
    protected Parm[] listExceptionParms_;
    public int ErrorLevel = 50000;
    private boolean addStackTrace = false;
    private boolean addCauseToMessage_ = true;

    public CMException() {
        this((Throwable)null);
    }

    public CMException(Throwable t) {
        this(t, null);
    }

    public CMException(String sCode) {
        this((Throwable)null, sCode);
    }

    public CMException(Throwable t, String sCode) {
        super(t);
        this.sCode_ = sCode;
        this.cause_ = t;
        if (this.sCode_ == null) {
            this.setDefaultCode(t);
        }
    }

    public CMException(Throwable e, String sCode, Parm ... parms) {
        this(e, sCode);
        this.listExceptionParms_ = parms;
    }

    public CMException(String sCode, Parm ... parms) {
        this((Throwable)null, sCode, parms);
    }

    public CMException(String sCode, String parmName, Object parmValue) {
        this((Throwable)null, sCode, new Parm(parmName, parmValue));
    }

    public CMException(Exception e) {
        this((Throwable)e);
        this.initException(e);
    }

    private void initException(Exception e) {
        this.ex_ = e;
        this.cause_ = e != null ? e.getCause() : null;
    }

    public CMException(Exception e, String sCode) {
        this((Throwable)e, sCode);
        this.initException(e);
    }

    public CMException(Exception e, String sCode, Exception e2) {
        this((Throwable)e, sCode);
        this.initException(e);
        this.ex2_ = e2;
    }

    public CMException(Exception e, String sCode, Parm ... parms) {
        this((Throwable)e, sCode, parms);
        this.initException(e);
    }

    public CMException(Exception e, String sCode, String parmName, Object parmValue) {
        this((Throwable)e, sCode, new Parm(parmName, parmValue));
        this.initException(e);
    }

    public Exception getException() {
        return this.ex_;
    }

    public Exception getException2() {
        return this.ex2_;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public void setErrorLevel(int el) {
        this.ErrorLevel = el;
    }

    @Override
    public String getCode() {
        if (this.sCode_ == null) {
            this.setDefaultCode(this.cause_);
        }
        return this.sCode_;
    }

    private void setDefaultCode(Throwable cause) {
        if (cause != null) {
            String errorName = cause.getClass().getSimpleName();
            this.sCode_ = "cmCMError";
            Parm[] parms = new Parm[]{new Parm("Error", errorName)};
            this.listExceptionParms_ = parms;
        } else {
            this.sCode_ = "cmGeneralCMError";
        }
    }

    public String getFullMessageSys(boolean putStackTrace) {
        return this.getFullMessage(this.getDefaultServerLocale(), putStackTrace);
    }

    private Locale getDefaultServerLocale() {
        if (!ConfigurationFactory.isConfigLoaded()) {
            return Locale.getDefault();
        }
        return ConfigurationFactory.getConfig().getServerLocale().toLocale();
    }

    public String getFullMessageSys() {
        return this.getFullMessageSys(true);
    }

    protected Locale getLocale() {
        Locale locale = Locale.ENGLISH;
        if (CMError.getUseResources()) {
            try {
                locale = CMExecutionContext.get().getRequestLocale("productLocale").toLocale();
            }
            catch (Exception e) {
                try {
                    locale = this.getDefaultServerLocale();
                }
                catch (Exception e2) {
                    locale = Locale.ENGLISH;
                }
            }
        }
        return locale;
    }

    public String getFullMessage() {
        return this.getFullMessage(this.getLocale());
    }

    public String getFullMessage(Locale locale) {
        return this.getFullMessage(locale, true);
    }

    public String getFullMessage(Locale locale, boolean putStackTrace) {
        if (locale == null) {
            locale = this.getDefaultServerLocale();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(this.getMessage(locale));
        Exception ex = this.ex_;
        while (ex != null && ex != this.cause_) {
            ret.append(CMConstants.NEW_LINE_SEPERATOR);
            ret.append(this.getLocalizedMessage(ex, putStackTrace));
            if (ex instanceof CMException) {
                CMException cmex = (CMException)ex;
                ex = cmex.getException();
                continue;
            }
            ex = null;
        }
        if (this.cause_ != null && this.addCauseToMessage_) {
            ret.append(" Cause: ");
            ret.append(this.getLocalizedMessage(this.cause_, putStackTrace));
        }
        return ret.toString();
    }

    @Override
    public String getMessage() {
        return this.getMessage(this.getLocale());
    }

    public String getMessage(Locale locale) {
        String strMessage;
        if (locale == null) {
            locale = this.getDefaultServerLocale();
        }
        if ((strMessage = CMError.getMessage(this.sCode_, this.listExceptionParms_, locale)) != null) {
            return strMessage;
        }
        StringBuilder ret = new StringBuilder();
        if (ret.length() == 0) {
            ret.append(this.getCode());
            ret.append("  ");
            ret.append(this.getClass().toString());
        }
        if (this.listExceptionParms_ != null) {
            for (int i = 0; i < this.listExceptionParms_.length; ++i) {
                ret.append(", ");
                ret.append(this.listExceptionParms_[i].getName());
                ret.append("=");
                ret.append(this.listExceptionParms_[i].getValue());
            }
        }
        return ret.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getLocalizedMessage(Throwable throwable) {
        return this.getLocalizedMessage(throwable, true);
    }

    public String getLocalizedMessage(Throwable throwable, boolean putStackTrace) {
        StringBuilder ret = new StringBuilder();
        ret.append(throwable.getLocalizedMessage());
        if (putStackTrace) {
            ret.append(CMConstants.NEW_LINE_SEPERATOR);
            ret.append(CMConstants.NEW_LINE_SEPERATOR + "Stack trace:" + CMConstants.NEW_LINE_SEPERATOR);
            ByteArrayOutputStream traceBytes = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(traceBytes);
            throwable.printStackTrace(ps);
            ret.append(traceBytes.toString());
        }
        return ret.toString();
    }

    public String getLocalizedMessage(Exception ex) {
        return this.getLocalizedMessage(ex, true);
    }

    public String getLocalizedMessage(Exception ex, boolean allowStackTrace) {
        StringBuilder ret;
        String localizedMessage = ex.getLocalizedMessage();
        if (ex instanceof AAAException) {
            boolean wroteSomething = false;
            ret = new StringBuilder();
            try {
                XMLElement messagesEL;
                ArrayList<XMLElement> messagesList;
                XMLDocParser parser = new XMLDocParser();
                XMLDoc xmlDoc = null;
                xmlDoc = parser.readXML(localizedMessage);
                if (xmlDoc != null && xmlDoc.getRootXMLElement() != null && (messagesList = (messagesEL = xmlDoc.getRootXMLElement().getChildWithName("messages")).getChildren()) != null) {
                    ListIterator iter = messagesList.listIterator();
                    while (iter.hasNext()) {
                        XMLElement xmlEl = (XMLElement)iter.next();
                        String message = xmlEl.getOptionalChildValueWithName("messageString");
                        if (message == null) continue;
                        if (wroteSomething) {
                            ret.append(CMConstants.NEW_LINE_SEPERATOR);
                        }
                        ret.append(message);
                        wroteSomething = true;
                    }
                }
            }
            catch (Exception parser) {
                // empty catch block
            }
            if (!wroteSomething) {
                ret.append(XMLUtils.escape((String)localizedMessage));
            }
            localizedMessage = ret.toString();
        }
        if (localizedMessage == null) {
            localizedMessage = ex.getClass().toString();
        }
        boolean isRuntimeException = ex instanceof RuntimeException;
        if (allowStackTrace && (isRuntimeException || this.addStackTrace)) {
            ret = new StringBuilder(localizedMessage);
            ret.append(CMConstants.NEW_LINE_SEPERATOR + "Stack trace:" + CMConstants.NEW_LINE_SEPERATOR);
            ByteArrayOutputStream traceBytes = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(traceBytes);
            ex.printStackTrace(ps);
            ret.append(traceBytes.toString());
            localizedMessage = ret.toString();
        }
        return localizedMessage;
    }

    public Parm[] getListExceptionParms_() {
        return this.listExceptionParms_;
    }

    @Override
    public NameValuePair[] getParms() {
        return this.listExceptionParms_;
    }

    public void setAddStackTrace(boolean addStackTrace) {
        this.addStackTrace = addStackTrace;
    }

    public void setAddCauseToMessage(boolean addCause) {
        this.addCauseToMessage_ = addCause;
    }

    public static class Parm
    extends NameValuePair {
        public Parm(String name, String value) {
            super(name, value);
        }

        public Parm(String name, Object value) {
            super(name, String.valueOf(value));
        }

        public String toString() {
            return "CMException.Parm(" + this.getName() + "=" + this.getValue() + ")";
        }
    }
}

