/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.CAM.AAAException;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CSKRequestHandler;
import com.cognos.accman.jcam.crypto.casync.CARequestHandler;
import com.cognos.cm.cmInfo;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.properties.CMDbStoreAncestors;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.deployment.DeploymentExecutionContext;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.ReadTenantFilter;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMStringArray;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AccManAuthResponse;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AuditContext;
import com.cognos.cm.server.CMBreadcrumbs;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContextData;
import com.cognos.cm.server.CMLocalePreference;
import com.cognos.cm.server.CMPermissionException;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.CMSessionStateRequestsAction;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.ExtendedUserCapabilities;
import com.cognos.cm.server.Header;
import com.cognos.cm.server.RequestManager;
import com.cognos.cm.server.UserPreferences;
import com.cognos.cm.server.UserSessionCache;
import com.cognos.cm.server.UserSessionCacheEntry;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.executioncontext.UserAccountInfo;
import com.cognos.cm.server.profileSettings.SessionProfileSettings;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreFactory;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.trustedServices.TrustedServices;
import com.cognos.cm.trustedServices.trustedService;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.hash.HashUtil;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMExecutionContext
implements Cloneable {
    private static ThreadLocal<CMExecutionContext> data = new ThreadLocal();
    private static ConcurrentHashMap<Object, CMExecutionContext> executionContextsMap = new ConcurrentHashMap();
    private int tenantId_ = -9999;
    private ReadTenantFilter readTenantFilter = new ReadTenantFilter.SessionBasedTenantFilter();
    String sGetUserDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><objectAttributesDocument xmlns=\"http://developer.cognos.com/schemas/CAM/AAA/1/\" language=\"en-us\">";
    String sGetUserDoc2 = "</objectAttributesDocument>";
    public static int CURRENTUSER_CONTENTLOCALE = 0;
    public static int CURRENTUSER_PRODUCTLOCALE = 1;
    public static int CURRENTUSER_FORMAT = 2;
    public static int CURRENTUSER_TIMEZONE = 3;
    public static int CURRENTUSER_USEACCESSIBILITYFEATURES = 4;
    public static int CURRENTUSER_SKIN = 5;
    public static int CURRENTUSER_LISTVIEWSEPARATOR = 6;
    public static int CURRENTUSER_AUTOMATICPAGEREFRESH = 7;
    public static int CURRENTUSER_SHOWOPTIONSUMMARY = 8;
    public static int CURRENTUSER_LINESPERPAGE = 9;
    public static int CURRENTUSER_DISPLAYMODE = 10;
    public static int CURRENTUSER_COLUMNSPERPAGE = 11;
    public static int CURRENTUSER_SHOWWELCOMEPAGE = 12;
    private static boolean auditSetUpAndTearDown = false;
    private CMExecutionContextData context_ = new CMExecutionContextData();
    protected static UserSessionCache sessionCache_ = new UserSessionCache(1000);
    private boolean repairInvalidContainment = false;
    private boolean applyTenantIdVirtualInheritance = true;

    public static void iterateOverContexts(CMSessionStateRequestsAction action) {
        for (Map.Entry<Object, CMExecutionContext> entry : executionContextsMap.entrySet()) {
            CMExecutionContext context = entry.getValue();
            action.doAction(context);
        }
    }

    public static boolean isExecutionTimeLimitExceeded(boolean patternMatched) {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (ctx.getExecutionTime() > (long)AdvancedSettings.MAXEXECUTIONTIMEOUT && ctx.getContext().getCurrentUserSession() != null && ctx.getContext().getSIPFObjectPath() != null && ctx.getContext().getSIPFObjectPath().indexOf("configuration") == -1) {
            if (patternMatched) {
                return true;
            }
            return CMExecutionContext.isOperationPatternMatch();
        }
        return false;
    }

    public static boolean isOperationPatternMatch() {
        block4: {
            CMExecutionContext ctx;
            block3: {
                ctx = CMExecutionContext.get();
                if (!AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns_Enabled) break block3;
                for (int i = 0; i < AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns.length / 2 && AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns[i] != null && AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns[i].length() != 0 && AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns[i + 1] != null && AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns[i + 1].length() != 0; i += 2) {
                    if (!AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns[i].equalsIgnoreCase(ctx.getContext().getSIPFOperation()) || (ctx.getContext().getSIPFObjectPath() == null || !ctx.getContext().getSIPFObjectPath().endsWith(AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns[i + 1])) && (ctx.getContext().getSIPFOriginalObjectPath() == null || !ctx.getContext().getSIPFOriginalObjectPath().endsWith(AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns[i + 1]))) continue;
                    return true;
                }
                break block4;
            }
            if (!AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns_RegEx_Enabled) break block4;
            for (int i = 0; i < AdvancedSettings.EXECUTIONTIMEOUTPATTERN_operation_RegEx.length && AdvancedSettings.EXECUTIONTIMEOUTPATTERN_operation_RegEx[i] != null && AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns_RegEx[i] != null; ++i) {
                Matcher m;
                if (!AdvancedSettings.EXECUTIONTIMEOUTPATTERN_operation_RegEx[i].equalsIgnoreCase(ctx.getContext().getSIPFOperation())) continue;
                if (ctx.getContext().getSIPFObjectPath() != null && (m = AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns_RegEx[i].matcher(ctx.getContext().getSIPFObjectPath())).matches()) {
                    return true;
                }
                if (ctx.getContext().getSIPFOriginalObjectPath() == null || !(m = AdvancedSettings.EXECUTIONTIMEOUTPATTERN_patterns_RegEx[i].matcher(ctx.getContext().getSIPFObjectPath())).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private String getCurrentContextString() {
        CMExecutionContext ctx = CMExecutionContext.get();
        return "Session:" + ctx.getContext().getCurrentUserSession() + "|" + "Operation:" + ctx.getContext().getSIPFOperation() + "|" + "ObjectPath:" + ctx.getContext().getSIPFObjectPath() + "|" + "OriginalObjectpath:" + ctx.getContext().getSIPFOriginalObjectPath() + "|" + "ExecutionTime:" + ctx.getExecutionTime();
    }

    public static void checkCancelOrTimeOut() throws CMException {
        CMExecutionContext.checkCancelOrTimeOut(false);
    }

    public static void checkCancelOrTimeOut(boolean patternMatched) throws CMException {
        if (AdvancedSettings.ENABLEMAXEXECUTIONTIMEOUT) {
            CMExecutionContext ctx = CMExecutionContext.get();
            if (CMExecutionContext.getCancel()) {
                CMException ex = new CMException("cmCancel");
                CMExecutionContext.logException("cmCancel", ctx.getCurrentContextString());
                throw ex;
            }
            if (CMExecutionContext.isExecutionTimeLimitExceeded(patternMatched)) {
                CMException ex = new CMException("cmExecutionTimeout", new CMException.Parm("Value", String.valueOf(ctx.getExecutionTime())));
                String strTrace = "";
                StringWriter sw = new StringWriter();
                PrintWriter pr = new PrintWriter(sw);
                ex.printStackTrace(pr);
                pr.flush();
                strTrace = sw.toString();
                CMExecutionContext.logException("cmExecutionTimeout", ctx.getCurrentContextString() + XMLUtils.escape((String)strTrace));
                throw ex;
            }
        }
    }

    private static void logException(String code, String value) {
        try {
            CMException logEx = new CMException(code, new CMException.Parm("Value", value));
            String msg = logEx.getLocalizedMessage(logEx);
            CMIndications.logException(logEx, msg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static synchronized void setCancel() {
        CMExecutionContext ctx = CMExecutionContext.get();
        ctx.getContext().setCancel(true);
    }

    public static synchronized boolean getCancel() {
        CMExecutionContext ctx = CMExecutionContext.get();
        return ctx.getContext().isCancel();
    }

    public static void mapCurrentThreadContext() {
        CMExecutionContext ctx = CMExecutionContext.get();
        ctx.getContext().setNStartTime(System.currentTimeMillis());
        Integer key = new Integer(System.identityHashCode(Thread.currentThread()));
        executionContextsMap.put(key, ctx);
    }

    public static void unmapCurrentThreadContext() {
        CMExecutionContext ctx = CMExecutionContext.get();
        Integer key = new Integer(System.identityHashCode(Thread.currentThread()));
        executionContextsMap.remove(key);
        ctx.getContext().setNStartTime(0L);
    }

    public Object clone() {
        try {
            CMExecutionContext c = (CMExecutionContext)super.clone();
            c.context_ = (CMExecutionContextData)this.getContext().clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public CMStore getStore() throws CMStoreNotAvailable, CMStoreUnexpected {
        CMStore store = this.getContext().getStore();
        if (store == null) {
            store = CMStoreFactory.getStore();
            if (!store.isInitialized()) {
                this.getContext().setStore(null);
            } else {
                this.getContext().setStore(store);
            }
        }
        return store;
    }

    public CMStore getStoreUnchecked() {
        CMStore store = null;
        try {
            store = this.getStore();
        }
        catch (Exception e) {
            CMIndications.logException(e);
            throw new RuntimeException(e);
        }
        return store;
    }

    public String getAccManPassportID() {
        return this.getContext().getCurrentUserPassportID();
    }

    public static String parseAccManPassportIDDocument(String passportdoc) {
        String passportValue = null;
        if (passportdoc == null || passportdoc.length() <= 0) {
            return null;
        }
        try {
            Document doc = CMXMLUtils.parse(new InputSource(new StringReader(passportdoc)));
            NodeList objects = doc.getElementsByTagName("CAMPassport");
            Element elCAMID = (Element)objects.item(0);
            if (elCAMID == null) {
                return null;
            }
            passportValue = elCAMID.getAttribute("id");
            if (passportValue == null || passportValue.length() < 1) {
                objects = elCAMID.getElementsByTagName("id");
                if ((elCAMID = (Element)objects.item(0)) == null) {
                    return null;
                }
                passportValue = CMXMLUtils.getCharacterContent(elCAMID);
            }
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return passportValue;
    }

    public void suppressProxyCreation() {
        this.getContext().setProxyCreationSuppressionCount(this.getContext().getProxyCreationSuppressionCount() + 1);
    }

    public void enableProxyCreation() {
        this.getContext().setProxyCreationSuppressionCount(this.getContext().getProxyCreationSuppressionCount() - 1);
    }

    public boolean proxyCreationEnabled() {
        return this.getContext().getProxyCreationSuppressionCount() == 0;
    }

    public void setAccManPassportID(String accManPassportID) {
        this.getContext().setCurrentUserPassportID(accManPassportID);
        this.getContext().setCurrentUserSession(sessionCache_.lookupPassport(accManPassportID));
    }

    public void setAccManSecurityBlob(String securityblob) {
        this.getContext().setSecurityBlob(securityblob);
    }

    public String getAccManSecurityBlob() {
        return this.getContext().getSecurityBlob();
    }

    public String getAccManPassportObjectStr() {
        String passportIDValue = this.getAccManPassportID();
        if (passportIDValue == null) {
            return null;
        }
        return "<object xmlns=\"http://developer.cognos.com/schemas/CAM/AAA/1/\" id=\"" + passportIDValue + "\" class=\"passport\"></object>";
    }

    public void setCurrentUserPath(String path) {
        this.getContext().getCurrentUserSession().currentUserPath_ = path;
    }

    public void Authenticated() {
        if (this.getContext().getCurrentUserSession() != null) {
            this.getContext().getCurrentUserSession().Authenticated();
        }
    }

    public String getCurrentUser() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().getCurrentUser();
        }
        return null;
    }

    public void setTrustedCredential(String trCr) {
        this.getContext().setTrustedCredential(trCr);
    }

    public String getTrustedCredential() {
        return this.getContext().getTrustedCredential();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAccountInfo getCurrentUserAccountInfo() throws CMException {
        UserAccountInfo userAccountInfo = new UserAccountInfo();
        String sCamID = this.getCurrentUser();
        if (sCamID == null) {
            return userAccountInfo;
        }
        userAccountInfo.setCAMID(sCamID);
        String sUserAccountPath = "/directory//*[@id='" + CMStoreXPath.attributeEncodeString(sCamID, '\'') + "']";
        CMStoreXPath userAccountPath = new CMStoreXPath(null, sUserAccountPath, false, 10);
        CMStoreQueryResults qresults = null;
        CMProperty[] props = new CMProperty[]{CMProperty.ID, CMProperty.ANCESTORS};
        qresults = this.getStore().executeQuery(userAccountPath, props, null, 0, 512, null);
        int accountObjectID = -1;
        try {
            if (qresults.next()) {
                accountObjectID = qresults.getObjectID();
                userAccountInfo.setAccountObjId(accountObjectID);
                this.setCurrentUserAccountObjectID(accountObjectID);
                CMDbStoreAncestors ancestors = (CMDbStoreAncestors)qresults.getValue(1);
                userAccountInfo.setDbAncestors(ancestors);
                qresults.reset();
                userAccountInfo.setQResults(qresults);
                qresults = null;
            }
        }
        finally {
            if (qresults != null) {
                qresults.release();
            }
        }
        return userAccountInfo;
    }

    public int getCurrentUserAccountObjectID() throws CMException {
        if (this.getContext().getCurrentUserSession() != null) {
            if (this.getContext().getCurrentUserSession().getCurrentUserAccountObjectID() == 0 && this.getContext().getCurrentUserSession().getCurrentUser() != null) {
                CMStore store = this.getStore();
                this.getContext().getCurrentUserSession().setCurrentUserAccountObjectID(store.getUserAccountObjID(this.getContext().getCurrentUserSession().getCurrentUser()));
            }
            return this.getContext().getCurrentUserSession().getCurrentUserAccountObjectID();
        }
        return 0;
    }

    public void setCurrentUserAccountObjectID(int obj_id) {
        if (this.getContext().getCurrentUserSession() != null) {
            this.getContext().getCurrentUserSession().setCurrentUserAccountObjectID(obj_id);
        }
    }

    public int getCurrentUserSessionObjectID() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().getCurrentSessionObjectID();
        }
        return 0;
    }

    public void setCurrentUserSessionObjectID(int obj_id) {
        if (this.getContext().getCurrentUserSession() != null) {
            sessionCache_.addSessionObjectID(obj_id);
            this.getContext().getCurrentUserSession().setCurrentSessionObjectID(obj_id);
        }
    }

    public List<String> getCurrentUserAncestors() throws AAAException, CMException {
        if (this.getContext().getCurrentUserSession() != null) {
            if (this.getContext().getCurrentUserSession().currentUserAncestors_ == null) {
                this.getContext().getCurrentUserSession().currentUserAncestors_ = AccMan.getAncestorsAndSelf(this.getContext().getCurrentUserSession().getCurrentUser(), false).getAncestorCamIDs();
            }
            return this.getContext().getCurrentUserSession().currentUserAncestors_;
        }
        return null;
    }

    public List<String> getCurrentUserAncestorNames() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().currentUserAncestorsNames_;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAccountDescendantAncestorValues(List<String> names, List<String> classes, List<String> searchPaths, List<String> searchPathsStoreIDs) {
        boolean bRet = false;
        bRet = this.getAccountAncestorValues(names, classes, searchPaths, searchPathsStoreIDs);
        if (!bRet || this.getCurrentUserDisplayName() == null || this.getCurrentUserSearchPath() == null) {
            return false;
        }
        names.add(this.getCurrentUserDisplayName());
        classes.add(CMObjectClass.ACCOUNT.getName());
        String searchPath = this.getCurrentUserSearchPath();
        searchPaths.add(searchPath);
        CMStoreQueryResults results = null;
        try {
            CMStoreXPath objectContext = (CMStoreXPath)CMStoreXPath.parse(searchPath);
            results = this.getStore().executeQuery(objectContext, null, null, 0, 512, null);
            int objectID = -1;
            if (results.next()) {
                objectID = results.getObjectID();
                String storeID = this.getStore().getObjectStoreID(objectID);
                searchPathsStoreIDs.add(storeID);
            } else {
                searchPathsStoreIDs.add(new String(""));
            }
            CMQueryUtils.safeQueryResultsRelease(results);
        }
        catch (CMException ex) {
            searchPathsStoreIDs.add(new String(""));
        }
        finally {
            CMQueryUtils.safeQueryResultsRelease(results);
        }
        return true;
    }

    public boolean getAccountAncestorValues(List<String> names, List<String> classes, List<String> searchPaths, List<String> searchPathsStoreIDs) {
        if (this.getContext() == null || this.getContext().getCurrentUserSession() == null) {
            return false;
        }
        String locale = this.getCurrentUserContentLocale().getLocaleID();
        if (this.getContext().getCurrentUserSession().currentUserAncestorsLocale_ == null || !this.getContext().getCurrentUserSession().currentUserAncestorsLocale_.equals(locale)) {
            return false;
        }
        if (this.getContext().getCurrentUserSession().currentUserAncestorsNames_ == null || this.getContext().getCurrentUserSession().currentUserAncestorsClasses_ == null || this.getContext().getCurrentUserSession().currentUserAncestorsPaths_ == null) {
            return false;
        }
        names.addAll(this.getContext().getCurrentUserSession().currentUserAncestorsNames_);
        classes.addAll(this.getContext().getCurrentUserSession().currentUserAncestorsClasses_);
        searchPaths.addAll(this.getContext().getCurrentUserSession().currentUserAncestorsPaths_);
        searchPathsStoreIDs.addAll(this.getContext().getCurrentUserSession().currentUserAncestorsStoreIDs_);
        return true;
    }

    public String getCurrentUserSearchPath() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().currentUserSearchPath_;
        }
        return null;
    }

    public void initializeASession(AccManAuthResponse authRsp, boolean bCreateProxy) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        UserSessionCacheEntry session = ctx.getContext().getCurrentUserSession();
        UserSessionCacheEntry cachedSession = sessionCache_.lookupPassport(authRsp.getPassportID());
        if (session != null && session == cachedSession) {
            session.processUserInfo(authRsp, bCreateProxy);
            session.setIsMultipleNamespaceSession(true);
            return;
        }
        session = new UserSessionCacheEntry(authRsp, bCreateProxy);
        cachedSession = sessionCache_.addEntry(session);
        if (session != cachedSession) {
            int currentUser = session.getCurrentUserAccountObjectID();
            int cachedUser = cachedSession.getCurrentUserAccountObjectID();
            if (currentUser > 0 && cachedUser > 0 && currentUser != cachedUser) {
                String msg = "'" + currentUser + "' != '" + cachedUser + "'";
                CMException cmex = new CMException("cmInvalidPassport");
                CMIndications.logException(cmex, msg);
                throw cmex;
            }
            ctx.getContext().setCurrentUserSession(cachedSession);
        }
    }

    public static ArrayList<CMObjectReference> mergeMembers(ArrayList<CMObjectReference> oldMembers, ArrayList<CMObjectReference> newMembers) {
        if (oldMembers == null) {
            return newMembers;
        }
        ArrayList<CMObjectReference> returnList = oldMembers;
        for (int i = 0; i < newMembers.size(); ++i) {
            CMObjectReference newMember = newMembers.get(i);
            boolean found = false;
            String searchPath = newMember.getSearchPath();
            for (int j = 0; j < oldMembers.size() && !found; ++j) {
                CMObjectReference oldMember = oldMembers.get(j);
                if (!searchPath.equals(oldMember.getSearchPath())) continue;
                found = true;
            }
            if (found) continue;
            returnList.add(newMember);
        }
        return returnList;
    }

    public String getCurrentUserDisplayName() {
        if (this.getContext().getCurrentUserSession() != null) {
            if (this.getContext().getCurrentUserSession().currentUserDisplayName_ != null) {
                return this.getContext().getCurrentUserSession().currentUserDisplayName_;
            }
            if (this.getContext().getCurrentUserSession().currentUserDisplayName_ == null) {
                return "";
            }
            return this.getContext().getCurrentUserSession().currentUserDisplayName_;
        }
        return null;
    }

    public String getCurrentUserPath() {
        if (this.getContext().getCurrentUserSession() != null) {
            if (this.getContext().getCurrentUserSession().currentUserPath_ == null) {
                return "";
            }
            return this.getContext().getCurrentUserSession().currentUserPath_;
        }
        return "";
    }

    public String getCurrentUserInternalPath() {
        if (this.getContext().getCurrentUserSession() != null && this.getContext().getCurrentUserSession().currentUserInternalPath_ != null) {
            return this.getContext().getCurrentUserSession().currentUserInternalPath_;
        }
        return this.getCurrentUserPath();
    }

    public ArrayList<CMObjectReference> getCurrentUserIdentity() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().currentUserIdentity_;
        }
        return null;
    }

    public boolean isUserAuthenticatedIntoNamespace(String camid) {
        UserSessionCacheEntry session = this.getContext().getCurrentUserSession();
        if (session == null || session.isAnonymousUser()) {
            return false;
        }
        if (camid.equals(":")) {
            return true;
        }
        for (String nsid : session.getAuthenticatedNamespaces()) {
            if (!camid.equals(nsid)) continue;
            return true;
        }
        return false;
    }

    public SessionProfileSettings getCurrentUserProfileSettings() {
        UserSessionCacheEntry session = this.getContext().getCurrentUserSession();
        if (session != null) {
            return session.profileSettings;
        }
        return null;
    }

    public CMObjectReference getSessionProfileRole() {
        UserSessionCacheEntry session = this.getContext().getCurrentUserSession();
        if (session != null && session.profileSettings != null) {
            return session.profileSettings.getProfileRole();
        }
        return null;
    }

    public boolean getCurrentUserIdentityIncludesObject(int obj_id) {
        ArrayList<CMObjectReference> identities = this.getCurrentUserIdentity();
        if (identities != null) {
            for (int iIdent = 0; iIdent < identities.size(); ++iIdent) {
                CMDbStoreObjectReference userRef = (CMDbStoreObjectReference)identities.get(iIdent);
                if (userRef.getObjectID() != obj_id) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCapability(String capability) {
        ExtendedUserCapabilities caps = this.getUserCapabilities();
        return caps != null ? caps.hasCapability(capability) : false;
    }

    public boolean currentUserCanSeeHiddenObjects() {
        boolean showHidden;
        String value = this.getPreference(CMPreference.SHOWHIDDENOBJECTS);
        if (value == null) {
            value = CMPreference.SHOWHIDDENOBJECTS.getDefaultValue();
        }
        if (!(showHidden = CMXMLUtils.isBooleanAttrTrue(value))) {
            return false;
        }
        return this.hasCapability("canUseShowHiddenObjectsPreference");
    }

    public HashMap<String, HashSet<String>> getCurrentUserRoutingHints() throws CMException {
        UserSessionCacheEntry currentUserSession = this.getContext().getCurrentUserSession();
        if (currentUserSession != null) {
            if (currentUserSession.currentUserRoutingHints_ == null) {
                currentUserSession.currentUserRoutingHints_ = this.calculateCurrentUserRoutingHints();
            }
            return currentUserSession.currentUserRoutingHints_;
        }
        return null;
    }

    private void updateUserRoutingHints(CMStoreQueryResults results, HashMap<String, HashSet<String>> routingHints) throws CMException {
        if (results != null) {
            while (results.next()) {
                Object value = results.getValue(0);
                if (value == null) continue;
                CMStringArray hints = (CMStringArray)value;
                String className = results.getObjectClass().getName();
                HashSet<String> hintSet = routingHints.get(className);
                if (hintSet == null) {
                    hintSet = new HashSet();
                    routingHints.put(className, hintSet);
                }
                for (int i = 0; i < hints.getSize(); ++i) {
                    hintSet.add(hints.getString(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, HashSet<String>> calculateCurrentUserRoutingHints() throws CMException {
        ArrayList<CMObjectReference> identity;
        HashMap<String, HashSet<String>> routingHints = new HashMap<String, HashSet<String>>();
        UserSessionCacheEntry sessionEntry = this.getContext().getCurrentUserSession();
        if (sessionEntry != null && (identity = sessionEntry.currentUserIdentity_) != null) {
            Iterator<CMObjectReference> proxyIterator = identity.iterator();
            ArrayList<Integer> objIDList = new ArrayList<Integer>();
            HashSet<String> searchPathSet = new HashSet<String>();
            for (int j = 0; j < identity.size(); ++j) {
                CMObjectReference proxy = proxyIterator.next();
                if (proxy.getObjectID() != -1) {
                    objIDList.add(proxy.getObjectID());
                    continue;
                }
                if (proxy.getObjectClass() == CMObjectClass.ACCOUNT) continue;
                String searchPath = proxy.getSearchPath();
                searchPathSet.add(searchPath);
            }
            CMStore store = CMExecutionContext.get().getStore();
            CMProperty[] props = new CMProperty[]{CMProperty.ROUTINGHINTS};
            if (objIDList.size() > 0) {
                CMStoreQueryResults results = null;
                int[] objIDs = new int[objIDList.size()];
                for (int i = 0; i < objIDList.size(); ++i) {
                    objIDs[i] = (Integer)objIDList.get(i);
                }
                try {
                    results = store.executeQuery(objIDs, props, null, 0, 512, null);
                    this.updateUserRoutingHints(results, routingHints);
                }
                finally {
                    if (results != null) {
                        results.release();
                    }
                }
            }
            for (String searchPath : searchPathSet) {
                CMStoreXPath objectContext = (CMStoreXPath)CMStoreXPath.parse(searchPath);
                CMStoreQueryResults results = null;
                try {
                    results = store.executeQuery(objectContext, props, null, 0, 33280, null);
                    this.updateUserRoutingHints(results, routingHints);
                }
                finally {
                    if (results == null) continue;
                    results.release();
                }
            }
        }
        return routingHints;
    }

    public void setPreference(CMPreference pref, String value) {
        if (pref == CMPreference.CONTENTLOCALE) {
            this.getContext().setUserContentLocales(null);
            this.getContext().setContentLocale(null);
            if (value == null) {
                value = pref.getDefaultValue();
            }
        } else if (pref == CMPreference.PRODUCTLOCALE) {
            this.getContext().setProductLocale(null);
            if (value == null) {
                value = pref.getDefaultValue();
            }
        }
        this.getContext().getRequestPreferences().set(pref, value);
    }

    public String getPreference(CMPreference pref) {
        String prefValue = this.getContext().getRequestPreferences().get(pref);
        if (prefValue == null) {
            prefValue = this.checkAndSetDefaultPreference(pref);
        }
        return prefValue;
    }

    private String checkAndSetDefaultPreference(CMPreference pref) {
        String prefName = pref.getName();
        String prefValue = null;
        if (prefName.equals(CMPreference.CONTENTLOCALE.getName())) {
            prefValue = CMPreference.CONTENTLOCALE.getDefaultValue();
        } else if (prefName.equals(CMPreference.PRODUCTLOCALE.getName())) {
            prefValue = CMPreference.PRODUCTLOCALE.getDefaultValue();
        }
        if (prefValue != null) {
            this.getContext().getRequestPreferences().set(pref, prefValue);
        }
        return prefValue;
    }

    public CMLocalePreference getRequestLocale(String localeProperty) {
        CMLocalePreference pref = null;
        if (localeProperty == "contentLocale") {
            if (this.getContext().getContentLocale() == null) {
                this.getContext().setContentLocale(new CMLocalePreference(this.getPreference(CMPreference.CONTENTLOCALE)));
            }
            pref = this.getContext().getContentLocale();
        } else {
            if (this.getContext().getProductLocale() == null) {
                this.getContext().setProductLocale(new CMLocalePreference(this.getPreference(CMPreference.PRODUCTLOCALE)));
            }
            pref = this.getContext().getProductLocale();
        }
        return pref;
    }

    public CMStringLocale getCurrentUserContentLocale() {
        CMStringLocale[] locales = this.getCurrentUserMappedLocales();
        if (locales == null) {
            return null;
        }
        return locales[0];
    }

    public CMStringLocale[] getCurrentUserMappedLocales() {
        if (this.getContext().getUserContentLocales() != null) {
            return this.getContext().getUserContentLocales();
        }
        String contentLocaleStr = this.getPreference(CMPreference.CONTENTLOCALE);
        CMStringLocale contentLocale = CMDbStoreStringLocales.findLocale(contentLocaleStr);
        if (contentLocale == null) {
            throw new IllegalStateException("Unknown locale: " + contentLocaleStr);
        }
        int numEntries = 1;
        CMStringLocale mappedContentLocale = contentLocale.getMappedLocale();
        if (mappedContentLocale != null) {
            ++numEntries;
        }
        this.getContext().setUserContentLocales(new CMStringLocale[numEntries]);
        this.getContext().getUserContentLocales()[0] = contentLocale;
        if (numEntries == 2) {
            this.getContext().getUserContentLocales()[1] = mappedContentLocale;
        }
        return this.getContext().getUserContentLocales();
    }

    public void setTrustedValue(String sValue) {
        this.getContext().setTrustedValue(sValue);
    }

    public byte[] getCommonSymmetricKey() {
        if (this.getContext().getTrustedValue() == null) {
            return null;
        }
        byte[] encryptedCSK = this.getContext().getTrustedValue().getBytes();
        try {
            if (CMServlet.CAMFactory_ == null) {
                CMIndications.logException(new CMException("cmErrorTrustedId"));
            } else {
                CSKRequestHandler cskrh = CMServlet.CAMFactory_.createCSKRequestHandler();
                encryptedCSK = cskrh.handleCSKRequest(encryptedCSK);
            }
        }
        catch (CAMCryptoException camCex) {
            CMIndications.logException(new CMException((Exception)((Object)camCex), "cmbadTrustedId"));
        }
        catch (Exception ex) {
            CMIndications.logException(new CMException(ex, "cmbadTrustedId"));
        }
        return encryptedCSK;
    }

    public byte[] getCACertificates() throws CMException {
        if (this.getContext().getTrustedValue() == null) {
            return null;
        }
        byte[] encryptedCA = this.getContext().getTrustedValue().getBytes();
        try {
            if (CMServlet.CAMFactory_ == null) {
                CMIndications.logException(new CMException("cmErrorTrustedId"));
            } else {
                CARequestHandler carh = CMServlet.CAMFactory_.createCARequestHandler();
                encryptedCA = carh.handleCARequest(encryptedCA);
            }
        }
        catch (CAMCryptoException camCAex) {
            CMIndications.logException(new CMException((Exception)((Object)camCAex), "cmbadTrustedId"));
        }
        catch (Exception ex) {
            CMIndications.logException(new CMException(ex, "cmbadTrustedId"));
        }
        return encryptedCA;
    }

    public trustedService getTrustedService() {
        return this.getContext().getTrustedService();
    }

    public String getServiceId() {
        return this.getContext().getTrustedServiceId();
    }

    public void setServiceId(String sValue) {
        this.getContext().setTrustedService(TrustedServices.getServiceInfo(sValue));
        this.getContext().setTrustedServiceId(sValue);
    }

    public String getSessionContext() {
        String passportId;
        String sessionContext = this.getContext().getSessionContext();
        if (sessionContext == null && (passportId = this.getAccManPassportID()) != null) {
            sessionContext = sessionCache_.lookupSessionContextByPassport(passportId);
        }
        if (sessionContext == null) {
            sessionContext = "";
        }
        return sessionContext;
    }

    public void setSessionContext(String sValue) {
        this.getContext().setSessionContext(sValue);
    }

    public String getRequestContext() {
        if (this.getContext().getRequestContext() == null) {
            return "";
        }
        return this.getContext().getRequestContext();
    }

    public void setRequestContext(String sValue) {
        this.getContext().setRequestContext(sValue);
    }

    public int getHopCount() {
        return this.getContext().getHopCount();
    }

    public void setHopCount(int iValue) {
        this.getContext().setHopCount(iValue);
    }

    public void setHopCount(String sValue) {
        if (sValue == null) {
            this.getContext().setHopCount(0);
        } else {
            try {
                this.getContext().setHopCount(Integer.parseInt(sValue));
            }
            catch (NumberFormatException ex) {
                this.getContext().setHopCount(0);
            }
        }
    }

    public String getStepContext() {
        if (this.getContext().getStepContext() == null) {
            return "";
        }
        return this.getContext().getStepContext();
    }

    public void setStepContext(String sValue) {
        this.getContext().setStepContext(sValue);
    }

    public XMLElement getConversationContext() {
        return this.getContext().getConversationContext();
    }

    public void setConversationContext(XMLElement conversationContext) {
        this.getContext().setConversationContext(conversationContext);
    }

    public String getBIBUSheader() {
        if (this.getContext().getBIBUSheader() == null) {
            if (this.getContext().getRequestManager() == null) {
                this.getContext().setBIBUSheader(CMExecutionContext.getDefaultBIBUSheader("en", "en", "", ""));
            } else {
                this.getContext().setBIBUSheader(this.getContext().getRequestManager().makeBiBusHeader(true));
            }
        }
        return this.getContext().getBIBUSheader();
    }

    public XMLElement getBiBusHeaderElement() {
        if (this.getContext().getRequestManager() != null) {
            return this.getContext().getRequestManager().getSOAPHeader();
        }
        return null;
    }

    public void setBIBUSheader(String header) {
        this.getContext().setBIBUSheader(header);
        this.getContext().setRequestManager(null);
    }

    public void setBIBUSheader(RequestManager reqMan) {
        this.getContext().setBIBUSheader(null);
        this.getContext().setRequestManager(reqMan);
    }

    public String getSOAPRequest() {
        if (this.getContext().getRequestManager() != null) {
            return this.getContext().getRequestManager().getFullSOAPRequest();
        }
        return null;
    }

    public Header getHeader() {
        if (this.getContext().getRequestManager() != null) {
            return this.getContext().getRequestManager().getHeader();
        }
        return null;
    }

    public String getCAMAdditionalInfo() {
        if (this.getContext().getCAMAdditionalInfo() == null) {
            if (this.getContext().isInAdditionalInfoNow()) {
                if (this.getContext().getCAMAdditionalInfoOld() == null) {
                    return CMExecutionContext.getDefaultCAMAdditionalInfo();
                }
                return this.getContext().getCAMAdditionalInfoOld();
            }
            if (this.getContext().getRequestManager() == null) {
                this.getContext().setCAMAdditionalInfo(CMExecutionContext.getDefaultCAMAdditionalInfo());
            } else {
                this.getContext().setInAdditionalInfoNow(true);
                this.getContext().setCAMAdditionalInfo(this.getContext().getRequestManager().makeCAMAdditionalInfo());
                this.getContext().setInAdditionalInfoNow(false);
            }
        }
        return this.getContext().getCAMAdditionalInfo();
    }

    public void setCAMAdditionalInfo(RequestManager reqMan) {
        this.getContext().setCAMAdditionalInfoOld(this.getContext().getCAMAdditionalInfo());
        this.getContext().setCAMAdditionalInfo(null);
        this.getContext().setRequestManager(reqMan);
    }

    public static boolean hasContext() {
        return data.get() != null;
    }

    public String getCurrentUserDirectoryName() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().currentUserDirectoryName_;
        }
        return null;
    }

    public void setCurrentUserDirectoryName(String name) {
        if (this.getContext().getCurrentUserSession() != null) {
            this.getContext().getCurrentUserSession().currentUserDirectoryName_ = name;
        }
    }

    public static void setAuditing(boolean b) {
        auditSetUpAndTearDown = b;
    }

    public UserPreferences getCurrentUserSessionVars() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().userPreferences_;
        }
        return null;
    }

    public ExtendedUserCapabilities getUserCapabilities() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().getUserCapabilities();
        }
        return null;
    }

    public Date getCurrentUserSessionCreateTime() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().creationTime_;
        }
        return CMDateUtils.getTime();
    }

    public boolean getCurrentUserIsAdministrator() {
        return this.getContext().getCurrentUserSession() != null && this.getContext().getCurrentUserSession().isSystemAdministrator();
    }

    public boolean isTenantAdministrator() {
        return this.getContext().getCurrentUserSession() != null && this.getContext().getCurrentUserSession().isTenantAdministrator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCurrentUserIsSharedAnonymous() throws CMException {
        if (this.getContext().getCurrentUserSession() == null) {
            throw new IllegalStateException("No current user session");
        }
        if (this.getContext().getCurrentUserSession().isAnonymousUser() && !this.getContext().getCurrentUserSession().isSystemAdministrator()) {
            String anonAccountPath = "/directory//*[@id='::Anonymous']";
            CMStoreQueryResults results = null;
            try {
                results = this.getStore().executeQuery(new CMStoreXPath(anonAccountPath), null, null, 0, 2, null);
                results.next();
            }
            catch (CMPermissionException e) {
                boolean bl = true;
                return bl;
            }
            finally {
                if (results != null) {
                    results.release();
                }
            }
        }
        return false;
    }

    public boolean getCurrentUserIsMultipleNamespaceSession() {
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().getIsMultipleNamespaceSession();
        }
        return false;
    }

    public boolean getCurrentUserIsFullyTrusted() {
        if (this.getContext().getTrustedService() != null) {
            return this.getContext().getTrustedService().getFullyTrusted();
        }
        return false;
    }

    public boolean requireAccessCheck() {
        return !this.getCurrentUserIsAdministrator() && !this.getCurrentUserIsFullyTrusted();
    }

    public static String getDefaultBIBUSheader(String productLocale, String contentLocale, String sessionContext, String requestContext) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\t<bus:biBusHeader xmlns=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n");
        strBuf.append("\t\t<userPreferenceVars xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:userPreferenceVar[2]\">\r\n");
        strBuf.append("\t\t\t<item>\r\n");
        strBuf.append("\t\t\t\t<name xsi:type=\"xsd:string\" xml:space=\"preserve\">productLocale</name>\r\n");
        strBuf.append("\t\t\t\t<value xsi:type=\"xsd:string\" xml:space=\"preserve\">" + productLocale + "</value>\r\n");
        strBuf.append("\t\t\t</item>\r\n");
        strBuf.append("\t\t<item>\r\n");
        strBuf.append("\t\t\t<name xsi:type=\"xsd:string\" xml:space=\"preserve\">contentLocale</name>\r\n");
        strBuf.append("\t\t\t<value xsi:type=\"xsd:string\" xml:space=\"preserve\">" + contentLocale + "</value>\r\n");
        strBuf.append("\t\t</item>\r\n");
        strBuf.append("\t</userPreferenceVars>\r\n");
        strBuf.append("\t<tracking xsi:type=\"bus:tracking\">\r\n");
        strBuf.append("\t\t<sessionContext xsi:type=\"xsd:string\">" + sessionContext + "</sessionContext>\r\n");
        strBuf.append("\t\t<requestContext xsi:type=\"xsd:string\">" + requestContext + "</requestContext>\r\n");
        strBuf.append("\t\t<hopCount xsi:type=\"xsd:integer\">1</hopCount>\r\n");
        strBuf.append("\t\t<providers xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:provider[1]\">\r\n");
        strBuf.append("\t\t\t<provider xsi:type=\"bus:provider\">\r\n");
        strBuf.append("\t\t\t\t<name xsi:type=\"xsd:string\">cm</name>\r\n");
        strBuf.append("\t\t\t\t<patch xsi:type=\"xsd:int\">1</patch>\r\n");
        strBuf.append("\t\t\t\t<build xsi:type=\"xsd:string\">" + cmInfo.getVersion() + "</build>\r\n");
        strBuf.append("\t\t\t</provider>\r\n");
        strBuf.append("\t\t</providers>\r\n");
        strBuf.append("\t</tracking>\r\n");
        strBuf.append("\t<CAM xsi:type=\"bus:CAM\"/>\r\n");
        strBuf.append("</bus:biBusHeader>\r\n");
        return strBuf.toString();
    }

    private static String getDefaultCAMAdditionalInfo() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<additionalInfo>");
        strBuf.append("<productLocale>");
        strBuf.append(ConfigurationFactory.getConfig().getServerLocale().toString());
        strBuf.append("</productLocale>");
        strBuf.append("<contentLocale>");
        strBuf.append(ConfigurationFactory.getConfig().getServerLocale().toString());
        strBuf.append("</contentLocale>");
        strBuf.append("</additionalInfo>");
        return strBuf.toString();
    }

    public void setExecutingStaticRequest(boolean bStatic) {
        this.getContext().setStaticRequest(bStatic);
    }

    public boolean executingStaticRequest() {
        return this.getContext().isStaticRequest();
    }

    public void setIPFCategory(String str) {
        if (str == null) {
            return;
        }
        this.getContext().setSIPFCategory(str);
    }

    public String getIPFCategory() {
        return this.getContext().getSIPFCategory();
    }

    public void setIPFOperation(String str) {
        if (str == null) {
            return;
        }
        this.getContext().setSIPFOperation(str);
    }

    public String getIPFOperation() {
        return this.getContext().getSIPFOperation();
    }

    public void setIPFObjectType(String str) {
        if (str == null) {
            return;
        }
        this.getContext().setSIPFObjectType(str);
    }

    public String getIPFObjectType() {
        return this.getContext().getSIPFObjectType();
    }

    public void setIPFObjectPath(String str) {
        if (str == null) {
            return;
        }
        this.getContext().setSIPFObjectPath(str);
    }

    public String getIPFObjectPath() {
        return this.getContext().getSIPFObjectPath();
    }

    public void setIPFOriginalObjectPath(String str) {
        if (str == null) {
            return;
        }
        this.getContext().setSIPFOriginalObjectPath(str);
    }

    public String getIPFOriginalObjectPath() {
        return this.getContext().getSIPFOriginalObjectPath();
    }

    public void setAuditIndicationSentForLevel(int nLevel, boolean bSent) {
        if (nLevel == 50000) {
            this.getContext().bAuditIndicationSentFor_LEVEL1_ = bSent;
        } else if (nLevel == 40000) {
            this.getContext().bAuditIndicationSentFor_LEVEL2_ = bSent;
        } else if (nLevel == 30000) {
            this.getContext().bAuditIndicationSentFor_LEVEL3_ = bSent;
        } else if (nLevel == 20000) {
            this.getContext().bAuditIndicationSentFor_LEVEL4_ = bSent;
        } else if (nLevel == 10000) {
            this.getContext().bAuditIndicationSentFor_LEVEL5_ = bSent;
        } else {
            throw new IllegalStateException("Invalid indications level in context");
        }
    }

    public boolean getAuditIndicationSentForLevel(int nLevel) {
        boolean bRet = false;
        if (nLevel == 50000) {
            bRet = this.getContext().bAuditIndicationSentFor_LEVEL1_;
        } else if (nLevel == 40000) {
            bRet = this.getContext().bAuditIndicationSentFor_LEVEL2_;
        } else if (nLevel == 30000) {
            bRet = this.getContext().bAuditIndicationSentFor_LEVEL3_;
        } else if (nLevel == 20000) {
            bRet = this.getContext().bAuditIndicationSentFor_LEVEL4_;
        } else if (nLevel == 10000) {
            bRet = this.getContext().bAuditIndicationSentFor_LEVEL5_;
        } else {
            throw new IllegalStateException("Invalid indications level in context");
        }
        return bRet;
    }

    public void addLevel3Parm(CMException.Parm p) {
        this.getContext().getVLevel3Parms().add(p);
    }

    public ArrayList<CMException.Parm> getLevel3Parms() {
        ArrayList<CMException.Parm> vRet = null;
        vRet = this.getContext().getVLevel3Parms();
        return vRet;
    }

    public void resetLevel3Parms() {
        this.getContext().setVLevel3Parms(new ArrayList<CMException.Parm>());
    }

    public void addLevel3Message(String s) {
        this.getContext().getVLevel3Msgs().add(s);
    }

    public ArrayList<String> getLevel3Messages() {
        ArrayList<String> vRet = null;
        vRet = this.getContext().getVLevel3Msgs();
        return vRet;
    }

    public void resetLevel3Messages() {
        this.getContext().setVLevel3Msgs(new ArrayList<String>());
    }

    public void setIPFTimestamp(long ts) {
        this.getContext().setNIPFTimestamp(ts);
    }

    public long getIPFTimestamp() {
        long nRet = 0L;
        nRet = this.getContext().getNIPFTimestamp();
        return nRet;
    }

    public void resetIPFTimestamp() {
        this.getContext().setNIPFTimestamp(0L);
    }

    public void setIPFPerfCounterData(Object obj) {
        this.getContext().setVIPFPerfCounterData(obj);
    }

    public Object getIPFPerfCounterData() {
        Object ret = null;
        ret = this.getContext().getVIPFPerfCounterData();
        return ret;
    }

    public void setAuthenticateCreateSession() {
        this.getContext().setCreateSessionAfterAuthenticate(true);
    }

    public boolean getAuthenticateCreateSession() {
        return this.getContext().isCreateSessionAfterAuthenticate();
    }

    public void incrementRequestedWriteLockCount() {
        this.getContext().setNRequestedWriteLockCount(this.getContext().getNRequestedWriteLockCount() + 1L);
    }

    public long getRequestedWriteLockCount() {
        return this.getContext().getNRequestedWriteLockCount();
    }

    public void incrementWaitedForWriteLockCount() {
        this.getContext().setNWaitedForWriteLockCount(this.getContext().getNWaitedForWriteLockCount() + 1L);
    }

    public long getWaitedForWriteLockCount() {
        return this.getContext().getNWaitedForWriteLockCount();
    }

    public void incrementRequestedReadLockCount() {
        this.getContext().setNRequestedReadLockCount(this.getContext().getNRequestedReadLockCount() + 1L);
    }

    public long getRequestedReadLockCount() {
        return this.getContext().getNRequestedReadLockCount();
    }

    public void incrementWaitedForReadLockCount() {
        this.getContext().setNWaitedForReadLockCount(this.getContext().getNWaitedForReadLockCount() + 1L);
    }

    public long getWaitedForReadLockCount() {
        return this.getContext().getNWaitedForReadLockCount();
    }

    public long getExecutionTime() {
        if (this.getContext().getNStartTime() == 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - this.getContext().getNStartTime();
    }

    public CMBreadcrumbs getBreadcrumbs() {
        if (this.getContext().getBreadcrumbs() == null) {
            this.getContext().setBreadcrumbs(new CMBreadcrumbs());
        }
        return this.getContext().getBreadcrumbs();
    }

    public boolean isThreadInfoLogged() {
        return this.getContext().isBThreadInfoLogged();
    }

    public void setThreadInfoLogged(boolean logged) {
        this.getContext().setBThreadInfoLogged(logged);
    }

    public static CMExecutionContext get() {
        CMExecutionContext ctx = data.get();
        if (ctx == null) {
            throw new IllegalStateException("setUp() must be called before calling get()");
        }
        return ctx;
    }

    public static void set(CMExecutionContext cmec) {
        data.set(cmec);
    }

    public static void setUp() {
        if (CMExecutionContext.contextDataExists() && auditSetUpAndTearDown) {
            CMIndications.logException(new IllegalStateException("setUp() was called but thread-local context data already exists for thread '" + Thread.currentThread().getName() + "'"));
        }
        data.set(new CMExecutionContext());
    }

    private static boolean contextDataExists() {
        return data.get() != null;
    }

    public static void tearDown() {
        if (CMExecutionContext.contextDataExists()) {
            CMExecutionContext.get().release();
        }
        data.set(null);
    }

    public static void endUserSession(String passportID) {
        sessionCache_.removePassport(passportID);
    }

    public static int userSessionCacheSize() {
        return sessionCache_.size();
    }

    public static boolean sessionCacheContainsAccount(int id) {
        return sessionCache_.containsAccount(id);
    }

    public static boolean sessionCacheContainsSession(int id) {
        return sessionCache_.containsSession(id);
    }

    public static boolean sessionCacheContainsPassport(String passportID) {
        return sessionCache_.containsPassport(passportID);
    }

    public void release() {
        this.getContext().release();
        if (auditSetUpAndTearDown) {
            data.set(null);
        }
    }

    public AuditContext getAuditContext() {
        return this.getContext().getAuditContext();
    }

    public String getName() {
        return this.getContext().getThreadName();
    }

    public long getId() {
        return this.getContext().getNContextId();
    }

    public static UserSessionCache getSessionCache() {
        return sessionCache_;
    }

    public static void setSessionCache(UserSessionCache cache) {
        sessionCache_ = cache;
    }

    public CMPropertySet getPropertySet() {
        return CMPropertySet.CM;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<Object, CMExecutionContext> entry : executionContextsMap.entrySet()) {
            CMExecutionContext context = entry.getValue();
            sb.append("<thread name=\"");
            sb.append(XMLUtils.escape((String)context.getName()));
            sb.append("\" request=\"");
            sb.append(XMLUtils.escape((String)context.getIPFOperation()));
            sb.append("\" executionTime=\"");
            sb.append(context.getExecutionTime());
            sb.append("\" ipfPath=\"");
            sb.append(XMLUtils.escape((String)context.getIPFObjectPath()));
            sb.append("\" user=\"");
            sb.append(XMLUtils.escape((String)context.getCurrentUser()));
            String accManPassportID = context.getAccManPassportID();
            if (accManPassportID != null) {
                String session = new HashUtil().hash(accManPassportID);
                sb.append("\" session=\"");
                sb.append(XMLUtils.escape((String)session));
            }
            sb.append("\"/>");
            context.setThreadInfoLogged(true);
        }
        return sb.toString();
    }

    public CMExecutionContextData getContext() {
        return this.context_;
    }

    public boolean isCurrentUserIdentityIncludePath(String sCAMIDSeachPath) {
        ArrayList<CMObjectReference> identities = this.getCurrentUserIdentity();
        if (identities != null) {
            for (int iIdent = 0; iIdent < identities.size(); ++iIdent) {
                CMDbStoreObjectReference userRef = (CMDbStoreObjectReference)identities.get(iIdent);
                if (!userRef.getSearchPath().equals(sCAMIDSeachPath)) continue;
                return true;
            }
        }
        return false;
    }

    public int getCurrentUserTenantId() {
        if (this.tenantId_ != -9999) {
            return this.tenantId_;
        }
        if (this.getContext().getCurrentUserSession() != null) {
            return this.getContext().getCurrentUserSession().getTenantId();
        }
        return 0;
    }

    public void setStaticTenantId(int tenantId) {
        this.tenantId_ = tenantId;
    }

    public int getStaticTenantId() {
        return this.tenantId_;
    }

    public void setReadTenantFilter(ReadTenantFilter filter) {
        this.readTenantFilter = filter;
    }

    public ReadTenantFilter getReadTenantFilter() {
        return this.readTenantFilter;
    }

    public int[] getReadTenantIds() {
        return this.readTenantFilter.getReadTenantIds();
    }

    public boolean hasReadTenantFilter() {
        return this.readTenantFilter.getReadTenantIds() != null;
    }

    private boolean canReadTenant(int tenantId) {
        int[] teantIDs;
        for (int filterTenantId : teantIDs = this.readTenantFilter.getReadTenantIds()) {
            if (filterTenantId != tenantId) continue;
            return true;
        }
        return false;
    }

    public boolean canSeeObjectsWithTenantId(int tenantId) {
        if (!this.isMultitenancyEnabled()) {
            return true;
        }
        boolean result = tenantId == 0 ? true : (this.hasUnfilteredAdminAccess() ? true : (this.hasReadTenantFilter() ? this.canReadTenant(tenantId) : this.getCurrentUserTenantId() == tenantId));
        return result;
    }

    public boolean shouldDoTenantFiltering(boolean isMTDeploymentQuery) {
        int[] ids = this.getReadTenantIds();
        boolean isTenantListFiltering = ids != null && ids.length > 0 && (this.getContext().getCurrentUserSession() == null || this.getCurrentUserIsAdministrator() || this.isTenantAdministrator());
        boolean isMTDeploymentFiltering = false;
        if (isMTDeploymentQuery) {
            DeploymentExecutionContext deploymentContext = DeploymentExecutionContext.get();
            isMTDeploymentFiltering = deploymentContext.isMultiTenantDeployment() && deploymentContext.getTenantIDIntList() != null;
        }
        boolean isSessionFiltering = !this.hasUnfilteredAdminAccess() && this.isMultitenancyEnabled();
        return isTenantListFiltering || isMTDeploymentFiltering || isSessionFiltering;
    }

    public boolean isMultitenancyEnabled() {
        return CMDbStoreFactory.tenantRegistry.getTenantCount() > 1;
    }

    public boolean isTrustedServiceWithUnfilteredTenantAccess() {
        trustedService service = this.getTrustedService();
        return service != null && service.hasUnfilteredTenantAccess();
    }

    public boolean hasUnfilteredAdminAccess() {
        if (this.isTrustedServiceWithUnfilteredTenantAccess()) {
            return true;
        }
        return (this.getCurrentUserIsAdministrator() || this.isTenantAdministrator() || this.getContext().getCurrentUserSession() == null) && !this.hasReadTenantFilter();
    }

    public boolean hasFilteredAdminAccess() {
        return (this.getCurrentUserIsAdministrator() || this.getContext().getCurrentUserSession() == null) && this.hasReadTenantFilter();
    }

    public boolean isAbleToEditTenantId() {
        return this.getCurrentUserIsAdministrator() || this.getContext().getCurrentUserSession() == null;
    }

    public boolean repairInvalidContainment() {
        return this.repairInvalidContainment;
    }

    public boolean setRepairInvalidContainment(boolean flag) {
        boolean previousState = this.repairInvalidContainment;
        this.repairInvalidContainment = flag;
        return previousState;
    }

    public void setApplyTenantIdVirtualInheritance(boolean applyIt) {
        this.applyTenantIdVirtualInheritance = applyIt;
    }

    public boolean applyTenantIdVirtualInheritance() {
        return this.applyTenantIdVirtualInheritance;
    }
}

