/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMMaintenancePluginTask;
import com.cognos.cm.server.CMMaintenanceTaskData;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CMMaintenancePluginManager {
    private static final String ELEM_MAINTENANCE_TASK = "maintenanceTask";
    private ArrayList<MaintenancePlugin> plugins_;
    private static final String ELEM_MAINTENANCE_PLUGIN_DETAIL = "maintenancePluginDetail";

    public void initialize() {
        this.plugins_ = null;
        try {
            this.loadMaintenancePlugins();
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
        }
    }

    public void invoke() {
        if (this.plugins_ != null) {
            for (int i = 0; i < this.plugins_.size(); ++i) {
                MaintenancePlugin p = this.plugins_.get(i);
                p.invoke();
            }
        }
    }

    private void loadMaintenancePlugins() throws CMException {
        String[] maintenanceFiles = this.getMaintenanceFiles();
        if (!this.maintenanceFilesExist(maintenanceFiles)) {
            return;
        }
        this.loadMaintenancePlugins(maintenanceFiles);
    }

    protected void loadMaintenancePlugins(String[] maintenanceFiles) throws CMException {
        for (int i = 0; i < maintenanceFiles.length; ++i) {
            String maintenanceFile = maintenanceFiles[i];
            if (!maintenanceFile.endsWith(".xml")) continue;
            this.loadMaintenancePlugin(maintenanceFile);
        }
    }

    protected void loadMaintenancePlugin(String maintenanceFile) throws CMException {
        InputStream fileStream = this.getDescriptorStream(maintenanceFile);
        Document descDoc = this.getDescriptorDoc(maintenanceFile, fileStream);
        this.checkDescriptorDocument(maintenanceFile, descDoc);
        Element rootNode = descDoc.getDocumentElement();
        this.checkRootNode(maintenanceFile, rootNode);
        MaintenancePlugin plugin = new MaintenancePlugin();
        NodeList taskNodes = this.getMaintenanceTasksNodeList(rootNode, maintenanceFile);
        ArrayList<CMMaintenancePluginTask> tasks = this.createPluginTasks(taskNodes);
        if (tasks != null && tasks.size() > 0) {
            plugin.addTasks(tasks);
            this.loadPlugin(plugin);
        }
    }

    private void loadPlugin(MaintenancePlugin plugin) {
        if (this.plugins_ == null) {
            this.plugins_ = new ArrayList();
        }
        this.plugins_.add(plugin);
    }

    private NodeList getMaintenanceTasksNodeList(Element el, String fileName) throws CMException {
        NodeList maintenanceTasks = el.getElementsByTagName(ELEM_MAINTENANCE_TASK);
        if (maintenanceTasks == null) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", fileName));
        }
        return maintenanceTasks;
    }

    private ArrayList<CMMaintenancePluginTask> createPluginTasks(NodeList taskList) throws CMException {
        ArrayList<CMMaintenancePluginTask> tasks = null;
        for (int i = 0; i < taskList.getLength(); ++i) {
            List<String> searchPaths;
            String javaclass;
            String name;
            Element taskElement = (Element)taskList.item(i);
            if (taskElement == null || this.missingProperty(name = CMXMLUtils.getCharacterContent(CMXMLUtils.getElementByTagName(taskElement, "name"))) || this.missingProperty(javaclass = CMXMLUtils.getCharacterContent(CMXMLUtils.getElementByTagName(taskElement, "javaclass"))) || this.missingProperty(searchPaths = CMXMLUtils.getCharacterContentListByTagName(CMXMLUtils.getElementByTagName(taskElement, "searchPaths"), "searchPath"))) continue;
            CMMaintenancePluginTask task = this.createMaintenanceTask(name, javaclass, searchPaths);
            if (tasks == null) {
                tasks = new ArrayList<CMMaintenancePluginTask>();
            }
            tasks.add(task);
        }
        return tasks;
    }

    private boolean missingProperty(List<String> searchPaths) {
        return searchPaths == null || searchPaths.isEmpty();
    }

    private boolean missingProperty(String propName) {
        return propName == null || propName.length() <= 0;
    }

    private CMMaintenancePluginTask createMaintenanceTask(String name, String javaclass, List<String> searchPaths) throws CMException {
        Class<?> cls = this.getMaintenanceTaskClass(javaclass);
        CMMaintenancePluginTask task = this.newMaintenanceTask(javaclass, cls);
        this.initializeTask(name, searchPaths, task);
        return task;
    }

    private CMMaintenancePluginTask newMaintenanceTask(String javaclass, Class<?> cls) throws CMException {
        CMMaintenancePluginTask task;
        try {
            task = (CMMaintenancePluginTask)cls.newInstance();
        }
        catch (InstantiationException ex) {
            CMException cmEx = new CMException((Exception)ex, "cmErrLoadingPlugin", new CMException.Parm("Class", javaclass));
            throw cmEx;
        }
        catch (IllegalAccessException ex) {
            CMException cmEx = new CMException((Exception)ex, "cmErrLoadingPlugin", new CMException.Parm("Class", javaclass));
            throw cmEx;
        }
        return task;
    }

    private void initializeTask(String name, List<String> searchPaths, CMMaintenancePluginTask task) {
        CMMaintenanceTaskData data = new CMMaintenanceTaskData();
        data.setName(name);
        data.setSearchPaths(searchPaths);
        task.initialize(data);
    }

    protected Class<?> getMaintenanceTaskClass(String javaclass) throws CMException {
        Class<?> cls = null;
        try {
            cls = Class.forName(javaclass);
        }
        catch (ClassNotFoundException ex) {
            CMException cmEx = new CMException((Exception)ex, "cmErrLoadingPlugin", new CMException.Parm("Class", javaclass));
            throw cmEx;
        }
        if (cls == null) {
            throw new CMException("cmErrLoadingPlugin", new CMException.Parm("Class", javaclass));
        }
        return cls;
    }

    private void checkRootNode(String descriptor, Element rootNode) throws CMException {
        if (rootNode == null || rootNode.getNodeType() != 1 || !rootNode.getNodeName().equals(ELEM_MAINTENANCE_PLUGIN_DETAIL)) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", descriptor));
        }
    }

    private void checkDescriptorDocument(String descriptor, Document descDoc) throws CMException {
        if (descDoc == null) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", descriptor));
        }
    }

    private Document getDescriptorDoc(String descriptor, InputStream descStream) throws CMException {
        Document descDoc = null;
        try {
            descDoc = CMXMLUtils.parse(new InputSource(descStream));
        }
        catch (Exception ex) {
            this.packageException(descriptor, ex);
        }
        return descDoc;
    }

    private void packageException(String fileName, Exception ex) throws CMException {
        throw new CMException(ex, "cmBadConfigFile", new CMException.Parm("File", fileName));
    }

    protected InputStream getDescriptorStream(String descriptor) {
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        return resourceLoader.getResourceInputStream("/WEB-INF/cm/maintenance/" + descriptor);
    }

    private boolean maintenanceFilesExist(String[] maintenanceFiles) {
        return maintenanceFiles != null && maintenanceFiles.length != 0;
    }

    protected String[] getMaintenanceFiles() {
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        return resourceLoader.listResourceNames("/WEB-INF/cm/maintenance/");
    }

    protected ArrayList<MaintenancePlugin> getPlugins() {
        return this.plugins_;
    }

    protected class MaintenancePlugin {
        private ArrayList<CMMaintenancePluginTask> tasks_;

        protected MaintenancePlugin() {
        }

        public void addTasks(List<CMMaintenancePluginTask> tasks) {
            if (this.tasks_ == null) {
                this.tasks_ = new ArrayList();
            }
            if (tasks != null) {
                this.tasks_.addAll(tasks);
            }
        }

        public void invoke() {
            if (this.tasks_ != null) {
                for (int i = 0; i < this.tasks_.size(); ++i) {
                    CMMaintenancePluginTask task = this.tasks_.get(i);
                    try {
                        task.invoke();
                        continue;
                    }
                    catch (CMException e) {
                        CMIndications.logException(new CMException((Exception)e, "cmErrInitPlugin", new CMException.Parm("Class", task.getClass())));
                    }
                }
            }
        }

        protected CMMaintenancePluginTask getTask(int i) {
            return this.tasks_.get(i);
        }
    }
}

