/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.plugin.Interface.CMPlugin;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cm.util.DOMUtils;
import com.cognos.cm.util.DOMWriter;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CMPluginManager {
    private Map<String, CMPlugin> plugins_;
    protected List<CMPluginDescriptor> pluginDescriptors_;
    private boolean hasPlugins_;
    private static CMPluginManager instance_;

    private CMPluginManager() {
        this.reset();
    }

    public static CMPluginManager getInstance() {
        if (instance_ == null) {
            instance_ = new CMPluginManager();
        }
        return instance_;
    }

    protected void reset() {
        this.plugins_ = null;
        this.pluginDescriptors_ = null;
        this.hasPlugins_ = false;
    }

    public void initialize(ICCLConfiguration icclConfig) throws CMException {
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        this.initialize(icclConfig, resourceLoader);
    }

    public void initialize(ICCLConfiguration icclConfig, CMResourceLoader resourceLoader) {
        this.loadConfigFiles(resourceLoader);
        this.loadPlugins(icclConfig);
    }

    private void loadConfigFiles(CMResourceLoader resourceLoader) {
        String[] configFiles = resourceLoader.listResourceNames("/WEB-INF/cm/plugins/config/");
        if (configFiles == null) {
            this.reset();
            return;
        }
        for (int i = 0; i < configFiles.length; ++i) {
            String desc = configFiles[i];
            if (!desc.endsWith(".xml")) continue;
            try {
                String file = "/WEB-INF/cm/plugins/config/" + desc;
                InputStream is = resourceLoader.getResourceInputStream(file);
                this.loadPluginDescriptors(is, file);
                continue;
            }
            catch (Throwable ex) {
                CMIndications.Audit_Message_FreeFormText("cmErrParsingPluginDesc", new CMException.Parm[]{new CMException.Parm("Message", ex.getMessage()), new CMException.Parm("File", desc)}, 50000, "StartService", "ContentManagerService", "", "Warning", null);
            }
        }
    }

    protected void loadPlugins(ICCLConfiguration icclConfig) {
        if (this.pluginDescriptors_ == null) {
            this.reset();
            return;
        }
        for (int i = this.pluginDescriptors_.size() - 1; i >= 0; --i) {
            CMPlugin plugin;
            String javaClass;
            String pluginID;
            CMPluginDescriptor pluginDesc;
            block12: {
                pluginDesc = this.pluginDescriptors_.get(i);
                pluginID = pluginDesc.getPluginID();
                javaClass = pluginDesc.getJavaClass();
                CMIndications.Audit_Message_FreeFormText("cmLoadingPlugin", new CMException.Parm[]{new CMException.Parm("Plugin", pluginID)}, 20000, "StartService", "ContentManagerService", "", "Info", null);
                Class<?> cls = null;
                try {
                    cls = Class.forName(javaClass);
                }
                catch (ClassNotFoundException ex) {
                    this.errorLoadingPluginAtIndex(i, javaClass, ex);
                    continue;
                }
                try {
                    String pluginType = pluginDesc.getPluginType();
                    if (pluginType.equalsIgnoreCase("Upgrade")) {
                        plugin = (CMPlugin)cls.newInstance();
                        break block12;
                    }
                    CMException ex1 = new CMException("cmErrUnknownPluginType", new CMException.Parm("Type", pluginType));
                    this.errorLoadingPluginAtIndex(i, javaClass, ex1);
                }
                catch (IllegalAccessException e) {
                    this.errorLoadingPluginAtIndex(i, javaClass, e);
                }
                catch (InstantiationException e) {
                    this.errorLoadingPluginAtIndex(i, javaClass, e);
                }
                continue;
            }
            try {
                plugin.initialize(pluginDesc, icclConfig);
            }
            catch (Throwable ex) {
                this.pluginDescriptors_.remove(i);
                CMException cmEx = new CMException(ex, "cmErrInitPlugin", new CMException.Parm("Class", javaClass));
                CMIndications.logException(cmEx);
                continue;
            }
            if (this.plugins_ == null) {
                this.plugins_ = new HashMap<String, CMPlugin>();
            }
            this.plugins_.put(pluginID, plugin);
        }
        if (this.plugins_ != null) {
            this.hasPlugins_ = true;
        }
    }

    private void errorLoadingPluginAtIndex(int index, String javaClass, Exception ex) {
        this.pluginDescriptors_.remove(index);
        CMException cmEx = ex != null ? new CMException(ex, "cmErrLoadingPlugin", new CMException.Parm("Class", javaClass)) : new CMException("cmErrLoadingPlugin", new CMException.Parm("Class", javaClass));
        CMIndications.logException(cmEx);
    }

    public boolean hasPlugins() {
        return this.hasPlugins_;
    }

    protected void loadPluginDescriptors(InputStream descStream, String desc) throws CMException, UnsupportedEncodingException {
        if (descStream == null) {
            throw new CMException("cmNoConfigFile", new CMException.Parm("File", desc));
        }
        Element rootNode = null;
        try {
            Document descDoc = CMXMLUtils.parse(new InputSource(descStream));
            rootNode = descDoc.getDocumentElement();
        }
        catch (Exception ex) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", desc));
        }
        if (!rootNode.getLocalName().equals("plugins")) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", desc));
        }
        Iterator<Node> it = DOMUtils.elementIterator(rootNode, "plugin");
        while (it.hasNext()) {
            Element pluginEl = (Element)it.next();
            try {
                CMPluginDescriptor pluginDesc = this.loadDescriptor(pluginEl);
                if (pluginDesc == null) continue;
                if (this.pluginDescriptors_ == null) {
                    this.pluginDescriptors_ = new ArrayList<CMPluginDescriptor>();
                }
                this.pluginDescriptors_.add(pluginDesc);
            }
            catch (IllegalStateException e) {
                CMIndications.Audit_Message_FreeFormText("cmErrParsingPluginDesc", new CMException.Parm[]{new CMException.Parm("Message", e.getMessage()), new CMException.Parm("File", desc)}, 50000, "StartService", "ContentManagerService", "", "Warning", null);
            }
        }
    }

    protected CMPluginDescriptor loadDescriptor(Element pluginEl) throws UnsupportedEncodingException {
        Element searchPathsElement;
        String searchPathsUseNameIdsStr;
        String type = this.getMandatoryAttribute(pluginEl, "type");
        boolean isMandatory = this.getMandatoryAttribute(pluginEl, "category").equalsIgnoreCase("Mandatory");
        String componentID = this.getMandatoryAttribute(pluginEl, "componentID");
        String name = this.getMandatoryElementText(pluginEl, "name");
        String version = this.getMandatoryElementText(pluginEl, "version");
        String javaclass = this.getMandatoryElementText(pluginEl, "javaclass");
        List<String> searchPaths = this.getMandatoryList(pluginEl, "searchPaths", "searchPath");
        List<String> properties = this.getMandatoryList(pluginEl, "properties", "property");
        List<String> classNames = this.getMandatoryList(pluginEl, "classNamesForDeployment", "className");
        boolean isPostImport = false;
        String importAction = pluginEl.getAttribute("importAction");
        if (importAction.length() > 0) {
            isPostImport = importAction.equalsIgnoreCase("PostImport");
        }
        String forDeploymentStr = pluginEl.getAttribute("forDeployment");
        boolean forDeployment = true;
        if (forDeploymentStr.length() > 0) {
            forDeployment = new Boolean(forDeploymentStr);
        }
        boolean searchPathsUseNameIds = false;
        NodeList searchPathsNodes = pluginEl.getElementsByTagName("searchPaths");
        if (searchPathsNodes.getLength() > 0 && (searchPathsUseNameIdsStr = (searchPathsElement = (Element)searchPathsNodes.item(0)).getAttribute("usesNameIds")).length() > 0) {
            searchPathsUseNameIds = new Boolean(searchPathsUseNameIdsStr);
        }
        boolean forContentTask = false;
        String forContentTaskStr = pluginEl.getAttribute("forContentTask");
        if (forContentTaskStr.length() > 0) {
            forContentTask = new Boolean(forContentTaskStr);
        }
        String cLibName = CMXMLUtils.getCharacterContent(DOMUtils.element(pluginEl, "cLibName"));
        List<String> editions = CMXMLUtils.getCharacterContentListByTagName(DOMUtils.element(pluginEl, "editions"), "edition");
        Map<String, String> parameters = this.getParameters(pluginEl);
        return new CMPluginDescriptor(type, isMandatory, isPostImport, forContentTask, componentID, name, version, javaclass, cLibName, searchPaths, properties, classNames, editions, parameters, forDeployment, searchPathsUseNameIds);
    }

    private List<String> getMandatoryList(Element parentElement, String elementName, String subElementName) {
        List<String> result = CMXMLUtils.getCharacterContentListByTagName(DOMUtils.element(parentElement, elementName), subElementName);
        if (result == null) {
            this.throwMissingElement(elementName + "/" + subElementName);
        }
        return result;
    }

    private String getMandatoryAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value.isEmpty()) {
            this.throwMissingAttribute(attributeName);
        }
        return value;
    }

    private String getMandatoryElementText(Element parentElement, String elementName) {
        String value = CMXMLUtils.getCharacterContent(DOMUtils.element(parentElement, elementName));
        if (value == null || value.length() == 0) {
            this.throwMissingElement(elementName);
        }
        return value;
    }

    private void throwMissingElement(String elemName) {
        throw new IllegalStateException("Missing mandatory element '" + elemName + "'");
    }

    private void throwMissingAttribute(String attribute) {
        throw new IllegalStateException("Missing mandatory attribute '" + attribute + "'");
    }

    private Map<String, String> getParameters(Element element) throws UnsupportedEncodingException {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator<Node> it = DOMUtils.elementIterator(element, "parameter");
        while (it.hasNext()) {
            Element item = (Element)it.next();
            String name = item.getAttribute("name");
            String value = this.getTextValue(item);
            result.put(name, value);
        }
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        return result;
    }

    private String getTextValue(Node value) throws UnsupportedEncodingException {
        Iterator<Node> i = DOMUtils.elementIterator(value);
        if (i.hasNext()) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            DOMWriter writer = new DOMWriter(true, data);
            writer.print(value);
            return data.toString("UTF-8");
        }
        return value.getTextContent();
    }

    public List<CMPluginDescriptor> getPluginDescriptors() {
        return this.pluginDescriptors_;
    }

    public Map<String, CMPlugin> getPlugins() {
        return this.plugins_;
    }

    public CMPlugin getPlugin(String pluginID) {
        if (pluginID == null) {
            return null;
        }
        CMPlugin plugin = null;
        if (this.plugins_.containsKey(pluginID)) {
            plugin = this.plugins_.get(pluginID);
        }
        return plugin;
    }

    public List<String> getOptionalUpgradeClasses() {
        ArrayList upgradeClasses = null;
        if (!this.hasPlugins()) {
            return null;
        }
        List<CMPluginDescriptor> descs = this.getPluginDescriptors();
        ListIterator<CMPluginDescriptor> descIt = descs.listIterator();
        while (descIt.hasNext()) {
            CMPluginDescriptor desc = (CMPluginDescriptor)descIt.next();
            if (desc.isMandatory() || !desc.getPluginType().equalsIgnoreCase("Upgrade")) continue;
            if (upgradeClasses == null) {
                upgradeClasses = new ArrayList();
            }
            upgradeClasses.addAll(desc.getClassNamesForDeployment());
        }
        return upgradeClasses;
    }
}

