/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class CMPreference {
    public static HashMap<String, CMPreference> allPreferences = new HashMap();
    private static List<CMPreference> prefsList = new ArrayList<CMPreference>();
    public static final CMPreference PRODUCTLOCALE = new ProductLocalePreference("productLocale", null, "PRODUCTLOCALE");
    public static final CMPreference CONTENTLOCALE = new ContentLocalePreference("contentLocale", null, "CONTENTLOCALE");
    public static final CMPreference TIMEZONEID = new TimeZonePreference("timeZoneID", null, "TIMEZONEID");
    public static final CMPreference FORMAT = new CMPreference("format", "HTML", "FORMAT");
    public static final CMPreference SKIN = new CMPreference("skin", "corporate", "OPTIONS");
    public static final CMPreference LISTVIEWSEPARATOR = new CMPreference("listViewSeparator", "none", "OPTIONS");
    public static final CMPreference AUTOMATICPAGEREFRESH = new CMPreference("automaticPageRefresh", "30", "OPTIONS");
    public static final CMPreference SHOWOPTIONSUMMARY = new CMPreference("showOptionSummary", "true", "OPTIONS");
    public static final CMPreference LINESPERPAGE = new CMPreference("linesPerPage", "15", "OPTIONS");
    public static final CMPreference DISPLAYMODE = new CMPreference("displayMode", "list", "OPTIONS");
    public static final CMPreference SHOWHINTS = new CMPreference("showHints", "showAll", "OPTIONS");
    public static final CMPreference COLUMNSPERPAGE = new CMPreference("columnsPerPage", "3", "OPTIONS");
    public static final CMPreference SHOWWELCOMEPAGE = new CMPreference("showWelcomePage", "true", "OPTIONS");
    public static final CMPreference SHOWHIDDENOBJECTS = new CMPreference("showHiddenObjects", "false", "OPTIONS");
    public static final CMPreference ACCESSIBILITYFEATURE = new CMPreference("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures", "false", "OPTIONS");
    public static CMPreference BIDIRECTIONALFEATURESENABLED = new CMPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled", "false", "OPTIONS");
    public static CMPreference BASETEXTDIRECTION = new CMPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection", "http://developer.cognos.com/ceba/constants/baseTextDirectionEnum#Auto", "OPTIONS"){

        @Override
        public boolean isIncludedInCookie() {
            boolean result = false;
            CMExecutionContext cmec = CMExecutionContext.get();
            if (null != cmec) {
                result = Boolean.valueOf(cmec.getPreference(BIDIRECTIONALFEATURESENABLED));
            }
            return result;
        }
    };
    public static CMPreference BACKGROUNDSESSIONLOGGING = new CMPreference("backgroundSessionLogging", "1970-01-01 00:00:00", "OPTIONS");
    public static final CMPreference IS_TOOLBAR_DOCKED = new CMPreference("isToolbarDocked", "true", "OPTIONS");
    private String name;
    private String defaultValue;
    private String propName;
    private CMProperty prop;
    private boolean optional;

    public static CMPreference find(String name) {
        return allPreferences.get(name);
    }

    private CMPreference(String name, String defaultValue, String propName) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.propName = propName;
        allPreferences.put(name, this);
        prefsList.add(this);
    }

    private CMPreference(String name, String defaultValue, String propName, boolean optionalPref) {
        this(name, defaultValue, propName);
        this.optional = optionalPref;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public static List<CMPreference> getAllPreferences() {
        return prefsList;
    }

    public CMProperty getMappedProperty() {
        if (this.propName != null && this.prop == null) {
            try {
                Field field = CMProperty.class.getDeclaredField(this.propName);
                this.prop = (CMProperty)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.prop;
    }

    public String mapValue(String value) {
        return value;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isIncludedInCookie() {
        return true;
    }

    private static class ProductLocalePreference
    extends LocalePreference {
        ProductLocalePreference(String name, String defaultValue, String propName) {
            super(name, defaultValue, propName);
        }

        @Override
        public String mapValue(String value) {
            if (value != null) {
                try {
                    IConfiguration config = ConfigurationFactory.getConfig();
                    value = config.normalizeLocale(value);
                    if (!config.validateProductLocale(value)) {
                        value = config.mapProductLocale(value, false);
                    }
                }
                catch (CMConfigurationException cMConfigurationException) {
                    // empty catch block
                }
            }
            return value;
        }
    }

    private static class ContentLocalePreference
    extends LocalePreference {
        ContentLocalePreference(String name, String defaultValue, String propName) {
            super(name, defaultValue, propName);
        }

        @Override
        public String mapValue(String value) {
            if (value != null) {
                try {
                    IConfiguration config = ConfigurationFactory.getConfig();
                    value = config.normalizeLocale(value);
                    if (!config.validateContentLocale(value)) {
                        value = config.mapContentLocale(value, false);
                    }
                }
                catch (CMConfigurationException cMConfigurationException) {
                    // empty catch block
                }
            }
            return value;
        }
    }

    private static class LocalePreference
    extends CMPreference {
        LocalePreference(String name, String defaultValue, String propName) {
            super(name, defaultValue, propName);
        }

        @Override
        public String getDefaultValue() {
            return ConfigurationFactory.getConfig().getServerLocale().toString();
        }
    }

    private static class TimeZonePreference
    extends CMPreference {
        TimeZonePreference(String name, String defaultValue, String propName) {
            super(name, defaultValue, propName);
        }

        @Override
        public String getDefaultValue() {
            String timeZone = ConfigurationFactory.getConfig().getCognosProp("serverTimeZoneID");
            if (timeZone == null) {
                timeZone = Calendar.getInstance().getTimeZone().getID();
            }
            return timeZone;
        }
    }
}

