/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.CAM.AAAException;
import com.cognos.CAM.AAA_Interface;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TmpCipherStreamSession;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.api.CAMConnector;
import com.cognos.cm.cam.AAACounterProxy;
import com.cognos.cm.cam.AAANotificationProxy;
import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.cam.AAAProvider_CAM;
import com.cognos.cm.cmInfo;
import com.cognos.cm.connectors.CMConnector.CMConnector;
import com.cognos.cm.connectors.CMConnector.CMResponseTimeoutException;
import com.cognos.cm.connectors.MDSRVConnector.MDSRVConnector;
import com.cognos.cm.connectors.MSConnector.MSConnector;
import com.cognos.cm.connectors.SDSConnector.SDSConnector;
import com.cognos.cm.connectors.rest.search.IndexConnector;
import com.cognos.cm.connectors.rest.synchromesh.SynchromeshConnector;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreMultipleCMsUtil;
import com.cognos.cm.dbstore.CMUserCapabilityPoliciesHandler;
import com.cognos.cm.externalRepository.ExternalObjectStoreConnectionProvider;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.maintenanceTasks.CMMaintenanceTaskCleanDeletedObjects;
import com.cognos.cm.maintenanceTasks.CMMaintenanceTaskDeleteOldSessions;
import com.cognos.cm.maintenanceTasks.CMMaintenanceTaskUpdateDeploymentStatus;
import com.cognos.cm.maintenanceTasks.CMMaintenanceThread;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.notification.SubscriptionManager;
import com.cognos.cm.notification.SubscriptionParser;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginManager;
import com.cognos.cm.server.ASyncRequestManager;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.BackgroundTaskAndQueueExecutor;
import com.cognos.cm.server.BridgeImpl;
import com.cognos.cm.server.C8Edition;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMDataUpgradeManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMLocalePreference;
import com.cognos.cm.server.CMMaintenancePluginManager;
import com.cognos.cm.server.CMPluginManager;
import com.cognos.cm.server.CMStatusWriter;
import com.cognos.cm.server.ComponentDependentCapabilities;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.DatabaseConfigInfo;
import com.cognos.cm.server.ExtendedUserCapabilities;
import com.cognos.cm.server.IBackgroundTaskAndQueueExecutor;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.LicenseManager;
import com.cognos.cm.server.MultipleCMsSyncThread;
import com.cognos.cm.server.NamespaceManager;
import com.cognos.cm.server.RequestHandlerFactory;
import com.cognos.cm.server.RequestManager;
import com.cognos.cm.server.Servlet;
import com.cognos.cm.server.UpdateInitialContentNames;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.profileSettings.ProfilesManager;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreContentException;
import com.cognos.cm.store.CMStoreException;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.trustedServices.TrustedServices;
import com.cognos.cm.util.CMDeferredInitActionUtils;
import com.cognos.cm.util.CMEnvironment;
import com.cognos.cm.util.CMFileUtils;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cm.util.ConnectionPool;
import com.cognos.cm.util.factory.CMFactory;
import com.cognos.cm.util.factory.CMFactoryContextClassLoaderLocator;
import com.cognos.cm.util.factory.CMFactoryLocator;
import com.cognos.cm.util.factory.CMFactorySystemPropLocator;
import com.cognos.cm.util.service.CMStatusParameter;
import com.cognos.cm.util.service.CMStatusParameterName;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import com.cognos.cmutils.tempcache.CMTempFileFactory;
import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.jmx.MBeanRegister;
import com.cognos.pogo.capacity.ServiceCapacity;
import com.cognos.pogo.capacity.ServiceCapacityConfiguration;
import com.cognos.pogo.capacity.ServiceCapacityMediator;
import com.cognos.pogo.pdk.Configuration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMServlet
extends HttpServlet
implements Servlet {
    private static final String CREATEBASEOBJECTSSCRIPT = "CMCreateBaseObjectsScript.xml";
    private static final String CREATESCRIPT = "CMCreateScript.xml";
    public static final String SEARCH_SUBSCRIPTION = "searchIndexing";
    private static final long serialVersionUID = 744565588049253565L;
    private static RequestHandlerFactory handlers;
    static IConfiguration config_;
    public static File rootDir_;
    public static File logsDir_;
    private static File temporaryFileDir_;
    public static NamespaceManager namespaceManager;
    @CMStatusParameter(name=CMStatusParameterName.RUNNING_MODE)
    public static int CMRunningMode_;
    @CMStatusParameter(name=CMStatusParameterName.IS_COMING_UP)
    public static boolean CMisComingUp_;
    @CMStatusParameter(name=CMStatusParameterName.IS_SUSPENDED)
    public static boolean CMisSuspended_;
    public static boolean RequestsAreAccepted_;
    @CMStatusParameter(name=CMStatusParameterName.IS_SHUTTINGDOWN)
    public static boolean CMisShuttingDown_;
    @CMStatusParameter(name=CMStatusParameterName.HAS_SHUTDOWN)
    public static boolean CMhasShutdown_;
    public static boolean ipfclientconfigExists_;
    public static boolean CMInitCalled_;
    public static int maxRequestIdleTime_;
    public static int maxUnexpectedErrorCount_;
    public static int maxDebugPingCount_;
    private static List<Throwable> initializationThrowablesList;
    public static AAAProvider AAA;
    public static CAMFactory CAMFactory_;
    public static TrustedRequestSession CAMtrustedRequestSession_;
    public static boolean isStandalone_;
    static int ResponseBufferSize_;
    static Locale DefaultLocale_;
    static Locale WebPageLocale_;
    public static String TimeStartedString_;
    public static MultipleCMsSyncThread syncThread_;
    private static boolean needsToStartSDSConnector;
    private static boolean needsToStartIndexConnector;
    private static boolean needsToStartSynchromeshConnector;
    public static HashMap<Integer, Thread> sleepingThreads_;
    private static int error_;
    private static Object errorSyncObject_;
    public static CMMaintenanceThread maintenanceThread_;
    private static final String CONFIGURATION_PEAK_FLAG = "inPeakDemandPeriod";
    private static final String CONFIGURATION_CMSPEAKCONNECTIONS = "cmsPeakConnections";
    private static final String CONFIGURATION_CMSCONNECTIONS = "cmsConnections";
    private static final String CONFIGURATION_EDITION = "edition";
    private static C8Edition edition;
    protected PrintStream debugOut = System.out;
    private static final String sEOL = "\r\n";
    private static final String sNotOperationalResp_Seg1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<SOAP-ENV:Envelope\t\txmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n\t\t\txmlns:faults=\"http://www.w3.org/2001/09/soap-faults\"\r\n\t\t\txmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n\t<SOAP-ENV:Header>\r\n\t\t<faults:Misunderstood qname=\"bus:CM\">\r\n\t\t\t<errorDetailDocument xmlns=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n\t\t\t\t<errorCode>cmStartFailed</errorCode>\r\n\t\t\t\t<errorMessage>";
    private static final byte[] baNotOperationalResp_Seg1;
    private static final String sNotOperationalResp_Seg2 = "</errorMessage>\r\n\t\t\t</errorDetailDocument>\r\n\t\t</faults:Misunderstood>\r\n\t</SOAP-ENV:Header>\r\n\t<SOAP-ENV:Body>\r\n\t\t<SOAP-ENV:Fault>\r\n\t\t\t<faultcode>Server</faultcode>\r\n\t\t\t<faultstring>Content Manager did something wrong</faultstring>\r\n\t\t\t<detail>\r\n\t\t\t\t<bus:exception>\r\n\t\t\t\t\t<severity>error</severity>\r\n\t\t\t\t\t<errorCode>cmStartFailed</errorCode>\r\n\t\t\t\t\t<bus:message>\r\n\t\t\t\t\t\t<messageString>";
    private static final byte[] baNotOperationalResp_Seg2;
    private static final String sNotOperationalResp_Seg3 = "</messageString>\r\n\t\t\t\t\t</bus:message>\r\n\t\t\t\t</bus:exception>\r\n\t\t\t</detail>\r\n\t\t</SOAP-ENV:Fault>\r\n\t</SOAP-ENV:Body>\r\n</SOAP-ENV:Envelope>\r\n";
    private static final byte[] baNotOperationalResp_Seg3;
    private static final String sNotStartedResp_Seg1 = "<SOAP-ENV:Envelope\t\txmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n\t\t\txmlns:faults=\"http://www.w3.org/2001/09/soap-faults\"\r\n\t\t\txmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n\t<SOAP-ENV:Header>\r\n\t\t<faults:Misunderstood qname=\"bus:CM\">\r\n\t\t\t<errorDetailDocument xmlns=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n\t\t\t\t<errorCode>cmStartingRejectRequest</errorCode>\r\n\t\t\t\t<errorMessage>";
    private static final byte[] baNotStartedResp_Seg1;
    private static final String sNotStartedResp_Seg2 = "</errorMessage>\r\n\t\t\t</errorDetailDocument>\r\n\t\t</faults:Misunderstood>\r\n\t</SOAP-ENV:Header>\r\n\t<SOAP-ENV:Body>\r\n\t\t<SOAP-ENV:Fault>\r\n\t\t\t<faultcode>SOAP-ENV:MustUnderstand</faultcode>\r\n\t\t\t<faultstring>";
    private static final byte[] baNotStartedResp_Seg2;
    private static final String sNotStartedResp_Seg3 = "</faultstring>\r\n\t\t</SOAP-ENV:Fault>\r\n\t</SOAP-ENV:Body>\r\n</SOAP-ENV:Envelope>";
    private static final byte[] baNotStartedResp_Seg3;
    String accmanTerminateDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><terminateDocument xmlns=\"http://developer.cognos.com/schemas/CAM/AAA/1/\" application=\"Content Manager\" />";
    private final Responder notOperationalResponder = new Responder(){

        @Override
        public void writeResponse(PrintWriter prt, OutputStream os) throws IOException {
            os.write(baNotOperationalResp_Seg1);
            this.writeToPrinter(prt, CMError.getMessage("cmStartFailed", null, ConfigurationFactory.getConfig().getServerLocale().toLocale()));
            os.write(baNotOperationalResp_Seg2);
            this.writeToPrinter(prt, CMError.getMessage("cmStartFailed", null, ConfigurationFactory.getConfig().getServerLocale().toLocale()));
            os.write(baNotOperationalResp_Seg3);
            os.flush();
        }

        @Override
        public String getIOExceptionMessage() {
            return "Content Manager is shut down, and is not accepting requests.";
        }
    };
    private final Responder notStartedResponder = new Responder(){

        @Override
        public void writeResponse(PrintWriter prt, OutputStream os) throws IOException {
            os.write(baNotStartedResp_Seg1);
            this.writeToPrinter(prt, CMError.getMessage("cmStartingRejectRequest", null, ConfigurationFactory.getConfig().getServerLocale().toLocale()));
            os.write(baNotStartedResp_Seg2);
            this.writeToPrinter(prt, CMError.getMessage("cmStartingRejectRequest", null, ConfigurationFactory.getConfig().getServerLocale().toLocale()));
            os.write(baNotStartedResp_Seg3);
            os.flush();
        }

        @Override
        public String getIOExceptionMessage() {
            return "Content Manager failed to initialize, please check the log.";
        }
    };
    private static final String advancedSettingsXPath_ = "//item[@xsi:type='cm:contentManagerService']/advancedSettings/value";
    static CMLocalePreference serverLocale_;

    protected void setDebugOutput(PrintStream stream) {
        this.debugOut = stream;
    }

    public CMServlet(boolean isStandalone) {
        isStandalone_ = isStandalone;
        if (handlers == null) {
            handlers = new RequestHandlerFactory();
        }
        if (isStandalone_) {
            config_ = ConfigurationFactory.getConfig();
        } else {
            ICCLConfiguration cclConfig = ConfigurationFactory.getCCLConfig();
            config_ = ConfigurationFactory.getConfig(cclConfig);
        }
    }

    private static final byte[] s2ba(String s) {
        return CMStringUtils.getUTF8BytesFromString(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        CMisShuttingDown_ = true;
        RequestsAreAccepted_ = false;
        ContentManager.PERF_TIMER_IN_CM.start();
        CMIndications.g_sDefaultIPFCategory = "Audit";
        CMIndications.g_sDefaultIPFOperation = "StopService";
        try {
            CMExecutionContext.setUp();
            CMExecutionContext ctx = CMExecutionContext.get();
            ctx.setRequestContext("Termination_REQ");
            ctx.setSessionContext("Termination_SESS");
            ASyncRequestManager.getInstance().terminateAsynThreadPool();
            if (temporaryFileDir_ != null) {
                File[] oldFiles = temporaryFileDir_.listFiles();
                for (int i = 0; i < oldFiles.length; ++i) {
                    oldFiles[i].delete();
                }
            }
            try {
                AAA.Terminate(this.accmanTerminateDoc, null);
            }
            catch (AAAException ae) {
                CMIndications.logException(new CMException((Exception)((Object)ae), "cmErrAccManInit"));
            }
            CAMtrustedRequestSession_ = null;
            CAMFactory_.terminate();
            CAMFactory_ = null;
            ConnectionPool.getInstance().dispose();
            try {
                SDSConnector.terminate();
            }
            catch (IOException ae) {
                // empty catch block
            }
            MSConnector.terminate();
            MDSRVConnector.terminate();
            try {
                maintenanceThread_.terminate();
                CMExecutionContext.get().getStore().terminate();
                syncThread_.terminate();
            }
            catch (Throwable ae) {
                // empty catch block
            }
            this.stopBackgroundTasks();
            try {
                RepositoryPluginManager.getManager().terminate();
            }
            catch (Throwable ae) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            CMIndications.Audit_Message_FreeFormText("cmCMStopped", new CMException.Parm[]{new CMException.Parm("Build", cmInfo.getVersion())}, 50000, "StopService", "ContentManagerService", "", "Success", null);
            CMIndications.shutdown();
            CMExecutionContext.tearDown();
            ContentManager.PERF_TIMER_IN_CM.stop();
            CMhasShutdown_ = true;
            throw throwable;
        }
        CMIndications.Audit_Message_FreeFormText("cmCMStopped", new CMException.Parm[]{new CMException.Parm("Build", cmInfo.getVersion())}, 50000, "StopService", "ContentManagerService", "", "Success", null);
        CMIndications.shutdown();
        CMExecutionContext.tearDown();
        ContentManager.PERF_TIMER_IN_CM.stop();
        CMhasShutdown_ = true;
        try {
            Thread thisThread = Thread.currentThread();
            ThreadGroup baseThreadGroup = thisThread.getThreadGroup();
            while (baseThreadGroup.getParent() != null) {
                baseThreadGroup = baseThreadGroup.getParent();
            }
            int nThreads = baseThreadGroup.activeCount();
            Thread[] allThreads = new Thread[nThreads * 5];
            baseThreadGroup.enumerate(allThreads);
            if (allThreads.length != 0) {
                boolean bHeaderPrinted = false;
                for (int k = 0; k < allThreads.length; ++k) {
                    Thread th = allThreads[k];
                    String sThreadName = th.getName();
                    if (!sThreadName.startsWith("CRN.CM.")) continue;
                    if (!bHeaderPrinted) {
                        this.debugOut.println("CM shutdown with active threads:");
                        bHeaderPrinted = true;
                    }
                    this.debugOut.println("   " + th.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void configure(Configuration configuration) {
        ASyncRequestManager asyncReqMan;
        boolean inPeakDemandHour = Boolean.valueOf(configuration.getValue(CONFIGURATION_PEAK_FLAG));
        int connections = inPeakDemandHour ? Integer.parseInt(configuration.getValue(CONFIGURATION_CMSPEAKCONNECTIONS)) : Integer.parseInt(configuration.getValue(CONFIGURATION_CMSCONNECTIONS));
        if (connections != (asyncReqMan = ASyncRequestManager.getInstance()).getThreadPollMaxThreads()) {
            asyncReqMan.setThreadPoolMaxThreads(connections);
        }
        ServiceCapacityMediator.getInstance().notify((ServiceCapacity)new ServiceCapacityConfiguration("contentManagerService", null, connections));
    }

    @Override
    public void reconfigure(Configuration configuration) {
        CMIndications.CMTrace("cmReconfig");
        if (!CMInitCalled_) {
            return;
        }
        this.configure(configuration);
        try {
            ConfigurationFactory.getConfig().reconfigure();
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
        }
        try {
            Element el;
            if (AAA != null && (el = configuration.getCmResponse()) != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLWriter domWriter = new XMLWriter((OutputStream)os);
                domWriter.write(el);
                String sRuntimeConfig = os.toString();
                CMExecutionContext currContext = CMExecutionContext.get();
                String additionalInfo = null;
                if (currContext != null) {
                    additionalInfo = currContext.getCAMAdditionalInfo();
                }
                AAA.Reconfigure(sRuntimeConfig, additionalInfo);
            }
            if (!ipfclientconfigExists_) {
                CMIndications.reconfigure();
            }
            this.reconfigureSubscriptions();
            this.reconfigureAdvancedSettings(configuration);
        }
        catch (AAAException exAAA) {
            CMException cmex = new CMException((Exception)((Object)exAAA), "cmReconfigCAMFailed");
            CMIndications.logException(cmex);
        }
        catch (IOException ioe) {
            CMException cmex = new CMException(ioe, "cmReconfigCAMFailed");
            CMIndications.logException(cmex);
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
    }

    protected boolean initializeSubscriptionManager(int storeDisposition) {
        SubscriptionManager manager = SubscriptionManager.getInstance();
        try {
            manager.initialize(CMResourceUtils.getResourceLoader(), CMExecutionContext.get().getStore());
            if (storeDisposition != 1) {
                Subscription searchSubscription = manager.getSubscription(SEARCH_SUBSCRIPTION);
                searchSubscription.enable(true);
            }
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
            return false;
        }
        return true;
    }

    protected void reconfigureSubscriptions() throws CMStoreNotAvailable, CMStoreUnexpected, CMException {
        this.reconfigureEOSSubscription();
        this.reconfigureUpdatePoliciesSubscription();
    }

    protected void reconfigureEOSSubscription() throws CMStoreNotAvailable, CMStoreUnexpected, CMException {
        SubscriptionManager manager = SubscriptionManager.getInstance();
        if (config_.isExternalObjectStoreEnabled()) {
            SubscriptionParser parser = new SubscriptionParser(CMResourceUtils.getResourceLoader(), CMExecutionContext.get().getStore());
            String fileName = "/WEB-INF/cm/subscriptions/externalObjectStore.xml";
            Subscription subscription = parser.parseOneSubscriptionFromDescriptorFile("externalObjectStore", fileName);
            subscription.enable(true);
            manager.addSubscription(subscription);
        } else {
            manager.removeSubscription("externalObjectStore");
        }
    }

    protected void reconfigureUpdatePoliciesSubscription() {
        SubscriptionManager manager = SubscriptionManager.getInstance();
        if (CMIndications.logEnabled("Audit.Other.CM", 30000)) {
            if (manager.getSubscription("updatePolicies") == null) {
                String fileName = "/WEB-INF/cm/subscriptions/updatePolicies.xml";
                try {
                    SubscriptionParser parser = new SubscriptionParser(CMResourceUtils.getResourceLoader(), CMExecutionContext.get().getStore());
                    Subscription subscription = parser.parseOneSubscriptionFromDescriptorFile("updatePolicies", fileName);
                    subscription.enable(true);
                    manager.addSubscription(subscription);
                }
                catch (Throwable ex) {
                    CMIndications.Audit_Warning("cmErrParsingSubscriptionDesc", new CMException.Parm[]{new CMException.Parm("Message", ex.getMessage()), new CMException.Parm("File", fileName)}, "Request");
                }
            }
        } else {
            manager.removeSubscription("updatePolicies");
        }
    }

    private void reconfigureAdvancedSettings(Configuration configuration) {
        try {
            String advancedSettings = "";
            Element el = configuration.getCmResponse();
            if (el != null) {
                Node node = el.selectSingleNode(advancedSettingsXPath_);
                if (node != null) {
                    advancedSettings = ((Element)node).getText();
                }
                AdvancedSettings.update(advancedSettings);
            }
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
        }
    }

    public static void setServerLocale(CMLocalePreference locale) {
        serverLocale_ = locale;
    }

    public static synchronized boolean CAMisTrusted(byte[] fullSoapRequest) throws CAMCryptoException {
        if (CAMtrustedRequestSession_ == null) {
            return false;
        }
        return CAMtrustedRequestSession_.isTrusted(fullSoapRequest);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response, long startRequestSystemMillis) throws ServletException {
        try {
            this.setupContext();
            response.setBufferSize(ResponseBufferSize_);
            if (!RequestsAreAccepted_) {
                Responder responder = this.notOperationalResponder;
                if (!CMisShuttingDown_ && CMisComingUp_) {
                    responder = this.notStartedResponder;
                }
                this.sendResponse(response, responder);
                return;
            }
            String sCMRoot = request.getParameter("CMRoot");
            if (sCMRoot != null && sCMRoot.length() > 0) {
                config_.setCMRootDir(sCMRoot);
            }
            RequestManager manager = new RequestManager(handlers, config_);
            manager.handle(request, response, startRequestSystemMillis);
        }
        catch (Throwable th) {
            this.debugOut.println("Catching throwable in doPost: " + th.getMessage());
            th.printStackTrace(this.debugOut);
            throw new ServletException(th);
        }
        finally {
            try {
                this.releaseLocks();
            }
            catch (Throwable th) {
                this.debugOut.println("Catching throwable in doPost: " + th.getMessage());
                th.printStackTrace(this.debugOut);
                throw new ServletException(th);
            }
            this.tearDownContext();
        }
    }

    private void setupContext() {
        CMExecutionContext.setUp();
        CMExecutionContext.mapCurrentThreadContext();
    }

    private void tearDownContext() {
        CMExecutionContext.unmapCurrentThreadContext();
        CMExecutionContext.tearDown();
    }

    private void sendResponse(HttpServletResponse response, Responder responder) throws IOException {
        try {
            ServletOutputStream sos = response.getOutputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter ow = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            PrintWriter pw = new PrintWriter(ow);
            responder.writeResponse(pw, baos);
            response.setContentType("text/xml; charset=utf-8");
            response.setStatus(500);
            byte[] bArray = baos.toByteArray();
            response.setContentLength(bArray.length);
            sos.write(bArray);
            sos.flush();
        }
        catch (IOException ex) {
            response.sendError(500, responder.getIOExceptionMessage());
        }
    }

    private void releaseLocks() throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = ctx.getStore();
        if (store.isInitialized()) {
            ICMLockManager lockManager = store.getLockManager();
            lockManager.releaseLocks();
        }
    }

    private static String getName(String filename) {
        int period = filename.lastIndexOf(46);
        if (period < 0) {
            return filename;
        }
        return filename.substring(0, period);
    }

    private static String getExtension(String filename) {
        int period = filename.lastIndexOf(46);
        if (period < 0) {
            return "";
        }
        return "." + filename.substring(period + 1);
    }

    private static void executeInitScript(String resourceName, InputStream inStream) throws CMException {
        String resultsFilename = CMServlet.getName(resourceName) + "_results" + CMServlet.getExtension(resourceName);
        File outFile = new File(logsDir_, resultsFilename);
        CMIndications.CMTrace("cmExecuteCreateScript", new CMException.Parm("Resource", resourceName));
        CMIndications.CMTrace("cmExecuteCreateScriptResults", new CMException.Parm("Filename", outFile.getAbsolutePath()));
        FileOutputStream outWriter = null;
        try {
            outWriter = new FileOutputStream(outFile);
            RequestManager manager = new RequestManager(handlers, config_);
            manager.handleStaticRequest(inStream, (OutputStream)outWriter);
            if (manager.faulted()) {
                if (!manager.successful()) {
                    throw new CMConfigurationException("cmBadCreateScript", new CMException.Parm[]{new CMException.Parm("Script", resourceName), new CMException.Parm("File", outFile.getAbsolutePath())});
                }
                CMIndications.CMTrace("cmBadCreateScript", new CMException.Parm("Script", resourceName), new CMException.Parm("File", outFile.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new CMConfigurationException((Throwable)e, "cmBadInitScript");
        }
        finally {
            IOUtils.closeQuietly((InputStream)inStream);
            IOUtils.closeQuietly((OutputStream)outWriter);
        }
    }

    public static void executeInitScript(String scriptName) throws CMException {
        File scriptFile = new File(scriptName);
        InputStream scriptInputStream = null;
        if (!scriptFile.isAbsolute()) {
            CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
            scriptInputStream = resourceLoader.getResourceInputStream("/WEB-INF/cm/" + scriptName);
        } else if (scriptFile.exists()) {
            try {
                scriptInputStream = new FileInputStream(scriptFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (scriptInputStream == null) {
            throw new CMConfigurationException("cmNoConfigScript", new CMException.Parm("Resource", scriptFile.getName()));
        }
        CMServlet.executeInitScript(scriptFile.getName(), scriptInputStream);
    }

    private void initializeMaintenanceThread() {
        maintenanceThread_ = new CMMaintenanceThread();
        try {
            CMMaintenanceTaskDeleteOldSessions deleteTask = new CMMaintenanceTaskDeleteOldSessions();
            maintenanceThread_.addTask("CRN.CM.DeleteOldSessions", deleteTask);
        }
        catch (CMException ex) {
            CMIndications.logException(new CMException(ex, "cmErrCleanSessions"));
        }
        try {
            CMMaintenanceTaskUpdateDeploymentStatus updateDeployStatusTask = new CMMaintenanceTaskUpdateDeploymentStatus();
            maintenanceThread_.addTask("CRN.CM.UpdateDeploymentStatus", updateDeployStatusTask);
        }
        catch (Exception ex) {
            CMIndications.logException(new CMException(ex, "cmFailedUpdateDeployStatus"));
        }
        try {
            CMMaintenanceTaskCleanDeletedObjects cleanDeletedObjectsTask = new CMMaintenanceTaskCleanDeletedObjects();
            maintenanceThread_.addTask("CRN.CM.CleanDeletedObjects", cleanDeletedObjectsTask);
        }
        catch (Exception ex) {
            CMIndications.logException(new CMException(ex, "cmFailedUpdateDeployStatus"));
        }
        maintenanceThread_.start();
    }

    public static int parseIntParam(String parmValue, int defaultValue) {
        try {
            if (parmValue != null && parmValue.length() > 0) {
                return Integer.parseInt(parmValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultValue;
    }

    public static boolean parseBoolParam(String parmValue, boolean defaultValue) {
        try {
            if (parmValue != null && parmValue.length() > 0) {
                return Boolean.valueOf(parmValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init() {
        CMisComingUp_ = true;
        CMInitCalled_ = true;
        PerfMonitor.enableCategory((String)"com.cognos.cm.server");
        PerfMonitor.setBaseEntry((PerfMeasure)ContentManager.PERF_TIMER_IN_CM.getMeasure());
        try {
            WebPageLocale_ = DefaultLocale_ = ConfigurationFactory.getConfig().getServerLocale().toLocale();
            TimeStartedString_ = CMServlet.getCurrentWebPageTimeString();
            CMExecutionContext.setUp();
            CMExecutionContext ctx = CMExecutionContext.get();
            ctx.setIPFCategory("Audit.CM");
            ctx.setIPFOperation("StartService");
            ctx.setRequestContext("Initialization_REQ");
            ctx.setSessionContext("Initialization_SESS");
            CMIndications.reconfigure();
            this.PrintProps();
            ContentManager.PERF_TIMER_IN_CM.start();
            ConfigurationFactory.getConfig();
            String homeDir = null;
            rootDir_ = new File(".");
            rootDir_ = rootDir_.getAbsoluteFile();
            rootDir_ = rootDir_.getParentFile();
            if (isStandalone_ && (homeDir = System.getProperty("cm.home")) == null) {
                CMException cmex = new CMException("cmErrCMHome", new CMException.Parm("Folder", homeDir));
                CMIndications.logException(cmex);
                return;
            }
            IConfiguration config = ConfigurationFactory.getConfig();
            String folder = config.resolveEffectivePath("../logs");
            logsDir_ = new File(folder);
            if (!logsDir_.exists()) {
                CMException cmex = new CMException("cmMissingLogsFolder", new CMException.Parm("Path", logsDir_.getAbsolutePath()));
                CMIndications.logException(cmex);
                return;
            }
            try {
                folder = config.resolveEffectivePath("../configuration");
                File ipfclientconfig = new File(config.getConfigurationDirectory(), "ipfclientconfig.xml");
                ipfclientconfigExists_ = ipfclientconfig.exists();
                this.detectEdition();
            }
            catch (CMConfigurationException ex) {
                CMIndications.logException(new CMException(ex, "cmErrConfig"));
            }
            try {
                String msg;
                if (CMError.getUseResources() && ((msg = CMError.getMessage("cmNoRequestHandlerSys", null, null)) == null || "cmNoRequestHandlerSys".equals(msg))) {
                    String fatalError = new String("***** FATAL ERROR *****");
                    String theError = new String("***** CM-SYS-5001 Content Manager is unable to start because its message files named cmmsgs_*.properties could not be found in the folder /WEB-INF/classes/.");
                    CMIndications.Audit_Message(fatalError);
                    CMIndications.Audit_Message(theError);
                    this.debugOut.println(fatalError);
                    this.debugOut.println(theError);
                    return;
                }
                AdvancedSettings.initialize();
                ASyncRequestManager.getInstance();
                try {
                    CMIndications.Audit_Message_FreeFormText("cmInitializePluginMgr", null, 20000, "StartService", "ContentManagerService", "", "Info", null);
                    CMPluginManager.getInstance().initialize(ConfigurationFactory.getCCLConfig());
                }
                catch (Throwable e) {
                    CMIndications.logException(new CMException(e, "cmErrPluginMgrInit"));
                }
                AAA = this.initializeAAAInterface();
                try {
                    CAMFactory_ = new CAMFactory();
                    String initString = new String("<initializeDocument><serviceID>CM</serviceID></initializeDocument>");
                    byte[] baInit = initString.getBytes();
                    CAMFactory_.initialize(baInit);
                    CAMtrustedRequestSession_ = CAMFactory_.createTrustedSession();
                }
                catch (CAMCryptoException camCex) {
                    CMIndications.logException(new CMException((Exception)((Object)camCex), "cmInitCAMFactoryFailed"));
                }
                catch (Exception ex) {
                    CMIndications.logException(new CMException(ex, "cmInitCAMFactoryFailed"));
                }
                if (!CMServlet.initializeTemporaryFileDirectory()) {
                    return;
                }
                IConfiguration cmConf = ConfigurationFactory.getConfig();
                maxUnexpectedErrorCount_ = CMServlet.parseIntParam(cmConf.getInternalProp("CMMaxUnexpectedErrors"), 0);
                maxRequestIdleTime_ = CMServlet.parseIntParam(cmConf.getInternalProp("CMRequestMaxIdleTime"), 0);
                maxDebugPingCount_ = CMServlet.parseIntParam(cmConf.getInternalProp("CMDebugMaxPings"), 0);
                if (ContentManager.startedSelf_) {
                    CMIndications.Audit_Message_FreeFormText("cmStartingSelf", new CMException.Parm[]{new CMException.Parm("Reason", ContentManager.startedSelfReason_)}, 50000, "StartService", "ContentManagerService", "", "Warning", null);
                }
                CMIndications.CMTrace("cmStarting");
                if (isStandalone_) {
                    CMIndications.CMTrace("cmCMHomeIs", new CMException.Parm("Folder", homeDir));
                }
                File fCurrDir = new File(".");
                String sCurrDir = fCurrDir.getAbsolutePath();
                CMIndications.CMTrace("cmCurrentDir", new CMException.Parm("Folder", sCurrDir));
                CMIndications.CMTrace("cmInitReqManager");
                try {
                    RequestManager.Initialize();
                }
                catch (Exception e) {
                    CMIndications.logException(new CMException(e, "cmErrInitReqMan"));
                    CMExecutionContext.tearDown();
                    CMisComingUp_ = false;
                    ContentManager.PERF_TIMER_IN_CM.stop();
                    return;
                }
                if (config_.databaseIsConfigured()) {
                    config_.encryptDatabaseProperty("user");
                    config_.encryptDatabaseProperty("password");
                    this.prepareExternalObjectStoreConnection();
                    boolean bInitCSSuccessful = this.initializeContentStoreContentIndependentBeforeLock();
                    if (bInitCSSuccessful) {
                        String cmURL = config_.getCognosProp("externalDispatcher");
                        syncThread_ = new MultipleCMsSyncThread(this, cmURL);
                        int mode = syncThread_.getMode();
                        syncThread_.start();
                        if (mode == 1) {
                            this.initializeContentStoreForActive(false);
                        } else {
                            this.initializeContentStoreForStandby(true, false);
                        }
                        if (this.clearError() != 0) {
                            syncThread_.terminate();
                        }
                        if (!ContentManager.startedSelf_ && !ContentManager.isStandalone_) {
                            MBeanRegister.registerMBeans();
                        }
                        CMIndications.loadAuditAccessFilters(ctx.getStore().getObjectClasses());
                    }
                } else {
                    List<DatabaseConfigInfo> missingInfo = config_.getDatabaseConfigInfo();
                    for (int i = 0; i < missingInfo.size(); ++i) {
                        DatabaseConfigInfo dbCInfo = missingInfo.get(i);
                        CMIndications.CMTrace("cmConfigureDBParameter", new CMException.Parm("Name", dbCInfo.name_), new CMException.Parm("Value", dbCInfo.value_));
                    }
                    CMIndications.logException(new CMException("cmDatabaseNotConfigured"));
                    CMIndications.CMTrace("cmNotConfigured");
                }
                String sResponseBufferSize = config_.getInternalProp("CMResponseBufferSize");
                if (sResponseBufferSize == null) return;
                ResponseBufferSize_ = Integer.parseInt(sResponseBufferSize);
                return;
            }
            catch (Exception ex) {
                CMIndications.logException(new CMException(ex, "cmStartFailed", new CMException.Parm("Build", cmInfo.getVersion())));
                return;
            }
            catch (Throwable t) {
                CMIndications.logException(new CMException(t, "cmStartFailed", new CMException.Parm("Build", cmInfo.getVersion())));
                CMExecutionContext.tearDown();
                return;
            }
            finally {
                CMExecutionContext.tearDown();
            }
        }
        catch (Exception ex) {
            CMIndications.logException(new CMException(ex, "cmStartFailed", new CMException.Parm("Build", cmInfo.getVersion())));
            return;
        }
        finally {
            CMisComingUp_ = false;
            ContentManager.PERF_TIMER_IN_CM.stop();
        }
    }

    private AAAProvider initializeAAAInterface() {
        CMFactory aaaFactory = this.createFactoryForAAA();
        AAAProvider_CAM cam = new AAAProvider_CAM((AAA_Interface)aaaFactory.newInstance());
        AAACounterProxy instrumentedAAA = new AAACounterProxy(cam);
        return new AAANotificationProxy(instrumentedAAA);
    }

    private CMFactory createFactoryForAAA() {
        String fallbackValue = "com.cognos.CAM.AAA";
        CMFactory factory = new CMFactory("com.cognos.CAM.AAA");
        String filename = "aaa.properties";
        String property = "com.cognos.CAM.AAA_Interface";
        factory.addLocator((CMFactoryLocator)new CMFactorySystemPropLocator("com.cognos.CAM.AAA_Interface"));
        factory.addLocator((CMFactoryLocator)new CMFactoryContextClassLoaderLocator("aaa.properties", "com.cognos.CAM.AAA_Interface"));
        return factory;
    }

    private void completeInitialization() {
        if (CMRunningMode_ == 1 || CMRunningMode_ == 2) {
            RequestsAreAccepted_ = true;
        }
        if (!ContentManager.startedSelf_ && CMRunningMode_ == 1) {
            String dispURI = config_.getCognosProp("internalDispatcher");
            String cmURI = CMDbStoreMultipleCMsUtil.getInstance().getRunningContentStoreName();
            if (dispURI != null && cmURI != null) {
                try {
                    CMConnector cmConnector = CMConnector.getConnector(dispURI);
                    cmConnector.setTimeoutInMilliseconds((int)AdvancedSettings.SENDREQUESTTIME);
                    cmConnector.CMIsActivetNotify(cmURI);
                }
                catch (CMResponseTimeoutException ex) {
                    CMIndications.logException(ex);
                }
                catch (CMException ex) {
                    CMIndications.logException(new CMException((Exception)ex, "cmCannotNotifyCMActive", new CMException.Parm("Path", dispURI)));
                }
            }
        }
        if (!ContentManager.startedSelf_) {
            ContentManager.reportRunningStatus();
        }
        if (CMRunningMode_ == 0) {
            if (this.getError() == 0) {
                this.setError(2);
            }
            CMIndications.Audit_Message_FreeFormText("cmStartFailed", new CMException.Parm[]{new CMException.Parm("Build", cmInfo.getVersion())}, 50000, "StartService", "ContentManagerService", "", "Failure", null);
        }
        System.gc();
    }

    private void prepareExternalObjectStoreConnection() throws CMException {
        String dispatcherURL = config_.getCognosProp("externalDispatcher");
        ExternalObjectStoreConnectionProvider provider = ExternalObjectStoreConnectionProvider.getInstance();
        provider.initialize(dispatcherURL);
        provider.register(config_);
    }

    @Override
    public boolean initializeContentStoreContentIndependentBeforeLock() {
        CMException cmex;
        boolean bInitSuccess = true;
        if (RequestManager.doUseAccMan()) {
            try {
                CMIndications.CMTrace("cmInitAAA");
                if (!AAA.Succeeded(AAA.Initialize(CMServlet.getAccManInitializeDocument(), null, CMExecutionContext.get().getCAMAdditionalInfo()))) {
                    bInitSuccess = false;
                }
            }
            catch (AAAException ae) {
                CMIndications.logException(new CMException((Exception)((Object)ae), "cmErrAccManInit"));
                bInitSuccess = false;
            }
        } else {
            CMIndications.CMTrace("cmNoAccManUse");
        }
        if (RequestManager.doUseAccMan() && !RequestManager.doCheckPolicies()) {
            CMIndications.CMTrace("cmNoAuthPolicies");
        }
        CMIndications.CMTrace("cmInitCS");
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = null;
        try {
            store = ctx.getStore();
        }
        catch (CMException e) {
            cmex = new CMException(e, "cmErrExeInit");
            CMIndications.logException(cmex);
            bInitSuccess = false;
        }
        if (bInitSuccess) {
            try {
                ConnectionPool.getInstance().initialize();
            }
            catch (CAMCryptoException ex4) {
                cmex = new CMException((Exception)((Object)ex4), "cmErrInitializingSession");
                CMIndications.logException(cmex);
                bInitSuccess = false;
            }
        }
        if (bInitSuccess) {
            try {
                store.initializeContentIndependentBeforeLock();
            }
            catch (CMConfigurationException e1) {
                CMIndications.logException(new CMException(e1, "cmErrInitContentStore"));
                bInitSuccess = false;
            }
            catch (CMException ex3) {
                CMIndications.logException(new CMException(ex3, "cmErrInitContentStore"));
                bInitSuccess = false;
            }
            catch (Exception e2) {
                CMIndications.logException(new CMException(e2, "cmErrInitContentStore"));
                bInitSuccess = false;
            }
        }
        return bInitSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRunningStateChanged() {
        HashMap<Integer, Thread> hashMap = sleepingThreads_;
        synchronized (hashMap) {
            for (Thread thread : sleepingThreads_.values()) {
                if (thread == null) continue;
                Thread thread2 = thread;
                synchronized (thread2) {
                    thread.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSleepingThread(Thread thread) {
        HashMap<Integer, Thread> hashMap = sleepingThreads_;
        synchronized (hashMap) {
            sleepingThreads_.put(new Integer(thread.hashCode()), thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSleepingThread(Thread thread) {
        HashMap<Integer, Thread> hashMap = sleepingThreads_;
        synchronized (hashMap) {
            sleepingThreads_.remove(new Integer(thread.hashCode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeContentStoreForActive(boolean suspended) {
        CMExecutionContext ctx = CMExecutionContext.get();
        ctx.setIPFCategory("Audit.CM");
        ctx.setIPFOperation("StartService");
        ctx.setRequestContext("Initialization_REQ");
        ctx.setSessionContext("Initialization_SESS");
        boolean bInitSuccess = true;
        int storeDisposition = 0;
        CMIndications.CMTrace("cmInitCS");
        CMStore store = null;
        try {
            CMDbConnection dbcon;
            CMException cmex;
            CMException cmex2;
            try {
                store = ctx.getStore();
            }
            catch (CMException e) {
                cmex2 = new CMException(e, "cmErrExeInit");
                CMIndications.logException(cmex2);
                bInitSuccess = false;
            }
            if (bInitSuccess) {
                try {
                    if (AdvancedSettings.PROTOTYPE_ENABLESTANDBYREADERS) {
                        store.deinitializeContentDependent();
                    }
                    storeDisposition = store.initializeContentDependent(false, syncThread_);
                }
                catch (CMConfigurationException e1) {
                    CMIndications.logException(new CMException(e1, "cmErrInitContentStore"));
                    bInitSuccess = false;
                }
                catch (CMStoreException ex) {
                    CMIndications.logException(new CMException(ex, "cmErrInitContentStore"));
                    bInitSuccess = false;
                    if (!(ex instanceof CMStoreContentException)) {
                        this.setError(1);
                    }
                }
                catch (CMException ex3) {
                    CMException toLog;
                    if (ex3.getCode().equals("cmInvalidTenantContainmentOnStartup")) {
                        toLog = ex3;
                        toLog.setAddStackTrace(false);
                        toLog.setAddCauseToMessage(false);
                    } else {
                        toLog = new CMException(ex3, "cmErrInitContentStore");
                    }
                    CMIndications.logException(toLog);
                    bInitSuccess = false;
                }
                catch (Exception e2) {
                    CMIndications.logException(new CMException(e2, "cmErrInitContentStore"));
                    bInitSuccess = false;
                }
            }
            ctx = CMExecutionContext.get();
            try {
                store = ctx.getStore();
            }
            catch (CMException e) {
                cmex2 = new CMException(e, "cmErrExeInit");
                CMIndications.logException(cmex2);
                bInitSuccess = false;
            }
            if (bInitSuccess) {
                bInitSuccess = this.initCapabilitiesAndTrustedServices();
            }
            boolean reloadBaseObjectNames = false;
            if (bInitSuccess && (storeDisposition == 1 || CMDbStoreFactory.versionBeforeUpgrade_ <= (double)0.65f)) {
                try {
                    CMServlet.executeInitScript(CREATEBASEOBJECTSSCRIPT);
                }
                catch (CMException ex3) {
                    cmex = new CMException(ex3, "cmErrCreateBaseObj");
                    CMIndications.logException(cmex);
                }
            }
            if (bInitSuccess) {
                try {
                    store.getDirectoryStoreID();
                }
                catch (CMException e) {
                    CMIndications.logException(e);
                    bInitSuccess = false;
                }
            }
            if (bInitSuccess) {
                boolean bl = bInitSuccess = this.initializeSubscriptionManager(storeDisposition) && namespaceManager.initialize(store, CMServlet.isStandby());
            }
            if (bInitSuccess && (storeDisposition == 1 || CMDbStoreFactory.versionBeforeUpgrade_ <= (double)0.65f)) {
                try {
                    CMServlet.executeInitScript(CREATESCRIPT);
                }
                catch (CMException ex3) {
                    cmex = new CMException(ex3, "cmErrExeInit");
                    CMIndications.logException(cmex);
                    bInitSuccess = false;
                }
            }
            if (bInitSuccess && storeDisposition == 1) {
                try {
                    CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
                    String[] initScripts = resourceLoader.listResourceNames("/WEB-INF/cm/initialContent/");
                    for (int i = 0; i < initScripts.length; ++i) {
                        CMServlet.executeInitScript("initialContent/" + initScripts[i]);
                    }
                }
                catch (Exception e) {
                    cmex = new CMException(e, "cmErrExeInit");
                    CMIndications.logException(cmex);
                    bInitSuccess = false;
                }
            }
            if (bInitSuccess) {
                try {
                    store.copyUserAccountTemplate("::Anonymous", null);
                }
                catch (Exception ex) {
                    cmex = new CMException(ex, "cmErrCreateBaseObj");
                    CMIndications.logException(cmex);
                    bInitSuccess = false;
                }
            }
            if (bInitSuccess) {
                dbcon = null;
                try {
                    dbcon = CMDbStoreFactory.getConnection();
                    CMDeferredInitActionUtils.executeDeferredInitActions(dbcon, "CMUPGRADESCRIPT");
                }
                catch (CMException ex) {
                    CMException cmex3 = new CMException(ex, "cmErrExeInit");
                    CMIndications.logException(cmex3);
                    bInitSuccess = false;
                }
                finally {
                    if (dbcon != null) {
                        CMDbStoreFactory.releaseConnection(dbcon);
                    }
                }
            }
            if (bInitSuccess) {
                dbcon = null;
                try {
                    dbcon = CMDbStoreFactory.getConnection();
                    CMUserCapabilityPoliciesHandler.populateUserCapabilityPoliciesSet(dbcon);
                    SubscriptionManager.getInstance().enableAllSubscritions(true);
                    this.reconfigureSubscriptions();
                }
                catch (CMException ex) {
                    CMIndications.logException(ex);
                    bInitSuccess = false;
                }
                finally {
                    if (dbcon != null) {
                        CMDbStoreFactory.releaseConnection(dbcon);
                    }
                }
            }
            if (bInitSuccess && storeDisposition != 3) {
                boolean requireMajorUpgrade = false;
                try {
                    requireMajorUpgrade = CMDbStoreFactory.dbMajorUpgradeRequired();
                }
                catch (Throwable ex) {
                    CMIndications.logException(ex);
                }
                CMDataUpgradeManager dataUpgradeMgr = new CMDataUpgradeManager();
                try {
                    if (requireMajorUpgrade) {
                        CMIndications.Audit_Message_FreeFormText("cmContentUpgradeStart", null, 50000, "Upgrade", "ContentManagerService", "", "Info", null);
                    }
                    dataUpgradeMgr.upgradeData(storeDisposition == 1, requireMajorUpgrade);
                    if (requireMajorUpgrade) {
                        CMIndications.Audit_Message_FreeFormText("cmContentUpgradeEnd", null, 50000, "Upgrade", "ContentManagerService", "", "Info", null);
                    }
                }
                catch (Throwable ex) {
                    CMIndications.Audit_Message_FreeFormText("cmDataUpgradeFail", null, 50000, "Upgrade", "ContentManagerService", "", "Warning", null);
                }
                File upgradeLogFile = new File(logsDir_, "upgradeLog.xml");
                if (requireMajorUpgrade && upgradeLogFile.exists()) {
                    CMIndications.Audit_Message_FreeFormText("cmUpgradeLogFilePath", new CMException.Parm[]{new CMException.Parm("PATH", upgradeLogFile.getAbsolutePath())}, 50000, "Upgrade", "ContentManagerService", "", "Info", null);
                }
            }
            if (bInitSuccess) {
                bInitSuccess = ProfilesManager.getInstance().updateSystemDefaultSettings(store, true);
                LicenseManager.initialize(store);
            }
            if (bInitSuccess) {
                this.updateInitialContentNames(store);
                this.initializeMaintenanceThread();
            }
            if (bInitSuccess) {
                this.startBackgroundTasks();
            }
            if (bInitSuccess) {
                CMisSuspended_ = suspended;
                CMRunningMode_ = 1;
                this.notifyRunningStateChanged();
            }
            if (bInitSuccess) {
                this.initializeMaintenancePluginManager();
            }
            if (bInitSuccess) {
                this.startConnectors();
            }
            if (bInitSuccess) {
                this.logSuccessfulStartup(store);
            }
        }
        finally {
            if (!bInitSuccess) {
                CMRunningMode_ = 0;
                RequestsAreAccepted_ = false;
            }
            CMServlet.logInitializationMsgs();
            this.completeInitialization();
        }
    }

    private void startConnectors() {
        if (needsToStartSDSConnector) {
            this.startSDSConnector();
        }
        if (needsToStartIndexConnector) {
            this.startIndexConnector();
        }
        if (needsToStartSynchromeshConnector) {
            this.startSynchromeshConnector();
        }
    }

    private boolean initCapabilitiesAndTrustedServices() {
        try {
            Document cmMetadata = this.loadCmMetadata();
            TrustedServices.load(cmMetadata);
            ComponentDependentCapabilities.init(cmMetadata);
            ExtendedUserCapabilities.init();
            return true;
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
            return false;
        }
    }

    private void initializeMaintenancePluginManager() {
        CMMaintenancePluginManager maintenance = new CMMaintenancePluginManager();
        maintenance.initialize();
        maintenance.invoke();
    }

    protected void startBackgroundTasks() {
        try {
            IBackgroundTaskAndQueueExecutor executor = this.createBackgroundTaskAndQueueExecutor();
            executor.run(!ContentManager.isTestMode());
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
        }
    }

    private void logSuccessfulStartup(CMStore store) {
        this.logStartupMessage(store);
        this.logRunningActive();
    }

    private void logRunningActive() {
        CMIndications.Audit_Message_FreeFormText("cmCMRunningActive", null, 50000, "StartService", "ContentManagerService", "", "Info", null);
    }

    private void logStartupMessage(CMStore store) {
        CMIndications.Audit_Message_FreeFormText("cmCMStarted", new CMException.Parm[]{new CMException.Parm("Build", cmInfo.getVersion()), new CMException.Parm("ExtendedVersion", cmInfo.getExtendedVersion()), new CMException.Parm("SchemaVersion", cmInfo.getStoreVersion()), new CMException.Parm("Implementation", store.getImplementation())}, 50000, "StartService", "ContentManagerService", "", "Success", null);
    }

    public static void addInitializationMsg(Throwable ex) {
        if (initializationThrowablesList == null) {
            initializationThrowablesList = new ArrayList<Throwable>();
        }
        initializationThrowablesList.add(ex);
    }

    private static void logInitializationMsgs() {
        if (null == initializationThrowablesList) {
            return;
        }
        for (Throwable throwable : initializationThrowablesList) {
            CMIndications.logException(throwable);
        }
        initializationThrowablesList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeContentStoreForStandby(boolean firstTime, boolean suspended) {
        CMExecutionContext ctx = CMExecutionContext.get();
        boolean bInitSuccess = true;
        if (maintenanceThread_ != null) {
            maintenanceThread_.terminate();
        }
        this.stopBackgroundTasks();
        CMisSuspended_ = suspended;
        CMRunningMode_ = 2;
        this.notifyRunningStateChanged();
        CMStore store = null;
        String cmURI = null;
        try {
            CMException cmex;
            try {
                store = CMExecutionContext.get().getStore();
                cmURI = store.getRunningContentStoreName();
            }
            catch (CMConfigurationException e1) {
                CMIndications.logException(new CMException(e1, "cmErrInitContentStore"));
                bInitSuccess = false;
            }
            catch (CMException ex3) {
                CMIndications.logException(new CMException(ex3, "cmErrInitContentStore"));
                bInitSuccess = false;
            }
            catch (Exception e2) {
                CMIndications.logException(new CMException(e2, "cmErrInitContentStore"));
                bInitSuccess = false;
            }
            if (firstTime) {
                ctx.setIPFCategory("Audit.CM");
                ctx.setIPFOperation("StartService");
                ctx.setRequestContext("Initialization_REQ");
                ctx.setSessionContext("Initialization_SESS");
            } else {
                try {
                    store.getLockManager().releaseLocks();
                }
                catch (CMException e) {
                    cmex = new CMException(e, "cmErrExeInit");
                    CMIndications.logException(cmex);
                    bInitSuccess = false;
                }
                try {
                    store.deinitializeContentDependent();
                    SDSConnector.terminate();
                    needsToStartSDSConnector = true;
                    IndexConnector.terminate();
                    needsToStartIndexConnector = true;
                    SynchromeshConnector.terminate();
                    needsToStartSynchromeshConnector = true;
                }
                catch (CMConfigurationException e1) {
                    CMIndications.logException(new CMException(e1, "cmErrInitContentStore"));
                    bInitSuccess = false;
                }
                catch (CMException ex3) {
                    CMIndications.logException(new CMException(ex3, "cmErrInitContentStore"));
                    bInitSuccess = false;
                }
                catch (Exception e2) {
                    CMIndications.logException(new CMException(e2, "cmErrInitContentStore"));
                    bInitSuccess = false;
                }
            }
            if (bInitSuccess) {
                try {
                    store.initializeContentIndependentAfterLock(true, syncThread_);
                }
                catch (CMConfigurationException e1) {
                    CMIndications.logException(new CMException(e1, "cmErrInitContentStore"));
                    bInitSuccess = false;
                }
                catch (CMException ex3) {
                    CMIndications.logException(new CMException(ex3, "cmErrInitContentStore"));
                    bInitSuccess = false;
                }
                catch (Exception e2) {
                    CMIndications.logException(new CMException(e2, "cmErrInitContentStore"));
                    bInitSuccess = false;
                }
            }
            if (bInitSuccess) {
                bInitSuccess = this.initCapabilitiesAndTrustedServices();
            }
            if (AdvancedSettings.PROTOTYPE_ENABLESTANDBYREADERS && bInitSuccess) {
                try {
                    store.getDirectoryStoreID();
                }
                catch (CMException e) {
                    CMIndications.logException(e);
                    bInitSuccess = false;
                }
                try {
                    store.getLockManager().releaseLocks();
                }
                catch (CMException e) {
                    cmex = new CMException(e, "cmErrExeInit");
                    CMIndications.logException(cmex);
                    bInitSuccess = false;
                }
            }
            if (bInitSuccess) {
                if (firstTime) {
                    this.logStartupMessage(store);
                }
                this.logRunningStandby(cmURI);
            }
        }
        finally {
            if (!bInitSuccess) {
                CMRunningMode_ = 0;
                RequestsAreAccepted_ = false;
            }
            this.completeInitialization();
        }
    }

    protected Document loadCmMetadata() throws CMException {
        CMResourceLoader loader = CMResourceUtils.getResourceLoader();
        InputStream is = loader.getResourceInputStream("/WEB-INF/cm/cmMetadata.xml");
        if (is == null) {
            throw new CMConfigurationException("cmNoConfigFile", new CMException.Parm("File", "/WEB-INF/cm/cmMetadata.xml"));
        }
        try {
            Document document = CMXMLUtils.parse(new InputSource(is));
            return document;
        }
        catch (Exception e) {
            throw new CMConfigurationException((Throwable)e, "cmBadConfigFile", new CMException.Parm("File", "/WEB-INF/cm/cmMetadata.xml"));
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private void logRunningStandby(String cmURI) {
        CMIndications.Audit_Message_FreeFormText("cmCMRunningStandby", new CMException.Parm[]{new CMException.Parm("URL", cmURI)}, 50000, "StartService", "ContentManagerService", "", "Info", null);
    }

    protected void stopBackgroundTasks() {
        try {
            IBackgroundTaskAndQueueExecutor executor = this.createBackgroundTaskAndQueueExecutor();
            executor.stop();
        }
        catch (CMException ex) {
            CMIndications.logException(ex);
        }
    }

    protected IBackgroundTaskAndQueueExecutor createBackgroundTaskAndQueueExecutor() {
        return new BackgroundTaskAndQueueExecutor();
    }

    public void updateInitialContentNames(CMStore store) {
        CMException e = UpdateInitialContentNames.execute(store);
        if (e != null) {
            String status = e.ErrorLevel >= 40000 ? "Warning" : "Info";
            CMIndications.Audit_Message_FreeFormText(e.getCode(), e.listExceptionParms_, 50000, "StartService", "ContentManagerService", "", status, null);
        }
    }

    private static boolean initializeTemporaryFileDirectory() {
        File tempDir;
        String tempPath;
        boolean bEncryptTempFiles;
        TmpCipherStreamSession tempFileCipherSession = null;
        String encrypt = config_.getCognosProp("encryptTemporaryFiles");
        if (encrypt == null) {
            encrypt = "false";
        }
        if (bEncryptTempFiles = Boolean.parseBoolean(encrypt)) {
            try {
                tempFileCipherSession = CAMFactory_.createTmpCipherStreamSession();
            }
            catch (CAMCryptoException camCex) {
                CMIndications.logException(new CMException((Exception)((Object)camCex), "cmInitCAMFactoryFailed"));
            }
        }
        if ((tempPath = config_.getCognosProp("temp")) == null) {
            try {
                IConfiguration config = ConfigurationFactory.getConfig();
                tempPath = config.resolveEffectivePath("../temp");
            }
            catch (CMConfigurationException ex) {
                CMIndications.logException(new CMException(ex, "cmErrConfig"));
            }
        }
        temporaryFileDir_ = tempDir = new File(tempPath);
        tempPath = config_.getCognosProp("CMTempFileDirectory");
        if (tempPath == null) {
            tempPath = "cm";
        }
        if (!(temporaryFileDir_ = new File(temporaryFileDir_, tempPath)).isDirectory()) {
            temporaryFileDir_.mkdirs();
        } else {
            File[] oldFiles = temporaryFileDir_.listFiles();
            for (int i = 0; i < oldFiles.length; ++i) {
                CMFileUtils.deleteComplete(oldFiles[i]);
            }
        }
        try {
            File temp = File.createTempFile("temp", "temp", temporaryFileDir_);
            temp.delete();
        }
        catch (IOException ex) {
            CMException cmex = new CMException("cmMissingTempFolder", new CMException.Parm("Path", temporaryFileDir_.getAbsolutePath()));
            CMIndications.logException(cmex);
            return false;
        }
        String sTempPrefix = config_.getInternalProp("CMTempFilePrefix");
        if (sTempPrefix == null) {
            sTempPrefix = "CM_";
        }
        CMTempFileFactory.init((String)sTempPrefix, (File)temporaryFileDir_, (TmpCipherStreamSession)tempFileCipherSession);
        return true;
    }

    public static String getTempDirectory() {
        return temporaryFileDir_.getAbsolutePath();
    }

    public static File getTempFileDir() {
        return temporaryFileDir_;
    }

    @Override
    public void PrintProps() {
        String sPP = ConfigurationFactory.getConfig().getInternalProp("CM.PrintProps");
        Enumeration<Object> myEnum = System.getProperties().keys();
        while (myEnum.hasMoreElements()) {
            String sKey = (String)myEnum.nextElement();
            String sMsg = "System properties: " + sKey + " = " + System.getProperty(sKey);
            if (sPP != null && sPP.equals("1")) {
                this.debugOut.println(sMsg);
            }
            if (!CMIndicationGlobals.bDebugLogEnabled) continue;
            CMIndications.CMDebugTrace(sMsg);
        }
    }

    @Override
    public void PrintProp(String p) {
        String s = "== " + p + "= " + System.getProperty(p);
        if (CMIndicationGlobals.bDebugLogEnabled) {
            CMIndications.CMDebugTrace(s);
        }
        CMIndications.CMTrace("cmProp", new CMException.Parm("Name", p), new CMException.Parm("Prop", System.getProperty(p)));
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            CMStatusWriter writer = new CMStatusWriter();
            writer.setTimeStarted(TimeStartedString_);
            writer.setCurrentWebTime(CMServlet.getCurrentWebPageTimeString());
            writer.setStatus(CMRunningMode_);
            writer.setSuspended(CMisSuspended_);
            writer.setOMVersion(new BridgeImpl().getCurrentVersion());
            writer.setVersionNumber(cmInfo.getVersion());
            writer.setReplyWithStatusCode("true".equalsIgnoreCase(request.getParameter("sc")));
            writer.writeCMStatusHTML(response);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void ExecuteStaticRequest(File inputFile, File outputFile) {
        FileOutputStream outWriter;
        block10: {
            if (!RequestsAreAccepted_) {
                return;
            }
            FileInputStream inReader = null;
            outWriter = null;
            try {
                CMExecutionContext.setUp();
                inReader = new FileInputStream(inputFile);
                outWriter = new FileOutputStream(outputFile);
                RequestManager manager = new RequestManager(handlers, config_);
                manager.handleStaticRequest(inReader, (OutputStream)outWriter);
                if (inReader == null) break block10;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (inReader != null) {
                    CMStreamUtils.quietClose((InputStream)inReader);
                }
                if (outWriter != null) {
                    CMStreamUtils.quietClose(outWriter);
                }
                CMExecutionContext.tearDown();
                catch (Throwable throwable) {
                    if (inReader != null) {
                        CMStreamUtils.quietClose((InputStream)inReader);
                    }
                    if (outWriter != null) {
                        CMStreamUtils.quietClose(outWriter);
                    }
                    CMExecutionContext.tearDown();
                    throw throwable;
                }
            }
            CMStreamUtils.quietClose((InputStream)inReader);
        }
        if (outWriter != null) {
            CMStreamUtils.quietClose((OutputStream)outWriter);
        }
        CMExecutionContext.tearDown();
    }

    @Override
    public String ExecuteStaticRequest(String sRequest) {
        return this.ExecuteStaticRequest(sRequest, true);
    }

    private String wrapRequestInSOAPEnvelope(String sRequest) {
        StringBuffer sb = new StringBuffer(3000);
        sb.append(CMSOAPConstants.SOAPEnvHeaderStart);
        sb.append(CMSOAPConstants.SOAPHeaderToBody);
        sb.append(sRequest);
        sb.append(CMSOAPConstants.SOAPBodyEnvEnd);
        sRequest = sb.toString();
        return sRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executePluginRequest(String request, boolean asSysAdmin) {
        boolean isDeploymentPlugin;
        if (CMhasShutdown_ || CMisShuttingDown_) {
            return null;
        }
        boolean bl = isDeploymentPlugin = CMRunningMode_ == 1;
        if (!isDeploymentPlugin) {
            asSysAdmin = true;
        }
        request = this.wrapRequestInSOAPEnvelope(request);
        String response = null;
        CMExecutionContext orgCtx = null;
        try {
            if (isDeploymentPlugin) {
                orgCtx = CMExecutionContext.get();
                CMExecutionContext.set((CMExecutionContext)orgCtx.clone());
            }
            if (CMIndicationGlobals.bCMServlet_CMAPIRequests) {
                CMIndications.CMTrace("cmCMAPIRequest", new CMException.Parm("request", request));
            }
            byte[] baRequest = request.getBytes("utf-8");
            RequestManager manager = new RequestManager(handlers, config_);
            ByteArrayOutputStream baosResponse = manager.handleStaticRequest(baRequest, asSysAdmin);
            response = baosResponse.toString("utf-8");
            if (CMIndicationGlobals.bCMServlet_CMAPIRequests) {
                CMIndications.CMTrace("cmCMAPIResponse", new CMException.Parm("response", response));
            }
        }
        catch (UnsupportedEncodingException e) {
            CMIndications.logException(e);
        }
        finally {
            if (orgCtx != null) {
                CMExecutionContext.set(orgCtx);
            }
        }
        return response;
    }

    @Override
    public String ExecuteStaticRequest(String sRequest, boolean mustBeInitialized, boolean bodyRequest) {
        if (bodyRequest) {
            sRequest = this.wrapRequestInSOAPEnvelope(sRequest);
        }
        return this.ExecuteStaticRequest(sRequest, mustBeInitialized);
    }

    @Override
    public String ExecuteStaticRequest(String sRequest, boolean mustBeInitialized) {
        if (mustBeInitialized && !RequestsAreAccepted_) {
            return null;
        }
        if (CMhasShutdown_ || CMisShuttingDown_) {
            return null;
        }
        String sResponse = null;
        try {
            if (CMIndicationGlobals.bCMServlet_CMAPIRequests) {
                CMIndications.CMTrace("cmCMAPIRequest", new CMException.Parm("request", sRequest));
            }
            byte[] baRequest = sRequest.getBytes("utf-8");
            ByteArrayOutputStream baosResponse = this.ExecuteStaticRequest2(baRequest);
            sResponse = baosResponse.toString("utf-8");
            if (CMIndicationGlobals.bCMServlet_CMAPIRequests) {
                CMIndications.CMTrace("cmCMAPIResponse", new CMException.Parm("response", sResponse));
            }
        }
        catch (UnsupportedEncodingException e) {
            CMIndications.logException(e);
        }
        return sResponse;
    }

    @Override
    public String ExecuteUntrustedStaticRequest(String sRequest, boolean mustBeInitialized) {
        if (mustBeInitialized && !RequestsAreAccepted_) {
            return null;
        }
        if (CMhasShutdown_ || CMisShuttingDown_) {
            return null;
        }
        String sResponse = null;
        try {
            if (CMIndicationGlobals.bCMServlet_CMAPIRequests) {
                CMIndications.CMTrace("cmCMAPIRequest", new CMException.Parm("request", sRequest));
            }
            byte[] baRequest = sRequest.getBytes("utf-8");
            RequestManager manager = new RequestManager(handlers, config_);
            ByteArrayOutputStream outStream = manager.handleStaticRequest(baRequest, false);
            sResponse = outStream.toString("utf-8");
            if (CMIndicationGlobals.bCMServlet_CMAPIRequests) {
                CMIndications.CMTrace("cmCMAPIResponse", new CMException.Parm("response", sResponse));
            }
        }
        catch (UnsupportedEncodingException e) {
            CMIndications.logException(e);
        }
        return sResponse;
    }

    @Override
    public void ExecuteUntrustedStaticRequest(String passportID, XMLDoc request, XMLElement originalHeader, boolean mustBeInitialized, OutputStream os) throws SAXException, CMException {
        if (mustBeInitialized && !RequestsAreAccepted_) {
            return;
        }
        if (CMhasShutdown_ || CMisShuttingDown_) {
            return;
        }
        RequestManager manager = new RequestManager(handlers, config_);
        manager.handleStaticRequest(passportID, request, originalHeader, false, os);
    }

    @Override
    @Deprecated
    public byte[] ExecuteStaticRequest(byte[] baRequest) {
        return this.ExecuteStaticRequest(baRequest, (String)null);
    }

    @Override
    @Deprecated
    public byte[] ExecuteStaticRequest(byte[] baRequest, String tenantID) {
        return CAMConnector.INSTANCE.executeRequest(baRequest, tenantID);
    }

    @Override
    public byte[] ExecuteStaticRequest(byte[] baRequest, boolean mustBeInitialized) {
        if (mustBeInitialized && !RequestsAreAccepted_ && !CMisShuttingDown_) {
            return null;
        }
        if (CMhasShutdown_) {
            return null;
        }
        byte[] response = null;
        try {
            if (CMIndicationGlobals.bCMServlet_CMAPIRequests) {
                CMIndications.CMTrace("cmCMAPIRequest", new CMException.Parm("request", new String(baRequest, "utf-8")));
            }
            ByteArrayOutputStream baosResponse = this.ExecuteStaticRequest2(baRequest);
            if (CMIndicationGlobals.bCMServlet_CMAPIRequests) {
                String sResponse = baosResponse.toString("utf-8");
                CMIndications.CMTrace("cmCMAPIResponse", new CMException.Parm("response", sResponse));
            }
            response = baosResponse.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            CMIndications.logException(e);
        }
        return response;
    }

    private ByteArrayOutputStream ExecuteStaticRequest2(byte[] baRequest) {
        RequestManager manager = new RequestManager(handlers, config_);
        ByteArrayOutputStream outStream = manager.handleStaticRequest(baRequest, true);
        return outStream;
    }

    public static String getAccManInitializeDocument() {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<initializeDocument xmlns=\"http://developer.cognos.com/schemas/CAM/AAA/1/\" applicationID=\"Content Manager\"><ipfConfig filename=\"" + CMEnvironment.getCRNConfigDir() + "/baseconfig.xml\"/>" + "<cryptoConfig filename=\"" + CMEnvironment.getCRNConfigDir() + "/CAM_Crypto_Config_01.xml\"/>" + "<installationRoot directory=\"" + CMEnvironment.getCRNRootDir() + "\"/>" + "</initializeDocument>";
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccManConfigurationDocument(String fileParam, String fileDefault) {
        String accmanInitData = null;
        String saccmanFile = config_.getInternalProp(fileParam);
        File accmanFile = null;
        accmanFile = saccmanFile == null || saccmanFile.length() <= 0 ? new File(config_.getConfigurationDirectory(), fileDefault) : new File(config_.getConfigurationDirectory(), saccmanFile);
        CMIndications.CMTrace("cmLoadAMFrom", new CMException.Parm("Filename", accmanFile.getAbsolutePath()));
        StringBuffer xmlBuf = new StringBuffer();
        FileInputStream inReader = null;
        try {
            inReader = new FileInputStream(accmanFile);
            int iRead = 0;
            while ((iRead = inReader.read()) > 0) {
                xmlBuf.append((char)iRead);
            }
        }
        catch (FileNotFoundException e) {
            CMIndications.logException(new CMException(e, "cmLoadAMFromFailed"));
            xmlBuf = null;
        }
        catch (IOException e) {
            CMIndications.logException(new CMException(e, "cmLoadAMFromFailed"));
            xmlBuf = null;
        }
        finally {
            if (inReader != null) {
                try {
                    inReader.close();
                }
                catch (Exception e) {}
            }
        }
        if (xmlBuf != null) {
            accmanInitData = xmlBuf.toString();
        } else {
            CMIndications.logException(new CMException("cmNoAccManConfigFile"));
        }
        return accmanInitData;
    }

    public static String getCurrentWebPageTimeString() {
        String sRet = null;
        DateFormat df = null;
        if (WebPageLocale_ != null) {
            df = DateFormat.getDateTimeInstance(0, 0, WebPageLocale_);
            Date d = new Date();
            sRet = df.format(d);
        }
        return sRet;
    }

    @Override
    public void startSDSConnector() {
        if (CMRunningMode_ == 1) {
            try {
                SDSConnector conn = SDSConnector.getConnector();
                if (conn != null) {
                    conn.runReplicator();
                    needsToStartSDSConnector = false;
                }
            }
            catch (Exception e) {
                CMIndications.logException(new CMException(e, "cmStartSDSReplicator"));
                needsToStartSDSConnector = true;
            }
        } else {
            needsToStartSDSConnector = true;
        }
    }

    @Override
    public void startIndexConnector() {
        if (CMRunningMode_ == 1) {
            try {
                IndexConnector conn = IndexConnector.getConnector();
                if (conn != null) {
                    conn.runIndexSynchronization();
                    needsToStartIndexConnector = false;
                }
            }
            catch (Exception e) {
                CMIndications.logException(new CMException(e, "cmFailToSyncSearchIndex"));
                needsToStartIndexConnector = true;
            }
        } else {
            needsToStartIndexConnector = true;
        }
    }

    @Override
    public void startSynchromeshConnector() {
        if (CMRunningMode_ == 1) {
            try {
                SynchromeshConnector conn = SynchromeshConnector.getConnector();
                if (conn != null) {
                    conn.startSynchromeshTask();
                    needsToStartSynchromeshConnector = false;
                }
            }
            catch (Exception e) {
                CMIndications.logException(new CMException(e, "cmFailToStartSynchromeshTask"));
                needsToStartSynchromeshConnector = true;
            }
        } else {
            needsToStartSynchromeshConnector = true;
        }
    }

    public static void suspend() {
        if (!CMisSuspended_) {
            CMisSuspended_ = true;
            syncThread_.CMIsSuspended();
        }
    }

    public static void resume() {
        if (CMisSuspended_) {
            CMisSuspended_ = false;
            syncThread_.CMIsResumed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setError(int error) {
        Object object = errorSyncObject_;
        synchronized (object) {
            error_ = error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getError() {
        Object object = errorSyncObject_;
        synchronized (object) {
            return error_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearError() {
        int returnError = 0;
        Object object = errorSyncObject_;
        synchronized (object) {
            returnError = error_;
            error_ = 0;
        }
        return returnError;
    }

    private void detectEdition() throws CMConfigurationException {
        String v = config_.getValue(CONFIGURATION_EDITION, false);
        CMServlet.setEdition(C8Edition.get(v));
        if (CMServlet.getEdition() == null) {
            throw new CMConfigurationException("cmUnknownEdition");
        }
    }

    public static void setEdition(C8Edition edition) {
        CMServlet.edition = edition;
    }

    public static C8Edition getEdition() {
        return edition;
    }

    public static boolean isRunning() {
        return CMRunningMode_ == 1;
    }

    public static boolean isStandby() {
        return CMRunningMode_ == 2;
    }

    static {
        namespaceManager = new NamespaceManager();
        CMRunningMode_ = 0;
        CMisComingUp_ = false;
        CMisSuspended_ = false;
        RequestsAreAccepted_ = false;
        CMisShuttingDown_ = false;
        CMhasShutdown_ = false;
        ipfclientconfigExists_ = false;
        CMInitCalled_ = false;
        isStandalone_ = false;
        ResponseBufferSize_ = 8192;
        DefaultLocale_ = null;
        WebPageLocale_ = null;
        TimeStartedString_ = CMServlet.getCurrentWebPageTimeString();
        syncThread_ = null;
        needsToStartSDSConnector = false;
        needsToStartIndexConnector = false;
        needsToStartSynchromeshConnector = false;
        sleepingThreads_ = new HashMap();
        error_ = 0;
        errorSyncObject_ = new Object();
        maintenanceThread_ = null;
        edition = C8Edition.ENTERPRISE;
        baNotOperationalResp_Seg1 = CMServlet.s2ba(sNotOperationalResp_Seg1);
        baNotOperationalResp_Seg2 = CMServlet.s2ba(sNotOperationalResp_Seg2);
        baNotOperationalResp_Seg3 = CMServlet.s2ba(sNotOperationalResp_Seg3);
        baNotStartedResp_Seg1 = CMServlet.s2ba(sNotStartedResp_Seg1);
        baNotStartedResp_Seg2 = CMServlet.s2ba(sNotStartedResp_Seg2);
        baNotStartedResp_Seg3 = CMServlet.s2ba(sNotStartedResp_Seg3);
        serverLocale_ = new CMLocalePreference(CMLocaleUtils.toString(new Locale("en", "")));
    }

    protected abstract class Responder {
        protected Responder() {
        }

        public abstract void writeResponse(PrintWriter var1, OutputStream var2) throws IOException;

        public abstract String getIOExceptionMessage();

        protected void writeToPrinter(PrintWriter prt, String s) {
            prt.write(s);
            prt.flush();
        }
    }
}

