/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.C8Edition;
import com.cognos.cm.server.CMServlet;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;

public class CMStatusWriter {
    private String timeStarted;
    private String currentWebTime;
    private String omVersion;
    private int status;
    private boolean suspended;
    private String versionNumber;
    private boolean replyWithStatusCode;

    public void writeCMStatusHTML(HttpServletResponse response) throws IOException {
        String header_state;
        response.setContentType("text/html; charset=UTF-8");
        response.setStatus(this.getResponseStatusCode());
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>IBM Cognos Content Manager</title><style> .header {font-family: Verdana; font-size: large; font-weight: bold;} .pname  {font-family: Verdana; font-size: x-small; font-weight: bold;} .pvalue {font-family: Verdana; font-size: x-small;}</style></head>");
        out.println("<body>");
        out.println("<P class=\"header\" style=\"color:#cc0000\">IBM Cognos</P>");
        out.println("<P class=\"header\">Content Manager</P>");
        if (CMServlet.getEdition() != C8Edition.MIDMARKET) {
            this.outputHTMLValue(out, "Build", this.getVersionNumber(), "version");
            this.outputHTMLValue(out, "Object Model version", this.omVersion, "omVersion");
            this.outputHTMLValue(out, "Start time", this.getTimeStarted(), "startTime");
            this.outputHTMLValue(out, "Current time", this.getCurrentWebTime(), "currentTime");
        }
        String state = null;
        if (this.getStatus() == 1) {
            if (this.isSuspended()) {
                state = "Running suspended";
                header_state = "suspended";
            } else {
                state = "Running";
                header_state = "running";
            }
        } else if (this.getStatus() == 2) {
            if (this.isSuspended()) {
                state = "Running as standby suspended";
                header_state = "standby-suspended";
            } else {
                state = "Running as standby";
                header_state = "standby";
            }
        } else {
            state = "Not running. See logs.";
            header_state = "not-running";
        }
        response.setHeader("X-Cognos-ContentManager-State", header_state);
        this.outputHTMLValue(out, "State", state, "state");
        out.print("</body>");
        out.println("</html>");
    }

    private void outputHTMLValue(PrintWriter out, String sTitle, String sValue, String id) {
        String idAttr = id == null ? "" : " id=\"" + id + "\"";
        out.println("<span class=\"pname\">" + sTitle + ": </span>" + "<span class=\"pvalue\"" + idAttr + ">" + XMLUtils.escape((String)sValue, (boolean)false) + "</span><br/>");
    }

    public void setTimeStarted(String timeStarted) {
        this.timeStarted = timeStarted;
    }

    public String getTimeStarted() {
        return this.timeStarted;
    }

    public void setCurrentWebTime(String currentWebTimeString) {
        this.currentWebTime = currentWebTimeString;
    }

    public String getCurrentWebTime() {
        return this.currentWebTime;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setOMVersion(String version) {
        this.omVersion = version;
    }

    public void setReplyWithStatusCode(boolean replyWithStatusCode) {
        this.replyWithStatusCode = replyWithStatusCode;
    }

    private int getResponseStatusCode() {
        if (!this.replyWithStatusCode) {
            return 200;
        }
        switch (this.getStatus()) {
            case 1: {
                return 200;
            }
            case 2: {
                return 503;
            }
        }
        return 500;
    }
}

