/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.InstalledComponentsCache;
import com.cognos.cm.util.DOMUtils;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComponentDependentCapabilities {
    private static HashMap<String, String> capabilityToComponent;

    public static boolean isCapabilitySupported(String capability) {
        String component = capabilityToComponent.get(capability);
        return component == null || InstalledComponentsCache.getInstance().isComponentInstalled(component);
    }

    public static void init(Document doc) throws CMException {
        capabilityToComponent = new HashMap();
        Element root = doc.getDocumentElement();
        Element installedComponents = DOMUtils.element(root, "componentCapabilities");
        if (installedComponents == null) {
            throw ComponentDependentCapabilities.configurationError();
        }
        for (Node node : ComponentDependentCapabilities.childElements(installedComponents)) {
            Element component = (Element)node;
            for (Node item : ComponentDependentCapabilities.childElements(node)) {
                capabilityToComponent.put(item.getTextContent(), component.getAttribute("name"));
            }
        }
    }

    private static CMException configurationError() {
        return new CMConfigurationException("cmBadConfigFile", new CMException.Parm("File", "cmMetadata.xml"));
    }

    private static Iterable<Node> childElements(final Node parent) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return DOMUtils.elementIterator(parent);
            }
        };
    }
}

