/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.server.CMConfiguration;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.IConfiguration;

public class ConfigurationFactory {
    private static IConfiguration config_ = null;
    private static ICCLConfiguration cclConfig = null;

    public static IConfiguration getConfig() {
        if (config_ == null) {
            throw new IllegalStateException("No configuration has been loaded via ConfigurationFactory.setConfig");
        }
        return config_;
    }

    public static IConfiguration getConfig(ICCLConfiguration icclconfig) {
        try {
            if (config_ == null) {
                ConfigurationFactory.setConfig(new CMConfiguration(icclconfig));
            }
            return config_;
        }
        catch (CMConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static IConfiguration newConfig(ICCLConfiguration icclconfig) {
        try {
            ConfigurationFactory.setConfig(new CMConfiguration(icclconfig));
            return ConfigurationFactory.getConfig();
        }
        catch (CMConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized ICCLConfiguration getCCLConfig() {
        if (cclConfig == null) {
            cclConfig = CCLConfigurationFactory.getInstance();
            try {
                cclConfig.init();
            }
            catch (CCLConfigurationException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }
        return cclConfig;
    }

    public static void setConfig(IConfiguration config) {
        config_ = config;
    }

    public static void resetConfig() {
        config_ = null;
    }

    public static void useFakeConfig() {
        config_ = new CMConfiguration(System.getProperties());
    }

    public static boolean isConfigLoaded() {
        return config_ != null;
    }
}

