/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.cmInfo;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.DiagnosticsConfiguration;
import com.cognos.cm.diagnostics.DiagnosticsManager;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.Servlet;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.testing.TestSuiteFactory;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.perfMonitor.PerfContext;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.pdk.Configuration;
import com.ibm.cognos.pogo.zipi.ZipiWrappedServlet;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.SAXException;

public class ContentManager
extends ZipiWrappedServlet {
    public static DiagnosticsManager diagnosticsManager = new DiagnosticsManager(ContentManager.class);
    private static final long serialVersionUID = -7421564903260338945L;
    public static final PerfTimer PERF_TIMER_IN_CM = PerfMonitor.getThreadLocalTimer((String)"com.cognos.cm.server.inCM", (String)"Total time spent in CM", (int)6);
    public static final Counter inCM = new AccumulatingCounter().makeThreadLocal();
    public static final Timer inCMTimer = new Timer(inCM);
    public static boolean isStandalone_ = false;
    public static boolean startedSelf_ = false;
    public static String startedSelfReason_ = null;
    public static Servlet servlet_;
    static int CMThreadRunningCount;
    private static ContentManager instance_;
    private long startRequestSystemMillis_ = 0L;
    private static long nActiveThreadCount_;
    public static File rootDir_;
    private static RequestReporter reporter_;

    public static ContentManager getInstance() {
        return instance_;
    }

    public ContentManager() {
        ContentManager.setInstance(this);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ZipiStorage.setCurrentService((String)"contentManagerService");
        try {
            super.service(request, response);
        }
        finally {
            ZipiStorage.clearCurrentService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PerfContext mCtx = PerfContext.get();
        mCtx.setRecording(false);
        diagnosticsManager.reset();
        try {
            PerfTimer timer = this.enterCM();
            try {
                if (servlet_ != null) {
                    inCMTimer.start();
                    servlet_.doPost(request, response, this.startRequestSystemMillis_);
                } else {
                    this.notStartedResponse(response);
                }
            }
            finally {
                inCMTimer.stop();
                this.exitCM(timer);
            }
        }
        finally {
            mCtx.reset();
            diagnosticsManager.update();
        }
    }

    public static long getActiveThreadCount() {
        return nActiveThreadCount_;
    }

    public static synchronized void incrementActiveThreadCount(long nIncr) {
        if ((nActiveThreadCount_ += nIncr) < 0L) {
            nActiveThreadCount_ = 0L;
        }
    }

    public void destroy() {
        if (servlet_ != null) {
            ContentManager.stop();
        }
    }

    public void init() {
        PerfContext mCtx = PerfContext.get();
        mCtx.setRecording(false);
        ServletContext context = this.getServletContext();
        context.setAttribute("com.cognos.cm.server.ContentManager", (Object)this);
        rootDir_ = new File(".");
        this.initializeLogging();
        boolean CMShouldStartItSelf = this.shouldStartStandAlone();
        if (CMShouldStartItSelf) {
            startedSelf_ = true;
            ContentManager.start();
        } else if (servlet_ != null) {
            servlet_.init();
        }
        mCtx.reset();
    }

    private void initializeLogging() {
        try {
            CMIndications.initialize();
        }
        catch (CMConfigurationException ex) {
            this.log("***** FATAL ERROR, UNABLE TO INITIALIZE LOGGING: *****", ex);
        }
    }

    private static void startHook() {
        if (ContentManager.isTestMode()) {
            Thread runner = TestSuiteFactory.getTestRunner();
            System.out.println("Content Manager loaded test thread: " + runner.getName());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (servlet_ != null) {
            servlet_.doGet(request, response);
        } else {
            this.notStartedResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ExecuteStaticRequest(File inputFile, File outputFile) {
        if (servlet_ == null) {
            return;
        }
        PerfContext mCtx = PerfContext.get();
        mCtx.setRecording(false);
        try {
            servlet_.ExecuteStaticRequest(inputFile, outputFile);
        }
        finally {
            mCtx.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ExecuteStaticRequest(String request) {
        if (servlet_ == null) {
            return null;
        }
        PerfContext mCtx = PerfContext.get();
        mCtx.setRecording(false);
        try {
            String string = servlet_.ExecuteStaticRequest(request);
            return string;
        }
        finally {
            mCtx.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ExecuteStaticRequest(String request, boolean mustBeInitialized, boolean bodyRequest) {
        if (servlet_ == null) {
            return null;
        }
        PerfContext mCtx = PerfContext.get();
        mCtx.setRecording(false);
        try {
            String string = servlet_.ExecuteStaticRequest(request, mustBeInitialized, bodyRequest);
            return string;
        }
        finally {
            mCtx.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ExecuteStaticRequest(String request, boolean trusted) {
        if (trusted) {
            return this.ExecuteStaticRequest(request);
        }
        if (servlet_ == null) {
            return null;
        }
        PerfContext mCtx = PerfContext.get();
        mCtx.setRecording(false);
        try {
            String string = servlet_.ExecuteUntrustedStaticRequest(request, true);
            return string;
        }
        finally {
            mCtx.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ExecuteStaticRequest(String passportID, XMLDoc request, XMLElement originalHeader, boolean trusted, OutputStream os) throws SAXException, CMException {
        if (trusted) {
            // empty if block
        }
        if (servlet_ == null) {
            return;
        }
        PerfContext mCtx = PerfContext.get();
        mCtx.setRecording(false);
        try {
            servlet_.ExecuteUntrustedStaticRequest(passportID, request, originalHeader, true, os);
        }
        finally {
            mCtx.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executePluginRequest(String request, boolean asSysAdmin) {
        if (servlet_ == null) {
            return null;
        }
        PerfContext mCtx = PerfContext.get();
        mCtx.setRecording(false);
        try {
            String string = servlet_.executePluginRequest(request, asSysAdmin);
            return string;
        }
        finally {
            mCtx.reset();
        }
    }

    public static void setReporter(RequestReporter reporter) {
        reporter_ = reporter;
        ContentManager.reportRunningStatus();
    }

    private static void reportRequestReceived() {
        if (reporter_ != null) {
            reporter_.incrementInitialRequests("contentManagerService");
        }
    }

    public static void reportRequestFailure(long elapsedTime) {
        if (reporter_ != null) {
            reporter_.reportFailure(elapsedTime);
        }
    }

    public static void reportRequestSuccess(long elapsedTime) {
        if (reporter_ != null) {
            reporter_.reportSuccess(elapsedTime);
        }
    }

    public static void reportRunningStatus() {
        if (reporter_ != null && servlet_ != null && !startedSelf_) {
            if (CMServlet.CMisSuspended_) {
                reporter_.setServiceStatus("suspended");
            } else if (CMServlet.CMRunningMode_ == 1) {
                reporter_.setServiceStatus("running");
            } else if (CMServlet.CMRunningMode_ == 2) {
                reporter_.setServiceStatus("standby");
            } else if (CMServlet.CMRunningMode_ == 0) {
                reporter_.setServiceStatus(ServiceStatus.UNKNOWN);
            }
        }
    }

    public static void start() {
        ContentManager.startHook();
        DiagnosticsConfiguration.configure();
        if (servlet_ != null) {
            DiagnosticsConfiguration.systemConfigurationLoaded();
        } else {
            servlet_ = ContentManager.getServlet();
            CMResourceUtils.initialize();
            DiagnosticsConfiguration.systemConfigurationLoaded();
            servlet_.init();
            int cmMode = CMServlet.CMRunningMode_;
            switch (cmMode) {
                case 1: {
                    ContentManager.runningModeHook();
                    break;
                }
                default: {
                    ContentManager.notRunningModeHook(cmMode);
                }
            }
        }
    }

    private static void runningModeHook() {
        if (startedSelf_) {
            System.out.println("Content Manager is running.");
        }
        if (ContentManager.isTestMode()) {
            Thread runner = TestSuiteFactory.getTestRunner();
            System.out.println("Content Manager starting test suite: " + runner.getClass().getName());
            runner.start();
        }
    }

    private static void notRunningModeHook(int cmMode) {
        if (ContentManager.isTestMode()) {
            System.err.println("Content Manager is NOT running (mode=" + cmMode + ")! Check your logs.");
            System.exit(1);
        }
    }

    private static Servlet getServlet() {
        return new CMServlet(isStandalone_);
    }

    public static boolean isTestMode() {
        return TestSuiteFactory.isTestMode();
    }

    public static void suspend() {
        if (servlet_ != null && CMServlet.CMRunningMode_ != 0) {
            CMServlet.suspend();
            ContentManager.reportRunningStatus();
        }
    }

    public static void resume() {
        if (servlet_ != null && CMServlet.CMRunningMode_ != 0) {
            CMServlet.resume();
            ContentManager.reportRunningStatus();
        }
    }

    public static void stop() {
        if (servlet_ != null) {
            servlet_.destroy();
        }
        servlet_ = null;
    }

    public static void reconfigure(Configuration configuration) {
        if (servlet_ != null) {
            servlet_.reconfigure(configuration);
        }
    }

    public static void configure(Configuration configuration) {
        if (servlet_ != null) {
            servlet_.reconfigure(configuration);
        }
    }

    public static void allServicesStarted() {
        if (servlet_ != null) {
            servlet_.startSDSConnector();
            servlet_.startIndexConnector();
            servlet_.startSynchromeshConnector();
        }
    }

    public static Servlet startStandalone() {
        isStandalone_ = true;
        startedSelf_ = true;
        try {
            CMIndications.initialize();
        }
        catch (CMConfigurationException ex) {
            System.err.println("***** FATAL ERROR, UNABLE TO START LOGGING: *****");
            ex.printStackTrace();
        }
        ContentManager.start();
        return servlet_;
    }

    public static void main(String[] args) throws CMException {
        ContentManager.startStandalone();
    }

    public void notStartedResponse(HttpServletResponse response) throws ServletException {
        try {
            System.gc();
            PrintWriter out = response.getWriter();
            response.setContentType("text/xml");
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            out.println("\t<SOAP-ENV:Header>");
            out.println("\t\t<bus:biBusHeader xsi:type=\"bus:biBusHeader\">");
            out.println("\t\t\t<tracking xsi:type=\"bus:tracking\">");
            out.println("\t\t\t\t<providers xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:provider[1]\">");
            out.println("\t\t\t\t\t<provider xsi:type=\"bus:provider\">");
            out.println("\t\t\t\t\t\t<name xsi:type=\"xsd:string\">cm</name>");
            out.println("\t\t\t\t\t\t<patch xsi:type=\"xsd:int\">1</patch>");
            out.println("\t\t\t\t\t\t<build xsi:type=\"xsd:string\">" + cmInfo.getVersion() + "</build>");
            out.println("\t\t\t\t\t</provider>");
            out.println("\t\t\t\t</providers>");
            out.println("\t\t\t</tracking>");
            out.println("\t\t</bus:biBusHeader>");
            out.println("\t</SOAP-ENV:Header>");
            out.println("\t<SOAP-ENV:Body>");
            out.println("\t<SOAP-ENV:Fault>");
            out.println("\t\t<faultcode>Client</faultcode>");
            out.println("\t\t<faultstring>" + CMError.getMessage("cmGeneralClientError", null, null) + "</faultstring>");
            out.println("\t\t<detail>");
            out.println("\t\t\t<bus:exception>");
            out.println("\t\t\t\t<severity>error</severity>");
            out.println("\t\t\t\t<errorCode>cmNotRunning</errorCode>");
            out.println("\t\t\t\t<bus:message>");
            out.println("\t\t\t\t\t<messageString>" + CMError.getMessage("cmNotRunning", null, null) + "</messageString>");
            out.println("\t\t\t\t</bus:message>");
            out.println("\t\t\t</bus:exception>");
            out.println("\t\t</detail>");
            out.println("\t</SOAP-ENV:Fault>");
            out.println("\t</SOAP-ENV:Body>");
            out.println("</SOAP-ENV:Envelope>");
        }
        catch (Exception ex) {
            throw new ServletException("Content Manager has not been started.");
        }
    }

    private boolean shouldStartStandAlone() {
        boolean bStartStandAlone = false;
        try {
            String sCMStartStandAlone = this.getInitParameter("CMStartStandAlone");
            if (sCMStartStandAlone != null) {
                bStartStandAlone = Boolean.valueOf(sCMStartStandAlone);
                startedSelfReason_ = "CMStartStandAlone=" + sCMStartStandAlone + " present in servlet configuration.";
            }
        }
        catch (Exception e) {
            System.err.println("Content Manager failed to determine startStandAlone status, assuming dispatcher will start us: " + e);
            bStartStandAlone = false;
        }
        return bStartStandAlone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerfTimer enterCM() {
        PERF_TIMER_IN_CM.start();
        this.startRequestSystemMillis_ = System.currentTimeMillis();
        Class<ContentManager> clazz = ContentManager.class;
        synchronized (ContentManager.class) {
            if (AdvancedSettings.MAXREQUESTS > 0) {
                while (CMThreadRunningCount >= AdvancedSettings.MAXREQUESTS) {
                    try {
                        ContentManager.class.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ++CMThreadRunningCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ContentManager.incrementActiveThreadCount(1L);
            ContentManager.reportRequestReceived();
            return PERF_TIMER_IN_CM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitCM(PerfTimer timer) {
        timer.stop();
        ContentManager.incrementActiveThreadCount(-1L);
        Class<ContentManager> clazz = ContentManager.class;
        synchronized (ContentManager.class) {
            if (AdvancedSettings.MAXREQUESTS > 0 || --CMThreadRunningCount == 0) {
                ContentManager.class.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void setInstance(ContentManager cm) {
        instance_ = cm;
    }

    static {
        CMThreadRunningCount = 0;
        nActiveThreadCount_ = 0L;
        rootDir_ = null;
        reporter_ = null;
    }
}

