/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRule;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.IExpirationTimeUpdater;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cmutils.date.DateUtils;
import com.cognos.cmutils.date.Duration;
import java.util.ArrayList;
import java.util.Date;

public class ExpirationTimeUpdater
implements IExpirationTimeUpdater {
    private CMStore store;

    public ExpirationTimeUpdater(CMStore store) {
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExpirationTime(CMRetentionRule rule, String path, boolean updateAll) throws CMException {
        String duration = rule.getMaxDuration();
        if (null == duration && !updateAll) {
            return;
        }
        Date expirationDate = null;
        Date creationDate = null;
        ArrayList<CMProperty> propNames = new ArrayList<CMProperty>();
        ArrayList<Object> propValues = new ArrayList<Object>();
        propNames.add(CMProperty.EXPIRATIONTIME);
        StringBuffer buf = this.getPathWithClassFilter(rule, path);
        if (!updateAll) {
            buf.append("[").append("not(@").append(this.getExpirationTimeProperty().getName()).append(")").append("]");
        }
        CMStorePath affectedObjectsPath = this.getCMStoreXPath(buf.toString());
        CMStoreQueryResults results = null;
        try {
            results = this.store.executeQuery(affectedObjectsPath, new CMProperty[]{CMProperty.CREATIONTIME}, null, 7, 512, null);
            while (results.next()) {
                Object value = results.getValue(0);
                if (value != null) {
                    creationDate = DateUtils.parse((String)value.toString());
                    if (null != duration) {
                        Duration durationObj = new Duration(duration);
                        expirationDate = durationObj.addTo(creationDate);
                    }
                }
                String storeID = this.store.getObjectStoreID(results.getObjectID());
                CMStoreXPath storePath = CMStoreXPath.fromStoreID(storeID);
                CMStoreQueryResults oneObjectResults = null;
                try {
                    oneObjectResults = this.store.executeQuery(storePath, null, null, 7, 512, null);
                    if (oneObjectResults == null || !oneObjectResults.next()) continue;
                    propValues.clear();
                    if (null == duration) {
                        propValues.add(null);
                    } else {
                        propValues.add(CMDateUtils.getIsoDate(expirationDate));
                    }
                    oneObjectResults.reset();
                    this.store.update(oneObjectResults, propNames, propValues);
                }
                finally {
                    if (oneObjectResults == null) continue;
                    oneObjectResults.release();
                }
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
        }
    }

    private StringBuffer getPathWithClassFilter(CMRetentionRule rule, String path) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(path);
        buffer.append("/*");
        buffer.append(ContentObjectSelectionRule.getPredicateForObjectClasses(this.getObjectClassNames(rule.getObjectClass().getDerivedClasses())));
        return buffer;
    }

    private String[] getObjectClassNames(ArrayList<CMObjectClass> objectClasses) {
        String[] classNames = new String[objectClasses.size()];
        for (int i = 0; i < objectClasses.size(); ++i) {
            classNames[i] = objectClasses.get(i).getName();
        }
        return classNames;
    }

    protected CMStorePath getCMStoreXPath(String path) throws CMStoreParseException {
        return new CMStoreXPath(path);
    }

    protected CMProperty getExpirationTimeProperty() {
        return CMProperty.EXPIRATIONTIME;
    }
}

