/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ComponentDependentCapabilities;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMSOAPWriter;
import com.cognos.cmutils.url.CMURLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class ExtendedUserCapabilities {
    public static final CMPropertyTypes.Type BIBUS_USERCAPABILITYENUM = new CMPropertyTypes.Type(CMSOAPConstants.NS_BIBUS, "userCapabilityEnum");
    private static final String CAPABILITIES_QUERY = "/capability/descendant::*[@objectClass='securedFunction' or @objectClass='securedFeature' or @objectClass='productCapability']";
    private static final String EXECUTE_PERMISSION = "[permission('execute')]";
    private static final char WORD_SEPARATOR = ';';
    private static final char SIGNATURE_SEPARATOR = '&';
    private static final int MAX_LEGACY_BIT = 127;
    private static final int SHIFT = 5;
    private static Signer signer = new Signer();
    private static String[] orderedCapabilities;
    private static int maxBitIndex;
    private static int maxLegacyBitIndex;
    private int[] capabilitiesBitSet;
    private String legacySignature;
    private String extendedSignature;

    public static void init() {
        ArrayList<String> allCaps = CMProperty.USERCAPABILITY.getSupportedEnumValues();
        maxBitIndex = CMProperty.USERCAPABILITY.getMaxBitIndex();
        maxLegacyBitIndex = Math.min(maxBitIndex, 127);
        orderedCapabilities = new String[maxBitIndex + 1];
        for (String capability : allCaps) {
            int bitIdx = ExtendedUserCapabilities.getCapabilityIndex(capability);
            ExtendedUserCapabilities.orderedCapabilities[bitIdx] = capability;
        }
    }

    public static ExtendedUserCapabilities create(boolean isSysAdmin) throws CMException {
        return new ExtendedUserCapabilities(ExtendedUserCapabilities.queryCapabilities(isSysAdmin));
    }

    protected ExtendedUserCapabilities(List<String> caps) throws CMException {
        this.capabilitiesBitSet = this.toBitSet(caps);
        this.extendedSignature = signer.createExtendedSignature(this.encodeBits(maxBitIndex));
        String s = ExtendedUserCapabilities.writeCapabilitiesAsXML(this.getLegacyCapabilities());
        this.legacySignature = signer.createLegacySignature(s);
    }

    public List<String> getCapabilities() {
        return this.getUserCapabilities(maxBitIndex);
    }

    public List<String> getLegacyCapabilities() {
        return this.getUserCapabilities(maxLegacyBitIndex);
    }

    public boolean hasCapability(String value) {
        int idx = ExtendedUserCapabilities.getCapabilityIndex(value);
        if (idx == -1) {
            return false;
        }
        return (this.capabilitiesBitSet[ExtendedUserCapabilities.wordIndex(idx)] & 1 << idx) != 0;
    }

    public String getUserCapabilityCacheValue() {
        return ExtendedUserCapabilities.writeCapabilitiesAsXML(this.getLegacyCapabilities()) + "<signature xsi:type=\"xsd:base64Binary\">" + this.legacySignature + "</signature>";
    }

    public String getLegacyCookieValue() {
        return CMURLEncoder.encode((String)(this.encodeBits(maxLegacyBitIndex) + '&' + this.legacySignature));
    }

    public String getCookieValue() {
        return CMURLEncoder.encode((String)(this.encodeBits(maxBitIndex) + '&' + this.extendedSignature));
    }

    private static int getCapabilityIndex(String capability) {
        return CMProperty.USERCAPABILITY.getEnumValueBitIndex(capability);
    }

    private static int wordIndex(int bit) {
        return bit >> 5;
    }

    private String encodeBits(int maxBit) {
        StringBuilder buf = new StringBuilder();
        for (int n = this.getFirstWord(maxBit); n != 0; --n) {
            buf.append(Integer.toHexString(this.capabilitiesBitSet[n]));
            buf.append(';');
        }
        buf.append(Integer.toHexString(this.capabilitiesBitSet[0]));
        return buf.toString();
    }

    private ArrayList<String> getUserCapabilities(int maxBit) {
        ArrayList<String> result = new ArrayList<String>();
        int maxWord = ExtendedUserCapabilities.wordIndex(maxBit) + 1;
        for (int n = 0; n < maxWord; ++n) {
            if (this.capabilitiesBitSet[n] == 0) continue;
            int offset = n << 5;
            for (int i = 0; i < 32; ++i) {
                if ((this.capabilitiesBitSet[n] & 1 << i) == 0) continue;
                result.add(orderedCapabilities[offset + i]);
            }
        }
        return result;
    }

    private int[] toBitSet(List<String> caps) {
        int[] result = new int[ExtendedUserCapabilities.wordIndex(maxBitIndex) + 1];
        for (String s : caps) {
            int wi;
            int idx = ExtendedUserCapabilities.getCapabilityIndex(s);
            int n = wi = ExtendedUserCapabilities.wordIndex(idx);
            result[n] = result[n] | 1 << idx;
        }
        return result;
    }

    private int getFirstWord(int maxBit) {
        int n;
        for (n = ExtendedUserCapabilities.wordIndex(maxBit); n != 0 && this.capabilitiesBitSet[n] == 0; --n) {
        }
        return n;
    }

    private static String writeCapabilitiesAsXML(List<String> caps) {
        StringBuilder buf = new StringBuilder();
        CMSOAPWriter wrt = new CMSOAPWriter(buf);
        wrt.setTrackNamespaces(false);
        ((CMSOAPWriter)wrt.element("userCapabilities")).arrayType(BIBUS_USERCAPABILITYENUM, caps.size());
        for (String cap : caps) {
            ((CMSOAPWriter)((CMSOAPWriter)wrt.element("item")).type(BIBUS_USERCAPABILITYENUM).text(cap)).end();
        }
        wrt.end();
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> queryCapabilities(boolean returnAll) throws CMException {
        String query2 = CAPABILITIES_QUERY + (returnAll ? "" : EXECUTE_PERMISSION);
        CMStoreXPath path = new CMStoreXPath(query2);
        CMProperty[] props = new CMProperty[]{CMProperty.USERCAPABILITY, CMObjectClass.PRODUCTCAPABILITY.getProperty("userCapability")};
        CMStore store = CMExecutionContext.get().getStore();
        boolean releaseLocks = false;
        ICMLockManager lockMgr = store.getLockManager();
        if (!lockMgr.hasLocks()) {
            releaseLocks = true;
            lockMgr.requestLocks(path);
        }
        ArrayList<String> capabilities = new ArrayList<String>();
        CMStoreQueryResults results = null;
        try {
            results = store.executeQuery(path, props, null, 0, 0, null);
            while (results.next()) {
                String capability;
                int propIdx = results.getObjectClass() == CMObjectClass.PRODUCTCAPABILITY ? 1 : 0;
                Object value = results.getValue(propIdx);
                if (value == null || !ComponentDependentCapabilities.isCapabilitySupported(capability = value.toString())) continue;
                capabilities.add(capability);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (releaseLocks) {
                lockMgr.releaseLocks();
            }
        }
        return capabilities;
    }

    static class Signer {
        Signer() {
        }

        String createLegacySignature(String value) throws CMException {
            try {
                GenericTrustedSession ses = CMServlet.CAMFactory_.createGenericTrustedSession();
                String passportID = CMExecutionContext.get().getAccManPassportID();
                byte[] signature = ses.createTrustToken(value.getBytes(StandardCharsets.UTF_8), passportID);
                return new String(signature, StandardCharsets.UTF_8);
            }
            catch (CAMCryptoException e) {
                throw new CMException((Exception)((Object)e), "cmUnexpectedError");
            }
        }

        String createExtendedSignature(String value) throws CMException {
            try {
                SigningSession ses = CMServlet.CAMFactory_.createSigningSession();
                String passportID = CMExecutionContext.get().getAccManPassportID();
                if (passportID != null) {
                    value = passportID + value;
                }
                byte[] signature = ses.hmac(value.getBytes(StandardCharsets.UTF_8));
                byte[] base642 = Base64.getEncoder().encode(signature);
                return new String(base642, StandardCharsets.UTF_8);
            }
            catch (CAMCryptoException e) {
                throw new CMException((Exception)((Object)e), "cmUnexpectedError");
            }
        }
    }
}

