/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.IExternalObjectStore;
import com.cognos.cmutils.system.SystemUtils;
import com.cognos.cmutils.url.FileURIUtils;
import java.io.File;
import java.io.IOException;

public class ExternalObjectStore
implements IExternalObjectStore {
    private boolean migrateContentToRepository;
    private String winFileStoreURI;
    private String unixFileStoreURI;

    ExternalObjectStore(boolean migrateContentToRepository, String winFileStoreURI, String unixFileStoreURI) throws CMConfigurationException {
        this.migrateContentToRepository = migrateContentToRepository;
        this.winFileStoreURI = winFileStoreURI != null ? winFileStoreURI : "";
        this.unixFileStoreURI = unixFileStoreURI != null ? unixFileStoreURI : "";
        this.validate();
    }

    private void validate() throws CMConfigurationException {
        String mandatoryURI = this.getOSFileStoreURI();
        if (mandatoryURI.isEmpty()) {
            throw new CMConfigurationException("cmConfigDatabaseError", new CMException.Parm("Name", ExternalObjectStore.getOSSpecificParameterName()));
        }
    }

    @Override
    public boolean isMigrateContentToRepository() {
        return this.migrateContentToRepository;
    }

    @Override
    public String getWinFileStoreURI() {
        return this.winFileStoreURI;
    }

    @Override
    public String getUnixFileStoreURI() {
        return this.unixFileStoreURI;
    }

    @Override
    public boolean isEnabled() {
        return !this.unixFileStoreURI.isEmpty() || !this.winFileStoreURI.isEmpty();
    }

    @Override
    public String getOSFileStoreURI() {
        if (SystemUtils.isRunningWindows()) {
            return this.getWinFileStoreURI();
        }
        return this.getUnixFileStoreURI();
    }

    @Override
    public String getOSFileStorePath() {
        return FileURIUtils.getPathFromURI((String)this.getOSFileStoreURI());
    }

    public static String getOSSpecificParameterName() {
        if (SystemUtils.isRunningWindows()) {
            return "winURI";
        }
        return "unixURI";
    }

    @Override
    public TestResult test() {
        String uriPath = this.getOSFileStoreURI();
        if (uriPath.isEmpty()) {
            return TestResult.CONFIG_ERROR;
        }
        File file = new File(this.getOSFileStorePath());
        boolean exists = file.exists();
        if (!exists) {
            return TestResult.REACH_ERROR;
        }
        TestResult result = TestResult.SUCCESS;
        result = this.testPermissions(file);
        return result;
    }

    private TestResult testPermissions(File eosRoot) {
        File testFile;
        try {
            testFile = File.createTempFile("eosTest", ".tmp", eosRoot);
        }
        catch (IOException e) {
            return TestResult.WRITE_ERROR;
        }
        if (!testFile.canRead() || eosRoot.list() == null) {
            return TestResult.READ_ERROR;
        }
        if (!testFile.canWrite()) {
            return TestResult.WRITE_ERROR;
        }
        try {
            testFile.delete();
            if (testFile.exists()) {
                return TestResult.WRITE_ERROR;
            }
        }
        catch (Exception e) {
            return TestResult.WRITE_ERROR;
        }
        return TestResult.SUCCESS;
    }

    public static enum TestResult {
        SUCCESS,
        CONFIG_ERROR,
        REACH_ERROR,
        READ_ERROR,
        WRITE_ERROR;

    }
}

