/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InstalledComponentsCache {
    private static InstalledComponentsCache singleton = new InstalledComponentsCache();
    protected static final PerfTimer QUERIES = PerfMonitor.getTimer((String)"com.cognos.cm.server.InstalledComponentsCache.queries", (String)"The number of installedComponent queries.", (int)6);
    private Set<String> installedComponents;
    private static final String INSTALLED_COMPONENTS_QUERY = "/configuration//installedComponent";

    public static InstalledComponentsCache getInstance() {
        return singleton;
    }

    public static void resetSingleton() {
        singleton = new InstalledComponentsCache();
    }

    private InstalledComponentsCache() {
    }

    public synchronized Set<String> getInstalledComponents() {
        if (this.installedComponents == null) {
            this.installedComponents = this.refreshInstalledComponents();
        }
        return this.installedComponents;
    }

    public synchronized void setInstalledComponents(Set<String> set) {
        this.installedComponents = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> refreshInstalledComponents() {
        QUERIES.start();
        CMStoreQueryResults results = null;
        HashSet<String> newInstalledComponents = new HashSet<String>();
        try {
            results = this.executeComponentsQuery();
            if (results != null) {
                this.addResultsToSet(newInstalledComponents, results);
            }
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        finally {
            if (results != null) {
                results.release();
            }
            QUERIES.stop();
        }
        return Collections.unmodifiableSet(newInstalledComponents);
    }

    private CMStoreQueryResults executeComponentsQuery() throws CMException {
        CMStoreQueryResults results;
        CMStorePath objectContext = null;
        try {
            objectContext = CMStoreXPath.parse(INSTALLED_COMPONENTS_QUERY);
        }
        catch (CMStoreParseException ex) {
            throw new IllegalStateException("bad path: " + ex.toString());
        }
        CMStore store = CMExecutionContext.get().getStore();
        CMProperty[] props = new CMProperty[1];
        CMObjectClass installedComp = CMObjectClass.INSTALLEDCOMPONENT;
        props[0] = store.getProperty("componentID", installedComp);
        try {
            results = store.executeQuery(objectContext, props, null, 0, 512, null);
        }
        catch (CMStoreObjectNotFound e) {
            results = null;
        }
        return results;
    }

    private Set<String> addResultsToSet(Set<String> set, CMStoreQueryResults results) throws CMException {
        while (results.next()) {
            Object value = results.getValue(0);
            if (value == null) continue;
            set.add(value.toString());
        }
        return set;
    }

    public boolean isComponentInstalled(String componentID) {
        return this.getInstalledComponents().contains(componentID);
    }
}

