/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMLocalePreference;
import com.cognos.cm.server.ExtendedUserCapabilities;
import com.cognos.cm.server.LicenseReport;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class LicenseManager {
    private static final String LICENSES_JSON = "licenses.json";
    private static LicenseManager instance = null;
    private HashMap<String, Integer> licenceCaps;
    private int maxLevel = -1;
    private HashMap<String, LicenseReport> reports = new HashMap();
    private ArrayList<String> licenseNames;

    public static void initialize(CMStore store) {
        instance = new LicenseManager(store);
    }

    public static LicenseManager getInstance() {
        return instance;
    }

    private LicenseManager(CMStore store) {
        this.processLicenseDefinitions();
    }

    public int getMaxLicenseLevel() {
        return this.maxLevel;
    }

    private int getCurrentUserTenantId(String tenant) throws CMException {
        CMExecutionContext ex = CMExecutionContext.get();
        TenantRegistry registry = ex.getStore().getTenantRegistry();
        int tenantId = -9999;
        if (tenant != null) {
            tenantId = registry.getTenantIdIntFromString(tenant, false);
        }
        if (registry.getTenantCount() < 2) {
            return 0;
        }
        if (ex.hasUnfilteredAdminAccess()) {
            return tenantId;
        }
        if (tenant != null && ex.hasReadTenantFilter() && (ex.isTenantAdministrator() || ex.getCurrentUserIsAdministrator())) {
            for (int t : ex.getReadTenantIds()) {
                if (t != tenantId) continue;
                return tenantId;
            }
        }
        return ex.getCurrentUserTenantId();
    }

    public synchronized LicenseReport getReport(String tenant, boolean refresh) throws CMException {
        LicenseReport report;
        int tenantId = this.getCurrentUserTenantId(tenant);
        String key = this.getReportLookupKey(tenantId);
        if (refresh && (report = this.reports.remove(key)) != null) {
            report.delete();
        }
        if ((report = this.reports.get(key)) == null && (report = new LicenseReport(this.maxLevel, key)).execute((CMDbStore)CMExecutionContext.get().getStore(), tenantId)) {
            this.reports.put(key, report);
        }
        return report;
    }

    private String getReportLookupKey(int tenantId) {
        return this.getProductLocale().toString() + '$' + tenantId;
    }

    public void updateUserLicenseLevel() {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (ctx.getContext().getCurrentUserSession().isAnonymousUser()) {
            return;
        }
        try {
            int level = this.getLicenceLevel(ctx);
            String capabilities = this.getCapabilitiesString(ctx);
            Timestamp loginTime = this.getLoginTime();
            this.updateAccountLicenceInfo(ctx, level, capabilities, loginTime);
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
    }

    public String getLicenseName(int level) {
        if (level >= this.licenseNames.size()) {
            return null;
        }
        String id = this.licenseNames.get(level);
        Locale locale = this.getProductLocale().toLocale();
        return CMError.getRLMessage(id, locale);
    }

    private CMLocalePreference getProductLocale() {
        return CMExecutionContext.get().getRequestLocale("productLocale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccountLicenceInfo(CMExecutionContext ctx, int level, String capabilities, Timestamp loginTime) throws CMException {
        CMStore store = ctx.getStore();
        CMStoreQueryResults rs = null;
        try {
            List<CMProperty> props = this.getProperties(store, "account", "_license", "lastLogin", "_capabilities");
            List<Object> values = Arrays.asList(level, loginTime, capabilities);
            String path = ctx.getCurrentUserInternalPath();
            CMStoreXPath xpath = new CMStoreXPath(path, 13);
            store.getLockManager().requestLocks(xpath);
            store.beginTransaction();
            rs = store.executeQuery(xpath, null, null, 7, 512, null);
            if (rs.next()) {
                rs.reset();
                store.update(rs, props, values);
                rs.release();
                rs = null;
            }
            store.commitTransaction();
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(rs);
            try {
                store.rollbackOpenTransaction();
            }
            catch (CMException cMException) {
                // empty catch block
            }
            store.getLockManager().releaseLocks();
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(rs);
        try {
            store.rollbackOpenTransaction();
        }
        catch (CMException cMException) {
            // empty catch block
        }
        store.getLockManager().releaseLocks();
    }

    private List<CMProperty> getProperties(CMStore store, String className, String ... properties) {
        CMObjectClass cls = store.getObjectClasses().getClassByName(className);
        ArrayList<CMProperty> result = new ArrayList<CMProperty>(properties.length);
        for (String prop : properties) {
            result.add(cls.getProperty(prop));
        }
        return result;
    }

    private int getLicenceLevel(CMExecutionContext ctx) throws CMException {
        ExtendedUserCapabilities caps = ctx.getUserCapabilities();
        int maxLevel = -1;
        for (String s : caps.getCapabilities()) {
            Integer level = this.licenceCaps.get(s);
            if (level == null) continue;
            maxLevel = Math.max(maxLevel, level);
        }
        return maxLevel;
    }

    private String getCapabilitiesString(CMExecutionContext ctx) throws CMException {
        ExtendedUserCapabilities caps = ctx.getUserCapabilities();
        String cookie = caps.getCookieValue();
        int n = cookie.indexOf("%26");
        return cookie.substring(0, n).replace("%3B", ";");
    }

    private Timestamp getLoginTime() {
        boolean isDerby = CMDbConnection.dbms_ == 5;
        return CMDateUtils.getTimestamp(isDerby);
    }

    public JSONObject loadLicenseDefinitions() {
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        InputStream is = null;
        String fileName = "/WEB-INF/cm/licenses.json";
        try {
            is = resourceLoader.getResourceInputStream(fileName);
            if (is != null) {
                return JSONObject.parse((InputStream)is);
            }
        }
        catch (IOException e) {
            IOUtils.closeQuietly((InputStream)is);
            CMConfigurationException ee = new CMConfigurationException("cmNoConfigFile", new CMException.Parm("File", fileName));
            CMIndications.logException(ee);
        }
        return null;
    }

    private void processLicenseDefinitions() {
        JSONObject defs = this.loadLicenseDefinitions();
        if (defs != null) {
            this.licenceCaps = new HashMap();
            this.licenseNames = new ArrayList();
            JSONArray licenses = (JSONArray)defs.get((Object)"licenses");
            for (Object o : licenses) {
                this.maxLevel = Math.max(this.maxLevel, this.processLicenseInfo((JSONObject)o));
            }
        }
    }

    private int processLicenseInfo(JSONObject item) {
        int level = ((Number)item.get((Object)"level")).intValue();
        for (String capability : (List)item.get((Object)"capabilities")) {
            this.licenceCaps.put(capability, level);
        }
        String name = (String)item.get((Object)"name");
        while (this.licenseNames.size() <= level) {
            this.licenseNames.add("");
        }
        this.licenseNames.set(level, name);
        return level;
    }
}

