/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.LicenseManager;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.JsonWriter;
import com.cognos.cm.util.csv.CSVWriter;
import com.cognos.cmutils.date.DateUtils;
import com.cognos.cmutils.tempcache.CMTempFileFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;

public class LicenseReport {
    private int[] counts;
    private String asOfTime;
    private File report;
    private String key;

    public LicenseReport(int maxLevel, String key) {
        this.counts = new int[maxLevel + 2];
        this.key = key;
    }

    public String getCreationTime() {
        return this.asOfTime;
    }

    public String getETag() {
        return this.asOfTime + '$' + this.key;
    }

    public String getSummary() {
        LicenseManager lm = LicenseManager.getInstance();
        JSONObject obj = new JSONObject();
        JSONArray licenses = new JSONArray();
        obj.put((Object)"licenses", (Object)licenses);
        for (int i = 0; i < this.counts.length; ++i) {
            int level = i == this.counts.length - 1 ? -1 : i;
            JSONObject license = new JSONObject();
            license.put((Object)"level", (Object)level);
            license.put((Object)"used", (Object)this.counts[i]);
            if (level != -1) {
                license.put((Object)"name", (Object)lm.getLicenseName(level));
            }
            licenses.add((Object)license);
        }
        obj.put((Object)"asOfTime", (Object)this.asOfTime);
        StringWriter sw = new StringWriter();
        JsonWriter jw = new JsonWriter(sw);
        try {
            jw.write(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sw.toString();
    }

    public InputStream getDetailedReport() throws IOException {
        if (this.report != null) {
            return CMTempFileFactory.getInstance().getInputStream(this.report);
        }
        return null;
    }

    public void delete() {
        if (!this.report.delete()) {
            this.report.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(CMDbStore store, int tenantId) {
        int defaultIsolation = -1;
        CMDbConnection con = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        CSVWriter csv = null;
        HashMap<Integer, String> tenantNames = null;
        try {
            tenantNames = this.initTenantNames(store);
            csv = this.createReportFile(tenantNames != null);
            con = store.getConnection();
            defaultIsolation = this.makeReadUncommitted(con);
            stmt = this.createStatement(con, tenantId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int level = this.writeRow(rs, csv, tenantNames);
                if (level < 0) continue;
                int n = level;
                this.counts[n] = this.counts[n] + 1;
            }
            if (csv.getError() != null) {
                throw csv.getError();
            }
            csv.close();
            this.asOfTime = CMDateUtils.getIsoDate();
            this.closeResultSet(rs);
            this.closeStatement(stmt);
            this.restoreTransactionIsolationLevel(con, defaultIsolation);
        }
        catch (Exception e) {
            try {
                if (csv != null) {
                    csv.close();
                }
                if (this.report != null) {
                    this.report.delete();
                    this.report = null;
                }
                CMIndications.logException(e);
                boolean bl = false;
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.restoreTransactionIsolationLevel(con, defaultIsolation);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.restoreTransactionIsolationLevel(con, defaultIsolation);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<Integer, String> initTenantNames(CMDbStore store) throws CMException {
        TenantRegistry tenantRegistry = store.getTenantRegistry();
        if (tenantRegistry.getTenantCount() < 2) {
            return null;
        }
        CMExecutionContext ex = CMExecutionContext.get();
        if (!ex.getCurrentUserIsAdministrator() && !ex.isTenantAdministrator()) {
            return null;
        }
        HashMap<Integer, String> tenantNames = new HashMap<Integer, String>();
        tenantNames.put(0, "");
        CMStoreQueryResults rs = null;
        CMStoreXPath path = new CMStoreXPath("/directory/tenants/*");
        store.getLockManager().requestLocks(path);
        try {
            rs = store.executeQuery(path, null, null, 0, 512, null);
            while (rs.next()) {
                String name = rs.getName();
                int tenantId = rs.getTenantID();
                tenantNames.put(tenantId, name);
            }
        }
        finally {
            rs.release();
            try {
                store.getLockManager().releaseLocks();
            }
            catch (CMException cMException) {}
        }
        return tenantNames;
    }

    private CSVWriter createReportFile(boolean includeTenant) throws IOException {
        this.report = CMTempFileFactory.getInstance().createTempFile();
        CSVWriter csv = new CSVWriter(CMTempFileFactory.getInstance().getOutputStream(this.report));
        csv.setLineSeparator("\r\n");
        csv.write("level").write("name").write("userId").write("lastLogon");
        if (includeTenant) {
            csv.write("tenant");
        }
        csv.endRecord();
        return csv;
    }

    private int writeRow(ResultSet rs, CSVWriter wrt, HashMap<Integer, String> tenantNames) throws SQLException {
        String userId = rs.getString(1);
        if (userId == null || userId.charAt(0) == ':') {
            return -1;
        }
        String userName = rs.getString(2);
        Timestamp ts = rs.getTimestamp(3);
        int licenseLevel = -1;
        String lastLogon = "";
        if (ts != null) {
            lastLogon = CMDateUtils.getIsoDate(ts, DateUtils.getDSTNeutralCalendar());
            licenseLevel = rs.getInt(4);
        }
        wrt.write(licenseLevel).write(userName).write(userId).write(lastLogon);
        if (tenantNames != null) {
            int tenantId = rs.getInt(5);
            String tenantName = tenantNames.get(tenantId);
            if (tenantName == null) {
                tenantName = "<unknown>";
            }
            wrt.write(tenantName);
        }
        wrt.endRecord();
        return licenseLevel == -1 ? this.counts.length - 1 : licenseLevel;
    }

    private PreparedStatement createStatement(CMDbConnection con, int tenantId) throws SQLException {
        SqlBuilder sql = new SqlBuilder(con.getSqlGenerator());
        sql.select().aliasedColumn("p1", "OBJID").separator().aliasedColumn("p33", "NAME").separator().aliasedColumn("p33", "LASTLOGIN").separator().aliasedColumn("p33", "LICENSE").separator().aliasedColumn("o", "TENANTID");
        sql.from().aliasedTable("p33", "CMOBJPROPS33").innerJoin().aliasedTable("p1", "CMOBJPROPS1").onJoinConditionEquals("p1", "CMID", "p33", "CMID").innerJoin().aliasedTable("o", "CMOBJECTS").onJoinConditionEquals("o", "CMID", "p33", "CMID");
        if (tenantId != -9999) {
            sql.where().aliasedColumn("o", "TENANTID").equalsValue(tenantId);
        }
        sql.orderBy().aliasedColumn("p33", "LICENSE").descending();
        return con.prepareStatement(sql.toString());
    }

    private int makeReadUncommitted(CMDbConnection con) throws SQLException {
        if (CMDbConnection.getDbmsInfo().getDbms() != 2) {
            int oldLevel = con.getConnection().getTransactionIsolation();
            con.getConnection().setTransactionIsolation(1);
            return oldLevel;
        }
        return -1;
    }

    private void closeStatement(PreparedStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            CMIndications.logException(e);
        }
    }

    private void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            CMIndications.logException(e);
        }
    }

    private void restoreTransactionIsolationLevel(CMDbConnection con, int level) {
        if (level != -1) {
            try {
                con.getConnection().setTransactionIsolation(level);
            }
            catch (SQLException e) {
                CMIndications.logException(e);
            }
        }
    }
}

