/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.BytesCounter;
import com.cognos.cm.server.CMException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream
implements BytesCounter {
    private long limitBytes;
    private long totalRead;

    public LimitedInputStream(InputStream in, long limit) {
        super(in);
        this.limitBytes = limit;
        this.totalRead = 0L;
    }

    @Override
    public int read() throws IOException {
        ++this.totalRead;
        if (this.limitBytes > 0L && this.totalRead > this.limitBytes) {
            CMException ex = new CMException("cmIODenialService");
            throw new IOException(ex.getMessage());
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result > 0) {
            this.totalRead += (long)result;
        }
        if (this.limitBytes > 0L && this.totalRead > this.limitBytes) {
            CMException ex = new CMException("cmIODenialService");
            throw new IOException(ex.getMessage());
        }
        return result;
    }

    @Override
    public long getBytesRead() {
        return this.totalRead;
    }
}

